# Речевые технологии для русского языка

# Общение

  * <https://t.me/speech_recognition_ru> - группа "Распознавание речи"
  * <https://t.me/speech_recognition> - группа на английском языке
  * <https://t.me/speechtech> - канал новостей
  * <https://t.me/betterdatacommunity/15> - сообщество speech в datacommunity
  * <https://t.me/voicestuff> <https://t.me/voice_stuff_chat> - Frappucсino's space
  * <https://t.me/TeraSpace> <https://t.me/teraspace_chat> - Tera's space

# Курсы

  * <https://github.com/markovka17/dla>
  * <https://github.com/yandexdataschool/speech_course>
  * <https://github.com/severilov/DL-Audio-Course>
  * <https://huggingface.co/learn/audio-course/ru/chapter0/introduction> - поиграться со звуковыми моделями HF
  * <https://www.youtube.com/playlist?list=PLYG3WHDP5CWVRxLjXZbllqIQTWY_QjKmz> - Deep Learning for Audio

# Данные для обучения

  * <https://github.com/salute-developers/golos>
  * <https://github.com/snakers4/open_stt>
  * <https://github.com/GeorgeFedoseev/DeepSpeech>
  * <https://github.com/sovaai/sova-dataset>
  * <https://www.openslr.org/96/> - Russian Librispeech
  * <https://commonvoice.mozilla.org/ru/datasets> - MCV

# Синтез речи

  * <https://www.caito.de/2019/01/03/the-m-ailabs-speech-dataset/> - M-AILabs dataset (from Librivox)
  * <https://ruslan-corpus.github.io/>
  * <https://github.com/sovaai/sova-tts>
  * <https://huggingface.co/bene-ges/tts_ru_hifigan_ruslan>
  * <https://github.com/alphacep/vosk-tts>
  * <https://github.com/RHVoice>
  * <https://github.com/snakers4/silero-models#text-to-speech>
  * <https://github.com/Tera2Space/TeraTTS>
  * <https://huggingface.co/omogr/xtts-ru-ipa>

# Преобразования голоса

 * <https://www.weights.gg/ru> - куча моделей для RVC
 * <https://2ch-ai.gitgud.site/wiki/speech/> - школота да дваче
 * <https://lunaiproject.uwu.ai/> - русский DiffSinger
 + есть куча телеграм каналов, в основном мутной направленности

# Общая предобработка для синтеза

  * <https://github.com/sovaai/sova-tts-tps>
  * <https://github.com/snakers4/silero-models#text-enhancement>
  * <https://github.com/snakers4/russian_stt_text_normalization>
  * <https://www.kaggle.com/competitions/text-normalization-challenge-russian-language/overview> - старое соревнование на Kaggle
  * <https://github.com/ppleskov/Text-Normalization-Challenge-Russian-Language> - один из победителей
  * <https://github.com/shigabeev/russian_tts_normalization>
  * <https://github.com/saarus72/text_normalization/tree/dev> - на основе Fred-T5
  * <https://github.com/Den4ikAI/runorm> - числа в текст, обработка английских слов, раскрытие сокращений
  * <https://github.com/just-ai/multilingual-text-parser>


# Расстановка ударений, фонетические словари и g2p

  * <https://github.com/reynoldsnlp/udar>
  * <https://github.com/einhornus/russian_accentuation>
  * <https://github.com/wilpert/RusPhonetizer>
  * <https://huggingface.co/bene-ges/ru_g2p_ipa_bert_large>
  * <https://github.com/Desklop/StressRNN>
  * <https://github.com/nsu-ai/russian_g2p>
  * <https://github.com/nsu-ai-team/russian_g2p_neuro>
  * <https://github.com/suralmasha/RuTranscript>
  * <https://github.com/MashaPo/russtress>
  * <https://huggingface.co/IlyaGusev/ru-word-stress-transformer>
  * <https://github.com/aishutin/rustress>
  * <https://github.com/Koziev/StressModel>
  * <https://github.com/omogr/omogre>
  * <https://github.com/Den4ikAI/ruaccent> - ёфикатор, ударение и разрешение омографов

# Словари

  * <https://github.com/reynoldsnlp/udar/blob/main/src/udar/resources/src/Tixonov.txt> - Морфемно-орфографический словарь Тихонова
  * <http://aot.ru> - Источник словаря Зализняка в машинном формате 
  * <https://github.com/gramdict/gramdict> - современная версия словаря Зализняка
  * <http://odict.ru/> - другое развитие Зализняка
  * <http://opencorpora.org/> - размеченный морфологический словарь
  * <https://ru.wiktionary.org> - Wiktionary
  * <https://kaikki.org/dictionary/Russian/> - дамп wiktionary в удобном формате

# Ёфикаторы

  * <https://github.com/sovaai/sova-tts-tps>
  * <https://github.com/e2yo/eyo-kernel>
  * <https://github.com/kalashnikovisme/karamzin>
  * <https://github.com/Text-extend-tools/python-yoficator>
  * <https://github.com/emacsmirror/yoficator>
  * <https://github.com/unabashed/yoficator>

# Распознавание эмоций

 * <https://github.com/aniemore/Aniemore>
 * <https://huggingface.co/xbgoose/hubert-large-speech-emotion-recognition-russian-dusha-finetuned>
 * <https://github.com/salute-developers/golos/tree/master/dusha>

# Модели для распознавания речи

Сравнение моделей [тут](https://alphacephei.com/nsh/2023/01/22/russian-models.html).

  * Vosk Small <https://alphacephei.com/vosk/models/vosk-model-small-ru-0.22.zip>
  * Vosk Big 0.22 <https://alphacephei.com/vosk/models/vosk-model-ru-0.22.zip>
  * Vosk Big 0.42 <https://alphacephei.com/vosk/models/vosk-model-ru-0.42.zip>
  * Nvidia RNNT Large <https://huggingface.co/nvidia/stt_ru_conformer_transducer_large>
  * Whisper medium <https://github.com/openai/whisper>
  * Whisper Adapted Medium <https://huggingface.co/mitchelldehaven/whisper-medium-ru>
  * Whisper Adapted Large <https://huggingface.co/mitchelldehaven/whisper-large-v2-ru>
  * Wav2VecLM <https://huggingface.co/jonatasgrosman/wav2vec2-xls-r-1b-russian>
  * Wav2VecLM Bond005 <https://huggingface.co/bond005/wav2vec2-large-ru-golos> (version 03.2023)
  * Salute Citrinet <https://github.com/salute-developers/golos>
  * FunASR Russian <https://modelscope.cn/models/damo/speech_UniASR_asr_2pass-ru-16k-common-vocab1664-tensorflow1-offline/summary>

Не тестировались (похуже качеством)

  * <https://github.com/sovse/base_rus_whisper_stt>

# Лингвистика (списки слов, морфология)

  * <http://aot.ru>
  * <https://natasha.github.io>

# Пунктуация и заглавные буквы

  * <https://alphacephei.com/vosk/models/vosk-recasepunc-en-0.22.zip>
  * <https://huggingface.co/kontur-ai/sbert_punc_case_ru>
    
  * <https://github.com/kotikkonstantin/ru-autopunctuation>
  * <https://github.com/vlomme/Bert-Russian-punctuation>
  * <https://github.com/Lesha17/Punctuation>
  * <https://github.com/gleb-skobinsky/ru_punct>
  * <https://github.com/sviperm/neuro-comma>
  * <https://github.com/snakers4/silero-models>
  * <https://github.com/marlon-br/neuro-comma>
  * <https://github.com/sviperm/neuro-comma>
  * <https://github.com/averkij/multipunct>
  * <https://github.com/denis-berezutskiy-lad/transcription-bert-ru-punctuator-scripts> [HuggingFace](https://huggingface.co/denis-berezutskiy-lad/lad_transcription_bert_ru_punctuator)
  * <https://huggingface.co/ai-forever/sage-fredt5-distilled-95m> - набор моделей SAGE

# История

  * [А.А. Зализняк Грамматический словарь](https://ru.wikipedia.org/wiki/%D0%93%D1%80%D0%B0%D0%BC%D0%BC%D0%B0%D1%82%D0%B8%D1%87%D0%B5%D1%81%D0%BA%D0%B8%D0%B9_%D1%81%D0%BB%D0%BE%D0%B2%D0%B0%D1%80%D1%8C_%D1%80%D1%83%D1%81%D1%81%D0%BA%D0%BE%D0%B3%D0%BE_%D1%8F%D0%B7%D1%8B%D0%BA%D0%B0_%D0%90._%D0%90._%D0%97%D0%B0%D0%BB%D0%B8%D0%B7%D0%BD%D1%8F%D0%BA%D0%B0)
  * [ОТиПЛ — это кафедра и отделение теоретической и прикладной лингвистики филологического факультета МГУ](http://tipl.philol.msu.ru/)
  * [Лобанов Борис Мефодьевич](https://obm.bsu.by/matematiki/lobanov-boris-mefodevich/)
  * ИППИ - [Сорокин Виктор Николаевич](https://www.mathnet.ru/rus/person43114)
  * ИПУ РАН [История](http://asmon.ru/ru/node/4)
  * [Сектор Цифровой Обработки и Распознавания Речевых Сигналов ВЦ РАН](http://www.ccas.ru/DCM/Chichag/index.htm)
 
 ## Alphacep

  * [2005 год начало работы над синтезатором Фестиваль](https://www.linux.org.ru/news/linux-general/775065?cid=776417)
  * [Festlang Clunits](https://www.opennet.ru/opennews/art.shtml?num=12399)
  * [Русский язык на Voxforge](http://www.voxforge.org/ru)
  * [CMUSphinx](https://cmusphinx.github.io/)
