/*! AdminLTE app.js
 * ================
 * Main JS application file for AdminLTE v2. This file
 * should be included in all pages. It controls some layout
 * options and implements exclusive AdminLTE plugins.
 *
 * @Author  Almsaeed Studio
 * @Support <http://www.almsaeedstudio.com>
 * @Email   <support@almsaeedstudio.com>
 * @version 2.3.2
 * @license MIT <http://opensource.org/licenses/MIT>
 */
function _init(){"use strict";$.AdminLTE.layout={activate:function(){var a=this;a.fix(),a.fixSidebar(),$(window,".wrapper").resize(function(){a.fix(),a.fixSidebar()})},fix:function(){var a=$(".main-header").outerHeight()+$(".main-footer").outerHeight(),b=$(window).height(),c=$(".sidebar").height();if($("body").hasClass("fixed"))$(".content-wrapper, .right-side").css("min-height",b-$(".main-footer").outerHeight());else{var d;b>=c?($(".content-wrapper, .right-side").css("min-height",b-a),d=b-a):($(".content-wrapper, .right-side").css("min-height",c),d=c);var e=$($.AdminLTE.options.controlSidebarOptions.selector);"undefined"!=typeof e&&e.height()>d&&$(".content-wrapper, .right-side").css("min-height",e.height())}},fixSidebar:function(){return $("body").hasClass("fixed")?("undefined"==typeof $.fn.slimScroll&&window.console&&window.console.error("Error: the fixed layout requires the slimscroll plugin!"),void($.AdminLTE.options.sidebarSlimScroll&&"undefined"!=typeof $.fn.slimScroll&&($(".sidebar").slimScroll({destroy:!0}).height("auto"),$(".sidebar").slimscroll({height:$(window).height()-$(".main-header").height()+"px",color:"rgba(0,0,0,0.2)",size:"3px"})))):void("undefined"!=typeof $.fn.slimScroll&&$(".sidebar").slimScroll({destroy:!0}).height("auto"))}},$.AdminLTE.pushMenu={activate:function(a){var b=$.AdminLTE.options.screenSizes;$(document).on("click",a,function(a){a.preventDefault(),$(window).width()>b.sm-1?$("body").hasClass("sidebar-collapse")?$("body").removeClass("sidebar-collapse").trigger("expanded.pushMenu"):$("body").addClass("sidebar-collapse").trigger("collapsed.pushMenu"):$("body").hasClass("sidebar-open")?$("body").removeClass("sidebar-open").removeClass("sidebar-collapse").trigger("collapsed.pushMenu"):$("body").addClass("sidebar-open").trigger("expanded.pushMenu")}),$(".content-wrapper").click(function(){$(window).width()<=b.sm-1&&$("body").hasClass("sidebar-open")&&$("body").removeClass("sidebar-open")}),($.AdminLTE.options.sidebarExpandOnHover||$("body").hasClass("fixed")&&$("body").hasClass("sidebar-mini"))&&this.expandOnHover()},expandOnHover:function(){var a=this,b=$.AdminLTE.options.screenSizes.sm-1;$(".main-sidebar").hover(function(){$("body").hasClass("sidebar-mini")&&$("body").hasClass("sidebar-collapse")&&$(window).width()>b&&a.expand()},function(){$("body").hasClass("sidebar-mini")&&$("body").hasClass("sidebar-expanded-on-hover")&&$(window).width()>b&&a.collapse()})},expand:function(){$("body").removeClass("sidebar-collapse").addClass("sidebar-expanded-on-hover")},collapse:function(){$("body").hasClass("sidebar-expanded-on-hover")&&$("body").removeClass("sidebar-expanded-on-hover").addClass("sidebar-collapse")}},$.AdminLTE.tree=function(a){var b=this,c=$.AdminLTE.options.animationSpeed;$(a).on("click","li a",function(a){var d=$(this),e=d.next();if(e.is(".treeview-menu")&&e.is(":visible")&&!$("body").hasClass("sidebar-collapse"))e.slideUp(c,function(){e.removeClass("menu-open")}),e.parent("li").removeClass("active");else if(e.is(".treeview-menu")&&!e.is(":visible")){var f=d.parents("ul").first(),g=f.find("ul:visible").slideUp(c);g.removeClass("menu-open");var h=d.parent("li");e.slideDown(c,function(){e.addClass("menu-open"),f.find("li.active").removeClass("active"),h.addClass("active"),b.layout.fix()})}e.is(".treeview-menu")&&a.preventDefault()})},$.AdminLTE.controlSidebar={activate:function(){var a=this,b=$.AdminLTE.options.controlSidebarOptions,c=$(b.selector),d=$(b.toggleBtnSelector);d.on("click",function(d){d.preventDefault(),c.hasClass("control-sidebar-open")||$("body").hasClass("control-sidebar-open")?a.close(c,b.slide):a.open(c,b.slide)});var e=$(".control-sidebar-bg");a._fix(e),$("body").hasClass("fixed")?a._fixForFixed(c):$(".content-wrapper, .right-side").height()<c.height()&&a._fixForContent(c)},open:function(a,b){b?a.addClass("control-sidebar-open"):$("body").addClass("control-sidebar-open")},close:function(a,b){b?a.removeClass("control-sidebar-open"):$("body").removeClass("control-sidebar-open")},_fix:function(a){var b=this;$("body").hasClass("layout-boxed")?(a.css("position","absolute"),a.height($(".wrapper").height()),$(window).resize(function(){b._fix(a)})):a.css({position:"fixed",height:"auto"})},_fixForFixed:function(a){a.css({position:"fixed","max-height":"100%",overflow:"auto","padding-bottom":"50px"})},_fixForContent:function(a){$(".content-wrapper, .right-side").css("min-height",a.height())}},$.AdminLTE.boxWidget={selectors:$.AdminLTE.options.boxWidgetOptions.boxWidgetSelectors,icons:$.AdminLTE.options.boxWidgetOptions.boxWidgetIcons,animationSpeed:$.AdminLTE.options.animationSpeed,activate:function(a){var b=this;a||(a=document),$(a).on("click",b.selectors.collapse,function(a){a.preventDefault(),b.collapse($(this))}),$(a).on("click",b.selectors.remove,function(a){a.preventDefault(),b.remove($(this))})},collapse:function(a){var b=this,c=a.parents(".box").first(),d=c.find("> .box-body, > .box-footer, > form  >.box-body, > form > .box-footer");c.hasClass("collapsed-box")?(a.children(":first").removeClass(b.icons.open).addClass(b.icons.collapse),d.slideDown(b.animationSpeed,function(){c.removeClass("collapsed-box")})):(a.children(":first").removeClass(b.icons.collapse).addClass(b.icons.open),d.slideUp(b.animationSpeed,function(){c.addClass("collapsed-box")}))},remove:function(a){var b=a.parents(".box").first();b.slideUp(this.animationSpeed)}}}if("undefined"==typeof jQuery)throw new Error("AdminLTE requires jQuery");$.AdminLTE={},$.AdminLTE.options={navbarMenuSlimscroll:!0,navbarMenuSlimscrollWidth:"3px",navbarMenuHeight:"200px",animationSpeed:500,sidebarToggleSelector:"[data-toggle='offcanvas']",sidebarPushMenu:!0,sidebarSlimScroll:!0,sidebarExpandOnHover:!1,enableBoxRefresh:!0,enableBSToppltip:!0,BSTooltipSelector:"[data-toggle='tooltip']",enableFastclick:!0,enableControlSidebar:!0,controlSidebarOptions:{toggleBtnSelector:"[data-toggle='control-sidebar']",selector:".control-sidebar",slide:!0},enableBoxWidget:!0,boxWidgetOptions:{boxWidgetIcons:{collapse:"fa-minus",open:"fa-plus",remove:"fa-times"},boxWidgetSelectors:{remove:'[data-widget="remove"]',collapse:'[data-widget="collapse"]'}},directChat:{enable:!0,contactToggleSelector:'[data-widget="chat-pane-toggle"]'},colors:{lightBlue:"#3c8dbc",red:"#f56954",green:"#00a65a",aqua:"#00c0ef",yellow:"#f39c12",blue:"#0073b7",navy:"#001F3F",teal:"#39CCCC",olive:"#3D9970",lime:"#01FF70",orange:"#FF851B",fuchsia:"#F012BE",purple:"#8E24AA",maroon:"#D81B60",black:"#222222",gray:"#d2d6de"},screenSizes:{xs:480,sm:768,md:992,lg:1200}},$(function(){"use strict";$("body").removeClass("hold-transition"),"undefined"!=typeof AdminLTEOptions&&$.extend(!0,$.AdminLTE.options,AdminLTEOptions);var a=$.AdminLTE.options;_init(),$.AdminLTE.layout.activate(),$.AdminLTE.tree(".sidebar"),a.enableControlSidebar&&$.AdminLTE.controlSidebar.activate(),a.navbarMenuSlimscroll&&"undefined"!=typeof $.fn.slimscroll&&$(".navbar .menu").slimscroll({height:a.navbarMenuHeight,alwaysVisible:!1,size:a.navbarMenuSlimscrollWidth}).css("width","100%"),a.sidebarPushMenu&&$.AdminLTE.pushMenu.activate(a.sidebarToggleSelector),a.enableBSToppltip&&$("body").tooltip({selector:a.BSTooltipSelector,container:'body'}),a.enableBoxWidget&&$.AdminLTE.boxWidget.activate(),a.enableFastclick&&"undefined"!=typeof FastClick&&FastClick.attach(document.body),a.directChat.enable&&$(document).on("click",a.directChat.contactToggleSelector,function(){var a=$(this).parents(".direct-chat").first();a.toggleClass("direct-chat-contacts-open")}),$('.btn-group[data-toggle="btn-toggle"]').each(function(){var a=$(this);$(this).find(".btn").on("click",function(b){a.find(".btn.active").removeClass("active"),$(this).addClass("active"),b.preventDefault()})})}),function(a){"use strict";a.fn.boxRefresh=function(b){function c(a){a.append(f),e.onLoadStart.call(a)}function d(a){a.find(f).remove(),e.onLoadDone.call(a)}var e=a.extend({trigger:".refresh-btn",source:"",onLoadStart:function(a){return a},onLoadDone:function(a){return a}},b),f=a('<div class="overlay"><div class="fa fa-refresh fa-spin"></div></div>');return this.each(function(){if(""===e.source)return void(window.console&&window.console.log("Please specify a source first - boxRefresh()"));var b=a(this),f=b.find(e.trigger).first();f.on("click",function(a){a.preventDefault(),c(b),b.find(".box-body").load(e.source,function(){d(b)})})})}}(jQuery),function(a){"use strict";a.fn.activateBox=function(){a.AdminLTE.boxWidget.activate(this)},a.fn.toggleBox=function(){var b=a(a.AdminLTE.boxWidget.selectors.collapse,this);a.AdminLTE.boxWidget.collapse(b)},a.fn.removeBox=function(){var b=a(a.AdminLTE.boxWidget.selectors.remove,this);a.AdminLTE.boxWidget.remove(b)}}(jQuery),function(a){"use strict";a.fn.todolist=function(b){var c=a.extend({onCheck:function(a){return a},onUncheck:function(a){return a}},b);return this.each(function(){"undefined"!=typeof a.fn.iCheck?(a("input",this).on("ifChecked",function(){var b=a(this).parents("li").first();b.toggleClass("done"),c.onCheck.call(b)}),a("input",this).on("ifUnchecked",function(){var b=a(this).parents("li").first();b.toggleClass("done"),c.onUncheck.call(b)})):a("input",this).on("change",function(){var b=a(this).parents("li").first();b.toggleClass("done"),a("input",b).is(":checked")?c.onCheck.call(b):c.onUncheck.call(b)})})}}(jQuery);

/* ================= Custom Methods ================= */

if(typeof String.prototype.hashCode !== 'function') {
    String.prototype.hashCode = function() {
        var hash = 0;
        if (this.length == 0) return hash;
        for (i = 0; i < this.length; i++) {
            char = this.charCodeAt(i);
            hash = ((hash<<5)-hash)+char;
            hash = hash & hash; // Convert to 32bit integer
        }
        return hash;
    };
}
if(typeof String.prototype.trim !== 'function') {
    String.prototype.trim = function() {
        return this.replace(/^\s+|\s+$/g, '');
    };
}
if (typeof String.prototype.startsWith != 'function') {
    // see below for better implementation!
    String.prototype.startsWith = function (str){
        return this.indexOf(str) == 0;
    };
}
if (typeof String.prototype.ucfirst != 'function') {
    // see below for better implementation!
    String.prototype.ucfirst = function (){
        return this.charAt(0).toUpperCase() + this.slice(1);
    };
}

if (typeof String.prototype.endsWith != 'function') {
    // see below for better implementation!
    String.prototype.endsWith = function (pattern){
        var d = this.length - pattern.length;
        return d >= 0 && this.lastIndexOf(pattern) === d;
    };
}

/* ================= Fancy Notifications ================= */
(function($) {
    'use strict';
    var Notification = function(container, options) {
        var self = this;
        self.container = $(container);
        self.notification = $('<div class="pgn push-on-sidebar-open"></div>');
        self.options = $.extend(true, {}, $.fn.pgNotification.defaults, options);
        if (!self.container.find('.pgn-wrapper[data-position=' + this.options.position + ']').length) {
            self.wrapper = $('<div class="pgn-wrapper" data-position="' + this.options.position + '"></div>');
            self.container.append(self.wrapper);
        } else {
            self.wrapper = $('.pgn-wrapper[data-position=' + this.options.position + ']');
        }
        self.alert = $('<div class="alert"></div>');
        self.alert.addClass('alert-' + self.options.type);
        if (self.options.style == 'bar') {
            new BarNotification();
        } else if (self.options.style == 'flip') {
            new FlipNotification();
        } else if (self.options.style == 'circle') {
            new CircleNotification();
        } else if (self.options.style == 'simple') {
            new SimpleNotification();
        } else {
            new SimpleNotification();
        }

        function SimpleNotification() {
            self.notification.addClass('pgn-simple');
            self.alert.append(self.options.message);
            if (self.options.showClose) {
                var close = $('<button type="button" class="close" data-dismiss="alert"></button>').append('<span aria-hidden="true">&times;</span>').append('<span class="sr-only">Close</span>');
                self.alert.prepend(close);
            }
        }

        function BarNotification() {
            self.notification.addClass('pgn-bar');
            self.alert.append('<span>' + self.options.message + '</span>');
            self.alert.addClass('alert-' + self.options.type);
            if (self.options.showClose) {
                var close = $('<button type="button" class="close" data-dismiss="alert"></button>').append('<span aria-hidden="true">&times;</span>').append('<span class="sr-only">Close</span>');
                self.alert.prepend(close);
            }
        }

        function CircleNotification() {
            self.notification.addClass('pgn-circle');
            var table = '<div>';
            if (self.options.thumbnail) {
                table += '<div class="pgn-thumbnail"><div>' + self.options.thumbnail + '</div></div>';
            }
            table += '<div class="pgn-message"><div>';
            if (self.options.title) {
                table += '<p class="bold">' + self.options.title + '</p>';
            }
            table += '<p>' + self.options.message + '</p></div></div>';
            table += '</div>';
            if (self.options.showClose) {
                table += '<button type="button" class="close" data-dismiss="alert">';
                table += '<span aria-hidden="true">&times;</span><span class="sr-only">Close</span>';
                table += '</button>';
            }
            self.alert.append(table);
            self.alert.after('<div class="clearfix"></div>');
        }

        function FlipNotification() {
            self.notification.addClass('pgn-flip');
            self.alert.append("<span>" + self.options.message + "</span>");
            if (self.options.showClose) {
                var close = $('<button type="button" class="close" data-dismiss="alert"></button>').append('<span aria-hidden="true">&times;</span>').append('<span class="sr-only">Close</span>');
                self.alert.prepend(close);
            }
        }
        self.notification.append(self.alert);
        self.alert.on('closed.bs.alert', function() {
            self.notification.remove();
            self.options.onClosed();
        });
        return this;
    };
    Notification.VERSION = "1.0.0";
    Notification.prototype.show = function() {
        this.wrapper.prepend(this.notification);
        this.options.onShown();
        if (this.options.timeout != 0) {
            var _this = this;
            setTimeout(function() {
                this.notification.fadeOut("slow", function() {
                    $(this).remove();
                    _this.options.onClosed();
                });
            }.bind(this), this.options.timeout);
        }
    };
    $.fn.pgNotification = function(options) {
        return new Notification(this, options);
    };
    $.fn.pgNotification.defaults = {
        style: 'simple',
        message: null,
        position: 'top-right',
        type: 'info',
        showClose: true,
        timeout: 4000,
        onShown: function() {},
        onClosed: function() {}
    }
})(window.jQuery);

$(document).ready(function() {
	/* ================= Toggle Switch - Checkbox ================= */
    $(".Switch").click(function() {
		$(this).hasClass("On") ? ($(this).parent().find("input:checkbox").attr("checked", !0), $(this).removeClass("On").addClass("Off")) : ($(this).parent().find("input:checkbox").attr("checked", !1), $(this).removeClass("Off").addClass("On"))
	}), $(".Switch").each(function() {
		$(this).parent().find("input:checkbox").length && ($(this).parent().find("input:checkbox").hasClass("show") || $(this).parent().find("input:checkbox").hide(), $(this).parent().find("input:checkbox").is(":checked") ? $(this).removeClass("On").addClass("Off") : $(this).removeClass("Off").addClass("On"))
	});
    
    /* ================= HTML ================= */
    $(".htmlbox").on("blur", function() {
        console.log("htmlbox.blur");
        $(this).next().val($(this).html());
    });
    
    /* ================= Default Select2 ================= */
    $("[rel=select2]").select2({
        
    });
    $("[rel=taginput]").select2({
        tags: true,
        tokenSeparators: [',']
    });
    
    /* ================= bootstrap-datetimepicker ================= */
    $(".input-group.date").datetimepicker({
        format: 'DD/MM/YYYY'
    });
    
    $(".input-group.datetime").datetimepicker({
        format: 'DD/MM/YYYY LT',
        sideBySide: true
    });
	
	/* ================= stickyTabs ================= */
	$('.nav-tabs').stickyTabs();
    
    /* ================= Validate Unique Fields ================= */
    jQuery.validator.addMethod("data-rule-unique", function(value, element) {
        value = value.trim();
        
        var isAllowed = false;
        var bsurl = $("body").attr('bsurl');
        var field_id = element.getAttribute('field_id');
        var _token = $("input[name=_token_"+field_id+"]").val();
        var adminRoute = element.getAttribute('adminRoute');
		var isEdit = element.getAttribute('isEdit');
		var row_id = element.getAttribute('row_id');
        
        if(value != '' && bsurl != "") {
            $.ajax({
				url: bsurl+"/"+adminRoute+"/check_unique_val/"+field_id,
				type:"POST",
				async: false,
				data:{
                    'field_value': value,
                    '_token': _token,
					'isEdit': isEdit,
					'row_id': row_id
                },
				success: function(data) {
                    // console.log(data);
                    if(data.exists == true) {
                        isAllowed = false;
                    } else {
                        isAllowed = true;
                    }
				}
			});
		}
		return isAllowed;
    }, 'This value exists in database.');
});

/* ================= File Manager ================= */
var bsurl = $('body').attr("bsurl");
var adminRoute = $('body').attr("adminRoute");
var cntFiles = null;
var fm_dropzone = null;
$(document).ready(function() {
    function showLAFM(type, selector) {
        $("#image_selecter_origin_type").val(type);
        $("#image_selecter_origin").val(selector);
        
        $("#fm").modal('show');
        
        loadFMFiles();
    }
    function getLI(upload) {
        var image = '';
        if($.inArray(upload.extension, ["jpg", "jpeg", "png", "gif", "bmp"]) > -1) {
            image = '<img src="'+bsurl+'/files/'+upload.hash+'/'+upload.name+'?s=130">';
        } else {
            switch (upload.extension) {
                case "pdf":
                    image = '<i class="fa fa-file-pdf-o"></i>';
                    break;
                default:
                    image = '<i class="fa fa-file-text-o"></i>';
                    break;
            }
        }
        return '<li><a class="fm_file_sel" data-toggle="tooltip" data-placement="top" title="'+upload.name+'" upload=\''+JSON.stringify(upload)+'\'>'+image+'</a></li>';
    }
    function loadFMFiles() {
        // load uploaded files
        $.ajax({
            dataType: 'json',
            url: $('body').attr("bsurl")+"/"+adminRoute+"/uploaded_files",
            success: function ( json ) {
                console.log(json);
                cntFiles = json.uploads;
                $(".fm_file_selector ul").empty();
                if(cntFiles.length) {
                    for (var index = 0; index < cntFiles.length; index++) {
                        var element = cntFiles[index];
                        var li = getLI(element);
                        $(".fm_file_selector ul").append(li);
                    }
                } else {
                    $(".fm_file_selector ul").html("<div class='text-center text-danger' style='margin-top:40px;'>No Files</div>");
                }
            }
        });
    }
    // $(".input-group.file input").on("blur", function() {
    //     if($(this).val().startsWith("http")) {
    //         $(this).next(".preview").css({
    //             "display": "block",
    //             "background-image": "url('"+$(this).val()+"')",
    //             "background-size": "cover"
    //         });
    //     } else {
    //         $(this).next(".preview").css({
    //             "display": "block",
    //             "background-image": "url('"+bsurl+"/"+$(this).val()+"')",
    //             "background-size": "cover"
    //         });
    //     }
    // });
    $("#fm input[type=search]").keyup(function () {
        var sstring = $(this).val().trim();
        console.log(sstring);
        if(sstring != "") {
            $(".fm_file_selector ul").empty();
            for (var index = 0; index < cntFiles.length; index++) {
                var upload = cntFiles[index];
                if(upload.name.toUpperCase().includes(sstring.toUpperCase())) {
                    $(".fm_file_selector ul").append(getLI(upload));
                }
            }
        } else {
            loadFMFiles();
        }
    });
    $(".btn_upload_image").on("click", function() {
        showLAFM("image", $(this).attr("selecter"));
    });

    $(".btn_upload_file").on("click", function() {
        showLAFM("file", $(this).attr("selecter"));
    });

    $(".btn_upload_files").on("click", function() {
        showLAFM("files", $(this).attr("selecter"));
    });
    
    fm_dropzone = new Dropzone("#fm_dropzone", {
        maxFilesize: 2,
        acceptedFiles: "image/*,application/pdf",
        init: function() {
            this.on("complete", function(file) {
                this.removeFile(file);
            });
            this.on("success", function(file) {
                console.log("addedfile");
                console.log(file);
                loadFMFiles();
            });
        }
    });

    $(".uploaded_image i.fa.fa-times").on("click", function() {
        $(this).parent().children("img").attr("src", "");
        $(this).parent().addClass("hide");
        $(this).parent().prev().removeClass("hide");
        $(this).parent().prev().prev().val("0");
    });

    $(".uploaded_file i.fa.fa-times").on("click", function(e) {
        $(this).parent().attr("href", "");
        $(this).parent().addClass("hide");
        $(this).parent().prev().removeClass("hide");
        $(this).parent().prev().prev().val("0");
        e.preventDefault();
    });

    $(".uploaded_file2 i.fa.fa-times").on("click", function(e) {
        var upload_id = $(this).parent().attr("upload_id");
        var $hiddenFIDs = $(this).parent().parent().prev();
        
        var hiddenFIDs = JSON.parse($hiddenFIDs.val());
        var hiddenFIDs2 = [];
        for (var key in hiddenFIDs) {
            if (hiddenFIDs.hasOwnProperty(key)) {
                var element = hiddenFIDs[key];
                if(element != upload_id) {
                    hiddenFIDs2.push(element);
                }
            }
        }
        $hiddenFIDs.val(JSON.stringify(hiddenFIDs2));
        $(this).parent().remove();
        e.preventDefault();
    });
    
    $("body").on("click", ".fm_file_sel", function() {
        type = $("#image_selecter_origin_type").val();
        upload = JSON.parse($(this).attr("upload"));
        console.log("upload sel: "+upload+" type: "+type);
        if(type == "image") {
            $hinput = $("input[name="+$("#image_selecter_origin").val()+"]");
            $hinput.val(upload.id);

            $hinput.next("a").addClass("hide");
            $hinput.next("a").next(".uploaded_image").removeClass("hide");
            $hinput.next("a").next(".uploaded_image").children("img").attr("src", bsurl+'/files/'+upload.hash+'/'+upload.name+"?s=150");
        } else if(type == "file") {
            $hinput = $("input[name="+$("#image_selecter_origin").val()+"]");
            $hinput.val(upload.id);

            $hinput.next("a").addClass("hide");
            $hinput.next("a").next(".uploaded_file").removeClass("hide");
            $hinput.next("a").next(".uploaded_file").attr("href", bsurl+'/files/'+upload.hash+'/'+upload.name);
        } else if(type == "files") {
            $hinput = $("input[name="+$("#image_selecter_origin").val()+"]");
            
            var hiddenFIDs = JSON.parse($hinput.val());
            // check if upload_id exists in array
            var upload_id_exists = false;
            for (var key in hiddenFIDs) {
                if (hiddenFIDs.hasOwnProperty(key)) {
                    var element = hiddenFIDs[key];
                    if(element == upload.id) {
                        upload_id_exists = true;
                    }
                }
            }
            if(!upload_id_exists) {
                hiddenFIDs.push(upload.id);
            }
            $hinput.val(JSON.stringify(hiddenFIDs));
            var fileImage = "";
            if(upload.extension == "jpg" || upload.extension == "png" || upload.extension == "gif" || upload.extension == "jpeg") {
                fileImage = "<img src='"+bsurl+"/files/"+upload.hash+"/"+upload.name+"?s=90'>";
            } else {
                fileImage = "<i class='fa fa-file-o'></i>";
            }
            $hinput.next("div.uploaded_files").append("<a class='uploaded_file2' upload_id='"+upload.id+"' target='_blank' href='"+bsurl+"/files/"+upload.hash+"/"+upload.name+"'>"+fileImage+"<i title='Remove File' class='fa fa-times'></i></a>");
        }
        $("#fm").modal('hide');
    });
});