## Federated Learning for Graph

### 2023

| Title                                                        | Venue                        | Link                                                         |
| ------------------------------------------------------------ | ---------------------------- | ------------------------------------------------------------ |
| Federated Learning on Non-IID Graphs via Structural Knowledge Sharing | AAAI                         | [pdf](https://arxiv.org/pdf/2211.13009.pdf)                  |
| Federated Learning-Based Cross-Enterprise Recommendation With Graph Neural | IEEE Trans. Industr. Inform. | [pdf](https://ieeexplore.ieee.org/stamp/stamp.jsp?tp=&arnumber=9873989&tag=1) |

### 2022

| Title                                                        | Venue                             | Link                                                         |
| ------------------------------------------------------------ | --------------------------------- | ------------------------------------------------------------ |
| FederatedScope-GNN: Towards a Unified, Comprehensive and Efficient Package for Federated Graph Learning | KDD                               | [pdf](https://dl.acm.org/doi/abs/10.1145/3534678.3539112), [code](https://github.com/alibaba/FederatedScope/tree/master/federatedscope/gfl) |
| FedWalk: Communication Efficient Federated Unsupervised Node Embedding with Differential Privacy | KDD                               | [pdf](https://arxiv.org/pdf/2205.15896v2.pdf)                |
| Deep Neural Network Fusion via Graph Matching with Applications to Model Ensemble and Federated Learning | ICML                              | [pdf](https://proceedings.mlr.press/v162/liu22k/liu22k.pdf)  |
| Personalized Federated Learning With a Graph                 | IJCAI                             | [pdf](https://www.ijcai.org/proceedings/2022/0357.pdf)       |
| Vertically Federated Graph Neural Network for Privacy-Preserving Node Classification | IJCAI                             | [pdf](https://www.ijcai.org/proceedings/2022/0272.pdf)       |
| Federated Graph Representation Learning using Self-Supervision | CIKM workshop                     | [pdf](https://arxiv.org/pdf/2210.15120.pdf)                  |
| FedGCN: Convergence and Communication Tradeoffs in Federated Training of Graph Convolutional Networks | CIKM workshop                     | [pdf](https://arxiv.org/abs/2201.12433),  [code](https://github.com/yh-yao/FedGCN) |
| FedGraph: Federated Graph Learning with Intelligent Sampling | TPDS                              | [pdf](https://arxiv.org/pdf/2111.01370.pdf)                  |
| Federated Graph Machine Learning: A Survey of Concepts, Techniques, and Applications | SIGKDD Explorations               | [pdf](https://arxiv.org/pdf/2207.11812.pdf)                  |
| More is Better (Mostly): On the Backdoor Attacks in Federated Graph Neural Networks | ACSAC                             | [pdf](https://dl.acm.org/doi/pdf/10.1145/3564625.3567999)    |
| FedNI: Federated Graph Learning with Network Inpainting for Population-Based Disease Prediction | TMI                               | [pdf](https://arxiv.org/pdf/2112.10166.pdf)                  |
| SemiGraphFL: Semi-supervised Graph Federated Learning for Graph Classification | PPSN                              | [pub](https://doi.org/10.1007/978-3-031-14714-2_33)          |
| A federated graph neural network framework for privacy-preserving personalization | Nature Communications             | [pdf](https://www.nature.com/articles/s41467-022-30714-9.pdf) |
| Federated Graph Learning with Periodic Neighbour Sampling    | IWQoS                             | [pub](https://ieeexplore.ieee.org/Xplore/errorpage.jsp?url=http%3A%2F%2Fieeexplore.ieee.org%2Fstamp%2Fstamp.jsp%3Ftp%3D%26arnumber%3D9812908) |
| A Privacy-Preserving Subgraph-Level Federated Graph Neural Network via Differential Privacy | KSEM                              | [pdf](https://arxiv.org/pdf/2206.03492.pdf)                  |
| Federated Multi-task Graph Learning                          | ACM Trans. Intell. Syst. Technol. | [pdf](https://dl.acm.org/doi/pdf/10.1145/3527622)            |

### 2021

| Title                                                        | Venue      | Link                                                         |
| ------------------------------------------------------------ | ---------- | ------------------------------------------------------------ |
| Federated Graph Classification over Non-IID Graphs           | NeurIPS    | [pdf](https://proceedings.neurips.cc//paper/2021/file/9c6947bd95ae487c81d4e19d3ed8cd6f-Paper.pdf), [code](https://github.com/Oxfordblue7/GCFL) |
| Subgraph Federated Learning with Missing Neighbor Generation | NeurIPS    | [pdf](http://proceedings.neurips.cc/paper/2021/file/34adeb8e3242824038aa65460a47c29e-Paper.pdf), [code](https://github.com/zkhku/fedsage) |
| Cross-Node Federated Graph Neural Network for Spatio-Temporal Data Modeling | KDD        | [pdf](https://arxiv.org/pdf/2106.05223v1.pdf), [code](https://github.com/mengcz13/KDD2021_CNFGNN) |
| Glint: Decentralized Federated Graph Learning with Traffic Throttling and Flow Scheduling | IEEE IWQoS | [pdf](https://ieeexplore.ieee.org/abstract/document/9521331) |
| Differentially Private Federated Knowledge Graphs Embedding  | CIKM       | [pdf](https://arxiv.org/pdf/2105.07615v2.pdf), [code](https://github.com/HKUST-KnowComp/FKGE) |

### 2020

| Title                                                 | Venue | Link                                                         |
| ----------------------------------------------------- | ----- | ------------------------------------------------------------ |
| FedE: Embedding Knowledge Graphs in Federated Setting | IJCKG | [pdf](https://dl.acm.org/doi/fullHtml/10.1145/3502223.3502233), [code](https://github.com/zjukg/FedE) |

### 2019

| Title                                                        | Venue | Link                                          |
| ------------------------------------------------------------ | ----- | --------------------------------------------- |
| Towards Federated Graph Learning for Collaborative Financial Crimes Detection | Arxiv | [pdf](https://arxiv.org/pdf/1909.12946v2.pdf) |
