## Federated Learning for Recommendation

### 2023

| Title                                                        | Venue                       | Link                                                         |
| ------------------------------------------------------------ | --------------------------- | ------------------------------------------------------------ |
| Privacy-Preserving Hierarchical Federated Recommendation Systems | IEEE Communications Letters | [pdf](https://ieeexplore.ieee.org/abstract/document/10044657) |
| Federated Recommendation with Additive Personalization       | arXiv                       | [pdf](https://arxiv.org/pdf/2301.09109.pdf)                  |
| Manipulating Federated Recommender Systems: Poisoning with Synthetic Users and Its Countermeasures | arXiv                       | [pdf](https://arxiv.org/pdf/2304.03054.pdf)                  |

### 2022

| Title | Venue | Link |
| --- | --- | --- |
| A Privacy-Preserving Oriented Service Recommendation Approach based on Personal Data Cloud and Federated Learning | IEEE ICWS | [pdf](https://ieeexplore.ieee.org/abstract/document/9885792) |
| Personalized Federated Recommendation System with Historical Parameter Clustering | JAIHC | [pdf](https://link.springer.com/article/10.1007/s12652-022-03709-z) |
| User-Controlled Federated Matrix Factorization for Recommender Systems | JIIS | [pdf](https://link.springer.com/article/10.1007/s10844-021-00688-z) |
| Differential Private Knowledge Transfer for Privacy-Preserving Cross-Domain Recommendation | WWW | [pdf](https://arxiv.org/pdf/2202.04893.pdf) |
| Towards Fair Federated Recommendation Learning: Characterizing the Inter-Dependence of System and Data Heterogeneity | RecSys | [pdf](https://arxiv.org/abs/2206.02633) |
| Personalized Federated Recommendation via Joint Representation Learning, User Clustering, and Model Adaptation | CIKM | [pdf](https://dl.acm.org/doi/pdf/10.1145/3511808.3557668) |
| FedCDR: Federated Cross-Domain Recommendation for Privacy-Preserving Rating Prediction | CIKM | [pdf](https://dl.acm.org/doi/pdf/10.1145/3511808.3557320) |
| Cali3F: Calibrated Fast Fair Federated Recommendation System | IJCNN | [pdf](https://arxiv.org/abs/2205.13121) |
| Ranking-based Federated POI Recommendation with Geographic Effect | IJCNN | [pdf](https://ieeexplore.ieee.org/abstract/document/9892943) |
| FedCL: Federated Contrastive Learning for Privacy-Preserving Recommendation | arXiv | [pdf](https://arxiv.org/abs/2204.09850) |
| Federated Unlearning for On-Device Recommendation | arXiv | [pdf](https://arxiv.org/abs/2210.10958) |
| PrivateRec: Differentially Private Training and Serving for Federated News Recommendation | arXiv | [pdf](https://arxiv.org/abs/2204.08146) |
| A Survey on Federated Recommendation Systems | IEEE TNNLS | [pdf](https://arxiv.org/pdf/2301.00767.pdf) |
| A Comprehensive Survey on Trustworthy Recommender Systems | arXiv | [pdf](https://arxiv.org/pdf/2209.10117.pdf) |

### 2021
| Title | Venue | Link |
| --- | --- | --- |
| Federated Social Recommendation with Graph Neural Network | ACM TIST | [pdf](https://arxiv.org/abs/2111.10778) |
| PREFER: Point-of-interest REcommendation with efficiency and privacy-preservation via Federated Edge leaRning | ACM IMWUT | [pdf](https://dl.acm.org/doi/abs/10.1145/3448099) |
| Federated Neural Collaborative Filtering | ACM KBS | [pdf](https://arxiv.org/abs/2106.04405) |
| POI Recommendation with Federated Learning and Privacy Preserving in Cross Domain Recommendation | INFOCOM workshop | [pdf](https://ieeexplore.ieee.org/document/9484510) |
| Fast-adapting and Privacy-preserving Federated Recommender System | VLDB Journal | [pdf](https://arxiv.org/abs/2104.00919) |
| FedCT: Federated Collaborative Transfer for Recommendation | SIGIR | [pdf](https://dl.acm.org/doi/abs/10.1145/3404835.3462825) |
| Stronger Privacy for Federated Collaborative Filtering with Implicit Feedback | RecSys | [pdf](https://arxiv.org/abs/2105.03941) |
| A Payload Optimization Method for Federated Recommender Systems | RecSys | [pdf](https://arxiv.org/abs/2107.13078) |
| Fedrec++: Lossless federated recommendation with explicit feedback | AAAI | [pdf](https://ojs.aaai.org/index.php/AAAI/article/view/16546) |
| Efficient-FedRec: Efficient Federated Learning Framework for Privacy-Preserving News Recommendation | EMNLP |  [pdf](https://aclanthology.org/2021.emnlp-main.223), [code](https://github.com/yjw1029/Efficient-FedRec) |
| Uni-FedRec: A Unified Privacy-Preserving News Recommendation Framework for Model Training and Online Serving | EMNLP | [pdf]( https://aclanthology.org/2021.findings-emnlp.124.pdf), [code](https://github.com/taoqi98/UniFedRec) |
| Practical and Secure Federated Recommendation with Personalized Masks | arXiv | [pdf](https://arxiv.org/abs/2109.02464) |
| FedGNN: Federated Graph Neural Network for Privacy-Preserving Recommendation | arXiv | [pdf](https://arxiv.org/abs/2102.04925) |
| Learning Federated Representations and Recommendations with Limited Negatives | arXiv | [pdf](https://arxiv.org/abs/2108.07931), [code](https://git.io/federated_dual_encoder) |
| DeepRec: On-device Deep Learning for Privacy-Preserving Sequential Recommendation in Mobile Commerce | www | [pdf](https://dl.acm.org/doi/abs/10.1145/3442381.3449942) |

### 2020
| Title | Venue | Link |
| --- | --- | --- |
| Practical Privacy Preserving POI Recommendation | ACM TIST | [pdf](https://arxiv.org/abs/2003.02834) |
| Secure Federated Matrix Factorization | IEEE Intelligent Systems | [pdf](https://ieeexplore.ieee.org/abstract/document/9162459), [code](https://github.com/Di-Chai/FedMF) |
| FedRec: Federated Recommendation With Explicit Feedback | IEEE Intelligent Systems | [pdf](https://ieeexplore.ieee.org/abstract/document/9170754), [code](https://csse.szu.edu.cn/staff/panwk/publications/FedRec/) |
| Privacy-Preserving News Recommendation Model Learning | EMNLP | [pdf](https://aclanthology.org/2020.findings-emnlp.128/), [code](https://github.com/taoqi98/FedNewsRec) |
| Federated Recommendation System via Differential Privacy | IEEE ISIT | [pdf](https://arxiv.org/abs/2005.06670) |
| Meta Matrix Factorization for Federated Rating Predictions | SIGIR | [pdf](https://arxiv.org/abs/1910.10086), [code](https://github.com/TempSDU/MetaMF) |
| FedFast: Going Beyond Average for Faster Training of Federated Recommender Systems | KDD | [pdf](https://dl.acm.org/doi/10.1145/3394486.3403176) |
| Federated recommendation systems | Springer | [pdf](https://link.springer.com/chapter/10.1007/978-3-030-63076-8_16) |

### 2019
| Title | Venue | Link |  
| --- | --- | --- | 
| Federated Collaborative Filtering for Privacy-Preserving Personalized Recommendation System | arXiv | [pdf](https://arxiv.org/abs/1901.09888) |

### 2018
| Title | Venue | Link |  
| --- | --- | --- | 
| Privacy Enhanced Matrix Factorization for Recommendation with Local Differential Privacy | IEEE TKDE | [pdf](https://ieeexplore.ieee.org/abstract/document/8290673) |
