# Contributing to tech-professionals-bangladesh
We welcome contributions from developers and tech professionals to showcase Bangladeshi talent worldwide. Please follow these steps to add your information to the repository.

## How to Contribute
### 1. Fork the Repository
   * Click the "Fork" button in the top-right corner of this repository to create a copy of it in your GitHub account.
### 2. Clone the Repository
   * Clone your forked repository to your local machine using the command:

   ```
   git clone https://github.com/your-username/tech-professionals-bangladesh.git
   ```

### 3. Create a New Branch
   * Create a new branch for your changes:
   
   ```
   git checkout -b add-your-name
   ```

### 4. Add Your Information Alphabetically
   * Open the README.md file.
   * Scroll to the List of Developers section.
   * Add your information alphabetically by first name in the following format:

   ```markdown
### [Your Name]
- **Email**: your.email@example.com
- **LinkedIn**: [your-linkedin-url](https://www.linkedin.com/in/your-profile)
- **GitHub**: [your-github-url](https://github.com/your-username)
- **Experience**: X+ years
- **Current Role**: Your Role at [Company](https://company.com)
- **Skills**: Skill 1, Skill 2, Skill 3
- **Location**: City, Country
- **Remote Work**: Yes/No
   ```
Example
If your name is "John Doe," your addition might look like this: 

```markdown
### John Doe
- **Email**: john.doe@example.com
- **LinkedIn**: [linkedin.com/in/johndoe](https://www.linkedin.com/in/johndoe)
- **GitHub**: [github.com/johndoe](https://github.com/johndoe)
- **Experience**: 5+ years
- **Current Role**: Software Engineer at [Company](https://company.com)
- **Skills**: Python, Django, AWS
- **Location**: Toronto, Canada
- **Remote Work**: Yes
```

**Note** If any of the fields are not applicable, write "N/A" in place of the information.

### 5. Commit Your Changes
   * Once you’ve added your information, commit your changes:
    
   ```
   git add README.md
   git commit -m "Add John Doe to the list of developers"
   ```

### 6. Push Your Changes
   * Push the changes to your forked repository:
   ```
   git push origin add-your-name
   ```

### 7. Create a Pull Request
   * Go to the original repository on GitHub and click the “New Pull Request” button.
   * Ensure your branch is selected and submit the pull request for review.
### 8. Wait for Approval
   * Once your pull request is reviewed and approved, it will be merged into the main repository.
   * Thank you for contributing and helping to build the Bangladeshi tech community worldwide!