# Código do Futuro (Code of the Future)

## 🗂 Modules

### 1 Front-end

#### Class 01 | Agile Methodology
    -  Agile Methodology
    -  Tradicional model x Agile teams
    -  Agile Manifest
    -  What is Scrum?
    -  Scrum Roles
    -  Scrum Advantages
    -  Scrum: Rituals and Cerimonies
    -  Scrum: Artifacts
    -  Scrum Practices I
    -  Scrum Practices II
    -  Scrum: Backlog Refinement
    -  Kanban

#### Class 02 | GIT
    -  Presentation and introduction to the theme
    -  Installation and basic commands
    -  Github and Remote repository
    -  Branch and Merge
    -  Fork, Pull Request and Github Pages

#### Class 03 | Introduction to JavaScript
    -  Review Basic JavaScript
    -  Exercises

#### Class 04 | JavaScript Practice
    -  Review Basic JavaScript
    -  Template String
    -  Ternary Operator
    -  Arrow Functions
    -  Arrays, Spread & Methods
    -  Objects Destructuring
    -  SPA, PWA, and Web Components
    -  Project

#### Class 05 | Angular: Components
    -  Angular CLI
    -  Angular: Generate new project
    -  Angular: Structure
    -  Angular: Components

#### Class 06 | Angular: Properties and Events
    -  Data Binding
    -  Property Binding
    -  Exercise: Property Binding
    -  Event Binding
    -  Customized Event Binding
    -  Exercise: Counter
    -  Two Way Data Binding
    -  Augury

#### Class 07 | Angular: Directives
    -  Introduction to Directives
    -  Directive ngIf
    -  Directive ngFor
    -  Exercise: Directives ngIf and ngFor
    -  Exercise: Directives ngIf and ngFor
    -  Directive ngClass

#### Class 08 | Angular: Encapsulation and Pipes
    -  View Encapsulation
    -  Lifecycle Hooks
    -  Pipes I
    -  Pipes II
    -  Localization
    -  Exercise: Pipes I
    -  Exercise: Pipes II
    -  Reorganizing the Project

#### Class 09 | Angular: Routes and Modules
    -  Routes
    -  Routes: Router link
    -  Routes: Default route and Not found route
    -  Install Bootstrap
    -  Services and Dependency Injection I
    -  Services and Dependency Injection II
    -  Modules
    -  Module Review
    -  HTTP Requests I
    -  HTTP Requests II

#### Class 10 | Angular: Interfaces
    -  Creating Interfaces
    -  Environment variables
    -  Adding Loading and Error Handling
    -  Working with RxJS operators
    -  Observables and RxJS
    -  Adding pagination at Extract
    -  Exercise: Creating contacts screen
    -  Contact details screen with Parameterized Routes
    -  Exercise: Contact Details

#### Class 11 | Angular: Forms
    -  POST, PUT and DELETE Requests
    -  Introduction to Forms
    -  ngForm, ngSubmit and ngModel
    -  ngModel Directive
    -  Forms validation
    -  Displaying form errors
    -  Applying styles at fields validations
    -  Applying own styles at fields validations
    -  Using ViewChild decorator I
    -  Using ViewChild decorator II
    -  Correction of Form parameter type
    -  Login Service I
    -  Login Service II
    -  Adding loading validations on Login
    -  Creating Authentication Service I
    -  Creating Authentication Service II
    -  Upgrading Authentication Service
    -  Adding Route Guards I
    -  Adding Route Guards II
    -  Modularization and Lazy Loading
    -  Augury Routinging and Contacts Refactoring
    -  Son Routes: Logged Area Component I
    -  Son Routes: Logged Area Component II
    -  Modularizating Login and Logout Button

#### Class 12 | Angular: Libraries and Deploy with Firebase
    -  Adding libraries to the project I
    -  Adding libraries to the project II
    -  Deleting a contact
    -  New Contact Component
    -  Reactive Forms
    -  Applying validation on form fields
    -  Applying CSS classes
    -  Creating a contact by POST request
    -  Create Edit Contact screen I
    -  Create Edit Contact screen II
    -  Grouped Forms
    -  Adding Headers with HTTP Interceptor
    -  Uploading an application in Firebase
    -  End of the Course

### 2 Back-end

#### Class 01 | Introduction to .NET
    -  .NET origins
    -  Servers to run .NET (Integration with systems)
    -  Resources

#### Class 02 | .NET Frameworks
    -  .NET Versions
    -  Exercises

#### Class 03 | Identity Server and Visual Studio
    -  Identity Server: Creating the Solution
    -  Identity Server: Setting the API
    -  Identity Server: Setting the Client
    -  Identity Server: Using Access Token
    -  Identity Server: Identity Server with Microservices
    -  Visual Studio: Productivity Resources
    -  Visual Studio: "Hello World"
    -  Visual Studio: Refactoring and IntelliSense

#### Class 04 | Object-oriented
    -  Introduction to Object-oriented
    -  Classes, instances and encapsulation
    -  Solving a logical problem
    -  Creating lists
    -  Creating console application menu
    -  Function to register students
    -  Listing students and calculating grades average
    -  Refactoring code and encapsulated variables
    -  Creating methods at class Student
    -  Understanding the properties of a class
    -  Talking a little bit about methods
    -  Adding methods
    -  Static methods
    -  Contructor methods
    -  Overwritten inheritance and polymorphism
    -  Public, protected, internal and private
    -  Code documentation
    -  Interfaces
    -  Abstract classes and classes members
    -  Sealed classes and classes members

#### Class 05 | SOLID Principles
    -  Introduction to SOLID
    -  SPR - Single Responsibility Principle
    -  OCP - Open-Closed Principle
    -  LSP - Liskov Substitution Principle
    -  ISP - Interface Segregation Principle
    -  DIP - Dependency Inversion Principle

#### Class 06 | Best pratices for software development and testing
    -  Introduction to Best Practices
    -  Clean Code Principles
    -  Clean Code: Classes Name
    -  Clean Code: Methods Name
    -  Clean Code: Function Creation
    -  Clean Code: Code Sample
    -  Clean Code: Class Creation 

#### Class 07 | Database: Fundamentals
    -  Database Selection: Reasons
    -  Normalized Databases x Non Normalized Databases

#### Class 08 | Database: MySQL
    -  Installing MySQL
    -  Creating database and tables with SQL I
    -  Creating database and tables with SQL II
    -  Creating tables at Workbench I
    -  Creating tables at Workbench II
    -  Altering structures and removing tables
    -  Inserting data at tables
    -  Making changes and understanding results
    -  Simple queries
    -  Groupings and totals
    -  Joins with 2 tables
    -  Joins with 3 or more tables
    -  Outer joins
    -  Subqueries

#### Class 09 | MVC Pattern, Models and Views
    -  MVC Pattern: WebForms vs MVC
    -  MVC Pattern: Introduction to MVC Pattern
    -  MVC Pattern: Routing
    -  MVC Pattern: Attribute Routing
    -  MVC Pattern: Action Result
    -  MVC Pattern: Views
    -  Models: Models Creation
    -  Models: Input I
    -  Models: Input II
    -  Models: HTTP Verbs
    -  Models: Model Validation I
    -  Models: Model Validation II
    -  Views: Partial Views
    -  Views: Layouts

#### Class 10 | Design Patterns
    -  Unit of Work: Repository I
    -  Unit of Work: Repository II
    -  Unit of Work: Generic Repository
    -  Unity of Work
    -  Explaining Strategy pattern
    -  Creating Strategy pattern structure
    -  Strategy: Coupling strategies
    -  Singleton: The Sigleton pattern
    -  Singleton: Abstract Factory

#### Class 11 | API's
    -  Building an API
    -  Entity Framework
    -  DTO
    -  Authentication
    -  Cookies X Session
    -  JWT: Json Web Token

#### Class 12 | Message Brokers and Traceability ID
    -  Presenting RabbitMQ
    -  Message Broker with Rebus and RabbitMQ
    -  Azure Service Bus: Sending Messages to the Queue
    -  Azure Service Bus: Receiving Queue Messages
    -  Virtualization: ASP.NET Core Microservices Project
    -  Traceability ID with Jaeger UI

#### Class 13 | Idempotence, Circuit Breaker and Telemetry
    -  Idempotency in commands
    -  Circuit Breaker concept
    -  Setting Polly for HTTP Requests
    -  Demonstrating Circuit Breaker and retries with Polly
    -  Presenting Telemetry
    -  Using telemetry in ASP.NET Core I
    -  Using telemetry in ASP.NET Core II
    -  Telemetry: Introduction to Jaeger

#### Class 14 | Testing and Error handling
    -  Tests: concepts and types
    -  Testing: Unit testing
    -  Testing: Integrated tests
    -  CI (continuous integration) & CD (Continuous delivery)
    -  Deploy application