# Desafio Final - Angular (Código do Futuro)
## Grupo 1
### Equipe

| Integrante | Foto | Redes sociais |
| :------------: | :------------: | :------------: |
| Alexandre da Costa Pedro | <img width="200px" src="https://media-exp1.licdn.com/dms/image/D4D03AQH-U0kZo4Di6w/profile-displayphoto-shrink_200_200/0/1670280075829?e=1675900800&v=beta&t=AKOYkuCpQdMekwT9f-g3WbEbDUtOTk8GnUiq8qKocM4"> | <a href="https://www.linkedin.com/in/alexandre-da-costa-pedro-a319b62b/" rel="nofollow"><img src="https://camo.githubusercontent.com/c00f87aeebbec37f3ee0857cc4c20b21fefde8a96caf4744383ebfe44a47fe3f/68747470733a2f2f696d672e736869656c64732e696f2f62616467652f2d4c696e6b6564496e2d2532333030373742353f7374796c653d666f722d7468652d6261646765266c6f676f3d6c696e6b6564696e266c6f676f436f6c6f723d7768697465" data-canonical-src="https://img.shields.io/badge/-LinkedIn-%230077B5?style=for-the-badge&amp;logo=linkedin&amp;logoColor=white" style="max-width: 100%;"></a> |
| Gabriel Gualberto de Oliveira | <img width="200px" src="https://media-exp1.licdn.com/dms/image/C4D03AQFYvAC-V__hJw/profile-displayphoto-shrink_200_200/0/1600299731633?e=1675900800&v=beta&t=B1uCN7kHQ63HDhy645OFAHkcoX3QnA5SENA3sEKkB30"> | <a href="https://www.linkedin.com/in/ggualberto/" rel="nofollow"><img src="https://camo.githubusercontent.com/c00f87aeebbec37f3ee0857cc4c20b21fefde8a96caf4744383ebfe44a47fe3f/68747470733a2f2f696d672e736869656c64732e696f2f62616467652f2d4c696e6b6564496e2d2532333030373742353f7374796c653d666f722d7468652d6261646765266c6f676f3d6c696e6b6564696e266c6f676f436f6c6f723d7768697465" data-canonical-src="https://img.shields.io/badge/-LinkedIn-%230077B5?style=for-the-badge&amp;logo=linkedin&amp;logoColor=white" style="max-width: 100%;"></a> |
| Jonathan Oliveira Avelino | <img width="200px" src="https://media-exp1.licdn.com/dms/image/C4D03AQGZGH2Ni3zGJQ/profile-displayphoto-shrink_200_200/0/1660338651176?e=1675900800&v=beta&t=u31mBVurDRhQ9ezqd84Kb2ChNYhoTky1N9qzA2I_YLw"> | <a href="https://www.linkedin.com/in/jonathan-avelino/" rel="nofollow"><img src="https://camo.githubusercontent.com/c00f87aeebbec37f3ee0857cc4c20b21fefde8a96caf4744383ebfe44a47fe3f/68747470733a2f2f696d672e736869656c64732e696f2f62616467652f2d4c696e6b6564496e2d2532333030373742353f7374796c653d666f722d7468652d6261646765266c6f676f3d6c696e6b6564696e266c6f676f436f6c6f723d7768697465" data-canonical-src="https://img.shields.io/badge/-LinkedIn-%230077B5?style=for-the-badge&amp;logo=linkedin&amp;logoColor=white" style="max-width: 100%;"></a> |
| Hugo Nunes | <img width="200px" src="https://media-exp1.licdn.com/dms/image/D4D03AQFqcrh5cCZ0yA/profile-displayphoto-shrink_200_200/0/1667692186260?e=1675900800&v=beta&t=V6ad5AuSTFJc4tTrXbIKoj-jFylex2g6EFsZXITxqzo"> | <a href="https://www.linkedin.com/in/hugo-nunes-323a41164/" rel="nofollow"><img src="https://camo.githubusercontent.com/c00f87aeebbec37f3ee0857cc4c20b21fefde8a96caf4744383ebfe44a47fe3f/68747470733a2f2f696d672e736869656c64732e696f2f62616467652f2d4c696e6b6564496e2d2532333030373742353f7374796c653d666f722d7468652d6261646765266c6f676f3d6c696e6b6564696e266c6f676f436f6c6f723d7768697465" data-canonical-src="https://img.shields.io/badge/-LinkedIn-%230077B5?style=for-the-badge&amp;logo=linkedin&amp;logoColor=white" style="max-width: 100%;"></a> |
| Luís Eduardo | <img width="200px" src="https://avatars.githubusercontent.com/u/117494775?v=4"> | <a href="https://www.linkedin.com/in/luis-eduardo-a14b51255/" rel="nofollow"><img src="https://camo.githubusercontent.com/c00f87aeebbec37f3ee0857cc4c20b21fefde8a96caf4744383ebfe44a47fe3f/68747470733a2f2f696d672e736869656c64732e696f2f62616467652f2d4c696e6b6564496e2d2532333030373742353f7374796c653d666f722d7468652d6261646765266c6f676f3d6c696e6b6564696e266c6f676f436f6c6f723d7768697465" data-canonical-src="https://img.shields.io/badge/-LinkedIn-%230077B5?style=for-the-badge&amp;logo=linkedin&amp;logoColor=white" style="max-width: 100%;"></a> |
| Silvia Helena Souza | <img width="200px" src="https://media-exp1.licdn.com/dms/image/C4D03AQGSwhhxnDvNsQ/profile-displayphoto-shrink_200_200/0/1651505804698?e=1675900800&v=beta&t=ZhzsJZ9CPc1cFNDlXFXAcK_rsBtid4b6RVOU3U_dDzg"> | <a href="https://www.linkedin.com/in/silvia-helena-s-94512a57/" rel="nofollow"><img src="https://camo.githubusercontent.com/c00f87aeebbec37f3ee0857cc4c20b21fefde8a96caf4744383ebfe44a47fe3f/68747470733a2f2f696d672e736869656c64732e696f2f62616467652f2d4c696e6b6564496e2d2532333030373742353f7374796c653d666f722d7468652d6261646765266c6f676f3d6c696e6b6564696e266c6f676f436f6c6f723d7768697465" data-canonical-src="https://img.shields.io/badge/-LinkedIn-%230077B5?style=for-the-badge&amp;logo=linkedin&amp;logoColor=white" style="max-width: 100%;"></a> |

<div align = "center">
  <h1> Projeto Radar </h1>
</div>
<br>

<div align = 'center' justify-content = 'space-around' >
<table>
  <thead>
    <tr>
      <th>Descrição da imagem</th>
      <th>Tela</th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td align = 'center'>Página de login</td>
      <td><img width="1604" alt=" Página de Login" src="./frontend/src/assets/screens/login.png"></td>
    </tr>
    <tr>
      <td align = 'center'>Página Home</td>
      <td><img width="1604" alt=" Página Home" src="./frontend/src/assets/screens/home.png"></td>
    </tr>
    <tr>
      <td align = 'center'>Página de cadastro de produtos</td>
      <td><img width="1604" alt=" Página de cadastro de produtos" src="./frontend/src/assets/screens/produtos.png"></td>
    </tr>
    <tr>
      <td align = 'center'>Página cadastro de clientes</td>
      <td><img width="1604" alt=" Página cadastro de clientes" src="./frontend/src/assets/screens/Clientes.png"></td>
    </tr>
    <tr>
      <td align = 'center'>Página cadastro de pedidos dos clientes</td>
      <td><img width="1604" alt=" Página cadastro de pedidos dos clientes" src="./frontend/src/assets/screens/pedidos.png"></td>
    </tr>
    <tr>
      <td align = 'center'>Página de fluxo de caixa, mostrando a movimentação do mês</td>
      <td><img width="1604" alt=" Página de fluxo de caixa, mostrando a movimentação do mês" src="./frontend/src/assets/screens/fluxo.png"></td>
    </tr>
  </tbody>
</table>
</div>
<br>
<br>

<p></p>

<p align="center">
  <a href="#theproject">O Projeto</a> •
  <a href="#target">Objetivo</a> •
  <a href="#technologies">Tecnologias utilizadas</a> •
  <a href="#development">Desenvolvimento</a> •
  <a href="#howtouse">Como utilizar</a> •
  <a href="#greetings">Agradecimentos</a>
</p>
<br>

<div id="theproject">
<h2> 👨🏻‍💻 O Projeto </h2>
<p> Nós recebemos o desafio para desenvolver um sistema chamado Radar, o qual possibilita ao lojista fazer o gerenciamento do fluxo de entrada e saída do seu negócio. </p>
</div>

<div id="target">
<h2> 💡 Objetivo </h2>
<p> Desenvolvimento de um sistema chamado Radar, o qual possibilita ao lojista fazer o gerenciamento do fluxo de entrada e saída do seu negócio.

O sistema foi desenvolvido em Angular, com as seguintes funcionalidades:
<br>
<ul>
  <li>Página de login</li>
  <li>Página home</li>
  <li>Página de cadastro de produtos</li>
  <li>Página cadastro de clientes</li>
  <li>Página cadastro de pedidos dos clientes</li>
  <li>Página de fluxo de caixa, mostrando a movimentação do mês</li>
</ul>

Para gravação das informações, criou-se uma API em Node.js e Express, com a persistência em disco com arquivo.json. Esta API foi integrada à aplicação frontend (Angular).
</p>
</div>
 
<div id="technologies">
<h2> 🛠 Tecnologias utilizadas </h2>
As seguintes tecnologias foram utilizadas para construção do projeto:<br><br>

|                       Descrição                       |           Ferramenta           |            Referência            |
| :----------------------------------------------: | :-----------------------: | :-------------------------------: |
|                       IDE                        |          VS CODE          |  https://code.visualstudio.com/                |
|        Ferramenta de Design de Interface         | FIGMA (Protótipo - UX/UI) |      https://www.figma.com/                |
|   Linguagem de programação (Backend, Frontend)   |        JAVASCRIPT         |  https://developer.mozilla.org/en-US/docs/Web/JavaScript/                |
|        Linguagem de programação (Frontend)       |        TYPESCRIPT         |  https://www.typescriptlang.org/                |
|           API e serviços backend (Backend)       |          NODE.JS          |        https://nodejs.org/                |
|   Framework de aplicação web Node.js (Backend)   |        EXPRESS.JS         |        https://expressjs.com/                |
|          Framework JavaScript (Frontend)         |          ANGULAR          |       https://angular.io/                |
|            Framework de CSS (Frontend)           |         BOOTSTRAP         |       https://getbootstrap.com/                |
|    Biblioteca de Componentes gráficos (UX/UI)     |        FONT AWESOME       |    https://fontawesome.com/                |
|             Open source API (Testing)            |          POSTMAN          |      https://www.postman.com/                 |

<div align = 'center'>
  <h3>Backend | API</h3>
  <img height =' 100px ' src="https://cdn.jsdelivr.net/gh/devicons/devicon/icons/nodejs/nodejs-original.svg"/>
  <img height =' 100px ' left=' 20px ' src="https://cdn.jsdelivr.net/gh/devicons/devicon/icons/express/express-original.svg"/>
  <br>
  <h3>Testing</h3>
  <img width =' 100px ' src="https://www.vectorlogo.zone/logos/getpostman/getpostman-icon.svg" />
  <br>
  <h3>IDE</h3>
  <img height =' 100px ' src="https://cdn.jsdelivr.net/gh/devicons/devicon/icons/vscode/vscode-original.svg" />
  <br>
  <h3>UX/UI</h3>
  <img height =' 100px ' src="https://cdn.jsdelivr.net/gh/devicons/devicon/icons/figma/figma-original.svg" />
  <img height =' 100px ' left='80px' src="https://i0.wp.com/blog.fontawesome.com/wp-content/uploads/2020/08/Proposed.png?resize=720%2C480&ssl=1"/>
  <br>
  <h3>Frontend</h3>
  <img width =' 100px ' src="https://cdn.jsdelivr.net/gh/devicons/devicon/icons/angularjs/angularjs-original.svg" />
  <img width =' 100px ' left='80px' src="https://cdn.jsdelivr.net/gh/devicons/devicon/icons/javascript/javascript-original.svg" />
  <img width =' 100px ' left='80px' src="https://cdn.jsdelivr.net/gh/devicons/devicon/icons/typescript/typescript-original.svg" />
  <img height =' 100px ' left='80px' src="https://cdn.jsdelivr.net/gh/devicons/devicon/icons/bootstrap/bootstrap-original.svg"/>
  <br>
</div>
<br>

<div id="development">
<h2> 📓 Desenvolvimento </h2>
<p> ✔️ Metodologias Ágeis: <br>Para ter uma melhor produtividade no desenvolvimento do projeto foi utilizado a metologia ágil Kaban. Dessa forma, para melhor organização o projeto foi fragmentado em quatro quadros, sendo: 
<br>
<ul>
  <li><bold>Backlog<bold>: as tarefas que precisam ser cumpridas no decorrer da Sprint</li>
  <li><bold>A Fazer<bold>: as tarefas que ainda serão realizadas</li>
  <li><bold>Em andamento<bold>: as tarefas que já estão sendo desenvolvidas</li>
  <li><bold>Concluído<bold>: as tarefas que foram cumpridas</li>
</ul>
<p>
  <a href="https://trello.com/b/xMzUPteQ/projeto-radar" alt="Metodologia Kanban - quadro Trello"> Clique aqui para visualizar os cards.
  </a>
  <br>
  <div align = 'center' justify-content = 'space-around' >
    <img width="1604" alt=" Metodologia Kanban - quadro Trello" src="./frontend/src/assets/screens/ScreenTrello.png">
  </div>
</p>
</div>

<div id="howtouse">
<h2>🧪 Como utilizar</h2>
  <ol &nbsp;>
    <li &nbsp;>Configure a IDE - Visual Studio Code</li>
    <li &nbsp;>Clone o repositório
      <ul>
        <li>git clone https://github.com/alexandrecpedro/radar-project.git</li>
      </ul>
    </li>
    <li &nbsp;>Entre no diretório do projeto:
      <ul>
        <li>cd radar-project</li>
      </ul>
    </li>
    <li><b>Testing</b>
      <ul>
        <li &nbsp;><u>Backend</u>
          <ol>
            <li &nbsp;>Entre no diretório backend
              <ul>
                <li>cd backend</li>
              </ul>
            </li>
            <li &nbsp;>Instale as dependências
              <ul>
                <li>npm install</li>
              </ul>
            </li>
            <li &nbsp;>Run
              <ul>
                <li>npm run dev</li>
              </ul>
            </li>
          </ol>
        </li>
        <li &nbsp;><u>Frontend</u>
          <ol>
            <li &nbsp;>Entre no diretório frontend
              <ul>
                <li>cd frontend</li>
              </ul>
            </li>
            <li &nbsp;>Instale as dependências
              <ul>
                <li>npm install</li>
              </ul>
            </li>
            <li &nbsp;>Run
              <ul>
                <li>ng serve</li>
              </ul>
            </li>
          </ol>
        </li>
      </ul>
    </li>
  </ol>
</div>

<div id="greetings">
<h2> 🤝 Agradecimentos </h2>
<p> Agradecemos à Febrafar/Farmarcas pela oportunidade de participarmos desta bela iniciativa que é o programa de treinamento Código do Futuro, que proporciona a ampliação de conhecimentos e de qualificação na área de desenvolvimento Full Stack - Frontend e Backend (Angular, C#/DotNet). </p>
</div>