import localFont from "next/font/local";
import { Terminal } from "@/components/Terminal";

const calFont = localFont({
  src: "./CalSans-SemiBold.woff2",
  variable: "--font-cal",
  preload: true,
  display: "swap",
});

export default function Home() {
  return (
    <div className="bg-gray-900 min-h-screen sm:overflow-hidden">
      <div
        className={`text-white text-lg text-center pt-8 tracking-wider ${calFont.className}`}
      >
        FULL STACK AI
      </div>

      <div className="relative isolate pt-10">
        <div
          className="absolute inset-x-0 -top-40 -z-10 transform-gpu overflow-hidden blur-3xl sm:-top-80"
          aria-hidden="true"
        >
          <div
            className="relative left-[calc(50%-11rem)] aspect-[1155/678] w-[36.125rem] -translate-x-1/2 rotate-[30deg] bg-gradient-to-tr from-[#ff80b5] to-[#9089fc] opacity-20 sm:left-[calc(50%-30rem)] sm:w-[72.1875rem]"
            style={{
              clipPath:
                "polygon(74.1% 44.1%, 100% 61.6%, 97.5% 26.9%, 85.5% 0.1%, 80.7% 2%, 72.5% 32.5%, 60.2% 62.4%, 52.4% 68.1%, 47.5% 58.3%, 45.2% 34.5%, 27.5% 76.7%, 0.1% 64.9%, 17.9% 100%, 27.6% 76.8%, 76.1% 97.7%, 74.1% 44.1%)",
            }}
          />
        </div>
        <div className="py-24 sm:py-32 lg:pb-40">
          <div className="mx-auto max-w-7xl px-6 lg:px-8">
            <div className="mx-auto max-w-2xl text-center">
              <h1
                className={`text-5xl tracking-wide text-white sm:text-6xl ${calFont.className}`}
              >
                Build a full-stack app from an AI prompt
              </h1>
              <p className="mt-8 text-lg leading-8 text-gray-50">
                Generate a full-stack Next.js app using our AI CLI.<br />
                Your app will be built with TypeScript, Tailwind, Prisma, Postgres, tRPC, authentication, Stripe, and Resend.
              </p>

              <div className="mt-10">
                <Terminal />
              </div>

              <div className="mt-16 flex items-center justify-center gap-x-10">
                <a
                  href="https://www.npmjs.com/package/fsai"
                  className="rounded-md bg-gradient-to-r from-indigo-500 via-purple-500 to-pink-500 px-6 py-4 text-lg font-semibold text-white shadow-sm  hover:from-indigo-600 hover:via-purple-600 hover:to-pink-600 focus-visible:outline focus-visible:outline-2 focus-visible:outline-offset-2 focus-visible:outline-purple-400 flex items-center hover:scale-105 duration-300"
                >
                  Launch your app
                  <RocketIcon className="ml-2 h-5 w-5" />
                </a>
                <a
                  href="https://github.com/alephmatic/full-stack-ai"
                  className="text-lg font-semibold leading-6 text-white hover:opacity-90 flex items-center hover:scale-105 duration-300"
                >
                  <StarIcon className="mr-2 h-5 w-5" />
                  Star on GitHub
                </a>
              </div>

              <iframe
                className="aspect-video h-full w-full rounded-lg mt-16"
                src="https://www.youtube.com/embed/DptvWuRfF2M"
                frameBorder="0"
                allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture"
                allowFullScreen
              />

              <div className="text-white text-center text-lg hover:scale-105 duration-300 mt-16">
                <a href='https://x.com/elie2222'>
                  Built by Elie
                </a>
              </div>
              <div className="text-white text-center text-lg hover:scale-105 duration-300 mt-8">
                <a href='https://www.getinboxzero.com'>
                  I{"'"}m also working on <strong>Inbox Zero</strong>, an open source email app to automate your emails and reach inbox zero fast.
                </a>
              </div>
            </div>
          </div>
        </div>

        <div
          className="absolute inset-x-0 top-[calc(100%-13rem)] -z-10 transform-gpu overflow-hidden blur-3xl sm:top-[calc(100%-30rem)]"
          aria-hidden="true"
        >
          <div
            className="relative left-[calc(50%+3rem)] aspect-[1155/678] w-[36.125rem] -translate-x-1/2 bg-gradient-to-tr from-[#ff80b5] to-[#9089fc] opacity-20 sm:left-[calc(50%+36rem)] sm:w-[72.1875rem]"
            style={{
              clipPath:
                "polygon(74.1% 44.1%, 100% 61.6%, 97.5% 26.9%, 85.5% 0.1%, 80.7% 2%, 72.5% 32.5%, 60.2% 62.4%, 52.4% 68.1%, 47.5% 58.3%, 45.2% 34.5%, 27.5% 76.7%, 0.1% 64.9%, 17.9% 100%, 27.6% 76.8%, 76.1% 97.7%, 74.1% 44.1%)",
            }}
          />
        </div>
      </div>
    </div>
  );
}

function RocketIcon(props: any) {
  return (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="24"
      height="24"
      viewBox="0 0 24 24"
      fill="none"
      stroke="currentColor"
      strokeWidth="2"
      strokeLinecap="round"
      strokeLinejoin="round"
      {...props}
    >
      <path d="M4.5 16.5c-1.5 1.26-2 5-2 5s3.74-.5 5-2c.71-.84.7-2.13-.09-2.91a2.18 2.18 0 0 0-2.91-.09z" />
      <path d="m12 15-3-3a22 22 0 0 1 2-3.95A12.88 12.88 0 0 1 22 2c0 2.72-.78 7.5-6 11a22.35 22.35 0 0 1-4 2z" />
      <path d="M9 12H4s.55-3.03 2-4c1.62-1.08 5 0 5 0" />
      <path d="M12 15v5s3.03-.55 4-2c1.08-1.62 0-5 0-5" />
    </svg>
  );
}

function StarIcon(props: any) {
  return (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="24"
      height="24"
      viewBox="0 0 24 24"
      fill="none"
      stroke="currentColor"
      strokeWidth="2"
      strokeLinecap="round"
      strokeLinejoin="round"
      {...props}
    >
      <polygon points="12 2 15.09 8.26 22 9.27 17 14.14 18.18 21.02 12 17.77 5.82 21.02 7 14.14 2 9.27 8.91 8.26 12 2" />
    </svg>
  );
}
