---
sidebar_position: 1
---

# Overview

<br/>

### What is Netly?

Netly is a robust C# socket library designed to streamline network communication. It offers comprehensive support for multiple protocols, including HTTP, TCP, SSL/TLS, UDP, Reliable UDP (RUDP), and WebSocket. This versatility makes Netly an excellent choice for developing a wide range of applications, from multiplayer games and chat systems to real-time data exchanges.

<br/>

### Why Choose Netly?

-   #### Open Source

        Netly is open source, ensuring that the community contributes to its growth and stability. And released under the MIT license (permissive) and its code is available on github, [see here](https://github.com/alec1o/Netly).

<br/>

-   #### Always Updated

    Netly is constantly updated to ensure you have the latest features and security patches.

<br/>

-   #### Multi-Platform

    Netly supports multiple platforms, including Android, iOS, Windows, Linux, and macOS, making it a versatile choice for your projects. Consoles and embedded systems may are also supported (not tested).

<br/>

-   #### .NET Standard 2.0 Support

    Netly supports .NET Standard 2.0, ensuring compatibility with average .NET version, 4.6.x to the most recent .NET versions.

<br/>

-   #### Multi-Protocol Support

    Netly supports multiple protocols, including:

    -   TCP
    -   UDP
    -   RUDP
    -   HTTP
    -   WebSocket

<br/>

-   #### Small and Performant
    Netly is designed to be small and performant, making it an excellent choice for high-performance applications.

<br/>

### When to use Netly?

-   #### Multiplayer Games

    Netly's support for multiple protocols, including TCP, UDP, and RUDP, makes it an excellent choice for developing multiplayer games that require real-time communication.

    <iframe width="355" height="200" src="https://www.youtube.com/embed/Zg6Vmzum_Nc?si=iDyj0tT73EdLMeGc" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" referrerpolicy="strict-origin-when-cross-origin" allowfullscreen></iframe>

<br/>

-   #### Chat Systems

    Netly's versatility and support for multiple protocols make it an excellent choice for developing chat systems, including those that require encryption (SSL/TLS) and reliability (RUDP).

    <iframe width="355" height="200" src="https://www.youtube.com/embed/4q5tYv8fz4M?si=7RuagewajWz72DKr" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" referrerpolicy="strict-origin-when-cross-origin" allowfullscreen></iframe>

<br/>

-   #### Voice Applications

    Netly's support for real-time communication and multiple protocols makes it an excellent choice for developing voice applications, such as VoIP systems.

<br/>

-   #### API Web Development (HTTP)

    Netly's support for HTTP makes it an excellent choice for developing web APIs that require high-performance and reliability.

<br/>

-   #### Integration with WebSocket Applications

    Netly's support for WebSocket makes it an excellent choice for integrating with WebSocket applications, enabling real-time communication and data exchange.

<br/>
