# malware-tools  
A curated list of malware repositories, trackers and malware analysis tools

## Malware repositories:  
VirusTotal - https://virustotal.com  
VirusBay - https://beta.virusbay.io  
MalBeacon - https://malbeacon.com  
Traffic.moe - https://traffic.moe  
Brad traffic analysis - https://www.malware-traffic-analysis.net  
theZoo - https://github.com/ytisf/theZoo/tree/master/malwares  
Contagio - https://contagiodump.blogspot.com  
OpenMalware - https://openmalware.com  
Virusign - http://www.virusign.com  
DasMelwerk - https://dasmalwerk.eu  
Malquarium - https://malquarium.org  
VirusShare - https://virusshare.com  
MalwareOne - https://malware.one  
AVCaesar - https://avcaesar.malware.lu  
0xffff0800 - https://iec56w4ibovnb4wc.onion.si/Library  
Malshare.com - https://malshare.com  
Malshare.io - https://malshare.io  

### Github repositories:
https://github.com/fabrimagic72/malware-samples  
https://github.com/InQuest/malware-samples  
https://github.com/0x48piraj/MalWAReX  
https://github.com/NEUAI/MalwareLibrary  
https://github.com/Tlgyt/The-Collection  

## Malware trackers:  
URLHaus - https://urlhaus.abuse.ch/browse/  
ViriBack - http://tracker.viriback.com  
0btemoslab - http://tracker.0btemoslab.com  
Malwaresuck - https://malwaresuck.com  
Benkow - http://benkow.cc/passwords.php?page=1  
Haruko - https://tracker.fumik0.com  
VXVault - http://vxvault.net/ViriList.php  
CC Tracker - https://cybercrime-tracker.net  
Malc0de - http://malc0de.com/database  
CRDF - https://threatcenter.crdf.fr  
MDL - https://www.malwaredomainlist.com/mdl.php  
Tweet IOC - http://tweettioc.com  
Stealer Tracker - http://malwr.cc  
ThreatShare - https://threatshare.io/malware/  

## Automated Sandbox evaluation:  
VirusTotal - https://www.virustotal.com  
Hybrid-Analysis - https://www.hybrid-analysis.com  
VMRay - https://www.vmray.com  
Sndbox - https://app.sndbox.com  
VirusBay - https://beta.virusbay.io  
Any.run - https://app.any.run  
Tria.ge - https://tria.ge  
Intezer - https://analyze.intezer.com  
Malwr - https://malwr.com  
Malwr Cuckoo - http://mlwr.ee  
Metadefender - https://metadefender.opswat.com  
Valkyrie - https://valkyrie.comodo.com  
Joe Sandbox - https://www.joesandbox.com  
Pikker - http://sandbox.pikker.ee  
ViCheck - https://www.vicheck.ca  
Jotti - https://virusscan.jotti.org  
Virscan - http://virscan.org  
Anubis - http://anubis.iseclab.org  
Wepawet - https://wepawet.cs.ucsb.edu  
Manalyzer - https://manalyzer.org  
Unpacme - https://www.unpac.me  

## Static string analysis:
### Linux:
file  
trid  
strings  
floss  
xxd  
redress  
ssdeep  
telfhash  
authentihash  
gdb  
strace  
radare2  
exiftool  
elfdump  
objdump  
readelf  
elfutils  
pax-utils  
imphash  
ssdeep  
authentihash  
bulk-extractor  
uudeview  
foremost  
scalpel  
steghide  
stegsnow  
zsteg  
stegosuite  
stegbreak  
stegdetect  
PEpper - https://github.com/Th3Hurrican3/PEpper  
pev  
pecarve  
pescanner.py  
analysePE.py  
AnalyzePE  
upx  
yara  
ripPE - https://github.com/matonis/ripPE  
Unipacker - https://github.com/unipacker/unipacker  
  
### Windows:  
CFF Explorer - https://ntcore.com/?page_id=388  
Resource Hacker - http://www.angusj.com/resourcehacker  
XN Resource Hacker - https://stefansundin.github.io/xn_resource_editor  
Dependency Walker - http://www.dependencywalker.com  
LordPE - http://www.woodmann.com/collaborative/tools/images/Bin_LordPE_2010-6-29_3.9_LordPE_1.41_Deluxe_b.zip  
Scylla - https://github.com/NtQuery/Scylla  
Detect It Easy - https://ntinfo.biz  
PE Explorer - http://www.heaventools.com/overview.htm  
Import REConstructor - https://github.com/NtQuery/Scylla  
LordPE - https://www.aldeid.com/wiki/LordPE  
PEiD - https://www.aldeid.com/wiki/PEiD  
PEview - https://www.aldeid.com/wiki/PEView  
FileAlyzer - https://www.safer-networking.org/products/filealyzer/  
PEstudio - https://www.winitor.com/  
Chimprec - https://www.aldeid.com/wiki/CHimpREC  
PE Insider - https://cerbero.io/peinsider/  
PEframe - https://github.com/guelfoweb/peframe  
UPX - https://github.com/upx  
Manalyze - https://github.com/JusticeRage/Manalyze  
PortEx - https://github.com/katjahahn/PortEx  
Signsrch - https://aluigi.altervista.org/mytoolz/signsrch.zip  
Revelo - http://www.kahusecurity.com/2012/05/revelo-javascript-deobfuscator  
UniExtract2 - https://github.com/Bioruebe/UniExtract2  
MalUnpack - https://github.com/hasherezade/mal_unpack  
PE_recovery_tools - https://github.com/hasherezade/pe_recovery_tools  
Auto XOR decrypter - https://github.com/MRGEffitas/scripts/blob/master/auto_xor_decryptor.py  
  
## Live dynamic detonation:  
### Proxy  
Fiddler - https://www.telerik.com/fiddler  
Burp Suite - https://portswigger.net/burp/communitydownload  
### MitM  
FakeDNS - https://www.fireeye.com/services/freeware/apatedns.html  
ApateDNS - https://github.com/Crypt0s/FakeDns  
### C2  
FakeNet - https://github.com/fireeye/flare-fakenet-ng  
INetSim - https://www.inetsim.org  
netcat - http://netcat.sourceforge.net  
TCPView - https://docs.microsoft.com/en-us/sysinternals/downloads/tcpview  
Wireshark - https://www.wireshark.org  
Imaginary C2 - https://github.com/felixweyne/imaginaryC2  
Suricata - https://suricata-ids.org/download/  
Emerging Threat SIGs - https://rules.emergingthreats.net/  
Tor - https://www.torproject.org/  
### Registry  
RegShot - https://sourceforge.net/projects/regshot  
WhatChanged - https://www.majorgeeks.com/files/details/what_changed.html  
CaptureBAT - https://www.honeynet.org/node/315  
### Process  
Process Hacker - https://github.com/processhacker/processhacker  
Process Monitor - https://docs.microsoft.com/en-us/sysinternals/downloads/procmon  
Process Explorer - https://docs.microsoft.com/en-us/sysinternals/downloads/process-explorer  
ProcessSpawnControl - https://github.com/felixweyne/ProcessSpawnControl  
ProcDOT - http://www.procdot.com  
### API  
API Monitor - http://www.rohitab.com/apimonitor#Download  
APISpy - http://www.matcode.com/apis32.htm  
### Persistance  
Autoruns - https://docs.microsoft.com/en-us/sysinternals/downloads/autoruns  
### Memory  
volatility - https://github.com/volatilityfoundation/volatility  
Memoryze - https://www.fireeye.com/services/freeware/memoryze.html  
OSR Driver Loader - https://www.aldeid.com/wiki/OSR-Driver-Loader  
The Sleuth Kit - https://github.com/sleuthkit/sleuthkit  
Truman - http://nsmwiki.org/Truman_Overview  
yara - https://github.com/virustotal/yara  
### Frameworks  
mastiff - https://github.com/KoreLogicSecurity/mastiff  
IRMA - https://github.com/quarkslab/irma  
VIPER - https://github.com/viper-framework/viper  
Loki - https://github.com/Neo23x0/Loki  
Multiscanner - https://github.com/mitre/multiscanner  
chopshop - https://github.com/MITRECND/chopshop  
Munin - https://github.com/Neo23x0/munin  
Fenrir - https://github.com/Neo23x0/Fenrir  
Harpoon - https://github.com/Neo23x0/harpoon  

  
## Manual reverse engineering:  
### PE:  
Online - https://onlinedisassembler.com/static/home/index.html  
IDA - https://www.hex-rays.com/products/ida/  
Hex-Rays Decompiler - https://www.hex-rays.com/products/decompiler/  
radare2 - https://github.com/radare/radare2  
Binary Ninja - https://binary.ninja/  
BinDiff - https://www.zynamics.com/bindiff.html  
BinNavi - https://github.com/google/binnavi  
Bochs - http://bochs.sourceforge.net/getcurrent.html  
x64dbg - https://x64dbg.com/#start  
WinDbg - https://docs.microsoft.com/en-us/windows-hardware/drivers/debugger/debugger-download-tools  
OllyDbg - http://www.ollydbg.de/  
ImmunityDbg - https://www.immunityinc.com/products/debugger/  
### Shellcode:  
xorsearch - https://blog.didierstevens.com/2014/09/29/update-xorsearch-with-shellcode-detector/  
scdbg - http://sandsprite.com/blogs/index.php?uid=7&pid=152  
shellcode2exe - https://zeltser.com/convert-shellcode-to-assembly/  
jmp2it - https://digital-forensics.sans.org/blog/2014/12/30/taking-control-of-the-instruction-pointer/  
BlobRunner - https://github.com/OALabs/BlobRunner  
### .NET:  
dnSpy - https://github.com/0xd4d/dnSpy  
dotPeek - https://www.jetbrains.com/decompiler  
ILSpy - https://github.com/icsharpcode/ILSpy  
JustDecompile - https://www.telerik.com/products/decompiler.aspx  
JustAssembly - https://www.telerik.com/justassembly  
Reflector - https://www.red-gate.com/products/dotnet-development/reflector/index  
CodeReflect - http://www.devextras.com/decompiler  
Dis# - http://www.netdecompiler.com  
IL Disassembler - https://www.dotnetperls.com/il-disassembler  
Disassembly Diagnoser - https://adamsitnik.com/Disassembly-Diagnoser  
### JS:  
V8 - https://isc.sans.edu/diary/V8+as+an+Alternative+to+SpiderMonkey+for+JavaScript+Deobfuscation/12157  
box-js - https://github.com/CapacitorSet/box-js  
js-detox - https://github.com/svent/jsdetox  
### Flash:  
SWFDec - https://cgit.freedesktop.org/wiki/swfdec  
swf_mastah.py - https://github.com/9b/pdfxray_lite/blob/master/swf_mastah.py  
### VBA:  
ViperMonkey - https://github.com/decalage2/ViperMonkey  
olevba.py - https://github.com/decalage2/oletools/wiki/olevba  
### OLE:  
OfficeMalScanner - http://www.reconstructer.org/code/OfficeMalScanner.zip  
OLETools - https://www.decalage.info/python/oletools  
Hachoir - https://bitbucket.org/haypo/hachoir/wiki/hachoir-urwid  
EXEFilter - http://www.decalage.info/exefilter  
### RTF:  
rtfproc  
rtfprocrule  
rtfraptor  
rtfscan  
rtfobj  
rtfparser  
rtfdump  
### PDF:  
PDF Stream Dumper - http://sandsprite.com/blogs/index.php?uid=7&pid=57  
PDF Dissector - https://blog.zynamics.com/2010/09/03/pdf-dissector-1-7-0-released/  
PDF Tools - https://blog.didierstevens.com/programs/pdf-tools/  
pdfid.py - https://blog.didierstevens.com/programs/pdf-tools/  
pdfparser.py - https://blog.didierstevens.com/programs/pdf-tools/    
peepdf.py - https://github.com/jesparza/peepdf  
qpdf - http://qpdf.sourceforge.net/  
pdfinfo  
pdf2txt  
pdfdetach  
  
## Other:  
Kahusecurity Tools - http://www.kahusecurity.com/tools.html  
DidierStevensSuite - https://github.com/DidierStevens/DidierStevensSuite  
Awesome Malware Analysis list - https://github.com/rshipp/awesome-malware-analysis  
Awesome Reversing list - https://github.com/tylerha97/awesome-reversing  
Remnux - https://remnux.org/  
SANS SIFT - https://digital-forensics.sans.org/community/downloads  
FireEye FLARE-VM - https://github.com/fireeye/flare-vm  
FireEye CommandoVM - https://github.com/fireeye/commando-vm  
Webshell-intel - https://github.com/Neo23x0/webshell-intel  
Malware-behaviors - https://github.com/MAECProject/malware-behaviors  
MalTrail - https://github.com/stamparm/maltrail  
### YARA:
YaraScanner - https://github.com/mitre/yararules-python  
Yara Analyzer - https://github.com/Neo23x0/yarAnalyzer  
Yara Generator - https://github.com/Neo23x0/yarGen  
Awesome-Yara - https://github.com/Neo23x0/awesome-yara  
Malware-signatures - https://github.com/Neo23x0/malware-signatures  
Signature-set - https://github.com/Neo23x0/signature-base  
Yara-rules - https://github.com/Neo23x0/rules  
mkYARA - https://blog.fox-it.com/2019/03/28/mkyara-writing-yara-rules-for-the-lazy-analyst/  
### VirusTotal:
VT Investigator paper - https://storage.googleapis.com/vt-gtm-wp-media/virustotal-for-investigators.pdf  
