{*******************************************************************************
Title: T2Ti ERP                                                                 
Description:  VO  relacionado  tabela [NFCE_RESOLUCAO] 
                                                                                
The MIT License                                                                 
                                                                                
Copyright: Copyright (C) 2010 T2Ti.COM                                          
                                                                                
Permission is hereby granted, free of charge, to any person                     
obtaining a copy of this software and associated documentation                  
files (the "Software"), to deal in the Software without                         
restriction, including without limitation the rights to use,                    
copy, modify, merge, publish, distribute, sublicense, and/or sell               
copies of the Software, and to permit persons to whom the                       
Software is furnished to do so, subject to the following                        
conditions:                                                                     
                                                                                
The above copyright notice and this permission notice shall be                  
included in all copies or substantial portions of the Software.                 
                                                                                
THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,                 
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES                 
OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND                        
NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT                     
HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,                    
WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING                    
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR                   
OTHER DEALINGS IN THE SOFTWARE.                                                 
                                                                                
       The author may be contacted at:                                          
           t2ti.com@gmail.com                                                   
                                                                                
@author Albert Eije (t2ti.com@gmail.com)                    
@version 1.0                                                                    
*******************************************************************************}
unit NfceResolucaoVO;

interface

uses
  VO, Atributos, Classes, Constantes, Generics.Collections, SysUtils, NfcePosicaoComponentesVO;

type
  [TEntity]
  [TTable('NFCE_RESOLUCAO')]
  TNfceResolucaoVO = class(TVO)
  private
    FID: Integer;
    FRESOLUCAO_TELA: String;
    FLARGURA: Integer;
    FALTURA: Integer;
    FIMAGEM_TELA: String;
    FIMAGEM_MENU: String;
    FIMAGEM_SUBMENU: String;

    FListaNfcePosicaoComponentesVO: TObjectList<TNfcePosicaoComponentesVO>;

  public 
    constructor Create; override;
    destructor Destroy; override;

    [TId('ID')]
    [TGeneratedValue(sAuto)]
    [TFormatter(ftZerosAEsquerda, taCenter)]
    property Id: Integer  read FID write FID;
    [TColumn('RESOLUCAO_TELA', 'Resolucao Tela', 160, [ldGrid, ldLookup, ldCombobox], False)]
    property ResolucaoTela: String  read FRESOLUCAO_TELA write FRESOLUCAO_TELA;
    [TColumn('LARGURA', 'Largura', 80, [ldGrid, ldLookup, ldCombobox], False)]
    [TFormatter(ftZerosAEsquerda, taCenter)]
    property Largura: Integer  read FLARGURA write FLARGURA;
    [TColumn('ALTURA', 'Altura', 80, [ldGrid, ldLookup, ldCombobox], False)]
    [TFormatter(ftZerosAEsquerda, taCenter)]
    property Altura: Integer  read FALTURA write FALTURA;
    [TColumn('IMAGEM_TELA', 'Imagem Tela', 400, [ldGrid, ldLookup, ldCombobox], False)]
    property ImagemTela: String  read FIMAGEM_TELA write FIMAGEM_TELA;
    [TColumn('IMAGEM_MENU', 'Imagem Menu', 400, [ldGrid, ldLookup, ldCombobox], False)]
    property ImagemMenu: String  read FIMAGEM_MENU write FIMAGEM_MENU;
    [TColumn('IMAGEM_SUBMENU', 'Imagem Submenu', 400, [ldGrid, ldLookup, ldCombobox], False)]
    property ImagemSubmenu: String  read FIMAGEM_SUBMENU write FIMAGEM_SUBMENU;

    [TManyValuedAssociation('ID_NFCE_RESOLUCAO', 'ID')]
    property ListaNfcePosicaoComponentesVO: TObjectList<TNfcePosicaoComponentesVO> read FListaNfcePosicaoComponentesVO write FListaNfcePosicaoComponentesVO;

  end;

implementation

constructor TNfceResolucaoVO.Create;
begin
  inherited;

  FListaNfcePosicaoComponentesVO := TObjectList<TNfcePosicaoComponentesVO>.Create;
end;

destructor TNfceResolucaoVO.Destroy;
begin
  FreeAndNil(FListaNfcePosicaoComponentesVO);

  inherited;
end;

initialization
  Classes.RegisterClass(TNfceResolucaoVO);

finalization
  Classes.UnRegisterClass(TNfceResolucaoVO);

end.
