{*******************************************************************************
Title: T2Ti ERP                                                                 
Description:  VO  relacionado  tabela [NFCE_POSICAO_COMPONENTES] 
                                                                                
The MIT License                                                                 
                                                                                
Copyright: Copyright (C) 2010 T2Ti.COM                                          
                                                                                
Permission is hereby granted, free of charge, to any person                     
obtaining a copy of this software and associated documentation                  
files (the "Software"), to deal in the Software without                         
restriction, including without limitation the rights to use,                    
copy, modify, merge, publish, distribute, sublicense, and/or sell               
copies of the Software, and to permit persons to whom the                       
Software is furnished to do so, subject to the following                        
conditions:                                                                     
                                                                                
The above copyright notice and this permission notice shall be                  
included in all copies or substantial portions of the Software.                 
                                                                                
THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,                 
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES                 
OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND                        
NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT                     
HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,                    
WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING                    
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR                   
OTHER DEALINGS IN THE SOFTWARE.                                                 
                                                                                
       The author may be contacted at:                                          
           t2ti.com@gmail.com                                                   
                                                                                
@author Albert Eije (t2ti.com@gmail.com)                    
@version 1.0                                                                    
*******************************************************************************}
unit NfcePosicaoComponentesVO;

interface

uses
  VO, Atributos, Classes, Constantes, Generics.Collections, SysUtils;

type
  [TEntity]
  [TTable('NFCE_POSICAO_COMPONENTES')]
  TNfcePosicaoComponentesVO = class(TVO)
  private
    FID: Integer;
    FID_NFCE_RESOLUCAO: Integer;
    FNOME: String;
    FALTURA: Integer;
    FLARGURA: Integer;
    FTOPO: Integer;
    FESQUERDA: Integer;
    FTAMANHO_FONTE: Integer;
    FTEXTO: String;

  public 
    [TId('ID')]
    [TGeneratedValue(sAuto)]
    [TFormatter(ftZerosAEsquerda, taCenter)]
    property Id: Integer  read FID write FID;
    [TColumn('ID_NFCE_RESOLUCAO', 'Id Resolucao', 80, [ldGrid, ldLookup, ldCombobox], False)]
    [TFormatter(ftZerosAEsquerda, taCenter)]
    property IdNfceResolucao: Integer  read FID_NFCE_RESOLUCAO write FID_NFCE_RESOLUCAO;
    [TColumn('NOME', 'Nome', 450, [ldGrid, ldLookup, ldCombobox], False)]
    property Nome: String  read FNOME write FNOME;
    [TColumn('ALTURA', 'Altura', 80, [ldGrid, ldLookup, ldCombobox], False)]
    [TFormatter(ftZerosAEsquerda, taCenter)]
    property Altura: Integer  read FALTURA write FALTURA;
    [TColumn('LARGURA', 'Largura', 80, [ldGrid, ldLookup, ldCombobox], False)]
    [TFormatter(ftZerosAEsquerda, taCenter)]
    property Largura: Integer  read FLARGURA write FLARGURA;
    [TColumn('TOPO', 'Topo', 80, [ldGrid, ldLookup, ldCombobox], False)]
    [TFormatter(ftZerosAEsquerda, taCenter)]
    property Topo: Integer  read FTOPO write FTOPO;
    [TColumn('ESQUERDA', 'Esquerda', 80, [ldGrid, ldLookup, ldCombobox], False)]
    [TFormatter(ftZerosAEsquerda, taCenter)]
    property Esquerda: Integer  read FESQUERDA write FESQUERDA;
    [TColumn('TAMANHO_FONTE', 'Tamanho Fonte', 80, [ldGrid, ldLookup, ldCombobox], False)]
    [TFormatter(ftZerosAEsquerda, taCenter)]
    property TamanhoFonte: Integer  read FTAMANHO_FONTE write FTAMANHO_FONTE;
    [TColumn('TEXTO', 'Texto', 450, [ldGrid, ldLookup, ldCombobox], False)]
    property Texto: String  read FTEXTO write FTEXTO;

  end;

implementation

initialization
  Classes.RegisterClass(TNfcePosicaoComponentesVO);

finalization
  Classes.UnRegisterClass(TNfcePosicaoComponentesVO);


end.
