# Web Visualization with Plotly, Flask and Ajax - Flapjax

<img width="30%" align="right" src="https://cdn-images-1.medium.com/max/800/1*qhJckkB5tgppH0TY5XVrvQ.png"/>

Why use Dash when Plotly plus Flask is easy and more flexible? Add a little bit of AJAX and you can add interactivity.

This repo contains the code for the articles listed, below.

If you find this content useful, please consider this... <br/><br/>
<a href='https://ko-fi.com/M4M64THKG' target='_blank'><img height='36' style='border:0px;height:36px;' src='https://cdn.ko-fi.com/cdn/kofi2.png?v=2' border='0' alt='Buy Me a Coffee at ko-fi.com' /></a>

<hr width="100%"/>

## [Flapjax](https://github.com/alanjones2/flapjax_public)

### An approach to Data visualisation with Flask, Python and Plotly

This new(er) repo is a development from the one your are looking now. It attempts to develop an approach to using Flask and Plotly and supports the tutorials that will be linked there in the future.

[Flapjax](https://github.com/alanjones2/flapjax_public)

<hr width="100%"/>

## Web Visualization with Plotly and Flask

[[Article](https://towardsdatascience.com/web-visualization-with-plotly-and-flask-3660abf9c946)] [[Code](https://github.com/alanjones2/Flask-Plotly/tree/main/plotly)]

<img width="60%" align="right" src="https://miro.medium.com/max/700/0*OZybgTXe44Nr3_KG"/>

This article explores using Flask and Plotly as an alternative to using Dash when creating Web apps. It compares a simple Dash app with a Flask/Plotly one and finds that the latter is easy and more flexible than it's Dash counterpart. You can find the code for the article in the [Plotly](https://github.com/alanjones2/Flask-Plotly/tree/main/plotly) folder.

<hr width="100%"/>

## An Interactive Web Dashboard with Plotly and Flask

[[Article](https://towardsdatascience.com/an-interactive-web-dashboard-with-plotly-and-flask-c365cdec5e3f)] [[Code](https://github.com/alanjones2/Flask-Plotly/tree/main/plotlycallback-gm)]

<img width="60%" align="right" src="https://miro.medium.com/max/1273/1*lrkc5plidfgwhZlAeQ3dmw.png"/>

This article shows how to create a truly interactive app as you might with Dash with callbacks but using Plotly and Flask and a bit of AJAX. The code for this is in 
[plotlycallback-gm](https://github.com/alanjones2/Flask-Plotly/tree/main/plotlycallback-gm).

A slightly modified version of the code above can be found here:
[plotlycallback-gm2](https://github.com/alanjones2/Flask-Plotly/tree/main/plotlycallback-gm2). In this version no parameters are passed to the template and the chart is always loaded using Ajax. It also has the benefit of labelling the chart! 

<hr width="100%"/>

## How to Build a Stock Tracker with Plotly and Flask

[[This article is no longer available](#)] [[Code](https://github.com/alanjones2/Flask-Plotly/tree/main/fin)]

<img width="60%" align="right" src="https://cdn-images-1.medium.com/max/800/1*qhJckkB5tgppH0TY5XVrvQ.png"/>

The _finance_ library for Python gives you access to Yahoo Finance data and Plotly and Flask let you build a stunning dashboard. 
With a Flask back end thaat leverages the _yfinance_ library and _Plotly_, and a web front end that plots a Plotly chart loaded from the server,this article shows you how to create a simple finance web app that produces impressive results.

<hr width="100%"/>

### To get all of the code either clone this repo or [download the zip file](https://github.com/alanjones2/Flask-Plotly/archive/refs/heads/main.zip)

<hr width="100%"/>

If you have found this content useful, please consider this... <br/><br/>
<a href='https://ko-fi.com/M4M64THKG' target='_blank'><img height='36' style='border:0px;height:36px;' src='https://cdn.ko-fi.com/cdn/kofi2.png?v=2' border='0' alt='Buy Me a Coffee at ko-fi.com' /></a>

__*Please note that all the software in this repo is written for educational purposes and should not be considered suitable for production code*__
