
    12-20-89

                   Financial Predictions with Neural Networks

                              by Jeannette Lawrence

    Experts use charts, their pet indicators, and even intuition to navigate
    through the massive amounts of financial information available.  Some
    study a few companies that appear to be good long-term investments.
    Some try to predict the future economy or stock market in general, but
    with the great number of influences involved, this seems at best an
    Olympian task.  Who can absorb years of data for 30 indicators, 500
    stocks, the political climate, and other influences, as well as keep
    track of current values?  There is even new scientific evidence that
    massive systems such as the U.S.  economy or the weather are not
    predictable very far into the future (due to the effects of chaos).

    To assist people in making forecasts for particular markets, there are
    more than 250 computer programs available.  Traditionally, these
    programs have used mathematical methods to make predictions.  While
    useful, they are limited by the predefined variables and equations and
    they cannot take subjective information into consideration (such as the
    quality of foreign relations).  Unfortunately, financial trends are
    often affected by situations that are not easily reduced to equations.

    One way to circumvent the limits of mathematical methods is to use
    rule-based expert systems.  These artificial intelligence systems are
    expensive, require complex programming, use surveys of financial experts
    to define the "game rules", and are still limited in their ability to
    think like people.  Even when a problem is solved, engineering a design
    change can be a monumental task.

                    Let Your Neural Network Do the Thinking

    Now neural networks are being used on personal computers to make
    financial predictions.  You can purchase a neural network program that
    is easy to use and runs on a PC for less than $200.

    They can be given subjective information as well as statistics and are
    not limited to any particular financial theory.  They learn from
    experience instead of following equations or rules.  They can be asked
    to consider hundreds of different influences, more than most people can
    digest.  They won't be overwhelmed by decades of statistics.  You can
    use a neural network in place of, or in addition to, traditional
    methods.

    Using a neural network for advice means you don't have to decipher
    complex waveforms to find a trend.  The network will determine which
    influences correlate to each other, if there are patterns, filtering out
    the noise, and picking up overall trends.  You can ask the network what
    the price of a certain mutual fund is likely to be in the near future,
    if a certain stock is currently a "good buy", or a number of other
    things.  It's up to you.  You decide what you want the network to learn
    and what kind of information it needs to be given in order to arrive at
    a conclusion.

    Neural network programs are a new kind of computing tool which simulate
    the structure and operation of the human brain.  They mimic many of the
    brain's most powerful abilities, including pattern recognition,
    association, and the ability to generalize by observing examples.
    Neural networks create their own model of the problem through a training
    process, so no programming is required.  A trained network provides
    answers with lightning speed, in less than a second.  You can retrain a
    network to use new, updated information in minutes.

    In this article you'll get a glimpse of how neural networks work and a
    look at some sample neural networks which predict the future corporate
    bond ratings of companies and which predict the future price of selected
    mutual funds.  Other common uses for neural networks include medical
    diagnostic systems, insurance claim evaluations, sports event
    predictions, loan risk evaluations, pattern recognition, and business
    analysis and decision making.

                      How Neural Networks Learn to Think

    One of the most puzzling things about people is how they use their
    brains to think.  The brain is composed of hundreds of billions of nerve
    cells (neurons) which are massively connected to each other.  Recently
    biologists have learned that it is the way the cells are connected which
    provides us with intelligence, rather than what is in the cells.  Neural
    networks simulate the structure and operation of the brain's neurons and
    connections.

    A new neural network starts out with a "blank mind".  The network is
    taught about a specific problem, such as predicting a stock's price,
    using a technique called training.  Training a neural network is like
    teaching a small child to recognize the letters of the alphabet.  You
    show him a picture of the letter "A" and ask him what letter he's
    looking at.  If he guesses right, you say so and go on to the next
    letter.  If he doesn't guess right, you tell him that he is looking at
    an "A".  Next, you show him a "B" and repeat the process.  You would do
    this for all the letters of the alphabet, then start over.  Eventually
    he will learn to recognize all of the letters correctly.

    A new neural network is shown some data and it guesses what the result
    should be.  At first the guesses are gibberish.  When the network is
    wrong, it is corrected.  The next time it sees that data, it will guess
    more accurately.  The network is shown lots of data, over and over until
    is learns all the data and results.  Like a person, a trained neural
    network can generalize, making a reasonable guess when given data which
    is different than any it has seen before.  You decide what information
    to provide and the network finds the patterns, trends, and hidden
    relationships.

    Just how does correcting the network cause it to learn?  It's all in the
    connections between the neurons.  The connections allow the neurons to
    communicate with each other and form answers.  When the network makes a
    wrong guess, an adjustment is made to the way neurons are connected,
    thus it is able to learn.  With most commercially available neural
    network programs (such as BrainMaker, used in the examples below) the
    network is created and trained by the program itself;  all you have to
    do is provide the data and the expected results for training.

                      Designing a Financial Neural Network

    Using a very simple example, here are the steps involved in designing a
    neural network.  The first thing you do is decide what result you want
    the network to provide for you and what information it will use to
    arrive at the result.  For example, suppose you want to make a network
    which will predict the price of the Dow Jones Industrial Average (DOW)
    on a month to month average basis, one month in advance.  The
    information to provide the network might include the Consumer Price
    Index (CPI), the price of crude oil, the inflation rate, the prime
    interest rate, the Gross National Product (GNP), and other indicators.

    It's best to give the network lots of information.  If you are unsure if
    there is a relationship, provide the data (for example between how the
    good the weather is over the U.S. and the DOW).  The neural network
    will figure out if the information is important and will learn to ignore
    anything irrelevant.  Sometimes a possibly irrelevant piece of
    information can allow the network to make distinctions which we are not
    aware of.  If there's no correlation, the network will just ignore the
    information.  Mathematical models aren't this flexible.

    If you're unsure about which economic theory to follow, don't worry.
    Some people are technical analysts (they believe the future is
    predictable based on history and current trends), some people are
    fundamentalists (the future is predictable based on principles of the
    system), and some people are monetarists (stability and growth are
    determined by supply of money controlled by the FED).  There is no
    reason to limit a neural network to any one of these theories.  You can
    have your inputs include the price of supplies this month, the price
    last month, and 3 months ago, the consumer price index this month, the
    price last month, and 3 months ago, the inflation rate this month, the
    rate last month, and 3 months ago, the DOW this month, the DOW last
    month, and 3 months ago, the unemployment rate, the political climate,
    and more.  People rarely learn all these things, because it's just too
    much to keep track of, but neural networks do not get overwhelmed by
    detail.

    A simple DOW predictor network might look like this:

    Inputs:                                                Output:

                                     Ŀ
    Which month it is Ĵ           
                                                
    Consumer Price Index Ĵ           
        for this month                  The     
    Price of crude oil Ĵ   Neural   Dow Jones average
        the this month                  Network        next month
    Inflation rate Ĵ           
        the this month                          
    DOW Ĵ           
        the this month                          
    Consumer Price Index Ĵ           
        last month                              
    Price of crude oil Ĵ           
        last month                              
    Inflation rate Ĵ           
        last month                              
    DOW Ĵ           
        last month                              
    Consumer Price Index Ĵ           
        3 months ago                            
    Price of crude oil Ĵ           
        3 months ago                            
    Inflation rate Ĵ           
        3 months ago                            
    DOW Ĵ           
        3 months ago                            
    Overall U.S. weather Ĵ           
        for this month                          
                                     

    This is a simple example.  A better design would have information from
    more periods in the past (last year, e.g.) and a greater variety of
    data.  The data is collected for a substantial period of time, say the
    last 15 years.  For the network to learn properly, you need historical
    data for each month for each kind of data for the last 15 years.  Part
    of you data collection could look like this:

Mo  CPI CPI-1 CPI-3 Oil  Oil-1 Oil-3 Dow  Dow-1 Dow-3  etc.   Dow Ave (output)

Jan 229 220   146   20.0 21.9  19.5  2645 2652  2597          2647
Feb 235 226   155   19.8 20.0  18.3  2633 2645  2585          2637
Mar 244 235   164   19.6 19.8  18.1  2627 2633  2579          2630
Apr 261 244   181   19.6 19.6  18.1  2611 2627  2563          2620
May 276 261   196   19.5 19.6  18.0  2630 2611  2582          2638
Jun 287 276   207   19.5 19.5  18.0  2637 2630  2589          2635
Jul 296 287   212   19.3 19.5  17.8  2640 2637  2592          2641

    Note that these are ficticious values shown for illustration purposes
    only.  In the example above, CPI is a certain month's consumer price
    index, CPI-1 is the index one month before, CPI-3 is the the index 3
    months before, etc.

    You can add traditional mathematical methods to neural networks.  For
    example, to a trend-analyzing network you can add information based upon
    moving averages.  Creating moving averages helps build networks that
    depend on current numbers and past numbers, but ignore extremely short
    small changes.  Assume you want to predict how the price of a stock will
    move, but in a general sort of way in a bigger time frame.  Based on
    what the average stock price has been from week to week during this
    month and last, the network can predict what the average stock price is
    going to be each week for the next month.  Some programs automate this
    task for you.

    After you have your data ready (including the output: DOW average for
    the next month), the program will create and train the new network for
    you.  With some programs, you can watch the training on the display,
    edit and test the network using pop-up menus, print out the results,
    graph trends, etc.  You can set the level of accuracy that you need from
    the network.  After the network is trained, you can give the network
    current information and get a prediction of next month's Dow Jones
    average.

                            Two Proficient Predictors

    Nicholas Murray Butler (an American educator and author) said, "An
    expert is one who knows more and more about less and less." A neural
    network is most expert when it is trained for a particular task, such as
    the future price of a certain stock or a group of related stocks (such
    as all U.S. automobile manufacturers).  It is very difficult to train a
    network to predict for many diverse kinds of stocks, since the stocks
    will react differently to various influences.  It would be a massive
    network that may have trouble learning so many different relationships.

    Creating a neural network financial expert can be quite helpful, even
    for experts.  In this section, two working financial applications are
    described.


    Bond Rating Prediction

    G. R. Pugh & Co.  of Cranford, New Jersey, does consulting to the
    Public Utility industry.  He maintains databases with financial and
    business information on the companies, advises with business forecasts
    and credit risk assessments and predicts the financial and operating
    health of these companies.  Some projections have been as far as 10
    years into the future.

    His expertise is also used by the brokerage industry.  He advises
    clients on the selection of good corporate bonds.  His clients need to
    know more accurately which bonds represent good investments for their
    customers.  Both increases and decreases provide the potential for
    profitable investment.  G. R. Pugh and Company has been using a
    BrainMaker neural network trained on three to four years of historical
    data with an XT-compatible PC to help predict the next year's corporate
    bond ratings of 115 public utilities companies.  "An XT is more than
    sufficient;  it's a FAST program," company president George Pugh notes.
    Learning to use the program and create a neural network from scratch
    took only 2 days.  The network trained itself in about four hours.

    Mr. Pugh announced that his network has been more successful than
    discriminant analysis methods he has used, and even a little better than
    a person could do.  "Discriminant analysis methods are good for getting
    the direction of lively issues, but neural networks pick up the subtle
    interactions much better," he explains.  The network categorizes the
    ratings with 100% accuracy within a broad category and 95% accuracy
    within a subcategory.  The mathematical method of discriminant analysis
    was only 85% accurate within a broad category.  (Bonds are rated much
    like report cards, with broad category ratings such as A, B, C, etc.  A
    subcateogry could be A+, for example.)

    According to Mr. Pugh, "BrainMaker was able to pick up some of the
    interplays in the inputs that statistical analysis couldn't get." The
    network makes a significant contribution to his analysis.  "The network
    allows me to pick up things that are not obvious with typical analysis."

    Moreover, nearly all of the network's difficulties were found to be
    associated with companies that were experiencing a particularly unusual
    problem (such as regulatory risk) or had an atypical business
    relationship (such as being involved in a large sale and lease-back
    transaction).  Ratings also tend to be subjective;  financial items are
    not the only things considered by the rating companies.  These
    influences were not represented in the training facts and makes
    predictions difficult.

    The trained network forecasts next year's Standard & Poor's and Moody's
    corporate bond ratings (both are industry standards) from the previous
    year's S & P and Moody's ratings and 23 other measures of each company's
    financial strength, such as income, sales, returns on equity, 5-year
    growth in sales, and measures of investment, construction, and debt
    load.  Each of these factors is assigned to its own input neuron, and
    each company's ratings for next year are the outputs of the network.

    Mr. Pugh advocates using a neural network as a tool that allows you to
    go beyond discriminant analysis.  He believes neural networks are
    particularly useful when there is a high correlation between data, but
    the network does not lose accuracy when there is "fuzziness" in the
    data.  "It is also able to pick out the trends, and seems to compute a
    decision more the way people do." He has plans for several other
    financial applications in the wings.


    Mutual Fund Prediction

    Dr. Judith Lipmanson of CHI Associates in Bethesda, Maryland, publishes
    technical business documents and newsletters for in-house use at
    technical and advisory firms.  She also is a technical analyst who uses
    a neural network to predict next week's price of 10 selected mutual
    funds for personal use.

    For the past several months, she has been using a BrainMaker neural
    network on a 386-based IBM-compatible AT.  The network gets updated with
    new data every week, and takes only minutes to retrain from scratch on a
    386-based IBM-compatible AT.

    Results have been good.  Currently, the network is producing outputs
    which are about 70% accurate.  Although the network is not perfectly
    accurate in its predictions, she has found that the neural network makes
    predictions which are useful.

    Dr. Lipmanson's network relies on historically-available numerical data
    of the kind typically found in back-issues of the Wall Street Journal.
    These indicators include such factors as the DOW Industrial, DOW
    Utilities, DOW Transportation and Standard & Poor's 500 weekly averages.
    Several years worth of data was gathered for the four initial conditions
    (the inputs) and the ten results (the outputs).  The results were
    shifted by a period of one week and the information was used to train
    the network.

    The network looks something like this:

    Inputs:                                           Outputs:

                              Ŀ
    DOW Industrial Ĵ            Fund # 1 next week
                                The       Fund # 2 next week
    Dow Utility Ĵ            Fund # 3 next week
                                Neural    Fund # 4 next week
    Dow Transportation Ĵ            Fund # 5 next week
                                Network   Fund # 6 next week
    S & P 500 Ĵ            Fund # 7 next week
                                          Fund # 8 next week
                                          Fund # 9 next week
                                          Fund # 10 next week
                              

    She collects the closing weekly averages on Friday and uses the new data
    to predict prices of the 10 mutual funds for the next week.  Making
    forecasts with a trained network requires only a few seconds, and the
    network can be readily updated with new information as it arises.

    A similar network could be trained to predict prices a day or a month in
    advance (or, in fact, all of these) simply by giving the network new
    output neurons and revised training data which reflects the new time
    periods to be predicted.

    The majority of financial applications are simply variations on this
    basic style.  Often additional inputs are used which give the network
    historical information, such as what the DOW was last week.  The design
    of this network, although simple, is effective.


    Summary

    A neural network is a new kind of computing tool that is not limited by
    equations or rules.  Neural networks function by finding correlations
    and patterns in the data which you provide.  These patterns become a
    part of the network during training.  A separate network is needed for
    each problem you want to solve, but many networks follow the same basic
    format.

    The networks described above were created with the BrainMaker Neural
    Network System.  BrainMaker is available from California Scientific
    Software, 10141 Evening Star Dr.  #6, Grass Valley, CA 95945-9051, and
    includes the data manipulation program NetMaker, a 255-page
    "Introduction to Neural Networks" and a 422-page User's Guide.  The
    price is $195.00.
                                                                                                       