# Learn Python Programming

Welcome to my Python learning journey! This repository documents my progress as I learn Python programming from the basics to advanced topics. I'm sharing my notes, code samples, and projects to help others who are on a similar path.

## About This Repository

This repository, `learn_python`, is a collection of resources, notes, and code samples that I'm creating as I learn Python. The name is a playful misspelling of "python" - a reminder that mistakes are part of the learning process!

## Curriculum

I'm following a comprehensive curriculum that covers various aspects of Python programming. You can find the full curriculum [here](./full_curriculam.md). The main topics include:

1. [Introduction to Computer Science and Programming](./01_computer_science_and_programming/README.md/)
2. Python Basics
3. Control Flow
4. Functions and Modules
5. Data Structures and Algorithms
6. Object-Oriented Programming (OOP)
7. File Handling and I/O
8. Advanced Python Concepts
9. Python Standard Library and External Modules
10. Web Development with Python
11. Database Interaction
12. Testing and Debugging
13. Advanced Topics
14. Python for Data Science and Machine Learning
15. Best Practices and Software Development
16. Projects and Practical Applications

## How to Use This Repository

1. Browse through the folders to find folder related to specific topics.
3. Feel free to use the code samples and assessment for your own learning.
4. If you spot any errors or have suggestions, please open an issue or submit a pull request!

## My Learning Approach

I'm documenting my learning process in several ways:

1. Taking detailed notes on each topic.
2. Writing code samples to practice concepts.
3. Working on small projects to apply what I've learned. (will be added very soon)
4. Reflecting on challenges and breakthroughs in my learning journey.

## Contributing

While this is primarily a personal learning repository, I welcome contributions! If you have suggestions for improvements, additional resources, or spot any errors, please feel free to:

1. Open an issue
2. Submit a pull request
3. Reach out to me directly

## Resources

Here are some resources I'm using in my learning journey:

- [Official Python Documentation](https://docs.python.org/3/)
- [Python.org](https://www.python.org/)
- [Real Python](https://realpython.com/)
- [Automate the Boring Stuff with Python](https://automatetheboringstuff.com/)
- [Fluent python by Luciano Ramalho](www.orelly.com)

(Add or modify this list as you discover helpful resources)

## Connect With Me

I'd love to connect with fellow learners and Python enthusiasts! Feel free to reach out to me on [GitHub](https://github.com/akmojahid) or [Facebook](https://fb.me/link.mojahid) or 
[Email](mailto:mojahid7h@gmail.com)

Happy coding, and remember - every expert was once a beginner!
