#include <multiboot.h>
#include <stdint.h>
#include <descriptor_tables.h>
#include <timer.h>
#include <drivers/keyboard/ps2.h>
#include <isr.h>
#include <screen.h>
#include <mm/paging.h>
#include <mm/kheap.h>
#include <thread.h>
#include <string.h>
#include <scheduler.h>
#include <printk.h>

#include <tests/multithreading_test.h>
#include <tests/heap_test.h>


void kernel_main(struct multiboot * mboot)
{
	char kawaii[] = {
		0x20, 0x5f, 0x20, 0x20, 0x20, 0x5f, 0x5f, 0x20, 0x20, 0x20,
		0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
		0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x5f, 0x20, 0x5f,
		0x20, 0x5f, 0x5f, 0x5f, 0x5f, 0x5f, 0x20, 0x5f, 0x5f, 0x5f,
		0x5f, 0x5f, 0x20, 0xa, 0x7c, 0x20, 0x7c, 0x20, 0x2f, 0x20,
		0x2f, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
		0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
		0x28, 0x5f, 0x7c, 0x5f, 0x29, 0x20, 0x20, 0x5f, 0x20, 0x20,
		0x2f, 0x20, 0x20, 0x5f, 0x5f, 0x5f, 0x7c, 0xa, 0x7c, 0x20,
		0x7c, 0x2f, 0x20, 0x2f, 0x20, 0x20, 0x5f, 0x5f, 0x20, 0x5f,
		0x5f, 0x5f, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x5f, 0x5f,
		0x5f, 0x5f, 0x20, 0x5f, 0x20, 0x5f, 0x20, 0x5f, 0x7c, 0x20,
		0x7c, 0x20, 0x7c, 0x20, 0x5c, 0x20, 0x60, 0x2d, 0x2d, 0x2e,
		0x20, 0xa, 0x7c, 0x20, 0x20, 0x20, 0x20, 0x5c, 0x20, 0x2f,
		0x20, 0x5f, 0x60, 0x20, 0x5c, 0x20, 0x5c, 0x20, 0x2f, 0x5c,
		0x20, 0x2f, 0x20, 0x2f, 0x20, 0x5f, 0x60, 0x20, 0x7c, 0x20,
		0x7c, 0x20, 0x7c, 0x20, 0x7c, 0x20, 0x7c, 0x20, 0x7c, 0x60,
		0x2d, 0x2d, 0x2e, 0x20, 0x5c, 0xa, 0x7c, 0x20, 0x7c, 0x5c,
		0x20, 0x20, 0x5c, 0x20, 0x28, 0x5f, 0x7c, 0x20, 0x7c, 0x5c,
		0x20, 0x56, 0x20, 0x20, 0x56, 0x20, 0x2f, 0x20, 0x28, 0x5f,
		0x7c, 0x20, 0x7c, 0x20, 0x7c, 0x20, 0x5c, 0x20, 0x5c, 0x5f,
		0x2f, 0x20, 0x2f, 0x5c, 0x5f, 0x5f, 0x2f, 0x20, 0x2f, 0xa,
		0x5c, 0x5f, 0x7c, 0x20, 0x5c, 0x5f, 0x2f, 0x5c, 0x5f, 0x5f,
		0x2c, 0x5f, 0x7c, 0x20, 0x5c, 0x5f, 0x2f, 0x5c, 0x5f, 0x2f,
		0x20, 0x5c, 0x5f, 0x5f, 0x2c, 0x5f, 0x7c, 0x5f, 0x7c, 0x5f,
		0x7c, 0x5c, 0x5f, 0x5f, 0x5f, 0x2f, 0x5c, 0x5f, 0x5f, 0x5f,
		0x5f, 0x2f, 0x20, 0xa, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
		0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
		0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
		0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
		0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0xa, 0x20, 0x20,
		0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
		0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
		0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
		0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
		0x20, 0xa, 0x0
	};

	cls();
	
	printk(kawaii);

	printk("The educational operating system, by Ahmed Khaled <nemoload@aol.com>\n");
	printk("Source code: https://github.com/nemoload/KawaiiOS\n\n");
	init_descriptor_tables();

	printk("[*] Global Descriptor Table updated\n");
	printk("[*] Interrupt Descriptor Table crated\n");

	keyboard_init();
	printk("[*] PS/2 driver is ready\n");

	
	cli();
	initialise_paging(mboot->mem_upper /*in KiBs */ * 1024);
	sti();

	printk("[*] Paging Initialized\n");
	printk("[*] Kernel Heap Initialized\n");
	
	/* PIC */
	init_timer(44000);
	/*outb(0x60,0xED|4);*/
	printk("[*] PIT Initialized\n");
		
	init_scheduler(init_threading());
	
	printk("[*] Kernel Threads Initialized \n");

	multithreading_test();
}