#
# This module is provided as LIBWEBRTC_USE_FILE by LibWebRTCConfig.cmake.
# It can be INCLUDEd in a project to load the needed compiler and linker
# settings to use LibWebRTC.
#

if (LIBWEBRTC_USE_FILE_INCLUDED)
  return()
endif ()
set(LIBWEBRTC_USE_FILE_INCLUDED 1)

# Enable threading
set(THREADS_PREFER_PTHREAD_FLAG ON)
find_package(Threads REQUIRED)

# Update CMAKE_MODULE_PATH so includes work.
list(APPEND CMAKE_MODULE_PATH ${LIBWEBRTC_CMAKE_DIR})

# Add compiler flags needed to use LibWebRTC.
set(CMAKE_C_FLAGS "${CMAKE_C_FLAGS} ${LIBWEBRTC_REQUIRED_C_FLAGS}")
set(CMAKE_C_FLAGS_DEBUG "${CMAKE_C_FLAGS_DEBUG} ${LIBWEBRTC_REQUIRED_C_FLAGS_DEBUG}")
set(CMAKE_C_FLAGS_RELEASE "${CMAKE_C_FLAGS_RELEASE} ${LIBWEBRTC_REQUIRED_C_FLAGS_RELEASE}")
set(CMAKE_CXX_FLAGS "${CMAKE_CXX_FLAGS} ${LIBWEBRTC_REQUIRED_CXX_FLAGS}")
set(CMAKE_CXX_FLAGS_DEBUG "${CMAKE_CXX_FLAGS_DEBUG} ${LIBWEBRTC_REQUIRED_CXX_FLAGS_DEBUG}")
set(CMAKE_CXX_FLAGS_RELEASE "${CMAKE_CXX_FLAGS_RELEASE} ${LIBWEBRTC_REQUIRED_CXX_FLAGS_RELEASE}")
set(CMAKE_STATIC_LINKER_FLAGS "${CMAKE_STATIC_LINKER_FLAGS} ${LIBWEBRTC_REQUIRED_STATIC_LINKER_FLAGS}")

# Add preprocessor definitions needed to use LibWebRTC.
set_property(DIRECTORY APPEND PROPERTY COMPILE_DEFINITIONS ${LIBWEBRTC_DEFINITIONS})

# Add include directories needed to use LibWebRTC.
include_directories(${LIBWEBRTC_INCLUDE_DIRS})

# Add link directories needed to use LibWebRTC.
link_directories(${LIBWEBRTC_LIBRARY_DIRS})
