# Documate Quickstart

Documate is an open-source tool designed to seamlessly **integrate an AI chat dialog into your documentation site**.

It uses your content to generate real-time answers to user questions, effectively acting as a "ChatGPT" for your platform.

## Getting Started

Documate can integrate with popular frameworks you're already familiar with, and it's versatile enough to be incorporated into your custom project.

Please choose a framework below to get started:

- [VitePress](/integration/vitepress)
- [Docusaurus](/integration/docusaurus)
- [Docsify](/integration/docsify)
- [Rspress](/integration/rspress)
- [Nextra](/integration/nextra)
- [General Vue Project](/getting-started/general-vue)

The following frameworks are coming soon:

- Vuepress
- Docus
- General React Project

## Key Features

### Hassle-free Integration

Documate can integrate with popular frameworks you're already familiar with, such as VitePress, Docusaurus, Docsify, etc. Additionally, it's versatile enough to be incorporated into your custom project.

### Easy to Use

No AI or vector search knowledge required. Simply follow a few steps, and you can integrate Documate into your site in minutes.

### Fully Controllable

You own the code, you own your data, and you can even choose which pages of your content to index.

### Fully Accessible

Documate is designed for accessibility. It supports full keyboard navigation and is compatible with screen readers.

### Fully Customizable

While provides a default UI tailored for your chosen framework, it's also completely adaptable to meet your specific needs.

## Examples

These examples can serve as headless templates to kickstart a new documentation site featuring Documate. For the full list, please visit [Documate examples directory on GitHub](https://github.com/AirCodeLabs/documate/tree/main/examples).

- VitePress ([examples/vitepress](https://github.com/AirCodeLabs/documate/tree/main/examples/vitepress))

::: tabs key:pm
== npm

```bash
npm create documate@latest --template vitepress
```

== yarn

```bash
yarn create documate --template vitepress
```

== pnpm

```bash
pnpm create documate --template vitepress
```

:::

- Docusaurus ([examples/docusaurus](https://github.com/AirCodeLabs/documate/tree/main/examples/docusaurus))

::: tabs key:pm
== npm

```bash
npm create documate@latest --template docusaurus
```

== yarn

```bash
yarn create documate --template docusaurus
```

== pnpm

```bash
pnpm create documate --template docusaurus
```

:::

- Docsify ([examples/docsify](https://github.com/AirCodeLabs/documate/tree/main/examples/docsify))

::: tabs key:pm
== npm

```bash
npm create documate@latest --template docsify
```

== yarn

```bash
yarn create documate --template docsify
```

== pnpm

```bash
pnpm create documate --template docsify
```

:::

- Rspress ([examples/rspress](https://github.com/AirCodeLabs/documate/tree/main/examples/rspress))

::: tabs key:pm
== npm

```bash
npm create documate@latest --template rspress
```

== yarn

```bash
yarn create documate --template rspress
```

== pnpm

```bash
pnpm create documate --template rspress
```

:::

- Nextra ([examples/nextra](https://github.com/AirCodeLabs/documate/tree/main/examples/nextra))

::: tabs key:pm
== npm

```bash
npm create documate@latest --template nextra
```

== yarn

```bash
yarn create documate --template nextra
```

== pnpm

```bash
pnpm create documate --template nextra
```

:::
