#pragma once

typedef int GenModeFlags;
enum _GenModeFlags
{
	GENERATOR_MODE_NONE = 0,
	GENERATOR_MODE_HEADER = (1 << 0),	// header .h
	GENERATOR_MODE_CARD = (1 << 1),		// picture of glyph icon and labels
	GENERATOR_MODE_FONT = (1 << 2),		// ttf file
	GENERATOR_MODE_SRC = (1 << 3),		// src embedded file (cpp, c#, etc)
	GENERATOR_MODE_CURRENT = (1 << 4),
	GENERATOR_MODE_BATCH = (1 << 5),
	GENERATOR_MODE_MERGED = (1 << 6),
	GENERATOR_MODE_MERGED_SETTINGS_DISABLE_GLYPH_RESCALE = (1 << 7),
	GENERATOR_MODE_FONT_SETTINGS_USE_POST_TABLES = (1 << 8),
	GENERATOR_MODE_LANG_C = (1 << 9),
	GENERATOR_MODE_LANG_CPP = (1 << 10),
	GENERATOR_MODE_LANG_CSHARP = (1 << 11),
	GENERATOR_MODE_LANG_LUA = (1 << 12),
	GENERATOR_MODE_LANG_PYTHON = (1 << 13),
	GENERATOR_MODE_LANG_RUST = (1 << 14),
	GENERATOR_MODE_OPEN_GENERATED_FILES_AUTO = (1 << 15),

	// Mix's

	 // for radio widget's
	 GENERATOR_MODE_RADIO_LANG = GENERATOR_MODE_LANG_C | GENERATOR_MODE_LANG_CPP | GENERATOR_MODE_LANG_CSHARP | GENERATOR_MODE_LANG_LUA | GENERATOR_MODE_LANG_PYTHON | GENERATOR_MODE_LANG_RUST,
	 GENERATOR_MODE_RADIO_FONT_SRC = GENERATOR_MODE_FONT | GENERATOR_MODE_SRC,
	 GENERATOR_MODE_RADIO_CUR_BAT_MER = GENERATOR_MODE_CURRENT | GENERATOR_MODE_BATCH | GENERATOR_MODE_MERGED,

	 // for group's

	 // header
	 GENERATOR_MODE_HEADER_CARD = GENERATOR_MODE_HEADER | GENERATOR_MODE_CARD,
	 GENERATOR_MODE_HEADER_CARD_SRC = GENERATOR_MODE_HEADER | GENERATOR_MODE_CARD | GENERATOR_MODE_SRC,

	 // font alone
	 GENERATOR_MODE_CURRENT_CARD = GENERATOR_MODE_CURRENT | GENERATOR_MODE_CARD,
	 GENERATOR_MODE_CURRENT_HEADER = GENERATOR_MODE_CURRENT | GENERATOR_MODE_HEADER,
	 GENERATOR_MODE_CURRENT_HEADER_CARD = GENERATOR_MODE_CURRENT | GENERATOR_MODE_HEADER_CARD,
	 GENERATOR_MODE_CURRENT_FONT = GENERATOR_MODE_CURRENT | GENERATOR_MODE_FONT,
	 GENERATOR_MODE_CURRENT_SRC = GENERATOR_MODE_CURRENT | GENERATOR_MODE_SRC,
	 GENERATOR_MODE_CURRENT_FONT_HEADER = GENERATOR_MODE_CURRENT_FONT | GENERATOR_MODE_HEADER,
	 GENERATOR_MODE_CURRENT_SRC_HEADER = GENERATOR_MODE_CURRENT_SRC | GENERATOR_MODE_HEADER,
	 GENERATOR_MODE_BATCH_CARD = GENERATOR_MODE_BATCH | GENERATOR_MODE_CARD,

	 // batch
	 GENERATOR_MODE_BATCH_HEADER = GENERATOR_MODE_BATCH | GENERATOR_MODE_HEADER,
	 GENERATOR_MODE_BATCH_FONT = GENERATOR_MODE_BATCH | GENERATOR_MODE_FONT,
	 GENERATOR_MODE_BATCH_SRC = GENERATOR_MODE_BATCH | GENERATOR_MODE_SRC,
	 GENERATOR_MODE_BATCH_FONT_HEADER = GENERATOR_MODE_BATCH_FONT | GENERATOR_MODE_HEADER,
	 GENERATOR_MODE_BATCH_SRC_HEADER = GENERATOR_MODE_BATCH_SRC | GENERATOR_MODE_HEADER,

	 // merged
	 GENERATOR_MODE_MERGED_CARD = GENERATOR_MODE_MERGED | GENERATOR_MODE_CARD,
	 GENERATOR_MODE_MERGED_HEADER = GENERATOR_MODE_MERGED | GENERATOR_MODE_HEADER,
	 GENERATOR_MODE_MERGED_FONT = GENERATOR_MODE_MERGED | GENERATOR_MODE_FONT,
	 GENERATOR_MODE_MERGED_SRC = GENERATOR_MODE_MERGED | GENERATOR_MODE_SRC,
	 GENERATOR_MODE_MERGED_FONT_HEADER = GENERATOR_MODE_MERGED_FONT | GENERATOR_MODE_HEADER,
	 GENERATOR_MODE_MERGED_SRC_HEADER = GENERATOR_MODE_MERGED_FONT | GENERATOR_MODE_HEADER,
	 GENERATOR_MODE_MERGED_FONT_HEADER_CARD = GENERATOR_MODE_MERGED_FONT | GENERATOR_MODE_HEADER | GENERATOR_MODE_CARD,
	 GENERATOR_MODE_MERGED_SRC_HEADER_CARD = GENERATOR_MODE_MERGED_FONT | GENERATOR_MODE_HEADER | GENERATOR_MODE_CARD
};

struct ImFont;
class ProjectFile;
class GenMode
{
public:
	GenModeFlags m_GenModeFlags =
		GENERATOR_MODE_CURRENT_HEADER |					// current font + header
		GENERATOR_MODE_FONT_SETTINGS_USE_POST_TABLES |	// tables exported in font
		GENERATOR_MODE_LANG_CPP;						// cpp style for header or source

public:
	void AddGenMode(GenModeFlags vFlags);
	void RemoveGenMode(GenModeFlags vFlags);
	GenModeFlags GetGenMode() const;
	bool IsGenMode(GenModeFlags vFlags) const;

public:
	static void ManageFlag(bool vSelected, GenModeFlags* vContainer, GenModeFlags vFlag, 
		bool vOneOrZeroAtTime, bool vAlwaysOne, GenModeFlags vFlagsToTakeIntoAccount);
	static void ManageFlag(bool vSelected,
		GenModeFlags vFlag, bool vOneOrZeroAtTime, bool vAlwaysOne, GenModeFlags vFlagsToTakeIntoAccount);
	static bool RadioButtonLabeled_BitWize_GenMode(
		float vWidth, const char* vLabel,
		const char* vHelp, GenModeFlags vFlag,
		bool vOneOrZeroAtTime = false, bool vAlwaysOne = true,
		GenModeFlags vFlagsToTakeIntoAccount = (GenModeFlags)0, bool vDisableSelection = false,
		ImFont* vLabelFont = nullptr);
	static bool RadioButtonLabeled_BitWize_GenMode(
		float vWidth, const char* vLabelOK,
		const char* vLabelNOK, const char* vHelp, GenModeFlags vFlag,
		bool vOneOrZeroAtTime = false, bool vAlwaysOne = true, // radio behavior, always one selected
		GenModeFlags vFlagsToTakeIntoAccount = (GenModeFlags)0, bool vDisableSelection = false,
		ImFont* vLabelFont = nullptr);
};
