---

# Online Leave Management System

Welcome to the **Online Leave Management System**! This is a user-friendly web application built with Django, designed to help manage employee leave requests efficiently. Whether you're applying for leave, checking your leave balance, or tracking the status of your applications, this system has you covered.

## Table of Contents

- [Features](#features)
- [Getting Started](#getting-started)
- [Installation](#installation)
- [Usage](#usage)
- [Contributing](#contributing)
- [Contact](#contact)
- [License](#license)

## Features

- **User Authentication**: Secure login, logout, and password management.
- **Leave Management**: Easily apply for leave, view the status of your applications, and check your leave balances.
- **Notifications**: Receive timely updates about the status of your leave applications.
- **Admin Interface**: Admin users can manage users, leave types, and applications through an intuitive admin panel.

## Getting Started

Follow these simple steps to set up the Online Leave Management System on your local machine.

### Prerequisites

Before you begin, ensure you have the following installed:

- **Python 3.x**: A programming language used for building this application.
- **Django**: A web framework for Python.
- **SQLite**: The default database used by this application.

## Installation

### Step 1: Clone the Repository

Open your terminal and run the following command to clone the repository:

```bash
git clone https://github.com/ahmednule/Online_leave_Management_system.git
cd Online-leave-management-system
```

### Step 2: Set Up a Virtual Environment

Creating a virtual environment helps manage dependencies for your project.

**For Windows:**

```bash
python -m venv venv
venv\Scripts\activate
```

**For Linux/Mac:**

```bash
python3 -m venv venv
source venv/bin/activate
```

### Step 3: Install Dependencies

Install Django using the following command:

```bash
pip install Django
```

### Step 4: Apply Migrations

Run the following command to set up the database:

```bash
python manage.py migrate
```

### Step 5: Load Initial Data (Optional)

```skip this process for now```
### Step 6: Create a Superuser (Optional)

To create an admin user with full access, run:

```bash
python manage.py createsuperuser
```

### Step 7: Run the Development Server

Start the server with the following command:

```bash
python manage.py runserver
```

### Step 8: Access the Application

Open your web browser and go to [http://127.0.0.1:8000/](http://127.0.0.1:8000/) to access the application.

## Usage

Once the application is running, you can log in, apply for leave, check your balances, and manage notifications. Admin users can access the admin interface to manage users and leave types.

## Contributing

We welcome contributions! Feel free to fork this project and submit pull requests. Your input helps improve the project.

## Contact

For any inquiries or support, please reach out to **Judy Auma** at [judyauma@gmail.com](mailto:judyauma@gmail.com).

## License

This project is licensed under the **Nairobi Technical Training Institute**.