import React from "react";
import { TouchableOpacity } from "react-native";
import Paragraph from "./Paragraph";

function TextLink({ onPress, style, children }) {
  return (
    <TouchableOpacity testID="clickable" onPress={onPress} style={style}>
      <Paragraph status="primary" fontFamily="Jost-Medium">
        {children}
      </Paragraph>
    </TouchableOpacity>
  );
}

export default TextLink;
