
import { defineComponent, h, computed } from 'vue'

export default defineComponent({
  name: 'SettingsIcon', 
  props: {
    size: {
      type: String,
      default: '24',
      validator: (s) => !isNaN(s) || s.length >= 2 && !isNaN(s.slice(0, s.length - 1)) && s.slice(-1) === 'x'
    },
    color: {
      type: String,
      default: 'currentColor'
    }
  },
  setup(props, { attrs }) {
    const getSize = computed(() => props.size.slice(-1) === 'x' 
      ? props.size.slice(0, props.size.length - 1) + 'em'
      : `${parseInt(props.size)}px`)

    const svg20 = "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"20\" height=\"20\" fill=\"none\" viewBox=\"0 0 20 20\">   <path fill=\"currentColor\" fill-rule=\"evenodd\" d=\"M11.2 1.646a2.03 2.03 0 00-2.4 0c-.736.54-1.942 1.398-2.796 1.886-.794.453-1.894.935-2.635 1.242a2.046 2.046 0 00-1.244 2.161c.115.849.264 2.142.264 3.065 0 .906-.144 2.171-.258 3.021a2.05 2.05 0 001.34 2.199c.86.307 2.132.797 2.922 1.248.762.436 1.699 1.193 2.327 1.733a2.051 2.051 0 002.544.106c.743-.543 1.904-1.365 2.732-1.839.794-.453 1.894-.935 2.635-1.242a2.046 2.046 0 001.244-2.161c-.114-.848-.264-2.142-.264-3.065s.15-2.216.264-3.065a2.046 2.046 0 00-1.244-2.161c-.741-.307-1.841-.789-2.635-1.242-.854-.488-2.06-1.347-2.796-1.886zM9.983 3.259A.028.028 0 0110 3.253c.007 0 .013.002.017.006.732.536 2.022 1.458 2.987 2.01.911.52 2.112 1.042 2.861 1.352.008.004.016.01.022.02a.04.04 0 01.006.027c-.115.85-.282 2.262-.282 3.332 0 1.07.167 2.483.282 3.332a.04.04 0 01-.006.027.045.045 0 01-.022.02c-.75.31-1.95.832-2.861 1.353-.938.535-2.181 1.42-2.92 1.96a.036.036 0 01-.024.007.059.059 0 01-.036-.014c-.635-.546-1.697-1.415-2.639-1.953-.96-.55-2.387-1.09-3.24-1.396a.046.046 0 01-.025-.02.044.044 0 01-.007-.03c.114-.852.276-2.234.276-3.286 0-1.07-.167-2.483-.282-3.332a.04.04 0 01.006-.027.045.045 0 01.022-.02c.75-.31 1.95-.832 2.861-1.353.965-.551 2.255-1.473 2.987-2.01zM9 10a1 1 0 112 0 1 1 0 01-2 0zm1-3a3 3 0 100 6 3 3 0 000-6z\"/> </svg>"
    const svg24 = "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"24\" height=\"24\" fill=\"none\" viewBox=\"0 0 24 24\">   <path fill=\"currentColor\" fill-rule=\"evenodd\" d=\"M13.18 1.62a2.024 2.024 0 00-2.36 0c-.909.652-2.613 1.843-3.806 2.506-1.115.62-2.68 1.274-3.619 1.648a2.038 2.038 0 00-1.263 2.179c.149 1.04.368 2.803.368 4.047 0 1.227-.213 2.957-.361 4.005a2.04 2.04 0 001.359 2.214c1.084.371 2.902 1.036 4.016 1.655 1.093.607 2.436 1.686 3.224 2.354a2.04 2.04 0 002.505.107c.925-.662 2.578-1.814 3.743-2.46 1.115-.62 2.68-1.275 3.619-1.649a2.038 2.038 0 001.263-2.179c-.149-1.04-.368-2.803-.368-4.047 0-1.244.22-3.006.368-4.047a2.038 2.038 0 00-1.263-2.18c-.939-.373-2.504-1.028-3.62-1.647-1.192-.663-2.896-1.854-3.806-2.506zm-1.194 1.625a.024.024 0 01.028 0c.901.646 2.693 1.903 4 2.63 1.237.686 2.907 1.381 3.85 1.757a.035.035 0 01.019.016c.005.008.006.016.005.023C19.74 8.709 19.5 10.598 19.5 12c0 1.402.24 3.29.387 4.33a.034.034 0 01-.004.022.036.036 0 01-.018.016c-.944.376-2.614 1.07-3.85 1.758-1.278.71-3.018 1.925-3.936 2.582a.03.03 0 01-.02.005.047.047 0 01-.028-.01c-.79-.67-2.264-1.866-3.545-2.577-1.29-.717-3.268-1.432-4.34-1.8a.04.04 0 01-.021-.017.035.035 0 01-.006-.024c.148-1.046.381-2.902.381-4.285 0-1.402-.24-3.29-.388-4.33a.035.035 0 01.005-.022.035.035 0 01.018-.016c.944-.376 2.614-1.07 3.85-1.758 1.308-.726 3.1-1.983 4.001-2.629zM10 12a2 2 0 114 0 2 2 0 01-4 0zm2-4a4 4 0 100 8 4 4 0 000-8z\"/> </svg>"

    const updateSvg = (svgString) => {
      const parser = new DOMParser()
      const doc = parser.parseFromString(svgString, 'image/svg+xml')
      const svg = doc.documentElement

      svg.setAttribute('width', getSize.value)
      svg.setAttribute('height', getSize.value)

      svg.querySelectorAll('[fill]:not([fill="none"])').forEach(el => {
        el.setAttribute('fill', props.color)
      })
      svg.querySelectorAll('[stroke]:not([stroke="none"])').forEach(el => {
        el.setAttribute('stroke', props.color)
      })

      return svg.outerHTML
    }

    return () => h('div', {
      ...attrs,
      innerHTML: updateSvg(props.size === '20' ? svg20 : svg24),
      style: {
        display: 'inline-block',
        width: getSize.value,
        height: getSize.value,
      }
    })
  }
})
