
import { defineComponent, h, computed } from 'vue'

export default defineComponent({
  name: 'FaceIdIcon', 
  props: {
    size: {
      type: String,
      default: '24',
      validator: (s) => !isNaN(s) || s.length >= 2 && !isNaN(s.slice(0, s.length - 1)) && s.slice(-1) === 'x'
    },
    color: {
      type: String,
      default: 'currentColor'
    }
  },
  setup(props, { attrs }) {
    const getSize = computed(() => props.size.slice(-1) === 'x' 
      ? props.size.slice(0, props.size.length - 1) + 'em'
      : `${parseInt(props.size)}px`)

    const svg20 = "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"20\" height=\"20\" fill=\"none\" viewBox=\"0 0 20 20\">   <path fill=\"currentColor\" fill-rule=\"evenodd\" d=\"M2 1a1 1 0 00-.748.336l-.245.782v.008l.004.026.012.102.043.39c.037.336.087.814.14 1.38.11 1.135.233 2.616.295 4.02a1 1 0 001.998-.088 84.586 84.586 0 00-.301-4.122c-.03-.306-.057-.587-.083-.834H8a1 1 0 000-2H2zm10.5 0a1 1 0 100 2h4.4l-.073.845c-.098 1.15-.211 2.664-.275 4.11a1 1 0 101.998.09c.062-1.41.174-2.895.27-4.032a132.912 132.912 0 01.161-1.774l.01-.103.003-.026v-.008A1 1 0 0018 1h-5.5zM3.499 12.044a1 1 0 10-1.998-.088 82.599 82.599 0 01-.294 4.02 105.52 105.52 0 01-.184 1.77l-.012.102-.003.026v.006l-.001.002A1 1 0 002 19h6a1 1 0 100-2H3.115a84.905 84.905 0 00.384-4.956zm15.05-.088a1 1 0 10-1.997.088A107.505 107.505 0 0016.9 17h-4.4a1 1 0 100 2H18a1 1 0 00.995-1.102v-.002l-.001-.006-.003-.026-.01-.103-.038-.391a133 133 0 01-.124-1.383 105.732 105.732 0 01-.27-4.031zM7.01 8a1 1 0 000-2H7a1 1 0 100 2h.01zm6 0a1 1 0 100-2H13a1 1 0 100 2h.01zm.628 3.23a1 1 0 01.132 1.408l-.725-.6.725.6v.001l-.002.001-.002.003-.007.008-.018.021c-.015.017-.034.04-.059.066a6.156 6.156 0 01-.946.828c-.622.44-1.573.934-2.736.934-1.163 0-2.114-.493-2.736-.934a6.152 6.152 0 01-.946-.828 3.372 3.372 0 01-.059-.066l-.018-.021-.007-.008-.002-.003H6.23v-.002l.695-.577-.696.577a1 1 0 011.537-1.28l4.562-.1-4.562.1.003.004.026.029a4.149 4.149 0 00.623.543c.438.31.987.566 1.581.566.595 0 1.143-.257 1.582-.566a4.154 4.154 0 00.648-.572l.003-.004a1.01 1.01 0 01.096-.1l1.309-.028zm0 0l-1.31.028a1 1 0 011.31-.028z\"/> </svg>"
    const svg24 = "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"24\" height=\"24\" fill=\"none\" viewBox=\"0 0 24 24\">   <path fill=\"currentColor\" fill-rule=\"evenodd\" d=\"M4.09 4.006l.002-.004L4.094 4H10V2H4.095a2.007 2.007 0 00-1.999 2.17c.109 1.343.285 3.706.364 5.867l1.998-.073C4.378 7.758 4.2 5.36 4.09 4.009v-.003zM14 4h5.907l.001.002a.015.015 0 01.002.003v.004c-.11 1.351-.288 3.75-.368 5.955l1.998.072c.08-2.16.255-4.523.364-5.865a2.007 2.007 0 00-2-2.171H14v2zM4.09 19.991c.11-1.351.288-3.75.368-5.954l-1.998-.074c-.08 2.161-.255 4.524-.364 5.866A2.006 2.006 0 004.094 22H10v-2H4.093l-.001-.001a.013.013 0 01-.002-.003v-.005zm15.452-5.954c.08 2.205.259 4.603.369 5.954v.004s0 .002-.002.002V20l-.002.001H14v2h5.906a2.006 2.006 0 001.998-2.17 140.963 140.963 0 01-.364-5.866l-1.998.072zM8.01 10a1 1 0 100-2H8a1 1 0 000 2h.01zm9-1a1 1 0 01-1 1H16a1 1 0 110-2h.01a1 1 0 011 1zm-8.454 4.169a1 1 0 00-1.112 1.662L8 14l-.556.831.002.001.002.002.007.005.025.016.085.054a13.84 13.84 0 001.343.742c.809.39 1.978.849 3.092.849s2.283-.46 3.092-.849a13.847 13.847 0 001.428-.796l.025-.016.007-.005.002-.002h.001L16 14l.556.831a1 1 0 00-1.112-1.662h-.002l-.014.01a7.21 7.21 0 01-.315.195c-.22.13-.529.303-.887.475-.752.36-1.582.651-2.226.651-.644 0-1.474-.29-2.226-.651a11.825 11.825 0 01-1.202-.67l-.014-.01h-.002zm0 0L8 14l.556-.831z\"/> </svg>"

    const updateSvg = (svgString) => {
      const parser = new DOMParser()
      const doc = parser.parseFromString(svgString, 'image/svg+xml')
      const svg = doc.documentElement

      svg.setAttribute('width', getSize.value)
      svg.setAttribute('height', getSize.value)

      svg.querySelectorAll('[fill]:not([fill="none"])').forEach(el => {
        el.setAttribute('fill', props.color)
      })
      svg.querySelectorAll('[stroke]:not([stroke="none"])').forEach(el => {
        el.setAttribute('stroke', props.color)
      })

      return svg.outerHTML
    }

    return () => h('div', {
      ...attrs,
      innerHTML: updateSvg(props.size === '20' ? svg20 : svg24),
      style: {
        display: 'inline-block',
        width: getSize.value,
        height: getSize.value,
      }
    })
  }
})
