# :construction_worker: Contributor's Guide

Below is the guidance for how to report issues, propose new features, and submit contributions via Pull Requests.

## :beetle: Before you start, file an issue

Please follow this simple rule to help us stop any unnecessary effort and frustration, so we all can ensure an efficient and effective use of everyone's time - yours, ours, and the time of other community members.

> If you have a question, or do you think you have discovered an issue, or would you like to propose a new feature, etc., then find/file an issue before starting work to fix or implement it.
>
>:exclamation: **For security issues please have a look at the [Security Policy](SECURITY.md)** :exclamation:

### :mag_right: Search existing issues first

Before filing a new issue, search existing open and closed issues first. Perhaps someone else has found the problem you are seeing, and someone may be working on or have already contributed a fix.

If no existing item describes your issue/feature, great - please file a new issue.

### :keyboard: File a new Issue

- You found a security issue and you want to report it? Please have a look at the [Security Policy](SECURITY.md).
- You have found a bug and you want to report it? Please file an issue with the tag "bug".
- You have found something critical, perhaps a bug where data can be lost, etc.? Please file an issue with the tag "critical".
- You got a great idea for a new feature? Please file an issue with the tag "feature".
- You have a question that you do not see answered in docs, videos, etc.? Please file an issue with the tag "documentation".
- You found an existing issue that describes yours? Great - please upvote and add additional commentary / info / repro-steps / etc.

### :pencil: Complete the template

Please include as much information as possible in your issue. The more information you provide, the more likely your issue/ask will be understood, accepted, and implemented.

- Do not assume somebody other than you is an expert in setting up your environment and do not assume somebody else is an expert in your workflow. Please tell us as much details you can, so we can help you as good as possible!
- What steps are needed to reproduce the issue? Assume we love to read repro steps. As much detail as you can stand is probably barely enough detail for us.
- We prefer error message text where possible, or screenshots of errors if the error text cannot be captured.
- If you intend to implement the fix/feature yourself, please say so! If you do not indicate you want to contribute, we assume that the issue is our to solve.

### :+1: Do not post "+1" comments

> Please do not post "+1", "me too", or similar comments - these comments just add noise to an issue.

If you do not have any additional information to add but would like to indicate that you are affected by the issue, upvote the original issue by clicking its :smiley:-button and hitting :+1: (+1) icon. This way it is much easier to measure how impactful an issue is.

---

## :man_technologist: Development

### :toolbox: Fork, Clone, Branch and Create your PR

Once you have filed an issue and discussed your proposed feature/fix, it is time to start development:

1. Fork the repo if you have not already
2. Clone your fork locally
3. Create & push a feature branch
4. Create a [Draft Pull Request](https://github.blog/2019-02-14-introducing-draft-pull-requests/)
5. Work on your changes

### :eyeglasses: Code Review

When you would like the project team to take a look, (even if the work is not yet fully-complete), mark the Pull Request as 'Ready For Review' so that the team can review your work and provide comments, suggestions, and request changes. We would like to encourage you to use the Pull Request as tool to start a conversation around your ideas and recruit people to help if necessary. It may take several cycles, but the result will be solid, testable, conformant code that is safe to merge.

### :jigsaw: Merge

Once your code has been reviewed and approved, it will be merged. Once merged, your Pull Request will be automatically closed.

---

## :balloon: Thank you

Thank you in advance for your contribution!