<!-- Please provide a general summary of your changes in the title above -->

# Pull Request
Thank you for your contribution.

Before submitting this Pull Request, please make sure: _Put an `x` in the boxes that apply_
- [ ] You reviewed our [guidelines for contributing](../CONTRIBUTING.md) to this repository
- [ ] Does an issue exists which is related to this Pull Request <!--- This project only accepts Pull Requests related to open issues -->
- [ ] Your code builds clean without any errors or warnings
- [ ] You are using approved terminology
- [ ] You have added necessary documentation (if appropriate)
- [ ] You have added unit tests

## Proposed changes
<!-- Please describe the big picture of your changes here to communicate to the maintainers why we should accept this Pull Request. Why is this change required? What problem does it solve? -->

## Types of changes
What types of changes does your change introduce? _Put an `x` in the boxes that apply_
- [ ] New feature (adds functionality)   <!-- If suggesting a new feature or change, please discuss it in an issue first -->
- [ ] Bugfix (fixes an issue)            <!-- If fixing a bug, there should be an issue describing it with steps to reproduce -->
- [ ] Security (fixes an security issue) | Please have a look at our [Security Policy](../SECURITY.md) first.
- [ ] Code style cleaning or Refactoring (formatting, renaming, restructuring, etc.)
- [ ] Documentation Update
- [ ] Other (please describe):

## Breaking change
Does this Pull Request cause existing functionality to not work as expected or even break. _Put an `x` in the boxes that apply_
- [ ] Yes
- [ ] No

## Solution Description
<!-- Describe your code changes in detail. Explain the technical solution you have provided and how it supports the project. Also explain why you chose the solution you did and what alternatives you considered, etc...-->

## How has this been tested?
<!--- Please describe in detail how you tested your changes. Include details of your testing environment, and the tests you ran to see how your change affects other areas of the code, etc. -->

## Deploy Notes
<!-- Notes regarding deployment of your work. These should note any step, like db migrations, manual work, organizational stuff, etc.-->

## Impacted Areas
<!-- Please list parts of the project that this Pull Request will affect -->
- Area 1
- Area 2
- ...

## Related Issues
<!-- Please list and link to related issues -->
Issue Name        | Issue Number                 
------------------| ---------------------------- 
FIRST ISSUE NAME  | [#1](/user/project/issues/1) 
SECOND ISSUE NAME | [#2](/user/project/issues/2) 
...               | ...

## Related Pull Requests
<!-- Please list and link related Pull Requests against other branches -->
Branch                | Pull Request
----------------------| --------------------------
ft-NNN-NAME-TRACKERID | [#1](/user/project/pull/1)
bg-NNN-NAME-TRACKERID | [#2](/user/project/pull/2)
...                   | ...