<h1 align="center">
  <img src="logo.png" width="275px"/>
</h1>

<p align="center">
    <a href="https://opensource.org/licenses/MIT" rel="nofollow">
        <img alt="MIT license" src="https://img.shields.io/github/license/adrg/os-font-list">
    </a>
    <a href="https://github.com/adrg/os-font-list/graphs/contributors">
        <img alt="GitHub contributors" src="https://img.shields.io/github/contributors/adrg/os-font-list" />
    </a>
    <a href="https://github.com/adrg/os-font-list/issues">
        <img alt="GitHub open issues" src="https://img.shields.io/github/issues-raw/adrg/os-font-list">
    </a>
    <a href="https://ko-fi.com/T6T72WATK">
        <img alt="Buy me a coffee" src="https://img.shields.io/static/v1.svg?label=%20&message=Buy%20me%20a%20coffee&color=579fbf&logo=buy%20me%20a%20coffee&logoColor=white">
    </a>
</p>

Curated lists of fonts for most versions of most operating systems. The font
lists contain fonts installed with the operating system and additional fonts
which can be downloaded from operating system sources.

## Windows

- [Windows 10](https://github.com/adrg/os-font-list/blob/master/md/windows/Windows-10.md)
- [Windows 8.1](https://github.com/adrg/os-font-list/blob/master/md/windows/Windows-8.1.md)
- [Windows 8](https://github.com/adrg/os-font-list/blob/master/md/windows/Windows-8.md)
- [Windows 7](https://github.com/adrg/os-font-list/blob/master/md/windows/Windows-7.md)
- [Windows Vista](https://github.com/adrg/os-font-list/blob/master/md/windows/Windows-Vista.md)
- [Windows XP](https://github.com/adrg/os-font-list/blob/master/md/windows/Windows-XP.md)
- [Windows 2000](https://github.com/adrg/os-font-list/blob/master/md/windows/Windows-2000.md)
- [Windows 98](https://github.com/adrg/os-font-list/blob/master/md/windows/Windows-98.md)
- [Windows 95](https://github.com/adrg/os-font-list/blob/master/md/windows/Windows-95.md)
- [Windows NT](https://github.com/adrg/os-font-list/blob/master/md/windows/Windows-NT.md)
- [Windows 3.1](https://github.com/adrg/os-font-list/blob/master/md/windows/Windows-3.1.md)

## macOS

- [macOS 10.15: Catalina](https://github.com/adrg/os-font-list/blob/master/md/macOS/macOS-10.15_Catalina.md)
- [macOS 10.14: Mojave](https://github.com/adrg/os-font-list/blob/master/md/macOS/macOS-10.14_Mojave.md)
- [macOS 10.13: High Sierra](https://github.com/adrg/os-font-list/blob/master/md/macOS/macOS-10.13_High-Sierra.md)
- [macOS 10.12: Sierra](https://github.com/adrg/os-font-list/blob/master/md/macOS/macOS-10.12_Sierra.md)
- [OS X 10.11: El Capitan](https://github.com/adrg/os-font-list/blob/master/md/macOS/OS-X-10.11_El-Capitan.md)
- [OS X 10.10: Yosemite](https://github.com/adrg/os-font-list/blob/master/md/macOS/OS-X-10.10_Yosemite.md)
- [OS X 10.9: Mavericks](https://github.com/adrg/os-font-list/blob/master/md/macOS/OS-X-10.9_Mavericks.md)
- [OS X 10.8: Mountain Lion](https://github.com/adrg/os-font-list/blob/master/md/macOS/OS-X-10.8_Mountain-Lion.md)
- [Mac OS X 10.7: Lion](https://github.com/adrg/os-font-list/blob/master/md/macOS/Mac-OS-X-10.7_Lion.md)
- [Mac OS X 10.6: Snow Leopard](https://github.com/adrg/os-font-list/blob/master/md/macOS/Mac-OS-X-10.6_Snow-Leopard.md)
- [Mac OS X 10.5: Leopard](https://github.com/adrg/os-font-list/blob/master/md/macOS/Mac-OS-X-10.5_Leopard.md)
- [Mac OS X 10.4: Tiger](https://github.com/adrg/os-font-list/blob/master/md/macOS/Mac-OS-X-10.4_Tiger.md)
- [Mac OS X 10.3: Panther](https://github.com/adrg/os-font-list/blob/master/md/macOS/Mac-OS-X-10.3_Panther.md)

## Linux

#### Ubuntu

- [Ubuntu 21.04: Hirsute Hippo](https://github.com/adrg/os-font-list/blob/master/md/linux/Ubuntu-21.04_Hirsute-Hippo.md)
- [Ubuntu 20.04: Focal Fossa](https://github.com/adrg/os-font-list/blob/master/md/linux/Ubuntu-20.04_Focal-Fossa.md)
- [Ubuntu 19.04: Disco Dingo](https://github.com/adrg/os-font-list/blob/master/md/linux/Ubuntu-19.04_Disco-Dingo.md)
- [Ubuntu 18.04: Bionic Beaver](https://github.com/adrg/os-font-list/blob/master/md/linux/Ubuntu-18.04_Bionic-Beaver.md)
- [Ubuntu 17.04: Zesty Zapus](https://github.com/adrg/os-font-list/blob/master/md/linux/Ubuntu-17.04_Zesty-Zapus.md)
- [Ubuntu 16.04: Xenial Xerus](https://github.com/adrg/os-font-list/blob/master/md/linux/Ubuntu-16.04_Xenial-Xerus.md)
- [Ubuntu 15.04: Wily Werewolf](https://github.com/adrg/os-font-list/blob/master/md/linux/Ubuntu-15.04_Wily-Werewolf.md)
- [Ubuntu 14.04: Trusty Tahr](https://github.com/adrg/os-font-list/blob/master/md/linux/Ubuntu-14.04_Trusty-Tahr.md)
- [Ubuntu 13.04: Raring Ringtail](https://github.com/adrg/os-font-list/blob/master/md/linux/Ubuntu-13.04_Raring-Ringtail.md)
- [Ubuntu 12.04: Precise Pangolin](https://github.com/adrg/os-font-list/blob/master/md/linux/Ubuntu-12.04_Precise-Pangolin.md)
- [Ubuntu 11.04: Natty Narwhal](https://github.com/adrg/os-font-list/blob/master/md/linux/Ubuntu-11.04_Natty-Narwhal.md)
- [Ubuntu 10.04: Lucid Lynx](https://github.com/adrg/os-font-list/blob/master/md/linux/Ubuntu-10.04_Lucid-Lynx.md)

#### Debian

- [Debian 11: Buster](https://github.com/adrg/os-font-list/blob/master/md/linux/Debian-11_Bullseye.md)
- [Debian 10: Buster](https://github.com/adrg/os-font-list/blob/master/md/linux/Debian-10_Buster.md)
- [Debian 9: Stretch](https://github.com/adrg/os-font-list/blob/master/md/linux/Debian-9_Stretch.md)
- [Debian 8: Jessie](https://github.com/adrg/os-font-list/blob/master/md/linux/Debian-8_Jessie.md)
- [Debian 7: Wheezy](https://github.com/adrg/os-font-list/blob/master/md/linux/Debian-7_Wheezy.md)
- [Debian 6: Squeeze](https://github.com/adrg/os-font-list/blob/master/md/linux/Debian-6_Squeeze.md)
- [Debian 5: Lenny](https://github.com/adrg/os-font-list/blob/master/md/linux/Debian-5_Lenny.md)

#### Fedora

- [Fedora 35 Workstation](https://github.com/adrg/os-font-list/blob/master/md/linux/Fedora-35-Workstation.md)
- [Fedora 34 Workstation](https://github.com/adrg/os-font-list/blob/master/md/linux/Fedora-34-Workstation.md)
- [Fedora 33 Workstation](https://github.com/adrg/os-font-list/blob/master/md/linux/Fedora-33-Workstation.md)
- [Fedora 32 Workstation](https://github.com/adrg/os-font-list/blob/master/md/linux/Fedora-32-Workstation.md)
- [Fedora 31 Workstation](https://github.com/adrg/os-font-list/blob/master/md/linux/Fedora-31-Workstation.md)
- [Fedora 30 Workstation](https://github.com/adrg/os-font-list/blob/master/md/linux/Fedora-30-Workstation.md)
- [Fedora 29 Workstation](https://github.com/adrg/os-font-list/blob/master/md/linux/Fedora-29-Workstation.md)
- [Fedora 28 Workstation](https://github.com/adrg/os-font-list/blob/master/md/linux/Fedora-28-Workstation.md)
- [Fedora 27 Workstation](https://github.com/adrg/os-font-list/blob/master/md/linux/Fedora-27-Workstation.md)
- [Fedora 26 Workstation](https://github.com/adrg/os-font-list/blob/master/md/linux/Fedora-26-Workstation.md)
- [Fedora 25 Workstation](https://github.com/adrg/os-font-list/blob/master/md/linux/Fedora-25-Workstation.md)

#### CentOS

- [CentOS 7](https://github.com/adrg/os-font-list/blob/master/md/linux/CentOS-7.md)
- [CentOS 6](https://github.com/adrg/os-font-list/blob/master/md/linux/CentOS-6.md)

## Contributing

Contributions in the form of pull requests, issues or just general feedback,
are always welcome.  
See [CONTRIBUTING.md](https://github.com/adrg/os-font-list/blob/master/CONTRIBUTING.md).

**Contribution guide**

1. Modify one of the existing font CSV files in the `csv` directory, or add a new one.
2. Generate updated versions of Markdown files based on the CSV files: `python ./generate_md.py`.
3. Make a PR with your modifications.

**File naming convention**

`OS-Name-Version_Code-Name.ext` (e.g. `Mac-OS-X-10.6_Snow-Leopard.csv`)

## References

See [REFERENCES.md](https://github.com/adrg/os-font-list/blob/master/REFERENCES.md).

## License

Copyright (c) 2019 Adrian-George Bostan.

This project is licensed under the [MIT license](https://opensource.org/licenses/MIT).
See [LICENSE](https://github.com/adrg/os-font-list/blob/master/LICENSE) for more details.
