## CSL204: Operating Systems Lab

This repository contains the programs and resources developed during the CSL204 Operating Systems Lab sessions.

### Purpose

This repository serves as a central hub for sharing and referencing the lab programs and resources created in CSL204. It aims to:

- **Facilitate collaboration:** Students can access and share code and resources with each other, enabling better understanding and troubleshooting.
- **Maintain a record of work:** Programs and resources are preserved for future reference and revision.
- **Promote learning:** Sharing and reviewing code and resources promotes knowledge exchange and reinforces key operating systems concepts.

### Repository Structure

The repository is organized into folders corresponding to each lab session topic:

- **Bankers Algorithm:** Contains programs and resources related to implementing and simulating the Banker's algorithm for deadlock prevention.
- **Disk Scheduling:** Contains programs and resources related to implementing various disk scheduling algorithms like FCFS, SSTF, SCAN, etc.
- **IPC Semaphore:** Contains programs and resources related to implementing and using semaphores for inter-process communication and synchronization.
- **IPC shm:** Contains programs and resources related to using shared memory for inter-process communication.
- **Memory Allocation:** Contains programs and resources related to implementing various memory allocation algorithms like fixed-size partitioning, variable-size partitioning, buddy system, etc.
- **Page Replacement:** Contains programs and resources related to implementing various page replacement algorithms like FIFO, LRU, OPT, etc.
- **Process Scheduling:** Contains programs and resources related to implementing various process scheduling algorithms like FCFS, SJF, Priority, etc.
- **Shell programs:** Contains shell scripts written for various tasks related to process management, file system manipulation, etc.
- **System Calls:** Contains programs and resources related to using various system calls for file operations, process management, etc.

### Usage

1. **Fork the repository:** This creates your own copy of the code and resources, allowing you to make modifications and contribute your work.
2. **Clone the repository:** Download your forked copy to your local machine.
3. **Navigate to the relevant folder based on the lab session topic.**
4. **Review and explore the provided programs and resources.**
5. **Feel free to modify and adapt the code and resources for your own learning or project purposes.**

### Contributing

Contributions are welcome to this repository. Please consider contributing by:

- Adding programs and resources from your own lab sessions.
- Improving existing code or documentation.
- Reporting any issues or bugs.

Before contributing, please review the following guidelines:

- Ensure your contributions are relevant to the CSL204 course.
- Follow the existing coding style and formatting.
- Provide clear and concise comments for your code.
- Open a pull request for your contributions.

### License

This repository is licensed under the MIT License. Please refer to the LICENSE file for details.

### Contact

For any questions or feedback, please feel free to open an issue on the GitHub repository.

> [!IMPORTANT]  
> This repository is intended for educational purposes only. The provided programs may be incomplete or contain errors. Use them at your own risk and discretion.
