//
//  GoogleMDIconsType.swift
//  GoogleMD-Icons
//
//  Created by Adam Golczak on 26/07/2018.
//

import Foundation

public enum GoogleMDIconType: Int {
    
    public var text: String? {
        return googleMDIconsCodes[rawValue]
    }
    
    public init?(name: String) {
        switch name {
            case "ac_unit": self = .acUnit
            case "access_alarm": self = .accessAlarm
            case "access_alarms": self = .accessAlarms
            case "access_time": self = .accessTime
            case "accessibility": self = .accessibility
            case "accessible": self = .accessible
            case "account_balance": self = .accountBalance
            case "account_balance_wallet": self = .accountBalanceWallet
            case "account_box": self = .accountBox
            case "account_circle": self = .accountCircle
            case "adb": self = .adb
            case "add": self = .add
            case "add_aphoto": self = .addAPhoto
            case "add_alarm": self = .addAlarm
            case "add_alert": self = .addAlert
            case "add_box": self = .addBox
            case "add_circle": self = .addCircle
            case "add_circle_outline": self = .addCircleOutline
            case "add_location": self = .addLocation
            case "add_shopping_cart": self = .addShoppingCart
            case "add_to_photos": self = .addToPhotos
            case "add_to_queue": self = .addToQueue
            case "adjust": self = .adjust
            case "airline_seat_flat": self = .airlineSeatFlat
            case "airline_seat_flat_angled": self = .airlineSeatFlatAngled
            case "airline_seat_individual_suite": self = .airlineSeatIndividualSuite
            case "airline_seat_legroom_extra": self = .airlineSeatLegroomExtra
            case "airline_seat_legroom_normal": self = .airlineSeatLegroomNormal
            case "airline_seat_legroom_reduced": self = .airlineSeatLegroomReduced
            case "airline_seat_recline_extra": self = .airlineSeatReclineExtra
            case "airline_seat_recline_normal": self = .airlineSeatReclineNormal
            case "airplanemode_active": self = .airplanemodeActive
            case "airplanemode_inactive": self = .airplanemodeInactive
            case "airplay": self = .airplay
            case "airport_shuttle": self = .airportShuttle
            case "alarm": self = .alarm
            case "alarm_add": self = .alarmAdd
            case "alarm_off": self = .alarmOff
            case "alarm_on": self = .alarmOn
            case "album": self = .album
            case "all_inclusive": self = .allInclusive
            case "all_out": self = .allOut
            case "android": self = .android
            case "announcement": self = .announcement
            case "apps": self = .apps
            case "archive": self = .archive
            case "arrow_back": self = .arrowBack
            case "arrow_downward": self = .arrowDownward
            case "arrow_drop_down": self = .arrowDropDown
            case "arrow_drop_down_circle": self = .arrowDropDownCircle
            case "arrow_drop_up": self = .arrowDropUp
            case "arrow_forward": self = .arrowForward
            case "arrow_upward": self = .arrowUpward
            case "art_track": self = .artTrack
            case "aspect_ratio": self = .aspectRatio
            case "assessment": self = .assessment
            case "assignment": self = .assignment
            case "assignment_ind": self = .assignmentInd
            case "assignment_late": self = .assignmentLate
            case "assignment_return": self = .assignmentReturn
            case "assignment_returned": self = .assignmentReturned
            case "assignment_turned_in": self = .assignmentTurnedIn
            case "assistant": self = .assistant
            case "assistant_photo": self = .assistantPhoto
            case "attach_file": self = .attachFile
            case "attach_money": self = .attachMoney
            case "attachment": self = .attachment
            case "audiotrack": self = .audiotrack
            case "autorenew": self = .autorenew
            case "av_timer": self = .avTimer
            case "backspace": self = .backspace
            case "backup": self = .backup
            case "battery_alert": self = .batteryAlert
            case "battery_charging_full": self = .batteryChargingFull
            case "battery_full": self = .batteryFull
            case "battery_std": self = .batteryStd
            case "battery_unknown": self = .batteryUnknown
            case "beach_access": self = .beachAccess
            case "beenhere": self = .beenhere
            case "block": self = .block
            case "bluetooth": self = .bluetooth
            case "bluetooth_audio": self = .bluetoothAudio
            case "bluetooth_connected": self = .bluetoothConnected
            case "bluetooth_disabled": self = .bluetoothDisabled
            case "bluetooth_searching": self = .bluetoothSearching
            case "blur_circular": self = .blurCircular
            case "blur_linear": self = .blurLinear
            case "blur_off": self = .blurOff
            case "blur_on": self = .blurOn
            case "book": self = .book
            case "bookmark": self = .bookmark
            case "bookmark_border": self = .bookmarkBorder
            case "border_all": self = .borderAll
            case "border_bottom": self = .borderBottom
            case "border_clear": self = .borderClear
            case "border_color": self = .borderColor
            case "border_horizontal": self = .borderHorizontal
            case "border_inner": self = .borderInner
            case "border_left": self = .borderLeft
            case "border_outer": self = .borderOuter
            case "border_right": self = .borderRight
            case "border_style": self = .borderStyle
            case "border_top": self = .borderTop
            case "border_vertical": self = .borderVertical
            case "branding_watermark": self = .brandingWatermark
            case "brightness1": self = .brightness1
            case "brightness2": self = .brightness2
            case "brightness3": self = .brightness3
            case "brightness4": self = .brightness4
            case "brightness5": self = .brightness5
            case "brightness6": self = .brightness6
            case "brightness7": self = .brightness7
            case "brightness_auto": self = .brightnessAuto
            case "brightness_high": self = .brightnessHigh
            case "brightness_low": self = .brightnessLow
            case "brightness_medium": self = .brightnessMedium
            case "broken_image": self = .brokenImage
            case "brush": self = .brush
            case "bubble_chart": self = .bubbleChart
            case "bug_report": self = .bugReport
            case "build": self = .build
            case "burst_mode": self = .burstMode
            case "business": self = .business
            case "business_center": self = .businessCenter
            case "cached": self = .cached
            case "cake": self = .cake
            case "call": self = .call
            case "call_end": self = .callEnd
            case "call_made": self = .callMade
            case "call_merge": self = .callMerge
            case "call_missed": self = .callMissed
            case "call_missed_outgoing": self = .callMissedOutgoing
            case "call_received": self = .callReceived
            case "call_split": self = .callSplit
            case "call_to_action": self = .callToAction
            case "camera": self = .camera
            case "camera_alt": self = .cameraAlt
            case "camera_enhance": self = .cameraEnhance
            case "camera_front": self = .cameraFront
            case "camera_rear": self = .cameraRear
            case "camera_roll": self = .cameraRoll
            case "cancel": self = .cancel
            case "card_giftcard": self = .cardGiftcard
            case "card_membership": self = .cardMembership
            case "card_travel": self = .cardTravel
            case "casino": self = .casino
            case "cast": self = .cast
            case "cast_connected": self = .castConnected
            case "center_focus_strong": self = .centerFocusStrong
            case "center_focus_weak": self = .centerFocusWeak
            case "change_history": self = .changeHistory
            case "chat": self = .chat
            case "chat_bubble": self = .chatBubble
            case "chat_bubble_outline": self = .chatBubbleOutline
            case "check": self = .check
            case "check_box": self = .checkBox
            case "check_box_outline_blank": self = .checkBoxOutlineBlank
            case "check_circle": self = .checkCircle
            case "chevron_left": self = .chevronLeft
            case "chevron_right": self = .chevronRight
            case "child_care": self = .childCare
            case "child_friendly": self = .childFriendly
            case "chrome_reader_mode": self = .chromeReaderMode
            case "class_icon": self = .classIcon
            case "clear": self = .clear
            case "clear_all": self = .clearAll
            case "close": self = .close
            case "closed_caption": self = .closedCaption
            case "cloud": self = .cloud
            case "cloud_circle": self = .cloudCircle
            case "cloud_done": self = .cloudDone
            case "cloud_download": self = .cloudDownload
            case "cloud_off": self = .cloudOff
            case "cloud_queue": self = .cloudQueue
            case "cloud_upload": self = .cloudUpload
            case "code": self = .code
            case "collections": self = .collections
            case "collections_bookmark": self = .collectionsBookmark
            case "color_lens": self = .colorLens
            case "colorize": self = .colorize
            case "comment": self = .comment
            case "compare": self = .compare
            case "compare_arrows": self = .compareArrows
            case "computer": self = .computer
            case "confirmation_number": self = .confirmationNumber
            case "contact_mail": self = .contactMail
            case "contact_phone": self = .contactPhone
            case "contacts": self = .contacts
            case "content_copy": self = .contentCopy
            case "content_cut": self = .contentCut
            case "content_paste": self = .contentPaste
            case "control_point": self = .controlPoint
            case "control_point_duplicate": self = .controlPointDuplicate
            case "copyright": self = .copyright
            case "create": self = .create
            case "create_new_folder": self = .createNewFolder
            case "credit_card": self = .creditCard
            case "crop": self = .crop
            case "crop169": self = .crop169
            case "crop32": self = .crop32
            case "crop54": self = .crop54
            case "crop75": self = .crop75
            case "crop_din": self = .cropDin
            case "crop_free": self = .cropFree
            case "crop_landscape": self = .cropLandscape
            case "crop_original": self = .cropOriginal
            case "crop_portrait": self = .cropPortrait
            case "crop_rotate": self = .cropRotate
            case "crop_square": self = .cropSquare
            case "dashboard": self = .dashboard
            case "data_usage": self = .dataUsage
            case "date_range": self = .dateRange
            case "dehaze": self = .dehaze
            case "delete": self = .delete
            case "delete_forever": self = .deleteForever
            case "delete_sweep": self = .deleteSweep
            case "description": self = .description
            case "desktop_mac": self = .desktopMac
            case "desktop_windows": self = .desktopWindows
            case "details": self = .details
            case "developer_board": self = .developerBoard
            case "developer_mode": self = .developerMode
            case "device_hub": self = .deviceHub
            case "devices": self = .devices
            case "devices_other": self = .devicesOther
            case "dialer_sip": self = .dialerSip
            case "dialpad": self = .dialpad
            case "directions": self = .directions
            case "directions_bike": self = .directionsBike
            case "directions_boat": self = .directionsBoat
            case "directions_bus": self = .directionsBus
            case "directions_car": self = .directionsCar
            case "directions_railway": self = .directionsRailway
            case "directions_run": self = .directionsRun
            case "directions_subway": self = .directionsSubway
            case "directions_transit": self = .directionsTransit
            case "directions_walk": self = .directionsWalk
            case "disc_full": self = .discFull
            case "dns": self = .dns
            case "do_not_disturb": self = .doNotDisturb
            case "do_not_disturb_alt": self = .doNotDisturbAlt
            case "do_not_disturb_off": self = .doNotDisturbOff
            case "do_not_disturb_on": self = .doNotDisturbOn
            case "dock": self = .dock
            case "domain": self = .domain
            case "done": self = .done
            case "done_all": self = .doneAll
            case "donut_large": self = .donutLarge
            case "donut_small": self = .donutSmall
            case "drafts": self = .drafts
            case "drag_handle": self = .dragHandle
            case "drive_eta": self = .driveEta
            case "dvr": self = .dvr
            case "edit": self = .edit
            case "edit_location": self = .editLocation
            case "eject": self = .eject
            case "email": self = .email
            case "enhanced_encryption": self = .enhancedEncryption
            case "equalizer": self = .equalizer
            case "error": self = .error
            case "error_outline": self = .errorOutline
            case "euro_symbol": self = .euroSymbol
            case "ev_station": self = .evStation
            case "event": self = .event
            case "event_available": self = .eventAvailable
            case "event_busy": self = .eventBusy
            case "event_note": self = .eventNote
            case "event_seat": self = .eventSeat
            case "exit_to_app": self = .exitToApp
            case "expand_less": self = .expandLess
            case "expand_more": self = .expandMore
            case "explicit": self = .explicit
            case "explore": self = .explore
            case "exposure": self = .exposure
            case "exposure_neg1": self = .exposureNeg1
            case "exposure_neg2": self = .exposureNeg2
            case "exposure_plus1": self = .exposurePlus1
            case "exposure_plus2": self = .exposurePlus2
            case "exposure_zero": self = .exposureZero
            case "extension_icon": self = .extensionIcon
            case "face": self = .face
            case "fast_forward": self = .fastForward
            case "fast_rewind": self = .fastRewind
            case "favorite": self = .favorite
            case "favorite_border": self = .favoriteBorder
            case "featured_play_list": self = .featuredPlayList
            case "featured_video": self = .featuredVideo
            case "feedback": self = .feedback
            case "fiber_dvr": self = .fiberDvr
            case "fiber_manual_record": self = .fiberManualRecord
            case "fiber_new": self = .fiberNew
            case "fiber_pin": self = .fiberPin
            case "fiber_smart_record": self = .fiberSmartRecord
            case "file_download": self = .fileDownload
            case "file_upload": self = .fileUpload
            case "filter": self = .filter
            case "filter1": self = .filter1
            case "filter2": self = .filter2
            case "filter3": self = .filter3
            case "filter4": self = .filter4
            case "filter5": self = .filter5
            case "filter6": self = .filter6
            case "filter7": self = .filter7
            case "filter8": self = .filter8
            case "filter9": self = .filter9
            case "filter9_plus": self = .filter9Plus
            case "filter_band_w": self = .filterBAndW
            case "filter_center_focus": self = .filterCenterFocus
            case "filter_drama": self = .filterDrama
            case "filter_frames": self = .filterFrames
            case "filter_hdr": self = .filterHdr
            case "filter_list": self = .filterList
            case "filter_none": self = .filterNone
            case "filter_tilt_shift": self = .filterTiltShift
            case "filter_vintage": self = .filterVintage
            case "find_in_page": self = .findInPage
            case "find_replace": self = .findReplace
            case "fingerprint": self = .fingerprint
            case "first_page": self = .firstPage
            case "fitness_center": self = .fitnessCenter
            case "flag": self = .flag
            case "flare": self = .flare
            case "flash_auto": self = .flashAuto
            case "flash_off": self = .flashOff
            case "flash_on": self = .flashOn
            case "flight": self = .flight
            case "flight_land": self = .flightLand
            case "flight_takeoff": self = .flightTakeoff
            case "flip": self = .flip
            case "flip_to_back": self = .flipToBack
            case "flip_to_front": self = .flipToFront
            case "folder": self = .folder
            case "folder_open": self = .folderOpen
            case "folder_shared": self = .folderShared
            case "folder_special": self = .folderSpecial
            case "font_download": self = .fontDownload
            case "format_align_center": self = .formatAlignCenter
            case "format_align_justify": self = .formatAlignJustify
            case "format_align_left": self = .formatAlignLeft
            case "format_align_right": self = .formatAlignRight
            case "format_bold": self = .formatBold
            case "format_clear": self = .formatClear
            case "format_color_fill": self = .formatColorFill
            case "format_color_reset": self = .formatColorReset
            case "format_color_text": self = .formatColorText
            case "format_indent_decrease": self = .formatIndentDecrease
            case "format_indent_increase": self = .formatIndentIncrease
            case "format_italic": self = .formatItalic
            case "format_line_spacing": self = .formatLineSpacing
            case "format_list_bulleted": self = .formatListBulleted
            case "format_list_numbered": self = .formatListNumbered
            case "format_paint": self = .formatPaint
            case "format_quote": self = .formatQuote
            case "format_shapes": self = .formatShapes
            case "format_size": self = .formatSize
            case "format_strikethrough": self = .formatStrikethrough
            case "format_textdirection_lto_r": self = .formatTextdirectionLToR
            case "format_textdirection_rto_l": self = .formatTextdirectionRToL
            case "format_underlined": self = .formatUnderlined
            case "forum": self = .forum
            case "forward": self = .forward
            case "forward10": self = .forward10
            case "forward30": self = .forward30
            case "forward5": self = .forward5
            case "free_breakfast": self = .freeBreakfast
            case "fullscreen": self = .fullscreen
            case "fullscreen_exit": self = .fullscreenExit
            case "functions": self = .functions
            case "g_translate": self = .gTranslate
            case "gamepad": self = .gamepad
            case "games": self = .games
            case "gavel": self = .gavel
            case "gesture": self = .gesture
            case "get_app": self = .getApp
            case "gif": self = .gif
            case "golf_course": self = .golfCourse
            case "gps_fixed": self = .gpsFixed
            case "gps_not_fixed": self = .gpsNotFixed
            case "gps_off": self = .gpsOff
            case "grade": self = .grade
            case "gradient": self = .gradient
            case "grain": self = .grain
            case "graphic_eq": self = .graphicEq
            case "grid_off": self = .gridOff
            case "grid_on": self = .gridOn
            case "group": self = .group
            case "group_add": self = .groupAdd
            case "group_work": self = .groupWork
            case "hd": self = .hd
            case "hdr_off": self = .hdrOff
            case "hdr_on": self = .hdrOn
            case "hdr_strong": self = .hdrStrong
            case "hdr_weak": self = .hdrWeak
            case "headset": self = .headset
            case "headset_mic": self = .headsetMic
            case "healing": self = .healing
            case "hearing": self = .hearing
            case "help": self = .help
            case "help_outline": self = .helpOutline
            case "high_quality": self = .highQuality
            case "highlight": self = .highlight
            case "highlight_off": self = .highlightOff
            case "history": self = .history
            case "home": self = .home
            case "hot_tub": self = .hotTub
            case "hotel": self = .hotel
            case "hourglass_empty": self = .hourglassEmpty
            case "hourglass_full": self = .hourglassFull
            case "http": self = .http
            case "https": self = .https
            case "image": self = .image
            case "image_aspect_ratio": self = .imageAspectRatio
            case "import_contacts": self = .importContacts
            case "import_export": self = .importExport
            case "important_devices": self = .importantDevices
            case "inbox": self = .inbox
            case "indeterminate_check_box": self = .indeterminateCheckBox
            case "info": self = .info
            case "info_outline": self = .infoOutline
            case "input": self = .input
            case "insert_chart": self = .insertChart
            case "insert_comment": self = .insertComment
            case "insert_drive_file": self = .insertDriveFile
            case "insert_emoticon": self = .insertEmoticon
            case "insert_invitation": self = .insertInvitation
            case "insert_link": self = .insertLink
            case "insert_photo": self = .insertPhoto
            case "invert_colors": self = .invertColors
            case "invert_colors_off": self = .invertColorsOff
            case "iso": self = .iso
            case "keyboard": self = .keyboard
            case "keyboard_arrow_down": self = .keyboardArrowDown
            case "keyboard_arrow_left": self = .keyboardArrowLeft
            case "keyboard_arrow_right": self = .keyboardArrowRight
            case "keyboard_arrow_up": self = .keyboardArrowUp
            case "keyboard_backspace": self = .keyboardBackspace
            case "keyboard_capslock": self = .keyboardCapslock
            case "keyboard_hide": self = .keyboardHide
            case "keyboard_return": self = .keyboardReturn
            case "keyboard_tab": self = .keyboardTab
            case "keyboard_voice": self = .keyboardVoice
            case "kitchen": self = .kitchen
            case "label": self = .label
            case "label_outline": self = .labelOutline
            case "landscape": self = .landscape
            case "language": self = .language
            case "laptop": self = .laptop
            case "laptop_chromebook": self = .laptopChromebook
            case "laptop_mac": self = .laptopMac
            case "laptop_windows": self = .laptopWindows
            case "last_page": self = .lastPage
            case "launch": self = .launch
            case "layers": self = .layers
            case "layers_clear": self = .layersClear
            case "leak_add": self = .leakAdd
            case "leak_remove": self = .leakRemove
            case "lens": self = .lens
            case "library_add": self = .libraryAdd
            case "library_books": self = .libraryBooks
            case "library_music": self = .libraryMusic
            case "lightbulb_outline": self = .lightbulbOutline
            case "line_style": self = .lineStyle
            case "line_weight": self = .lineWeight
            case "linear_scale": self = .linearScale
            case "link": self = .link
            case "linked_camera": self = .linkedCamera
            case "list": self = .list
            case "live_help": self = .liveHelp
            case "live_tv": self = .liveTv
            case "local_activity": self = .localActivity
            case "local_airport": self = .localAirport
            case "local_atm": self = .localAtm
            case "local_bar": self = .localBar
            case "local_cafe": self = .localCafe
            case "local_car_wash": self = .localCarWash
            case "local_convenience_store": self = .localConvenienceStore
            case "local_dining": self = .localDining
            case "local_drink": self = .localDrink
            case "local_florist": self = .localFlorist
            case "local_gas_station": self = .localGasStation
            case "local_grocery_store": self = .localGroceryStore
            case "local_hospital": self = .localHospital
            case "local_hotel": self = .localHotel
            case "local_laundry_service": self = .localLaundryService
            case "local_library": self = .localLibrary
            case "local_mall": self = .localMall
            case "local_movies": self = .localMovies
            case "local_offer": self = .localOffer
            case "local_parking": self = .localParking
            case "local_pharmacy": self = .localPharmacy
            case "local_phone": self = .localPhone
            case "local_pizza": self = .localPizza
            case "local_play": self = .localPlay
            case "local_post_office": self = .localPostOffice
            case "local_printshop": self = .localPrintshop
            case "local_see": self = .localSee
            case "local_shipping": self = .localShipping
            case "local_taxi": self = .localTaxi
            case "location_city": self = .locationCity
            case "location_disabled": self = .locationDisabled
            case "location_off": self = .locationOff
            case "location_on": self = .locationOn
            case "location_searching": self = .locationSearching
            case "lock": self = .lock
            case "lock_open": self = .lockOpen
            case "lock_outline": self = .lockOutline
            case "looks": self = .looks
            case "looks3": self = .looks3
            case "looks4": self = .looks4
            case "looks5": self = .looks5
            case "looks6": self = .looks6
            case "looks_one": self = .looksOne
            case "looks_two": self = .looksTwo
            case "loop": self = .loop
            case "loupe": self = .loupe
            case "low_priority": self = .lowPriority
            case "loyalty": self = .loyalty
            case "mail": self = .mail
            case "mail_outline": self = .mailOutline
            case "map": self = .map
            case "markunread": self = .markunread
            case "markunread_mailbox": self = .markunreadMailbox
            case "memory": self = .memory
            case "menu": self = .menu
            case "merge_type": self = .mergeType
            case "message": self = .message
            case "mic": self = .mic
            case "mic_none": self = .micNone
            case "mic_off": self = .micOff
            case "mms": self = .mms
            case "mode_comment": self = .modeComment
            case "mode_edit": self = .modeEdit
            case "monetization_on": self = .monetizationOn
            case "money_off": self = .moneyOff
            case "monochrome_photos": self = .monochromePhotos
            case "mood": self = .mood
            case "mood_bad": self = .moodBad
            case "more": self = .more
            case "more_horiz": self = .moreHoriz
            case "more_vert": self = .moreVert
            case "motorcycle": self = .motorcycle
            case "mouse": self = .mouse
            case "move_to_inbox": self = .moveToInbox
            case "movie": self = .movie
            case "movie_creation": self = .movieCreation
            case "movie_filter": self = .movieFilter
            case "multiline_chart": self = .multilineChart
            case "music_note": self = .musicNote
            case "music_video": self = .musicVideo
            case "my_location": self = .myLocation
            case "nature": self = .nature
            case "nature_people": self = .naturePeople
            case "navigate_before": self = .navigateBefore
            case "navigate_next": self = .navigateNext
            case "navigation": self = .navigation
            case "near_me": self = .nearMe
            case "network_cell": self = .networkCell
            case "network_check": self = .networkCheck
            case "network_locked": self = .networkLocked
            case "network_wifi": self = .networkWifi
            case "new_releases": self = .newReleases
            case "next_week": self = .nextWeek
            case "nfc": self = .nfc
            case "no_encryption": self = .noEncryption
            case "no_sim": self = .noSim
            case "not_interested": self = .notInterested
            case "note": self = .note
            case "note_add": self = .noteAdd
            case "notifications": self = .notifications
            case "notifications_active": self = .notificationsActive
            case "notifications_none": self = .notificationsNone
            case "notifications_off": self = .notificationsOff
            case "notifications_paused": self = .notificationsPaused
            case "offline_pin": self = .offlinePin
            case "ondemand_video": self = .ondemandVideo
            case "opacity": self = .opacity
            case "open_in_browser": self = .openInBrowser
            case "open_in_new": self = .openInNew
            case "open_with": self = .openWith
            case "pages": self = .pages
            case "pageview": self = .pageview
            case "palette": self = .palette
            case "pan_tool": self = .panTool
            case "panorama": self = .panorama
            case "panorama_fish_eye": self = .panoramaFishEye
            case "panorama_horizontal": self = .panoramaHorizontal
            case "panorama_vertical": self = .panoramaVertical
            case "panorama_wide_angle": self = .panoramaWideAngle
            case "party_mode": self = .partyMode
            case "pause": self = .pause
            case "pause_circle_filled": self = .pauseCircleFilled
            case "pause_circle_outline": self = .pauseCircleOutline
            case "payment": self = .payment
            case "people": self = .people
            case "people_outline": self = .peopleOutline
            case "perm_camera_mic": self = .permCameraMic
            case "perm_contact_calendar": self = .permContactCalendar
            case "perm_data_setting": self = .permDataSetting
            case "perm_device_information": self = .permDeviceInformation
            case "perm_identity": self = .permIdentity
            case "perm_media": self = .permMedia
            case "perm_phone_msg": self = .permPhoneMsg
            case "perm_scan_wifi": self = .permScanWifi
            case "person": self = .person
            case "person_add": self = .personAdd
            case "person_outline": self = .personOutline
            case "person_pin": self = .personPin
            case "person_pin_circle": self = .personPinCircle
            case "personal_video": self = .personalVideo
            case "pets": self = .pets
            case "phone": self = .phone
            case "phone_android": self = .phoneAndroid
            case "phone_bluetooth_speaker": self = .phoneBluetoothSpeaker
            case "phone_forwarded": self = .phoneForwarded
            case "phone_in_talk": self = .phoneInTalk
            case "phone_iphone": self = .phoneIphone
            case "phone_locked": self = .phoneLocked
            case "phone_missed": self = .phoneMissed
            case "phone_paused": self = .phonePaused
            case "phonelink": self = .phonelink
            case "phonelink_erase": self = .phonelinkErase
            case "phonelink_lock": self = .phonelinkLock
            case "phonelink_off": self = .phonelinkOff
            case "phonelink_ring": self = .phonelinkRing
            case "phonelink_setup": self = .phonelinkSetup
            case "photo": self = .photo
            case "photo_album": self = .photoAlbum
            case "photo_camera": self = .photoCamera
            case "photo_filter": self = .photoFilter
            case "photo_library": self = .photoLibrary
            case "photo_size_select_actual": self = .photoSizeSelectActual
            case "photo_size_select_large": self = .photoSizeSelectLarge
            case "photo_size_select_small": self = .photoSizeSelectSmall
            case "picture_as_pdf": self = .pictureAsPdf
            case "picture_in_picture": self = .pictureInPicture
            case "picture_in_picture_alt": self = .pictureInPictureAlt
            case "pie_chart": self = .pieChart
            case "pie_chart_outlined": self = .pieChartOutlined
            case "pin_drop": self = .pinDrop
            case "place": self = .place
            case "play_arrow": self = .playArrow
            case "play_circle_filled": self = .playCircleFilled
            case "play_circle_outline": self = .playCircleOutline
            case "play_for_work": self = .playForWork
            case "playlist_add": self = .playlistAdd
            case "playlist_add_check": self = .playlistAddCheck
            case "playlist_play": self = .playlistPlay
            case "plus_one": self = .plusOne
            case "poll": self = .poll
            case "polymer": self = .polymer
            case "pool": self = .pool
            case "portable_wifi_off": self = .portableWifiOff
            case "portrait": self = .portrait
            case "power": self = .power
            case "power_input": self = .powerInput
            case "power_settings_new": self = .powerSettingsNew
            case "pregnant_woman": self = .pregnantWoman
            case "present_to_all": self = .presentToAll
            case "print": self = .print
            case "priority_high": self = .priorityHigh
            case "public_icon": self = .publicIcon
            case "publish": self = .publish
            case "query_builder": self = .queryBuilder
            case "question_answer": self = .questionAnswer
            case "queue": self = .queue
            case "queue_music": self = .queueMusic
            case "queue_play_next": self = .queuePlayNext
            case "radio": self = .radio
            case "radio_button_checked": self = .radioButtonChecked
            case "radio_button_unchecked": self = .radioButtonUnchecked
            case "rate_review": self = .rateReview
            case "receipt": self = .receipt
            case "recent_actors": self = .recentActors
            case "record_voice_over": self = .recordVoiceOver
            case "redeem": self = .redeem
            case "redo": self = .redo
            case "refresh": self = .refresh
            case "remove": self = .remove
            case "remove_circle": self = .removeCircle
            case "remove_circle_outline": self = .removeCircleOutline
            case "remove_from_queue": self = .removeFromQueue
            case "remove_red_eye": self = .removeRedEye
            case "remove_shopping_cart": self = .removeShoppingCart
            case "reorder": self = .reorder
            case "repeat_icon": self = .repeatIcon
            case "repeat_one": self = .repeatOne
            case "replay": self = .replay
            case "replay10": self = .replay10
            case "replay30": self = .replay30
            case "replay5": self = .replay5
            case "reply": self = .reply
            case "reply_all": self = .replyAll
            case "report": self = .report
            case "report_problem": self = .reportProblem
            case "restaurant": self = .restaurant
            case "restaurant_menu": self = .restaurantMenu
            case "restore": self = .restore
            case "restore_page": self = .restorePage
            case "ring_volume": self = .ringVolume
            case "room": self = .room
            case "room_service": self = .roomService
            case "rotate90_degrees_ccw": self = .rotate90DegreesCcw
            case "rotate_left": self = .rotateLeft
            case "rotate_right": self = .rotateRight
            case "rounded_corner": self = .roundedCorner
            case "router": self = .router
            case "rowing": self = .rowing
            case "rss_feed": self = .rssFeed
            case "rv_hookup": self = .rvHookup
            case "satellite": self = .satellite
            case "save": self = .save
            case "scanner": self = .scanner
            case "schedule": self = .schedule
            case "school": self = .school
            case "screen_lock_landscape": self = .screenLockLandscape
            case "screen_lock_portrait": self = .screenLockPortrait
            case "screen_lock_rotation": self = .screenLockRotation
            case "screen_rotation": self = .screenRotation
            case "screen_share": self = .screenShare
            case "sd_card": self = .sdCard
            case "sd_storage": self = .sdStorage
            case "search": self = .search
            case "security": self = .security
            case "select_all": self = .selectAll
            case "send": self = .send
            case "sentiment_dissatisfied": self = .sentimentDissatisfied
            case "sentiment_neutral": self = .sentimentNeutral
            case "sentiment_satisfied": self = .sentimentSatisfied
            case "sentiment_very_dissatisfied": self = .sentimentVeryDissatisfied
            case "sentiment_very_satisfied": self = .sentimentVerySatisfied
            case "settings": self = .settings
            case "settings_applications": self = .settingsApplications
            case "settings_backup_restore": self = .settingsBackupRestore
            case "settings_bluetooth": self = .settingsBluetooth
            case "settings_brightness": self = .settingsBrightness
            case "settings_cell": self = .settingsCell
            case "settings_ethernet": self = .settingsEthernet
            case "settings_input_antenna": self = .settingsInputAntenna
            case "settings_input_component": self = .settingsInputComponent
            case "settings_input_composite": self = .settingsInputComposite
            case "settings_input_hdmi": self = .settingsInputHdmi
            case "settings_input_svideo": self = .settingsInputSvideo
            case "settings_overscan": self = .settingsOverscan
            case "settings_phone": self = .settingsPhone
            case "settings_power": self = .settingsPower
            case "settings_remote": self = .settingsRemote
            case "settings_system_daydream": self = .settingsSystemDaydream
            case "settings_voice": self = .settingsVoice
            case "share": self = .share
            case "shop": self = .shop
            case "shop_two": self = .shopTwo
            case "shopping_basket": self = .shoppingBasket
            case "shopping_cart": self = .shoppingCart
            case "short_text": self = .shortText
            case "show_chart": self = .showChart
            case "shuffle": self = .shuffle
            case "signal_cellular4_bar": self = .signalCellular4Bar
            case "signal_cellular_connected_no_internet4_bar": self = .signalCellularConnectedNoInternet4Bar
            case "signal_cellular_no_sim": self = .signalCellularNoSim
            case "signal_cellular_null": self = .signalCellularNull
            case "signal_cellular_off": self = .signalCellularOff
            case "signal_wifi4_bar": self = .signalWifi4Bar
            case "signal_wifi4_bar_lock": self = .signalWifi4BarLock
            case "signal_wifi_off": self = .signalWifiOff
            case "sim_card": self = .simCard
            case "sim_card_alert": self = .simCardAlert
            case "skip_next": self = .skipNext
            case "skip_previous": self = .skipPrevious
            case "slideshow": self = .slideshow
            case "slow_motion_video": self = .slowMotionVideo
            case "smartphone": self = .smartphone
            case "smoke_free": self = .smokeFree
            case "smoking_rooms": self = .smokingRooms
            case "sms": self = .sms
            case "sms_failed": self = .smsFailed
            case "snooze": self = .snooze
            case "sort": self = .sort
            case "sort_by_alpha": self = .sortByAlpha
            case "spa": self = .spa
            case "space_bar": self = .spaceBar
            case "speaker": self = .speaker
            case "speaker_group": self = .speakerGroup
            case "speaker_notes": self = .speakerNotes
            case "speaker_notes_off": self = .speakerNotesOff
            case "speaker_phone": self = .speakerPhone
            case "spellcheck": self = .spellcheck
            case "star": self = .star
            case "star_border": self = .starBorder
            case "star_half": self = .starHalf
            case "stars": self = .stars
            case "stay_current_landscape": self = .stayCurrentLandscape
            case "stay_current_portrait": self = .stayCurrentPortrait
            case "stay_primary_landscape": self = .stayPrimaryLandscape
            case "stay_primary_portrait": self = .stayPrimaryPortrait
            case "stop": self = .stop
            case "stop_screen_share": self = .stopScreenShare
            case "storage": self = .storage
            case "store": self = .store
            case "store_mall_directory": self = .storeMallDirectory
            case "straighten": self = .straighten
            case "streetview": self = .streetview
            case "strikethrough_s": self = .strikethroughS
            case "style": self = .style
            case "subdirectory_arrow_left": self = .subdirectoryArrowLeft
            case "subdirectory_arrow_right": self = .subdirectoryArrowRight
            case "subject": self = .subject
            case "subscriptions": self = .subscriptions
            case "subtitles": self = .subtitles
            case "subway": self = .subway
            case "supervisor_account": self = .supervisorAccount
            case "surround_sound": self = .surroundSound
            case "swap_calls": self = .swapCalls
            case "swap_horiz": self = .swapHoriz
            case "swap_vert": self = .swapVert
            case "swap_vertical_circle": self = .swapVerticalCircle
            case "switch_camera": self = .switchCamera
            case "switch_video": self = .switchVideo
            case "sync": self = .sync
            case "sync_disabled": self = .syncDisabled
            case "sync_problem": self = .syncProblem
            case "system_update": self = .systemUpdate
            case "system_update_alt": self = .systemUpdateAlt
            case "tab": self = .tab
            case "tab_unselected": self = .tabUnselected
            case "tablet": self = .tablet
            case "tablet_android": self = .tabletAndroid
            case "tablet_mac": self = .tabletMac
            case "tag_faces": self = .tagFaces
            case "tap_and_play": self = .tapAndPlay
            case "terrain": self = .terrain
            case "text_fields": self = .textFields
            case "text_format": self = .textFormat
            case "textsms": self = .textsms
            case "texture": self = .texture
            case "theaters": self = .theaters
            case "threed_rotation": self = .threedRotation
            case "thumb_down": self = .thumbDown
            case "thumb_up": self = .thumbUp
            case "thumbs_up_down": self = .thumbsUpDown
            case "time_to_leave": self = .timeToLeave
            case "timelapse": self = .timelapse
            case "timeline": self = .timeline
            case "timer": self = .timer
            case "timer10": self = .timer10
            case "timer3": self = .timer3
            case "timer_off": self = .timerOff
            case "title": self = .title
            case "toc": self = .toc
            case "today": self = .today
            case "toll": self = .toll
            case "tonality": self = .tonality
            case "touch_app": self = .touchApp
            case "toys": self = .toys
            case "track_changes": self = .trackChanges
            case "traffic": self = .traffic
            case "train": self = .train
            case "tram": self = .tram
            case "transfer_within_astation": self = .transferWithinAStation
            case "transform": self = .transform
            case "translate": self = .translate
            case "trending_down": self = .trendingDown
            case "trending_flat": self = .trendingFlat
            case "trending_up": self = .trendingUp
            case "tune": self = .tune
            case "turned_in": self = .turnedIn
            case "turned_in_not": self = .turnedInNot
            case "tv": self = .tv
            case "unarchive": self = .unarchive
            case "undo": self = .undo
            case "unfold_less": self = .unfoldLess
            case "unfold_more": self = .unfoldMore
            case "update": self = .update
            case "usb": self = .usb
            case "verified_user": self = .verifiedUser
            case "vertical_align_bottom": self = .verticalAlignBottom
            case "vertical_align_center": self = .verticalAlignCenter
            case "vertical_align_top": self = .verticalAlignTop
            case "vibration": self = .vibration
            case "video_call": self = .videoCall
            case "video_label": self = .videoLabel
            case "video_library": self = .videoLibrary
            case "videocam": self = .videocam
            case "videocam_off": self = .videocamOff
            case "videogame_asset": self = .videogameAsset
            case "view_agenda": self = .viewAgenda
            case "view_array": self = .viewArray
            case "view_carousel": self = .viewCarousel
            case "view_column": self = .viewColumn
            case "view_comfy": self = .viewComfy
            case "view_compact": self = .viewCompact
            case "view_day": self = .viewDay
            case "view_headline": self = .viewHeadline
            case "view_list": self = .viewList
            case "view_module": self = .viewModule
            case "view_quilt": self = .viewQuilt
            case "view_stream": self = .viewStream
            case "view_week": self = .viewWeek
            case "vignette": self = .vignette
            case "visibility": self = .visibility
            case "visibility_off": self = .visibilityOff
            case "voice_chat": self = .voiceChat
            case "voicemail": self = .voicemail
            case "volume_down": self = .volumeDown
            case "volume_mute": self = .volumeMute
            case "volume_off": self = .volumeOff
            case "volume_up": self = .volumeUp
            case "vpn_key": self = .vpnKey
            case "vpn_lock": self = .vpnLock
            case "wallpaper": self = .wallpaper
            case "warning": self = .warning
            case "watch": self = .watch
            case "watch_later": self = .watchLater
            case "wb_auto": self = .wbAuto
            case "wb_cloudy": self = .wbCloudy
            case "wb_incandescent": self = .wbIncandescent
            case "wb_iridescent": self = .wbIridescent
            case "wb_sunny": self = .wbSunny
            case "wc": self = .wc
            case "web": self = .web
            case "web_asset": self = .webAsset
            case "weekend": self = .weekend
            case "whatshot": self = .whatshot
            case "widgets": self = .widgets
            case "wifi": self = .wifi
            case "wifi_lock": self = .wifiLock
            case "wifi_tethering": self = .wifiTethering
            case "work": self = .work
            case "wrap_text": self = .wrapText
            case "youtube_searched_for": self = .youtubeSearchedFor
            case "zoom_in": self = .zoomIn
            case "zoom_out": self = .zoomOut
            case "zoom_out_map": self = .zoomOutMap
            default: return nil
        }
    }
    
    case acUnit, accessAlarm, accessAlarms, accessTime, accessibility, accessible, accountBalance, accountBalanceWallet, accountBox, accountCircle, adb, add, addAPhoto, addAlarm, addAlert, addBox, addCircle, addCircleOutline, addLocation, addShoppingCart, addToPhotos, addToQueue, adjust, airlineSeatFlat, airlineSeatFlatAngled, airlineSeatIndividualSuite, airlineSeatLegroomExtra, airlineSeatLegroomNormal, airlineSeatLegroomReduced, airlineSeatReclineExtra, airlineSeatReclineNormal, airplanemodeActive, airplanemodeInactive, airplay, airportShuttle, alarm, alarmAdd, alarmOff, alarmOn, album, allInclusive, allOut, android, announcement, apps, archive, arrowBack, arrowDownward, arrowDropDown, arrowDropDownCircle, arrowDropUp, arrowForward, arrowUpward, artTrack, aspectRatio, assessment, assignment, assignmentInd, assignmentLate, assignmentReturn, assignmentReturned, assignmentTurnedIn, assistant, assistantPhoto, attachFile, attachMoney, attachment, audiotrack, autorenew, avTimer, backspace, backup, batteryAlert, batteryChargingFull, batteryFull, batteryStd, batteryUnknown, beachAccess, beenhere, block, bluetooth, bluetoothAudio, bluetoothConnected, bluetoothDisabled, bluetoothSearching, blurCircular, blurLinear, blurOff, blurOn, book, bookmark, bookmarkBorder, borderAll, borderBottom, borderClear, borderColor, borderHorizontal, borderInner, borderLeft, borderOuter, borderRight, borderStyle, borderTop, borderVertical, brandingWatermark, brightness1, brightness2, brightness3, brightness4, brightness5, brightness6, brightness7, brightnessAuto, brightnessHigh, brightnessLow, brightnessMedium, brokenImage, brush, bubbleChart, bugReport, build, burstMode, business, businessCenter, cached, cake, call, callEnd, callMade, callMerge, callMissed, callMissedOutgoing, callReceived, callSplit, callToAction, camera, cameraAlt, cameraEnhance, cameraFront, cameraRear, cameraRoll, cancel, cardGiftcard, cardMembership, cardTravel, casino, cast, castConnected, centerFocusStrong, centerFocusWeak, changeHistory, chat, chatBubble, chatBubbleOutline, check, checkBox, checkBoxOutlineBlank, checkCircle, chevronLeft, chevronRight, childCare, childFriendly, chromeReaderMode, classIcon, clear, clearAll, close, closedCaption, cloud, cloudCircle, cloudDone, cloudDownload, cloudOff, cloudQueue, cloudUpload, code, collections, collectionsBookmark, colorLens, colorize, comment, compare, compareArrows, computer, confirmationNumber, contactMail, contactPhone, contacts, contentCopy, contentCut, contentPaste, controlPoint, controlPointDuplicate, copyright, create, createNewFolder, creditCard, crop, crop169, crop32, crop54, crop75, cropDin, cropFree, cropLandscape, cropOriginal, cropPortrait, cropRotate, cropSquare, dashboard, dataUsage, dateRange, dehaze, delete, deleteForever, deleteSweep, description, desktopMac, desktopWindows, details, developerBoard, developerMode, deviceHub, devices, devicesOther, dialerSip, dialpad, directions, directionsBike, directionsBoat, directionsBus, directionsCar, directionsRailway, directionsRun, directionsSubway, directionsTransit, directionsWalk, discFull, dns, doNotDisturb, doNotDisturbAlt, doNotDisturbOff, doNotDisturbOn, dock, domain, done, doneAll, donutLarge, donutSmall, drafts, dragHandle, driveEta, dvr, edit, editLocation, eject, email, enhancedEncryption, equalizer, error, errorOutline, euroSymbol, evStation, event, eventAvailable, eventBusy, eventNote, eventSeat, exitToApp, expandLess, expandMore, explicit, explore, exposure, exposureNeg1, exposureNeg2, exposurePlus1, exposurePlus2, exposureZero, extensionIcon, face, fastForward, fastRewind, favorite, favoriteBorder, featuredPlayList, featuredVideo, feedback, fiberDvr, fiberManualRecord, fiberNew, fiberPin, fiberSmartRecord, fileDownload, fileUpload, filter, filter1, filter2, filter3, filter4, filter5, filter6, filter7, filter8, filter9, filter9Plus, filterBAndW, filterCenterFocus, filterDrama, filterFrames, filterHdr, filterList, filterNone, filterTiltShift, filterVintage, findInPage, findReplace, fingerprint, firstPage, fitnessCenter, flag, flare, flashAuto, flashOff, flashOn, flight, flightLand, flightTakeoff, flip, flipToBack, flipToFront, folder, folderOpen, folderShared, folderSpecial, fontDownload, formatAlignCenter, formatAlignJustify, formatAlignLeft, formatAlignRight, formatBold, formatClear, formatColorFill, formatColorReset, formatColorText, formatIndentDecrease, formatIndentIncrease, formatItalic, formatLineSpacing, formatListBulleted, formatListNumbered, formatPaint, formatQuote, formatShapes, formatSize, formatStrikethrough, formatTextdirectionLToR, formatTextdirectionRToL, formatUnderlined, forum, forward, forward10, forward30, forward5, freeBreakfast, fullscreen, fullscreenExit, functions, gTranslate, gamepad, games, gavel, gesture, getApp, gif, golfCourse, gpsFixed, gpsNotFixed, gpsOff, grade, gradient, grain, graphicEq, gridOff, gridOn, group, groupAdd, groupWork, hd, hdrOff, hdrOn, hdrStrong, hdrWeak, headset, headsetMic, healing, hearing, help, helpOutline, highQuality, highlight, highlightOff, history, home, hotTub, hotel, hourglassEmpty, hourglassFull, http, https, image, imageAspectRatio, importContacts, importExport, importantDevices, inbox, indeterminateCheckBox, info, infoOutline, input, insertChart, insertComment, insertDriveFile, insertEmoticon, insertInvitation, insertLink, insertPhoto, invertColors, invertColorsOff, iso, keyboard, keyboardArrowDown, keyboardArrowLeft, keyboardArrowRight, keyboardArrowUp, keyboardBackspace, keyboardCapslock, keyboardHide, keyboardReturn, keyboardTab, keyboardVoice, kitchen, label, labelOutline, landscape, language, laptop, laptopChromebook, laptopMac, laptopWindows, lastPage, launch, layers, layersClear, leakAdd, leakRemove, lens, libraryAdd, libraryBooks, libraryMusic, lightbulbOutline, lineStyle, lineWeight, linearScale, link, linkedCamera, list, liveHelp, liveTv, localActivity, localAirport, localAtm, localBar, localCafe, localCarWash, localConvenienceStore, localDining, localDrink, localFlorist, localGasStation, localGroceryStore, localHospital, localHotel, localLaundryService, localLibrary, localMall, localMovies, localOffer, localParking, localPharmacy, localPhone, localPizza, localPlay, localPostOffice, localPrintshop, localSee, localShipping, localTaxi, locationCity, locationDisabled, locationOff, locationOn, locationSearching, lock, lockOpen, lockOutline, looks, looks3, looks4, looks5, looks6, looksOne, looksTwo, loop, loupe, lowPriority, loyalty, mail, mailOutline, map, markunread, markunreadMailbox, memory, menu, mergeType, message, mic, micNone, micOff, mms, modeComment, modeEdit, monetizationOn, moneyOff, monochromePhotos, mood, moodBad, more, moreHoriz, moreVert, motorcycle, mouse, moveToInbox, movie, movieCreation, movieFilter, multilineChart, musicNote, musicVideo, myLocation, nature, naturePeople, navigateBefore, navigateNext, navigation, nearMe, networkCell, networkCheck, networkLocked, networkWifi, newReleases, nextWeek, nfc, noEncryption, noSim, notInterested, note, noteAdd, notifications, notificationsActive, notificationsNone, notificationsOff, notificationsPaused, offlinePin, ondemandVideo, opacity, openInBrowser, openInNew, openWith, pages, pageview, palette, panTool, panorama, panoramaFishEye, panoramaHorizontal, panoramaVertical, panoramaWideAngle, partyMode, pause, pauseCircleFilled, pauseCircleOutline, payment, people, peopleOutline, permCameraMic, permContactCalendar, permDataSetting, permDeviceInformation, permIdentity, permMedia, permPhoneMsg, permScanWifi, person, personAdd, personOutline, personPin, personPinCircle, personalVideo, pets, phone, phoneAndroid, phoneBluetoothSpeaker, phoneForwarded, phoneInTalk, phoneIphone, phoneLocked, phoneMissed, phonePaused, phonelink, phonelinkErase, phonelinkLock, phonelinkOff, phonelinkRing, phonelinkSetup, photo, photoAlbum, photoCamera, photoFilter, photoLibrary, photoSizeSelectActual, photoSizeSelectLarge, photoSizeSelectSmall, pictureAsPdf, pictureInPicture, pictureInPictureAlt, pieChart, pieChartOutlined, pinDrop, place, playArrow, playCircleFilled, playCircleOutline, playForWork, playlistAdd, playlistAddCheck, playlistPlay, plusOne, poll, polymer, pool, portableWifiOff, portrait, power, powerInput, powerSettingsNew, pregnantWoman, presentToAll, print, priorityHigh, publicIcon, publish, queryBuilder, questionAnswer, queue, queueMusic, queuePlayNext, radio, radioButtonChecked, radioButtonUnchecked, rateReview, receipt, recentActors, recordVoiceOver, redeem, redo, refresh, remove, removeCircle, removeCircleOutline, removeFromQueue, removeRedEye, removeShoppingCart, reorder, repeatIcon, repeatOne, replay, replay10, replay30, replay5, reply, replyAll, report, reportProblem, restaurant, restaurantMenu, restore, restorePage, ringVolume, room, roomService, rotate90DegreesCcw, rotateLeft, rotateRight, roundedCorner, router, rowing, rssFeed, rvHookup, satellite, save, scanner, schedule, school, screenLockLandscape, screenLockPortrait, screenLockRotation, screenRotation, screenShare, sdCard, sdStorage, search, security, selectAll, send, sentimentDissatisfied, sentimentNeutral, sentimentSatisfied, sentimentVeryDissatisfied, sentimentVerySatisfied, settings, settingsApplications, settingsBackupRestore, settingsBluetooth, settingsBrightness, settingsCell, settingsEthernet, settingsInputAntenna, settingsInputComponent, settingsInputComposite, settingsInputHdmi, settingsInputSvideo, settingsOverscan, settingsPhone, settingsPower, settingsRemote, settingsSystemDaydream, settingsVoice, share, shop, shopTwo, shoppingBasket, shoppingCart, shortText, showChart, shuffle, signalCellular4Bar, signalCellularConnectedNoInternet4Bar, signalCellularNoSim, signalCellularNull, signalCellularOff, signalWifi4Bar, signalWifi4BarLock, signalWifiOff, simCard, simCardAlert, skipNext, skipPrevious, slideshow, slowMotionVideo, smartphone, smokeFree, smokingRooms, sms, smsFailed, snooze, sort, sortByAlpha, spa, spaceBar, speaker, speakerGroup, speakerNotes, speakerNotesOff, speakerPhone, spellcheck, star, starBorder, starHalf, stars, stayCurrentLandscape, stayCurrentPortrait, stayPrimaryLandscape, stayPrimaryPortrait, stop, stopScreenShare, storage, store, storeMallDirectory, straighten, streetview, strikethroughS, style, subdirectoryArrowLeft, subdirectoryArrowRight, subject, subscriptions, subtitles, subway, supervisorAccount, surroundSound, swapCalls, swapHoriz, swapVert, swapVerticalCircle, switchCamera, switchVideo, sync, syncDisabled, syncProblem, systemUpdate, systemUpdateAlt, tab, tabUnselected, tablet, tabletAndroid, tabletMac, tagFaces, tapAndPlay, terrain, textFields, textFormat, textsms, texture, theaters, threedRotation, thumbDown, thumbUp, thumbsUpDown, timeToLeave, timelapse, timeline, timer, timer10, timer3, timerOff, title, toc, today, toll, tonality, touchApp, toys, trackChanges, traffic, train, tram, transferWithinAStation, transform, translate, trendingDown, trendingFlat, trendingUp, tune, turnedIn, turnedInNot, tv, unarchive, undo, unfoldLess, unfoldMore, update, usb, verifiedUser, verticalAlignBottom, verticalAlignCenter, verticalAlignTop, vibration, videoCall, videoLabel, videoLibrary, videocam, videocamOff, videogameAsset, viewAgenda, viewArray, viewCarousel, viewColumn, viewComfy, viewCompact, viewDay, viewHeadline, viewList, viewModule, viewQuilt, viewStream, viewWeek, vignette, visibility, visibilityOff, voiceChat, voicemail, volumeDown, volumeMute, volumeOff, volumeUp, vpnKey, vpnLock, wallpaper, warning, watch, watchLater, wbAuto, wbCloudy, wbIncandescent, wbIridescent, wbSunny, wc, web, webAsset, weekend, whatshot, widgets, wifi, wifiLock, wifiTethering, work, wrapText, youtubeSearchedFor, zoomIn, zoomOut, zoomOutMap
}

public let googleMDIconsCodes = ["\u{eb3b}", "\u{e190}", "\u{e191}", "\u{e192}", "\u{e84e}", "\u{e914}", "\u{e84f}", "\u{e850}", "\u{e851}", "\u{e853}", "\u{e60e}", "\u{e145}", "\u{e439}", "\u{e193}", "\u{e003}", "\u{e146}", "\u{e147}", "\u{e148}", "\u{e567}", "\u{e854}", "\u{e39d}", "\u{e05c}", "\u{e39e}", "\u{e630}", "\u{e631}", "\u{e632}", "\u{e633}", "\u{e634}", "\u{e635}", "\u{e636}", "\u{e637}", "\u{e195}", "\u{e194}", "\u{e055}", "\u{eb3c}", "\u{e855}", "\u{e856}", "\u{e857}", "\u{e858}", "\u{e019}", "\u{eb3d}", "\u{e90b}", "\u{e859}", "\u{e85a}", "\u{e5c3}", "\u{e149}", "\u{e5c4}", "\u{e5db}", "\u{e5c5}", "\u{e5c6}", "\u{e5c7}", "\u{e5c8}", "\u{e5d8}", "\u{e060}", "\u{e85b}", "\u{e85c}", "\u{e85d}", "\u{e85e}", "\u{e85f}", "\u{e860}", "\u{e861}", "\u{e862}", "\u{e39f}", "\u{e3a0}", "\u{e226}", "\u{e227}", "\u{e2bc}", "\u{e3a1}", "\u{e863}", "\u{e01b}", "\u{e14a}", "\u{e864}", "\u{e19c}", "\u{e1a3}", "\u{e1a4}", "\u{e1a5}", "\u{e1a6}", "\u{eb3e}", "\u{e52d}", "\u{e14b}", "\u{e1a7}", "\u{e60f}", "\u{e1a8}", "\u{e1a9}", "\u{e1aa}", "\u{e3a2}", "\u{e3a3}", "\u{e3a4}", "\u{e3a5}", "\u{e865}", "\u{e866}", "\u{e867}", "\u{e228}", "\u{e229}", "\u{e22a}", "\u{e22b}", "\u{e22c}", "\u{e22d}", "\u{e22e}", "\u{e22f}", "\u{e230}", "\u{e231}", "\u{e232}", "\u{e233}", "\u{e06b}", "\u{e3a6}", "\u{e3a7}", "\u{e3a8}", "\u{e3a9}", "\u{e3aa}", "\u{e3ab}", "\u{e3ac}", "\u{e1ab}", "\u{e1ac}", "\u{e1ad}", "\u{e1ae}", "\u{e3ad}", "\u{e3ae}", "\u{e6dd}", "\u{e868}", "\u{e869}", "\u{e43c}", "\u{e0af}", "\u{eb3f}", "\u{e86a}", "\u{e7e9}", "\u{e0b0}", "\u{e0b1}", "\u{e0b2}", "\u{e0b3}", "\u{e0b4}", "\u{e0e4}", "\u{e0b5}", "\u{e0b6}", "\u{e06c}", "\u{e3af}", "\u{e3b0}", "\u{e8fc}", "\u{e3b1}", "\u{e3b2}", "\u{e3b3}", "\u{e5c9}", "\u{e8f6}", "\u{e8f7}", "\u{e8f8}", "\u{eb40}", "\u{e307}", "\u{e308}", "\u{e3b4}", "\u{e3b5}", "\u{e86b}", "\u{e0b7}", "\u{e0ca}", "\u{e0cb}", "\u{e5ca}", "\u{e834}", "\u{e835}", "\u{e86c}", "\u{e5cb}", "\u{e5cc}", "\u{eb41}", "\u{eb42}", "\u{e86d}", "\u{e86e}", "\u{e14c}", "\u{e0b8}", "\u{e5cd}", "\u{e01c}", "\u{e2bd}", "\u{e2be}", "\u{e2bf}", "\u{e2c0}", "\u{e2c1}", "\u{e2c2}", "\u{e2c3}", "\u{e86f}", "\u{e3b6}", "\u{e431}", "\u{e3b7}", "\u{e3b8}", "\u{e0b9}", "\u{e3b9}", "\u{e915}", "\u{e30a}", "\u{e638}", "\u{e0d0}", "\u{e0cf}", "\u{e0ba}", "\u{e14d}", "\u{e14e}", "\u{e14f}", "\u{e3ba}", "\u{e3bb}", "\u{e90c}", "\u{e150}", "\u{e2cc}", "\u{e870}", "\u{e3be}", "\u{e3bc}", "\u{e3bd}", "\u{e3bf}", "\u{e3c0}", "\u{e3c1}", "\u{e3c2}", "\u{e3c3}", "\u{e3c4}", "\u{e3c5}", "\u{e437}", "\u{e3c6}", "\u{e871}", "\u{e1af}", "\u{e916}", "\u{e3c7}", "\u{e872}", "\u{e92b}", "\u{e16c}", "\u{e873}", "\u{e30b}", "\u{e30c}", "\u{e3c8}", "\u{e30d}", "\u{e1b0}", "\u{e335}", "\u{e1b1}", "\u{e337}", "\u{e0bb}", "\u{e0bc}", "\u{e52e}", "\u{e52f}", "\u{e532}", "\u{e530}", "\u{e531}", "\u{e534}", "\u{e566}", "\u{e533}", "\u{e535}", "\u{e536}", "\u{e610}", "\u{e875}", "\u{e612}", "\u{e611}", "\u{e643}", "\u{e644}", "\u{e30e}", "\u{e7ee}", "\u{e876}", "\u{e877}", "\u{e917}", "\u{e918}", "\u{e151}", "\u{e25d}", "\u{e613}", "\u{e1b2}", "\u{e3c9}", "\u{e568}", "\u{e8fb}", "\u{e0be}", "\u{e63f}", "\u{e01d}", "\u{e000}", "\u{e001}", "\u{e926}", "\u{e56d}", "\u{e878}", "\u{e614}", "\u{e615}", "\u{e616}", "\u{e903}", "\u{e879}", "\u{e5ce}", "\u{e5cf}", "\u{e01e}", "\u{e87a}", "\u{e3ca}", "\u{e3cb}", "\u{e3cc}", "\u{e3cd}", "\u{e3ce}", "\u{e3cf}", "\u{e87b}", "\u{e87c}", "\u{e01f}", "\u{e020}", "\u{e87d}", "\u{e87e}", "\u{e06d}", "\u{e06e}", "\u{e87f}", "\u{e05d}", "\u{e061}", "\u{e05e}", "\u{e06a}", "\u{e062}", "\u{e2c4}", "\u{e2c6}", "\u{e3d3}", "\u{e3d0}", "\u{e3d1}", "\u{e3d2}", "\u{e3d4}", "\u{e3d5}", "\u{e3d6}", "\u{e3d7}", "\u{e3d8}", "\u{e3d9}", "\u{e3da}", "\u{e3db}", "\u{e3dc}", "\u{e3dd}", "\u{e3de}", "\u{e3df}", "\u{e152}", "\u{e3e0}", "\u{e3e2}", "\u{e3e3}", "\u{e880}", "\u{e881}", "\u{e90d}", "\u{e5dc}", "\u{eb43}", "\u{e153}", "\u{e3e4}", "\u{e3e5}", "\u{e3e6}", "\u{e3e7}", "\u{e539}", "\u{e904}", "\u{e905}", "\u{e3e8}", "\u{e882}", "\u{e883}", "\u{e2c7}", "\u{e2c8}", "\u{e2c9}", "\u{e617}", "\u{e167}", "\u{e234}", "\u{e235}", "\u{e236}", "\u{e237}", "\u{e238}", "\u{e239}", "\u{e23a}", "\u{e23b}", "\u{e23c}", "\u{e23d}", "\u{e23e}", "\u{e23f}", "\u{e240}", "\u{e241}", "\u{e242}", "\u{e243}", "\u{e244}", "\u{e25e}", "\u{e245}", "\u{e246}", "\u{e247}", "\u{e248}", "\u{e249}", "\u{e0bf}", "\u{e154}", "\u{e056}", "\u{e057}", "\u{e058}", "\u{eb44}", "\u{e5d0}", "\u{e5d1}", "\u{e24a}", "\u{e927}", "\u{e30f}", "\u{e021}", "\u{e90e}", "\u{e155}", "\u{e884}", "\u{e908}", "\u{eb45}", "\u{e1b3}", "\u{e1b4}", "\u{e1b5}", "\u{e885}", "\u{e3e9}", "\u{e3ea}", "\u{e1b8}", "\u{e3eb}", "\u{e3ec}", "\u{e7ef}", "\u{e7f0}", "\u{e886}", "\u{e052}", "\u{e3ed}", "\u{e3ee}", "\u{e3f1}", "\u{e3f2}", "\u{e310}", "\u{e311}", "\u{e3f3}", "\u{e023}", "\u{e887}", "\u{e8fd}", "\u{e024}", "\u{e25f}", "\u{e888}", "\u{e889}", "\u{e88a}", "\u{eb46}", "\u{e53a}", "\u{e88b}", "\u{e88c}", "\u{e902}", "\u{e88d}", "\u{e3f4}", "\u{e3f5}", "\u{e0e0}", "\u{e0c3}", "\u{e912}", "\u{e156}", "\u{e909}", "\u{e88e}", "\u{e88f}", "\u{e890}", "\u{e24b}", "\u{e24c}", "\u{e24d}", "\u{e24e}", "\u{e24f}", "\u{e250}", "\u{e251}", "\u{e891}", "\u{e0c4}", "\u{e3f6}", "\u{e312}", "\u{e313}", "\u{e314}", "\u{e315}", "\u{e316}", "\u{e317}", "\u{e318}", "\u{e31a}", "\u{e31b}", "\u{e31c}", "\u{e31d}", "\u{eb47}", "\u{e892}", "\u{e893}", "\u{e3f7}", "\u{e894}", "\u{e31e}", "\u{e31f}", "\u{e320}", "\u{e321}", "\u{e5dd}", "\u{e895}", "\u{e53b}", "\u{e53c}", "\u{e3f8}", "\u{e3f9}", "\u{e3fa}", "\u{e02e}", "\u{e02f}", "\u{e030}", "\u{e90f}", "\u{e919}", "\u{e91a}", "\u{e260}", "\u{e157}", "\u{e438}", "\u{e896}", "\u{e0c6}", "\u{e639}", "\u{e53f}", "\u{e53d}", "\u{e53e}", "\u{e540}", "\u{e541}", "\u{e542}", "\u{e543}", "\u{e556}", "\u{e544}", "\u{e545}", "\u{e546}", "\u{e547}", "\u{e548}", "\u{e549}", "\u{e54a}", "\u{e54b}", "\u{e54c}", "\u{e54d}", "\u{e54e}", "\u{e54f}", "\u{e550}", "\u{e551}", "\u{e552}", "\u{e553}", "\u{e554}", "\u{e555}", "\u{e557}", "\u{e558}", "\u{e559}", "\u{e7f1}", "\u{e1b6}", "\u{e0c7}", "\u{e0c8}", "\u{e1b7}", "\u{e897}", "\u{e898}", "\u{e899}", "\u{e3fc}", "\u{e3fb}", "\u{e3fd}", "\u{e3fe}", "\u{e3ff}", "\u{e400}", "\u{e401}", "\u{e028}", "\u{e402}", "\u{e16d}", "\u{e89a}", "\u{e158}", "\u{e0e1}", "\u{e55b}", "\u{e159}", "\u{e89b}", "\u{e322}", "\u{e5d2}", "\u{e252}", "\u{e0c9}", "\u{e029}", "\u{e02a}", "\u{e02b}", "\u{e618}", "\u{e253}", "\u{e254}", "\u{e263}", "\u{e25c}", "\u{e403}", "\u{e7f2}", "\u{e7f3}", "\u{e619}", "\u{e5d3}", "\u{e5d4}", "\u{e91b}", "\u{e323}", "\u{e168}", "\u{e02c}", "\u{e404}", "\u{e43a}", "\u{e6df}", "\u{e405}", "\u{e063}", "\u{e55c}", "\u{e406}", "\u{e407}", "\u{e408}", "\u{e409}", "\u{e55d}", "\u{e569}", "\u{e1b9}", "\u{e640}", "\u{e61a}", "\u{e1ba}", "\u{e031}", "\u{e16a}", "\u{e1bb}", "\u{e641}", "\u{e0cc}", "\u{e033}", "\u{e06f}", "\u{e89c}", "\u{e7f4}", "\u{e7f7}", "\u{e7f5}", "\u{e7f6}", "\u{e7f8}", "\u{e90a}", "\u{e63a}", "\u{e91c}", "\u{e89d}", "\u{e89e}", "\u{e89f}", "\u{e7f9}", "\u{e8a0}", "\u{e40a}", "\u{e925}", "\u{e40b}", "\u{e40c}", "\u{e40d}", "\u{e40e}", "\u{e40f}", "\u{e7fa}", "\u{e034}", "\u{e035}", "\u{e036}", "\u{e8a1}", "\u{e7fb}", "\u{e7fc}", "\u{e8a2}", "\u{e8a3}", "\u{e8a4}", "\u{e8a5}", "\u{e8a6}", "\u{e8a7}", "\u{e8a8}", "\u{e8a9}", "\u{e7fd}", "\u{e7fe}", "\u{e7ff}", "\u{e55a}", "\u{e56a}", "\u{e63b}", "\u{e91d}", "\u{e0cd}", "\u{e324}", "\u{e61b}", "\u{e61c}", "\u{e61d}", "\u{e325}", "\u{e61e}", "\u{e61f}", "\u{e620}", "\u{e326}", "\u{e0db}", "\u{e0dc}", "\u{e327}", "\u{e0dd}", "\u{e0de}", "\u{e410}", "\u{e411}", "\u{e412}", "\u{e43b}", "\u{e413}", "\u{e432}", "\u{e433}", "\u{e434}", "\u{e415}", "\u{e8aa}", "\u{e911}", "\u{e6c4}", "\u{e6c5}", "\u{e55e}", "\u{e55f}", "\u{e037}", "\u{e038}", "\u{e039}", "\u{e906}", "\u{e03b}", "\u{e065}", "\u{e05f}", "\u{e800}", "\u{e801}", "\u{e8ab}", "\u{eb48}", "\u{e0ce}", "\u{e416}", "\u{e63c}", "\u{e336}", "\u{e8ac}", "\u{e91e}", "\u{e0df}", "\u{e8ad}", "\u{e645}", "\u{e80b}", "\u{e255}", "\u{e8ae}", "\u{e8af}", "\u{e03c}", "\u{e03d}", "\u{e066}", "\u{e03e}", "\u{e837}", "\u{e836}", "\u{e560}", "\u{e8b0}", "\u{e03f}", "\u{e91f}", "\u{e8b1}", "\u{e15a}", "\u{e5d5}", "\u{e15b}", "\u{e15c}", "\u{e15d}", "\u{e067}", "\u{e417}", "\u{e928}", "\u{e8fe}", "\u{e040}", "\u{e041}", "\u{e042}", "\u{e059}", "\u{e05a}", "\u{e05b}", "\u{e15e}", "\u{e15f}", "\u{e160}", "\u{e8b2}", "\u{e56c}", "\u{e561}", "\u{e8b3}", "\u{e929}", "\u{e0d1}", "\u{e8b4}", "\u{eb49}", "\u{e418}", "\u{e419}", "\u{e41a}", "\u{e920}", "\u{e328}", "\u{e921}", "\u{e0e5}", "\u{e642}", "\u{e562}", "\u{e161}", "\u{e329}", "\u{e8b5}", "\u{e80c}", "\u{e1be}", "\u{e1bf}", "\u{e1c0}", "\u{e1c1}", "\u{e0e2}", "\u{e623}", "\u{e1c2}", "\u{e8b6}", "\u{e32a}", "\u{e162}", "\u{e163}", "\u{e811}", "\u{e812}", "\u{e813}", "\u{e814}", "\u{e815}", "\u{e8b8}", "\u{e8b9}", "\u{e8ba}", "\u{e8bb}", "\u{e8bd}", "\u{e8bc}", "\u{e8be}", "\u{e8bf}", "\u{e8c0}", "\u{e8c1}", "\u{e8c2}", "\u{e8c3}", "\u{e8c4}", "\u{e8c5}", "\u{e8c6}", "\u{e8c7}", "\u{e1c3}", "\u{e8c8}", "\u{e80d}", "\u{e8c9}", "\u{e8ca}", "\u{e8cb}", "\u{e8cc}", "\u{e261}", "\u{e6e1}", "\u{e043}", "\u{e1c8}", "\u{e1cd}", "\u{e1ce}", "\u{e1cf}", "\u{e1d0}", "\u{e1d8}", "\u{e1d9}", "\u{e1da}", "\u{e32b}", "\u{e624}", "\u{e044}", "\u{e045}", "\u{e41b}", "\u{e068}", "\u{e32c}", "\u{eb4a}", "\u{eb4b}", "\u{e625}", "\u{e626}", "\u{e046}", "\u{e164}", "\u{e053}", "\u{eb4c}", "\u{e256}", "\u{e32d}", "\u{e32e}", "\u{e8cd}", "\u{e92a}", "\u{e0d2}", "\u{e8ce}", "\u{e838}", "\u{e83a}", "\u{e839}", "\u{e8d0}", "\u{e0d3}", "\u{e0d4}", "\u{e0d5}", "\u{e0d6}", "\u{e047}", "\u{e0e3}", "\u{e1db}", "\u{e8d1}", "\u{e563}", "\u{e41c}", "\u{e56e}", "\u{e257}", "\u{e41d}", "\u{e5d9}", "\u{e5da}", "\u{e8d2}", "\u{e064}", "\u{e048}", "\u{e56f}", "\u{e8d3}", "\u{e049}", "\u{e0d7}", "\u{e8d4}", "\u{e8d5}", "\u{e8d6}", "\u{e41e}", "\u{e41f}", "\u{e627}", "\u{e628}", "\u{e629}", "\u{e62a}", "\u{e8d7}", "\u{e8d8}", "\u{e8d9}", "\u{e32f}", "\u{e330}", "\u{e331}", "\u{e420}", "\u{e62b}", "\u{e564}", "\u{e262}", "\u{e165}", "\u{e0d8}", "\u{e421}", "\u{e8da}", "\u{e84d}", "\u{e8db}", "\u{e8dc}", "\u{e8dd}", "\u{e62c}", "\u{e422}", "\u{e922}", "\u{e425}", "\u{e423}", "\u{e424}", "\u{e426}", "\u{e264}", "\u{e8de}", "\u{e8df}", "\u{e8e0}", "\u{e427}", "\u{e913}", "\u{e332}", "\u{e8e1}", "\u{e565}", "\u{e570}", "\u{e571}", "\u{e572}", "\u{e428}", "\u{e8e2}", "\u{e8e3}", "\u{e8e4}", "\u{e8e5}", "\u{e429}", "\u{e8e6}", "\u{e8e7}", "\u{e333}", "\u{e169}", "\u{e166}", "\u{e5d6}", "\u{e5d7}", "\u{e923}", "\u{e1e0}", "\u{e8e8}", "\u{e258}", "\u{e259}", "\u{e25a}", "\u{e62d}", "\u{e070}", "\u{e071}", "\u{e04a}", "\u{e04b}", "\u{e04c}", "\u{e338}", "\u{e8e9}", "\u{e8ea}", "\u{e8eb}", "\u{e8ec}", "\u{e42a}", "\u{e42b}", "\u{e8ed}", "\u{e8ee}", "\u{e8ef}", "\u{e8f0}", "\u{e8f1}", "\u{e8f2}", "\u{e8f3}", "\u{e435}", "\u{e8f4}", "\u{e8f5}", "\u{e62e}", "\u{e0d9}", "\u{e04d}", "\u{e04e}", "\u{e04f}", "\u{e050}", "\u{e0da}", "\u{e62f}", "\u{e1bc}", "\u{e002}", "\u{e334}", "\u{e924}", "\u{e42c}", "\u{e42d}", "\u{e42e}", "\u{e436}", "\u{e430}", "\u{e63d}", "\u{e051}", "\u{e069}", "\u{e16b}", "\u{e80e}", "\u{e1bd}", "\u{e63e}", "\u{e1e1}", "\u{e1e2}", "\u{e8f9}", "\u{e25b}", "\u{e8fa}", "\u{e8ff}", "\u{e900}", "\u{e56b}"]
