
# Android Security & Reverse Engineering YouTube Curriculum

## Table of Contents

1. [Android Exploits & Attacks](#android-exploits--attacks)
2. [Android Permissions & Privileges](#android-permissions--privileges)
3. [Android Webviews & Javascript Interfaces](#android-webviews--javascript-interfaces)
4. [Android Reverse Engineering & Obfuscation](#android-reverse-engineering--obfuscation)
5. [Android Bluetooth Security](#android-bluetooth-security)
6. [Payment Systems & ATMs](#payment-systems--atms)
7. [Android Malware & Surveillance](#android-malware--surveillance)
8. [Android Hardware Vectors](#android-hardware-vectors)
9. [Android GPU Attacks](#android-gpu-attacks)
10. [Baseband Attacks](#baseband-attacks)
11. [Hard-Coded Credentials & Adjacent Attacks](#hard-coded-credentials--adjacent-attacks)
12. [Android Kernel Exploits](#android-kernel-exploits)
13. [Input Validation & Path Traversal Attacks](#input-validation--path-traversal-attacks)
---

## Android Exploits & Attacks

- [**Xiaomi The Money : Our Toronto Pwn2Own Exploit & BTS Story**](https://www.youtube.com/watch?v=B0A8F_Izmj0)
  - *DEFCON 32* by Ken Gannon, Ilyes Beghdadi
- [**Breaking network crypto in popular Chinese keyboard apps**](https://www.youtube.com/watch?v=RgCI3GOXLr0)
  - *DEFCON 32* by Jeffrey Knockel, Mona Wang
- [**Beyond Android MTE: Navigating OEM's Logic Labyrinths**](https://youtu.be/VDhHSCsaByk?feature=shared) 
  - *OffensiveCon24* by Joffrey Guilbon, Max, Mateusz Fruba and Georgi Geshev
- [**Privacy Detective: Sniffing Out Your Data Leaks for Android**](https://www.youtube.com/watch?v=Krvi3bCXlCA) 
  - *Black Hat Asia 2024* By Zhengyang Zhou,Yiman He, Ning Wang, Xianlin Wu & Feifei Chen 
- [**SystemUI As EvilPiP: The Hijacking Attacks on Modern Mobile Devices**](https://youtu.be/47lDlfsji8Y?feature=shared) 
  - *Black Hat Asia 2024* By WeiMin Cheng & Yue Li
- [**Attacking Debug Modules In The Android Ecosystem**](https://www.youtube.com/watch?v=3lpMaFVvF64) 
  - *Black Hat Asia 2024* by Lewei Qu
- [**Still Vulnerable Out of the Box: Revisiting the Security of Prepaid Android Carrier Devices**](https://youtu.be/mYLa1f6LoLI?feature=shared)
  - *DEFCON 31* by Ryan Johnson
- [**The Living Dead: Hacking Mobile Face Recognition SDKs with Non-Deepfake Attacks**](https://www.youtube.com/watch?v=nPE2AjNB2sI) 
  - *Black Hat USA 2023* by By: Wing Cheong Lau , Kaixuan Luo , Xianbo Wang
- [**Hacking & Securing Android Applications**](https://youtu.be/WCw-N6lMLI4?feature=shared) 
  - *OWASP 2023 Global AppSec DC* by Daniel Llewellyn
- [**When Exploits Aren't Binary - Keynote**](https://youtu.be/rVAsXjqp9TI?feature=shared)
  - *BSides Canberra 2023* by Maddie Stone
- [**SigMorph: Covert Communication Exploiting Android Signing Schemes**](https://www.youtube.com/watch?v=C2qstasV53Y) 
  - *Nullcon Goa 2023* by by Ayan Saha And Achute Sharma   
- [**Android Parcels: The Bad, the Good and the Better**](https://www.youtube.com/watch?v=qIzMKfOmIAA) 
  - *Black Hat Europe 2022* by Hao Ke, Bernardo Rufino, Maria Uretsky, Yang Yang
- [**Unix Domain Socket: A Hidden Door Leading to Privilege Escalation in the Android Ecosystem**](https://youtu.be/Zi7FKB2AU58?feature=shared) 
  - *Black Hat Asia 2022* By: Dongxiang Ke, Lewei Qu, Han Yan & Daozheng Lin
- [**Start Arbitrary Activity App Components as System User: Vulnerability Affecting Samsung Android Devices**](https://youtu.be/SRCiMKlCavs?feature=shared) 
  - *Black Hat Asia 2022* by Ryan Johnson, Mohamed Elsabagh, Angelos Stavrou 
- [**(UN)protected Broadcasts in Android 9 & 10**](https://youtu.be/nDHPZH20rtE?feature=shared)
  - *Black Hat Asia 2021* by Ryan Johnson
- [**HITB2021AMS KEYNOTE 2: The State Of Mobile Security**](https://www.youtube.com/watch?v=oGZL3ywcy1E)
  - *Hack In The Box Security Conference Amsterdam 2020* by Zuk Avraham
- [**TiYunZong Exploit Chain to Remotely Root Modern Android Devices**](https://www.youtube.com/watch?v=K91SrkKt4IQ) 
  - *Black Hat USA 2020* by Guang Gong
- [**Android Bug Foraging**](https://www.youtube.com/watch?v=QmcXtfLU1Xw)
  - *DEF CON 28 Safe Mode AppSec Village* by Pedro Umbelino ,João Morais
- [**Vulnerable Out of the Box - Evaluation of Android Carrier Devices**](https://www.youtube.com/watch?v=R2brQvQeTvM)
  - *DEF CON 26* by Ryan Johnson & Stavrou 
- [**Simple Spyware: Android's Invisible Foreground Services**](https://youtu.be/EuInUW77CPo?feature=shared) 
  - *Black Hat Europe 2019* by Thomas Sutter and Bernhard Tellenbach

## Android Permissions & Privileges
- [**Bypassing Android Permissions From All Protection Levels**](https://www.youtube.com/watch?v=pP5tKT9-I0Y) 
  - *DEFCON 30* by Nikita Kurtin    
- [**Hacking Android Foreground Services Escalation Of Privileges**](https://www.youtube.com/watch?v=3I53IkJpQ6I) 
  - *Nullcon Goa 2022* by Rony Das
- [**Re-route Your Intent for Privilege Escalation: A Universal Way to Exploit Android PendingIntents in High-profile and System Apps**](https://youtu.be/pc8ZKl5XG24?feature=shared)
  - *Black Hat Europe 2021* by En He
- [**Permissionless Android Universal Overlays**](https://www.youtube.com/watch?v=Jdhg1Tx8CjQ)
  - *InsomniHack 2023* by Dimitrios Valsamaras
- [**Inter-App Collusion: Exploiting the Improper Export of Android Application Components for Privilege Elevation & Credential Theft**](https://youtu.be/1p449kjbW94?feature=shared)
  - *Shmoocon 2024* by Edward Warren
- [**Dissecting Huawei Mobile Devices**](https://youtu.be/LxoHSrrGaNA?feature=shared)
  - *HEXACON2022* by Maxime Peterlin & Alexandre Adamski

## Android Webviews & Javascript Interfaces

- [**AutoSpill: Zero Effort Credential Stealing from Mobile Password Managers**](https://www.youtube.com/watch?v=t-6YYdbjO7g) 
  - *Black Hat Europe 2023* by By: Ankit Gangwal , Shubham Singh , Abhijeet Srivastava
- [**The Tangled Webview - Javascriptinterface Once More**](https://www.youtube.com/watch?v=56sOniHFwVU) 
  - *Black Hat Asia 2021* by Ce Qin
- [**Using Android WebViews to Steal All the Files**](https://www.youtube.com/watch?v=NCEQ0QIyicE) 
  - *Shmoocon 2020* by Jesson Soto Ventura

## Android Reverse Engineering & Obfuscation
- [**The Complexity Of Reversing Flutter Applications**](https://www.youtube.com/watch?v=JNoEUPlgcZk)
  - *Nullcon Berlin 2024* by Axelle Apvrille
- [**Beyond Java: Obfuscating Android Apps with Native Code**](https://www.youtube.com/watch?v=wayMcQQZV1U) 
  - *TROOPERS23* by Laurie Kirk
- [**Runtime Riddles: Manipulation Points in the Android Source**](https://www.youtube.com/watch?v=Bq7Z3X4xwCE) 
  - *DEFCON 31* by Laurie Kirk
- [**Unmasking the Godfather - Reverse Engineering the Latest Android Banking Trojan**](https://youtu.be/jNQmc2REwFg) 
  - *Strange Loop Conference 2023* by Laurie Kirk
- [**Dissecting the Modern Android Data Encryption Scheme**](https://youtu.be/unRFQhkK1DE?feature=shared) 
  - *Recon 2023* by Maxime Rossi and Damiano Melotti
- [**Endoscope: Unpacking Android Apps with VM-Based Obfuscation**](https://www.youtube.com/watch?v=4Rmc1rEyADU) 
  - *Black Hat USA 2023* By: Fan Wu , Xuankai Zhang
- [**ADBHoney: Low interaction honeypot designed for Android Debug Bridge**](https://youtu.be/STElT2ri6K8?feature=shared) 
  - *Android Security Symposium 2020* by Gabriel Cirlig
- [**Securing the System: Reversing Android Pre-Installed Apps**](https://www.youtube.com/watch?v=U6qTcpCfuFc) 
  - *Black Hat USA 2019* by Maddie Stone
    
 
## Android Bluetooth Security
- [**Deep into Android Bluetooth Bug Hunting: New Attack Surfaces & Code Patterns**](https://www.youtube.com/watch?v=TDSgRWOeS-4) 
  - *Black Hat Europe 2022* by Zinuo Han
- [**Stealthily Access Android Phones: Bypass the Bluetooth Authentication**](https://www.youtube.com/watch?v=6J3weqoiads) 
  - *Black Hat USA 2020* by Sourcell Xu and Xin Xin
    

## Payment Systems & ATMs
- [**Contactless Overflow Code Execution in Payment Terminals & ATMs**](https://www.youtube.com/watch?v=eV76vObO2IM) 
  - *DEFCON 31* by Josep Rodriguez
- [**Turning my virtual wallet into a skimming device**](https://www.youtube.com/watch?v=NGhamH4_CZY) 
  - *DEFCON 31* by Borgogno, Barrionuevo
- [**How an android application can drain your wallet**](https://www.youtube.com/watch?v=O4OoJpbdDl0) 
  - *Bsides Lisbon 2022* by Dimitrios Valsamaras
 
## Android Malware & Surveillance
- [**When Malware Becomes Creative - Dimitrios Valsamaras and José Leitão**](https://www.youtube.com/watch?v=kxQmvWj_E5c)
  - *BSides Lisbon 2024* by Dimitrios Valsamaras and José Leitão
- [**Revisiting Stealthy Sensitive Information Collection from Android Apps**](https://youtu.be/tooIp6Wenww?feature=shared) 
  - *Black Hat Asia 2023* by Guangdong Bai, Guangshuai Xia, Qing Zhang
- [**Monitoring Surveillance Vendors: In-the-Wild Android Full Chains in 2021**](https://youtu.be/0Vv5kLj0tz4?feature=shared) 
  - *Black Hat USA 2022* by Xingyu Jin, Richard Neal, Christian Resell, Clement Lecigne
- [**PRC's Use of Mobile Surveillance for Tracking the Uighur population in China and Abroad**](https://youtu.be/33immRynwXA?feature=shared)
  - *CYBERWARCON 2022* by Kristina Balaam
- [**A Deep Dive into Privacy Dashboard of Top Android Vendors**](https://youtu.be/LyWwGqkXtVM?feature=shared) 
  - *Black Hat Europe 2021* by Bin Ma, Xiangxing Qian, Wei Wen & Zhenyu Zhu   
- [**A Mirage of Safety Bug Finding & Exploit Techniques of Top Android Vendor's Privacy Protection Apps**](https://www.youtube.com/watch?v=LKux50LIl7M) 
  - *Black Hat Asia 2021* by Huiming Liu & Xiangqian Zhang
- [**Can You Hear Me Now? Remote Eavesdropping Vulnerabilities in Mobile Messaging Applications**](https://youtu.be/s44K1IBnw4I?feature=shared)
  - *Black Hat USA 2021* by Natalie Silvanovich
- [**#HITBLockdown002 D1T1 - Zen: A Complex Campaign of Harmful Android Apps - Łukasz Siewierski**](https://youtu.be/-G4A3wCOBho?feature=shared)
  - *Hack In The Box Security Conference Lockdown 2021* by Łukasz Siewierski
- [**Android malware targeting Belgian Financial apps**](https://youtu.be/J47pp09sBxA?feature=shared)
  - *BruCON 0x0D 2021* by Jeroen Beckers
- [**Vulnerabilities discovered in Android stalkerware**](https://www.youtube.com/watch?v=jnf8EgLwGsk)
  - *Ekoparty 2021: Mobile Hacking* by Lukas Stefanko
- [**BAD BINDER: Finding an Android in the Wild 0day**](https://youtu.be/TAwQ4ezgEIo?feature=shared) 
  - *OffensiveCon20* by Maddie Stone

## Android Hardware Vectors
- [**Hardwear.io NL 2024: Google Nest Wifi Pro Bypassing Android Verified Boot**](https://www.youtube.com/watch?v=NbUYbuOk0wM)
  - *Hardwear.io NL 2024* by Sergei Volokitin 
- [**Dissecting The Modern Android Data Encryption Scheme**](https://youtu.be/I7_8OMcWPHg?feature=shared)
  - *Hardwear.io NL 2023* by Maxine Rossi 
- [**Physical Attacks Against Smartphones**](https://youtu.be/31xrNuH1RV4?feature=shared)
  - *DEFCON 31* by Christopher Wade
- [**Attack on Titan M, Reloaded: Vulnerability Research on a Modern Security Chip**](https://youtu.be/bCjkAkXiwK4?feature=shared)
  - *Black Hat USA 2022* by: Damiano Melotti , Maxime Rossi Bellom
- [**Breaking The Impossible: Bypassing Android's Secure Hardware Backed Attestation**](https://www.youtube.com/watch?app=desktop&v=OEhxgJbNnnU)
  - *BSides Basingstoke 2022* by Joseph Foote
 
## Android GPU Attacks
- [**The Way To Android Root: Exploiting Smartphone GPU**](https://youtu.be/BN07rjaNqXk?feature=shared)
  - *DEFCON 32* by Xiling Gong, Eugene Rodionov
- [**Make KSMA Great Again: The Art of Rooting Android Devices by GPU MMU Features**](https://youtu.be/2qkwSPnQqrU?feature=shared) 
  - *Black Hat USA 2023* By: Yong Wang
- [**Bad io_uring: A New Era of Rooting for Android**](https://www.youtube.com/watch?v=fhx3W1z7YD0) 
  - *Black Hat USA 2023* By: Zhaofeng Chen , Kang Li , Zhenpeng Lin , Xinyu Xing
- [**New Phones, Software & Chips = New Bugs?**](https://youtu.be/KAyfJt0CRVs?feature=shared) 
  - *OffensiveCon23* by Martijn Bogaard
- [**Evils in the Sparse Texture Memory: Exploit Kernel Based on Undefined Behaviors of Graphic APIs**](https://www.youtube.com/watch?v=0IiSbJB-smk) 
  - *Black Hat Europe 2023* by By: Xingyu Jin , Tony Mendez , Richard Neal
- [**Android Universal Root: Exploiting Mobile GPU / Command Queue Drivers**](https://www.youtube.com/watch?v=kEl5qbLZVeY) 
  - *Black Hat USA 2022* by Jon Bottarini, Xingyu Jin, Richard Neal

## Baseband Attacks
- [**How to Hack Shannon Baseband (from a Phone)**](https://youtu.be/quw8SnmMWg4?feature=shared) 
  - *OffensiveCon23* by Natalie Silvanovich
- [**Over the Air, Under the Radar: Attacking and Securing the Pixel Modem**](https://www.youtube.com/watch?v=KnN4NkaGCwE) 
  - *Black Hat USA 2023* by  Xiling Gong , Farzan Karimi , Eugene Rodionov , Xuan Xing
- [**Embedded Threats**](https://youtu.be/5oecn43xsDg?feature=shared) 
  - *OffensiveCon23* by  Markus Vervier
- [**A walk with Shannon: A walkthrough of a pwn2own baseband exploit - Amat Cama**](https://youtu.be/6bpxrfB9ioo?feature=shared)
  - *InsomniHack 2018* by Amat Cama
 
## Hard-Coded Credentials & Adjacent Attacks
- [**Hacking Trains**](https://www.youtube.com/watch?v=Iq5_YN-QwP8)
  - *Nullcon Berlin 2024* by Jaden Furtado
- [**Hacking Arcades for Fun**](https://www.youtube.com/live/_lB0GKFKoS4?feature=shared&t=14976)
  - *BSides Las Vegas 2024* by Ignacio Navarro
- [**Open, Sesame!" Unlocking Bluetooth Padlocks With Kind Requests - Miłosz Gaczkowski & Alex Pettifer**](https://youtu.be/1JDqhzQCtAA?feature=shared&t=417)
  - *BSides London 2023* by Miłosz Gaczkowski & Alex Pettifer
  
## Android Kernel Exploits
- [**How to Fuzz Your Way to Android Universal Root: Attacking Android Binder**](https://www.youtube.com/watch?v=U-xSM159YLI) 
  - *OffensiveCon24* by Eugene Rodionov,Zi Fan Tan and Gulshan Singh
- [**LinkDoor: A Hidden Attack Surface in the Android Netlink Kernel Modules**](https://www.youtube.com/watch?v=vqBC_WtDc6Q) 
  - *Black Hat Asia 2024* By Chao Ma, Han Yan & Tim Xia
- [**Game of Cross Cache: Let's win it in a more effective way**](https://www.youtube.com/watch?v=em9qgHm3uIk)
  - *Black Hat Asia 2024* By Le Wu & Qi Zhang
- [**Driving Forward in Android Drivers: Exploring the future of Android kernel hacking.**](https://www.youtube.com/watch?v=3xn_TmTIT4Q&t=9000s)
  - *Shmoocon 2024* by Seth Jenkins
- [**Exploiting Samsung: Analysis of an in-the-wild Samsung Exploit Chain**](https://youtu.be/hIRKYwgcT54?feature=shared)
  - *Ekoparty 2022* by Maddie Stone
- [**Elevating The TrustZone To Achieve A Powerful Android Kernel Exploit**](https://www.youtube.com/watch?v=WXqff23dT5I) 
  - *Nullcon Goa 2022* by Tamir Zahavi 
- [**Racing Against the Lock: Exploiting Spinlock UAF in the Android Kernel**](https://www.youtube.com/watch?v=E3CVDOlcHC4)  
  - *OffensiveCon23* by Moshe Kol
- [**ExplosION: The Hidden Mines in the Android ION Driver**](https://youtu.be/Qh6THzT0fxk?feature=shared)  
  - *Black Hat Asia 2022* by Le Wu, Xuen Li, Tim Xia
- [**Lost in Conversion: Exploit Data Structure Conversion with Attribute Loss to Break Android Systems**](https://youtu.be/14zczmy6U3k?feature=shared)  
  - *USENIX Security 2023* by Rui Li
- [**Attacking the Samsung Galaxy A Boot Chain**](https://youtu.be/WJ7wkJn7l7w?feature=shared)  
  - *OffensiveCon24* by Maxime Rossi Bellom, Damiano Melotti, Raphael Neveu, Gabrielle Viala
- [**Bug Hunting S21’s 10ADAB1E FW**](https://youtu.be/XvmtEwkG_Cc?feature=shared)  
  - *OffensiveCon22* by Federico Menarini and Martijn Bogaard
- [**Breaking Samsung's Root of Trust: Exploiting Samsung S10 Secure Boot**](https://www.youtube.com/watch?v=BwFtOrkKlbo&list=WL&index=1) 
  - *Black Hat USA 2020* by By Cheng-Yu Chao, Hung Chi Su and Che-Yang Wu

## Input Validation & Path Traversal Attacks
- [**Dirty Stream Attack, Turning Android Share Targets Into Attack Vectors**](https://www.youtube.com/watch?v=oZTGR9vJVMQ) 
  - *Black Hat Asia 2023* by Dimitrios Valsamaras
- [**Path traversal attacks on Android**](https://www.youtube.com/watch?v=EhCRdP1zXZo)
  - *Ekoparty 2023: Mobile Hacking Village* by Lukas Stefanko
- [**Bugfinding & Exploit Techniques Android File Transfer Apps**](https://www.youtube.com/watch?v=9gkconldTAU)
  - *DEF CON 27* by Xiangqian Zhang
    
 



