# Contributing Guidelines
We welcome and appreciate all contributions to the project! Below are some guidelines to follow when contributing.

## Issues
- Before opening a new issue, please check if the issue has already been reported.
- When opening a new issue, provide a clear and concise description of the problem. Include as much relevant information as possible (e.g. version, operating system, etc.).
## Pull Requests
- Fork the repository and create a new branch for your changes.
- Keep your changes in a single commit and limit the commit message to 72 characters in the subject line and a brief description in the body.
- Make sure that your code follows the existing coding style and best practices.
- Ensure that your code is well-documented and tested.
- Open a pull request with a clear title and description of your changes. Reference the related issue (if any) and explain the changes in detail.
- Wait for a maintainer to review and merge your pull request.
## Code of Conduct
- By participating in this project, you agree to abide by our Code of Conduct.

Thank you for your contribution!
