# GitBoard Web

Gitboard is a website that displays all public repositories hosted on Git, enabling users to search and browse repositories based on keywords, programming languages, and repository size. Users can view commit history, download code, and contribute to projects. Gitboard provides a unified search interface for users and tools for repository analysis.

# Getting Started ⭐

- To get started with Gitboard, simply visit our [website](https://gitboardweb.vercel.app/).
- From there, you can browse through open source projects, filter the projects and visit the user profile.
- Check the [Contributing Guide](/contributing.md) for more information.

![Screenshot 2023-05-26 at 6 06 19 PM](https://github.com/aashay28/GitBoard/assets/108337259/799bc073-e507-458d-ae7a-19f261a66a06)

![Screenshot 2023-05-26 at 6 03 41 PM](https://github.com/aashay28/GitBoard/assets/108337259/a4762904-48a7-4346-a376-855afd59fca8)

![Screenshot 2023-05-26 at 6 04 32 PM](https://github.com/aashay28/GitBoard/assets/108337259/1021764c-e16f-4ff4-9163-cd277d8bbc87)

# Tech Stacks 🛠️

To create this website we used:

![React](https://img.shields.io/badge/React-20232A?style=for-the-badge&logo=react&logoColor=61DAFB) ![Tailwind CSS](https://img.shields.io/badge/Tailwind_CSS-38B2AC?style=for-the-badge&logo=tailwind-css&logoColor=white) ![Vite](https://img.shields.io/badge/Vite-B73BFE?style=for-the-badge&logo=vite&logoColor=FFD62E) ![pnpm](https://img.shields.io/badge/npm-CB3837?style=for-the-badge&logo=npm&logoColor=white)

# Contributing ✨

- Are you interested in contributing to an open source project, but not sure where to start? You've come to the right place!
- We're inviting you to join our community and make your first contribution to this project.
- Whether you're a student, a self-taught programmer, or simply curious about open source, we welcome everyone who is eager to learn and contribute.
- You don't need to be an experienced developer to get started. There are many ways you can help us, from fixing typos in the documentation to adding new features to the website.
- Contributing to open source is a fantastic way to learn new skills, gain practical experience, and connect with like-minded individuals.

**Take a look at [Contributing Guide](/contributing.md) for further guidance.**

# Local Setup

## Prerequisite
- [Install node and npm](https://docs.npmjs.com/downloading-and-installing-node-js-and-npm)

Follow the below steps to setup the project for local development:
```
# Go to your project directory and clone the project
git clone https://github.com/aashay28/GitBoard.git && cd ./GitBoard

# Install packages
npm i

# Start the application in dev mode
npm run dev
```

Now you can start editing the files and view the changes using [this url](http://localhost:5174/)

# License 📝

Gitboard is licensed under the [MIT License](/LICENSE). See the LICENSE file for more information.

**Thank you for using Gitboard!**

# Our Contributors 🤝

<a href="https://github.com/aashay28/GitBoard/graphs/contributors">
  <img src="https://contrib.rocks/image?repo=aashay28/GitBoard" />
</a>
