# -*- coding: utf-8 -*-
"""Jernihin_5_tensorflow.ipynb

Automatically generated by Colaboratory.

Original file is located at
    https://colab.research.google.com/drive/1Hl22k666ePN4KFLivskDE74wviqMWwxF

# **Capstone Project C22-078**

* M319X0851 - Andrew Benedictus Jamesie  
* M319Y0854 - Cheliza Sriayu Simarsoit  
* M248X0512 - A. Gilang Aleyusta Savada  
* M182Y0310 - Ades Tikaningsih

***Project Theme***:  
Solusi Konservasi dan Pengelolaan Sumber Daya Alam

***Project Title***:  
Aplikasi Pendeteksi Kualitas Air sebagai Upaya Pengelolaan Sumber Daya Air yang Lebih Baik dengan Menggunakan Metode Deep Learning Berbasis Website

***Project Name***:  
Jernihin

# **1. *Library Import***
"""

# Commented out IPython magic to ensure Python compatibility.
import os
import numpy as np
import pandas as pd
import tensorflow as tf

from sklearn.model_selection import train_test_split
from sklearn.preprocessing import LabelEncoder

from keras.utils import np_utils
from keras.models import load_model
from keras.models import Sequential
from keras.layers import Dense, Dropout

from google.colab import drive
import seaborn as sns
import matplotlib.pyplot as plt
import matplotlib.image as mpimg
# %matplotlib inline

"""# **2. *Data Loading***

## 2.1 *Dataset Download*

https://data.amerigeoss.org/dataset/wqi-parameter-scores-1994-2013-b0941
"""

drive.mount('/content/drive/', force_remount=True)

water = pd.read_csv('drive/MyDrive/Dataset/WQI_Parameter_Scores_1994-2013.csv')
water.head()

"""## 2.2 *Dataset Preparation*

### 2.2.1 *Drop Unnecessary Features*
"""

water = water.drop(columns=['Station', 'Station Name', 'Year', 'Location 1'])

"""### 2.2.2 *Rename Columns*"""

water = water.rename(columns={
    'Overall WQI' : 'WQI',
    'WQI FC'      : 'Fecal',
    'WQI Oxy'     : 'Oxygen',
    'WQI pH'      : 'pH',
    'WQI TSS'     : 'Tot_Sediment', # Total Suspended Sediment
    'WQI Temp'    : 'Temp',
    'WQI TPN'     : 'Nitrogen',
    'WQI TP'      : 'Phosphorus',
    'WQI Turb'    : 'Turbidity',
})

"""### 2.2.3 *New Column Quality Classification*

http://pubs.sciepub.com/ajwr/1/3/3
"""

# Canadian Council of Ministers of the Environment Water Quality Index (CCME WQI)
# 95 - 100 Exellent
# 80 - 94  Good
# 60 - 79  Fair
# 45 - 59  Marginal
# 0  - 44  Poor

conditions = [
    (water.WQI >= 95) & (water.WQI <= 100),
    (water.WQI >= 80) & (water.WQI <= 94),
    (water.WQI >= 60) & (water.WQI <= 79),
    (water.WQI >= 45) & (water.WQI <= 59),
    (water.WQI >= 0)  & (water.WQI <= 44),
]

values = [5, 4, 3, 2, 1]

water['Quality'] = np.select(conditions, values)

water = water.drop(columns=['WQI'])
water.head()

"""# **3. *Data Understanding***

## 3.1 Menampilkan Data pada Dataframe `water`
"""

water

"""## 3.2 *Exploratory Data Analysis* (EDA)

### 3.2.1 Deskripsi Variabel
"""

water.info()

"""### 3.2.2 Deskripsi Statistik"""

water.describe()

"""### 3.2.3 *Missing Value Handling*"""

water.isnull().sum()

"""### 3.2.4 *Outliers Handling*"""

fig, axes = plt.subplots(1, 9, figsize=(11.5, 3))
count = 0
axes = axes.flatten()

for i, value in water.items():
    sns.boxplot(ax=axes[count], y=i, data=water)
    count += 1

plt.tight_layout(pad=0.5, h_pad=3, w_pad=0.8)

Q1 = water.quantile(0.25)
Q3 = water.quantile(0.75)

IQR = Q3 - Q1

water = water[~((water < (Q1 - 1.5*IQR)) | (water > (Q3 + 1.5*IQR))).any(axis=1)]

water.shape

fig, axes = plt.subplots(1, 9, figsize=(11.5, 3))
count = 0
axes = axes.flatten()

for i, value in water.items():
    sns.boxplot(ax=axes[count], y=i, data=water)
    count += 1

plt.tight_layout(pad=0.5, h_pad=3, w_pad=0.8)

"""### 3.2.5 *Univariate Analysis*"""

water.hist(bins=50, figsize=(14, 8))
plt.show()

"""### 3.2.6 *Multivariate Analysis*"""

sns.pairplot(water, diag_kind='kde')

"""### 3.2.7 *Heatmap Correlation Matrix*"""

plt.figure(figsize=(8, 6))

sns.heatmap(
    data       = water.corr().round(2),
    vmin       = -1,
    vmax       = 1,
    cmap       = 'viridis',
    annot      = True,
    linewidths = .5
)

plt.title('Numeric Features Correlation Matrix', size=20)

"""# **4. *Data Preparation***

## 4.1 *One-Hot Encoding*
"""

dataset = water.values

x = dataset[:,4:11].astype(float)
y = dataset[:,8]

encoder = LabelEncoder()
encoder.fit(y)
encodedY = encoder.transform(y)

y = np_utils.to_categorical(encodedY)

y

y.shape

"""## 4.2 *Split Data*"""

xTrain, xTest, yTrain, yTest = train_test_split(x, y, test_size=0.2, random_state=20221107)

print(f'Total all sample : {len(x)}')
print(f'Total data train : {len(xTrain)}')
print(f'Total data test  : {len(xTest)}')

"""# **5. *Model Development***"""

model = Sequential([
    Dense(64, input_dim=5, activation='relu'),
    Dense(32, activation='relu'),
    Dense(16, activation='relu'),
    Dense(8, activation='relu'),
    Dropout(0.25),
    Dense(4, activation='softmax')
])

model.compile(
    optimizer = 'adam',
    loss      = 'categorical_crossentropy',
    metrics   = ['accuracy']
)

model.summary()

class stopCallback(tf.keras.callbacks.Callback):
    def on_epoch_end(self, epoch, logs={}):
        if (logs.get('accuracy') > 0.98 and logs.get('val_accuracy') > 0.98):
            print('\naccuracy and val_accuracy reach > 98%')
            self.model.stop_training = True

stopTraining = stopCallback()

epoch = 200

history = model.fit(
    xTrain,
    yTrain,
    validation_data = (xTest, yTest),
    epochs          = epoch,
    batch_size      = 4,
    verbose         = 2,
    # callbacks       = [stopTraining]
)

"""# **6. *Model Evaluation***"""

accuracy     = history.history['accuracy']
val_accuracy = history.history['val_accuracy']

loss         = history.history['loss']
val_loss     = history.history['val_loss']

print(f'Max Training Accuracy: {max(accuracy)}')
print(f'Max Validation Accuracy: {max(val_accuracy)}\n')
print(f'Min Training Loss: {min(loss)}')
print(f'Min Validation Loss: {min(val_loss)}')

plt.figure(figsize = (12, 4))
plt.subplot(1, 2, 1)
plt.plot(accuracy,     label='Training Accuracy')
plt.plot(val_accuracy, label='Validation Accuracy')
plt.title('Training and Validation Accuracy')
plt.xlabel('Epoch')
plt.ylabel('Accuracy')
plt.legend(loc='lower right')

plt.subplot(1, 2, 2)
plt.plot(loss,     label='Training Loss')
plt.plot(val_loss, label='Validation Loss')
plt.title('Training and Validation Loss')
plt.xlabel('Epoch')
plt.ylabel('Loss')
plt.legend(loc='upper right')

plt.show()

lossTest, accTest = model.evaluate(xTest, yTest, batch_size=4)
print(f'\nLoss Test: {lossTest}')
print(f'Accuracy Test: {accTest*100}')

"""# **7. *Model Export Deployment***"""

model.save('model.h5')

!pip install tensorflowjs

!tensorflowjs_converter --input_format=keras model.h5 tfjs_model

"""# **8. *Model Test***"""

del model

filePath = '/content/model.h5'
model = load_model(filePath, compile=True)

x

y

score = model.evaluate(x, y, verbose=0)
print(f'{model.metrics_names[0]}: {round(score[0], 4)}')
print(f'{model.metrics_names[1]}: {round(score[1]*100, 4)}%')