# -*- coding: utf-8 -*-
"""Jernihin_5_sklearn.ipynb

Automatically generated by Colaboratory.

Original file is located at
    https://colab.research.google.com/drive/1tIgLlOeRJzhTJ5nXscenLQFYfjNPXEcw

# **Capstone Project C22-078**

* M319X0851 - Andrew Benedictus Jamesie  
* M319Y0854 - Cheliza Sriayu Simarsoit  
* M248X0512 - A. Gilang Aleyusta Savada  
* M182Y0310 - Ades Tikaningsih

***Project Theme***:  
Solusi Konservasi dan Pengelolaan Sumber Daya Alam

***Project Title***:  
Aplikasi Pendeteksi Kualitas Air sebagai Upaya Pengelolaan Sumber Daya Air yang Lebih Baik dengan Menggunakan Metode Deep Learning Berbasis Website

***Project Name***:  
Jernihin

# **1. *Library Import***
"""

# Commented out IPython magic to ensure Python compatibility.
import os
import pickle
import numpy as np
import pandas as pd

from sklearn.preprocessing import StandardScaler
from sklearn.model_selection import train_test_split
from sklearn.model_selection import RandomizedSearchCV

from sklearn.linear_model import LogisticRegression
from sklearn.neighbors import KNeighborsClassifier
from sklearn.ensemble import AdaBoostClassifier
from sklearn.ensemble import RandomForestClassifier
from sklearn.ensemble import GradientBoostingClassifier
from sklearn.tree import DecisionTreeClassifier

from sklearn.metrics import mean_squared_error
from sklearn.metrics import accuracy_score

from google.colab import drive
import seaborn as sns
import matplotlib.pyplot as plt
import matplotlib.image as mpimg
# %matplotlib inline

"""# **2. *Data Loading***

## 2.1 *Dataset Download*

https://data.amerigeoss.org/dataset/wqi-parameter-scores-1994-2013-b0941
"""

drive.mount('/content/drive/', force_remount=True)

water = pd.read_csv('drive/MyDrive/Dataset/WQI_Parameter_Scores_1994-2013.csv')
water.head()

"""## 2.2 *Dataset Preparation*

### 2.2.1 *Drop Unnecessary Features*
"""

water = water.drop(columns=['Station', 'Station Name', 'Year', 'Location 1'])

"""### 2.2.2 *Rename Columns*"""

water = water.rename(columns={
    'Overall WQI' : 'WQI',
    'WQI FC'      : 'Fecal',
    'WQI Oxy'     : 'Oxygen',
    'WQI pH'      : 'pH',
    'WQI TSS'     : 'Tot_Sediment', # Total Suspended Sediment
    'WQI Temp'    : 'Temp',
    'WQI TPN'     : 'Nitrogen',
    'WQI TP'      : 'Phosphorus',
    'WQI Turb'    : 'Turbidity',
})

"""### 2.2.3 *New Column Quality Classification*

http://pubs.sciepub.com/ajwr/1/3/3
"""

# Canadian Council of Ministers of the Environment Water Quality Index (CCME WQI)
# 95 - 100 Exellent
# 80 - 94  Good
# 60 - 79  Fair
# 45 - 59  Marginal
# 0  - 44  Poor

conditions = [
    (water.WQI >= 95) & (water.WQI <= 100),
    (water.WQI >= 80) & (water.WQI <= 94),
    (water.WQI >= 60) & (water.WQI <= 79),
    (water.WQI >= 45) & (water.WQI <= 59),
    (water.WQI >= 0)  & (water.WQI <= 44),
]

values = [5, 4, 3, 2, 1]

water['Quality'] = np.select(conditions, values)

water = water.drop(columns=['WQI'])
water.head()

"""### 2.2.4 *One-Hot Encoding*"""

# category = pd.get_dummies(water['Quality'])
# waterNew = pd.concat([water, category], axis=1)
# water    = waterNew.drop(['Quality'], axis=1)
# water

"""# **3. *Data Understanding***

## 3.1 Menampilkan Data pada Dataframe `water`
"""

water

"""## 3.2 *Exploratory Data Analysis* (EDA)

### 3.2.1 Deskripsi Variabel
"""

water.info()

"""### 3.2.2 Deskripsi Statistik"""

water.describe()

"""### 3.2.3 *Missing Value Handling*"""

water.isnull().sum()

"""### 3.2.4 *Outliers Handling*"""

fig, axes = plt.subplots(1, 9, figsize=(11.5, 3))
count = 0
axes = axes.flatten()

for i, value in water.items():
    sns.boxplot(ax=axes[count], y=i, data=water)
    count += 1

plt.tight_layout(pad=0.5, h_pad=3, w_pad=0.8)

Q1 = water.quantile(0.25)
Q3 = water.quantile(0.75)

IQR = Q3 - Q1

water = water[~((water < (Q1 - 1.5*IQR)) | (water > (Q3 + 1.5*IQR))).any(axis=1)]

water.shape

fig, axes = plt.subplots(1, 9, figsize=(11.5, 3))
count = 0
axes = axes.flatten()

for i, value in water.items():
    sns.boxplot(ax=axes[count], y=i, data=water)
    count += 1

plt.tight_layout(pad=0.5, h_pad=3, w_pad=0.8)

"""### 3.2.5 *Univariate Analysis*"""

water.hist(bins=50, figsize=(14, 8))
plt.show()

"""### 3.2.6 *Multivariate Analysis*"""

sns.pairplot(water, diag_kind='kde')

"""### 3.2.7 *Heatmap Correlation Matrix*"""

plt.figure(figsize=(8, 6))

sns.heatmap(
    data       = water.corr().round(2),
    vmin       = -1,
    vmax       = 1,
    cmap       = 'viridis',
    annot      = True,
    linewidths = .5
)

plt.title('Numeric Features Correlation Matrix', size=20)

"""# **4. *Data Preparation***

## 4.1 *Split Data*
"""

x = water.drop(['Quality'], axis=1)
y = water['Quality']

xTrain, xTest, yTrain, yTest = train_test_split(x, y, test_size=0.1, random_state=20221107)

print(f'Total all sample : {len(x)}')
print(f'Total data train : {len(xTrain)}')
print(f'Total data test  : {len(xTest)}')

"""## 4.2 *Numeric Features Standardization*"""

numericalFeatures = ['Fecal', 'Oxygen', 'pH', 'Tot_Sediment', 'Temp', 'Nitrogen', 'Phosphorus', 'Turbidity']

scaler = StandardScaler()
scaler.fit(xTrain[numericalFeatures])
xTrain[numericalFeatures] = scaler.transform(xTrain.loc[:, numericalFeatures])
xTrain[numericalFeatures].head()

"""# **5. *Model Development***

https://deepnote.com/@leonard-puttmann-a8ef/Water-quality-dataset-14a5f99f-9b81-49c9-9327-973b1c9f0b1f

## 5.1 *Model Preparation*
"""

models = pd.DataFrame(
    index   = ['train_mse', 'test_mse'],
    columns = ['KNN', 'RandomForest', 'AdaBoost', 'LRegression', 'DecisionTree', 'XGradientBoost']
)

"""## 5.2 *Models*"""

print(water.dtypes)

knn = KNeighborsClassifier(n_neighbors=30)
knn.fit(xTrain, yTrain)

models.loc["train_mse", "KNN"] = mean_squared_error(y_pred=knn.predict(xTrain), y_true=yTrain)

rfc = RandomForestClassifier(n_estimators=50, max_depth=16, random_state=20221107, n_jobs=-1)
rfc.fit(xTrain, yTrain)

models.loc['train_mse', 'RandomForest'] = mean_squared_error(y_pred=rfc.predict(xTrain), y_true=yTrain)

ada = AdaBoostClassifier(learning_rate=0.05, random_state=20221107)
ada.fit(xTrain, yTrain)

models.loc['train_mse', 'Boosting'] = mean_squared_error(y_pred=ada.predict(xTrain), y_true=yTrain)

lr = LogisticRegression()
lr.fit(xTrain, yTrain)

models.loc['train_mse', 'LogRegression'] = mean_squared_error(y_pred=lr.predict(xTrain), y_true=yTrain)

dtc = DecisionTreeClassifier()
dtc.fit(xTrain, yTrain)

models.loc['train_mse', 'DecisionTree'] = mean_squared_error(y_pred=dtc.predict(xTrain), y_true=yTrain)

xgb = GradientBoostingClassifier(learning_rate=0.05, n_estimators=10)
xgb.fit(xTrain, yTrain)

models.loc['train_mse', 'XGradientBoost'] = mean_squared_error(y_pred=xgb.predict(xTrain), y_true=yTrain)

"""# **6. *Model Evaluation***"""

xTest.loc[:, numericalFeatures] = scaler.transform(xTest[numericalFeatures])

mse = pd.DataFrame(
    columns = ['train', 'test'],
    index   = ['KNN', 'RandomForest', 'AdaBoost', 'LogRegression', 'DecisionTree', 'XGradientBoost']
)

modelDict = {
    'KNN'            : knn,
    'RandomForest'   : rfc,
    'AdaBoost'       : ada,
    'LogRegression'  : lr,
    'DecisionTree'   : dtc,
    'XGradientBoost' : xgb,
}

for name, model in modelDict.items():
    mse.loc[name, 'train'] = mean_squared_error(y_true=yTrain, y_pred=model.predict(xTrain))/1e3
    mse.loc[name, 'test']  = mean_squared_error(y_true=yTest,  y_pred=model.predict(xTest))/1e3

mse

fig, ax = plt.subplots()
mse.sort_values(by='test', ascending=False).plot(kind='barh', ax=ax, zorder=3)
ax.grid(zorder=0)

print(f'knn: {knn.score(xTest, yTest)}')
print(f'rfc: {rfc.score(xTest, yTest)}')
print(f'ada: {ada.score(xTest, yTest)}')
print(f'lr : {lr.score(xTest, yTest)}')
print(f'dtc: {dtc.score(xTest, yTest)}')
print(f'xgb: {xgb.score(xTest, yTest)}')

"""# **7. *Hyperparameter Tuning***"""

rfc = RandomForestClassifier()

rfc_params = {
    'n_estimators'      : [*range(25, 400, 20)],
    'criterion'         : ['gini', 'entropy', 'log_loss'],
    'max_depth'         : [*range(1, 11)],
    'min_samples_split' : [2, 4, 6, 8],
    'min_samples_leaf'  : [1, 2, 3, 4],
}

rs_rfc = RandomizedSearchCV(estimator=rfc, param_distributions=rfc_params, cv=5)

rs_rfc.fit(xTrain, yTrain)

print("Results from Random Forest Classifier")
print("\n Best estimator:\n", rs_rfc.best_estimator_)
print("\n Best score:\n", rs_rfc.best_score_)
print("\n Best parameters:\n", rs_rfc.best_params_)

# Test Best Model
rfc2 = RandomForestClassifier(
    criterion         = 'entropy',
    n_estimators      = 225,
    max_depth         = 9,
    min_samples_leaf  = 4,
    min_samples_split = 6,
    n_jobs            = -1
)

rfc2.fit(xTrain, yTrain)

y_pred = rfc2.predict(xTest)

print('Accuracy (%): ', accuracy_score(yTest, y_pred, normalize=True) * 100.0)

"""# **8. *Model Export Deployment***"""

with open('model.pkl', 'wb') as f:
    pickle.dump(rfc2, f)

"""# **9. *Model Test***"""

with open('model.pkl', 'rb') as f:
    model = pickle.load(f)

newData = np.array([93, 86, 96, 84, 90, 100, 84, 87])
newData = newData.reshape(1, -1)
print(newData)

prediction = model.predict(newData)[0]
print(prediction)

if prediction == 5:
    print('Exellent')
elif prediction == 4:
    print('Good')
elif prediction == 3:
    print('Fair')
elif prediction == 2:
    print('Marginal')
else:
    print('Poor')