<script>
    window.PagedConfig = {
        auto: false
    };
</script>
<script src="{{ mix('/static/js/build/paged.polyfill.js') }}"></script>
<script>
    class RepeatingTableHeaders extends Paged.Handler {
        constructor(chunker, polisher, caller) {
            super(chunker, polisher, caller);
        }
        afterPageLayout(pageElement, page, breakToken, chunker) {
            let tables = pageElement.querySelectorAll("table[data-split-from]");
            tables.forEach((table) => {
                let ref = table.dataset.ref;
                let sourceTable = chunker.source.querySelector("[data-ref='" + ref + "']");
                let header = sourceTable.querySelector("thead");
                if (header) {
                    let clonedHeader = header.cloneNode(true);
                    table.insertBefore(clonedHeader, table.firstChild);
                }
            });
        }
        afterRendered(pages) {
            document.querySelector('body').classList.add('rendered');
        }
    }
    Paged.registerHandlers(RepeatingTableHeaders);
</script>
<style>
    @page {
        size: A4;
        margin-top: 12mm;
        margin-bottom: 12mm;
        margin-left: 12mm;
        margin-right: 12mm;
    }

    @if($conf['cover'])

    #resetPageNum { counter-reset: page 1; }

    @page:nth(1) {
        padding-top: 0;

        @top-left {
            content: "";
            display: none;
        }

        @bottom-left {
            content: "";
            display: none;
        }

        @bottom-right {
            content: "";
            display: none;
        }
    }

    @endif

    @page {
        padding-top: 1rem;

        @top-left {
            content: element(header);
        }

        @bottom-left {
            content: element(footer);
            font-style: italic;
        }

        @bottom-right {
            content: "Page " counter(page);
            font-style: italic;
            padding-bottom: 1rem;
        }
    }

    .header {
        position: running(header);
        font-size: 1rem;
        border-bottom: 1px solid #000;
        padding-top: 1rem;
    }

    .footer {
        position: running(footer);
        font-size: 1rem;
        color: #000;
        padding-bottom: 1rem;
        width: 11cm;
        display: -webkit-box;
        overflow: hidden;
        text-overflow: ellipsis;
        word-wrap: break-word;
        word-break: break-all;
        white-space: normal !important;
        -webkit-line-clamp: 1;
        -webkit-box-orient: vertical;
    }
</style>
<div class="header">Generated by NOJ - https://github.com/ZsgsDesign/NOJ</div>
<div class="footer">{{$contest["shortName"]}}</div>

