/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.resource;

import java.util.ArrayList;
import java.util.List;
import org.springframework.core.io.Resource;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.web.reactive.resource.ResourceResolverChain;
import org.springframework.web.reactive.resource.ResourceTransformer;
import org.springframework.web.reactive.resource.ResourceTransformerChain;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

class DefaultResourceTransformerChain
implements ResourceTransformerChain {
    private final ResourceResolverChain resolverChain;
    private final List<ResourceTransformer> transformers = new ArrayList<ResourceTransformer>();
    private int index = -1;

    public DefaultResourceTransformerChain(ResourceResolverChain resolverChain, @Nullable List<ResourceTransformer> transformers) {
        Assert.notNull((Object)resolverChain, (String)"ResourceResolverChain is required");
        this.resolverChain = resolverChain;
        if (transformers != null) {
            this.transformers.addAll(transformers);
        }
    }

    @Override
    public ResourceResolverChain getResolverChain() {
        return this.resolverChain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Mono<Resource> transform(ServerWebExchange exchange, Resource resource) {
        ResourceTransformer transformer = this.getNext();
        if (transformer == null) {
            return Mono.just((Object)resource);
        }
        try {
            Mono<Resource> mono = transformer.transform(exchange, resource, this);
            return mono;
        }
        finally {
            --this.index;
        }
    }

    @Nullable
    private ResourceTransformer getNext() {
        Assert.state((this.index <= this.transformers.size() ? 1 : 0) != 0, (String)"Current index exceeds the number of configured ResourceTransformer's");
        if (this.index == this.transformers.size() - 1) {
            return null;
        }
        ++this.index;
        return this.transformers.get(this.index);
    }
}

