-- MySQL dump 10.13  Distrib 5.7.26, for Linux (x86_64)
--
-- Host: localhost    Database: zhtblog
-- ------------------------------------------------------
-- Server version	5.7.26-log

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `articls`
--

DROP TABLE IF EXISTS `articls`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `articls` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '唯一ID',
  `title` varchar(255) NOT NULL COMMENT '文章标题',
  `html` varchar(11845) NOT NULL COMMENT 'html格式文本',
  `time` datetime NOT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '发布时间',
  `browse` bigint(10) NOT NULL DEFAULT '0' COMMENT '浏览次数',
  `category` varchar(255) NOT NULL COMMENT '所属类别',
  `tags` varchar(255) NOT NULL DEFAULT '1' COMMENT '标签',
  `markdown` varchar(8845) NOT NULL COMMENT 'md格式文本',
  `Recommended` varchar(10) NOT NULL DEFAULT '\0' COMMENT '推荐阅读',
  `likearticls` bigint(10) DEFAULT '0' COMMENT '点赞数',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=23 DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `articls`
--

LOCK TABLES `articls` WRITE;
/*!40000 ALTER TABLE `articls` DISABLE KEYS */;
INSERT INTO `articls` VALUES (1,'axios的使用','<h1><a id=\"1npm_0\"></a>1.导入npm包</h1>\n<pre><div class=\"hljs\"><code class=\"lang-js\">npm  i  axios\n</code></div></pre>\n<h1><a id=\"2mainjs_4\"></a>2.打开main.js</h1>\n<pre><div class=\"hljs\"><code class=\"lang-js\"><span class=\"hljs-comment\">//导入axios</span>\n<span class=\"hljs-keyword\">import</span> axios <span class=\"hljs-keyword\">from</span> <span class=\"hljs-string\">\'axios\'</span>;\n<span class=\"hljs-comment\">//axios.defaults.headers.common[\'token\'] = \'123456\';</span>\nVue.prototype.axios = axios\n</code></div></pre>\n<h1><a id=\"3_13\"></a>3.使用</h1>\n<pre><div class=\"hljs\"><code class=\"lang-js\"><span class=\"hljs-keyword\">this</span>.axios({\n            <span class=\"hljs-attr\">method</span>: <span class=\"hljs-string\">\'post\'</span>,\n            <span class=\"hljs-attr\">url</span>: <span class=\"hljs-string\">\'/api/mybatis\'</span>,\n            <span class=\"hljs-attr\">data</span>: {\n                <span class=\"hljs-attr\">firstName</span>: <span class=\"hljs-string\">\'Fred\'</span>,\n                <span class=\"hljs-attr\">lastName</span>: <span class=\"hljs-string\">\'Flintstone\'</span>\n            }\n        });\n\n</code></div></pre>\n<p>设置Header</p>\n<blockquote>\n<p>setHeader(name, value, scopes=‘common’)</p>\n</blockquote>\n<blockquote>\n<p>参数：<br />\n名字<em>标题的名称<br />\n价值</em>标题的值<br />\n范围*只对特定类型的请求发送。缺省值<br />\n类型：列阵或弦<br />\n默认为common意味着所有类型的请求<br />\n可以get, post, delete, …</p>\n</blockquote>\n<pre><div class=\"hljs\"><code class=\"lang-js\"><span class=\"hljs-comment\">// Adds header: `Authorization: 123` to all requests</span>\n<span class=\"hljs-keyword\">this</span>.$axios.setHeader(<span class=\"hljs-string\">\'Authorization\'</span>, <span class=\"hljs-string\">\'123\'</span>)\n \n<span class=\"hljs-comment\">// Overrides `Authorization` header with new value</span>\n<span class=\"hljs-keyword\">this</span>.$axios.setHeader(<span class=\"hljs-string\">\'Authorization\'</span>, <span class=\"hljs-string\">\'456\'</span>)\n \n<span class=\"hljs-comment\">// Adds header: `Content-Type: application/x-www-form-urlencoded` to only post requests</span>\n<span class=\"hljs-keyword\">this</span>.$axios.setHeader(<span class=\"hljs-string\">\'Content-Type\'</span>, <span class=\"hljs-string\">\'application/x-www-form-urlencoded\'</span>, [\n  <span class=\"hljs-string\">\'post\'</span>\n])\n \n<span class=\"hljs-comment\">// Removes default Content-Type header from `post` scope</span>\n<span class=\"hljs-keyword\">this</span>.$axios.setHeader(<span class=\"hljs-string\">\'Content-Type\'</span>, <span class=\"hljs-literal\">false</span>, [<span class=\"hljs-string\">\'post\'</span>])\n\n</code></div></pre>\n<h1><a id=\"Token_55\"></a>设置Token</h1>\n<pre><div class=\"hljs\"><code class=\"lang-js\"> setToken(token, type, scopes=<span class=\"hljs-string\">\'common\'</span>)\n\n</code></div></pre>\n<p>Axios实例有一个额外的助手，可以轻松地设置全局身份验证头。</p>\n<blockquote>\n<p>参数：<br />\n令牌<em>授权令牌<br />\n类型：授权令牌前缀(通常为Bearer).<br />\n范围</em>只对特定类型的请求发送。缺省值<br />\n类型：列阵或弦<br />\n默认为common意味着所有类型的请求<br />\n可以get, post, delete, …</p>\n</blockquote>\n<pre><div class=\"hljs\"><code class=\"lang-js\"><span class=\"hljs-comment\">// Adds header: `Authorization: 123` to all requests</span>\n<span class=\"hljs-keyword\">this</span>.$axios.setToken(<span class=\"hljs-string\">\'123\'</span>)\n \n<span class=\"hljs-comment\">// Overrides `Authorization` header with new value</span>\n<span class=\"hljs-keyword\">this</span>.$axios.setToken(<span class=\"hljs-string\">\'456\'</span>)\n \n<span class=\"hljs-comment\">// Adds header: `Authorization: Bearer 123` to all requests</span>\n<span class=\"hljs-keyword\">this</span>.$axios.setToken(<span class=\"hljs-string\">\'123\'</span>, <span class=\"hljs-string\">\'Bearer\'</span>)\n \n<span class=\"hljs-comment\">// Adds header: `Authorization: Bearer 123` to only post and delete requests</span>\n<span class=\"hljs-keyword\">this</span>.$axios.setToken(<span class=\"hljs-string\">\'123\'</span>, <span class=\"hljs-string\">\'Bearer\'</span>, [<span class=\"hljs-string\">\'post\'</span>, <span class=\"hljs-string\">\'delete\'</span>])\n \n<span class=\"hljs-comment\">// Removes default Authorization header from `common` scope (all requests)</span>\n<span class=\"hljs-keyword\">this</span>.$axios.setToken(<span class=\"hljs-literal\">false</span>)\n\n</code></div></pre>\n<p><a href=\"http://www.axios-js.com/docs/nuxtjs-axios.html#prefix-host-and-port\" title=\"API文档\" target=\"_blank\">API文档</a></p>\n','2020-01-05 12:01:01',0,'axios','axios,vue','# 1.导入npm包\n```js\nnpm  i  axios\n```\n# 2.打开main.js\n\n```js\n//导入axios\nimport axios from \'axios\';\n//axios.defaults.headers.common[\'token\'] = \'123456\';\nVue.prototype.axios = axios\n```\n\n# 3.使用\n\n```js\nthis.axios({\n            method: \'post\',\n            url: \'/api/mybatis\',\n            data: {\n                firstName: \'Fred\',\n                lastName: \'Flintstone\'\n            }\n        });\n\n```\n\n设置Header\n\n> setHeader(name, value, scopes=\'common\')\n\n> 参数：\n名字*标题的名称\n价值*标题的值\n范围*只对特定类型的请求发送。缺省值\n类型：列阵或弦\n默认为common意味着所有类型的请求\n可以get, post, delete, …\n\n```js\n// Adds header: `Authorization: 123` to all requests\nthis.$axios.setHeader(\'Authorization\', \'123\')\n \n// Overrides `Authorization` header with new value\nthis.$axios.setHeader(\'Authorization\', \'456\')\n \n// Adds header: `Content-Type: application/x-www-form-urlencoded` to only post requests\nthis.$axios.setHeader(\'Content-Type\', \'application/x-www-form-urlencoded\', [\n  \'post\'\n])\n \n// Removes default Content-Type header from `post` scope\nthis.$axios.setHeader(\'Content-Type\', false, [\'post\'])\n\n```\n#  设置Token\n\n```js\n setToken(token, type, scopes=\'common\')\n\n```\n\nAxios实例有一个额外的助手，可以轻松地设置全局身份验证头。\n\n> 参数：\n令牌*授权令牌\n类型：授权令牌前缀(通常为Bearer).\n范围*只对特定类型的请求发送。缺省值\n类型：列阵或弦\n默认为common意味着所有类型的请求\n可以get, post, delete, …\n\n```js\n// Adds header: `Authorization: 123` to all requests\nthis.$axios.setToken(\'123\')\n \n// Overrides `Authorization` header with new value\nthis.$axios.setToken(\'456\')\n \n// Adds header: `Authorization: Bearer 123` to all requests\nthis.$axios.setToken(\'123\', \'Bearer\')\n \n// Adds header: `Authorization: Bearer 123` to only post and delete requests\nthis.$axios.setToken(\'123\', \'Bearer\', [\'post\', \'delete\'])\n \n// Removes default Authorization header from `common` scope (all requests)\nthis.$axios.setToken(false)\n\n```\n\n[API文档](http://www.axios-js.com/docs/nuxtjs-axios.html#prefix-host-and-port \"API文档\")','0',0),(2,'es6之promise对象常用API','<blockquote>\n<p>这篇文章是对Promise对象的简单概括，更多详细内容请访问阮一峰老师的<a href=\"http://es6.ruanyifeng.com/#docs/promise\" title=\"ECMAScript 6 入门\" target=\"_blank\">ECMAScript 6 入门</a></p>\n</blockquote>\n<h1><a id=\"1_2\"></a>1.基本用法</h1>\n<pre><div class=\"hljs\"><code class=\"lang-javascript\"><span class=\"hljs-keyword\">const</span> promise = <span class=\"hljs-keyword\">new</span> <span class=\"hljs-built_in\">Promise</span>(<span class=\"hljs-function\"><span class=\"hljs-keyword\">function</span>(<span class=\"hljs-params\">resolve, reject</span>) </span>{\n  <span class=\"hljs-comment\">// ... some code</span>\n\n  <span class=\"hljs-keyword\">if</span> (<span class=\"hljs-comment\">/* 异步操作成功 */</span>){\n    resolve(value);\n  } <span class=\"hljs-keyword\">else</span> {\n    reject(error);\n  }\n});\n</code></div></pre>\n<h1><a id=\"2Promiseprototypethen_14\"></a>2.Promise.prototype.then()</h1>\n<blockquote>\n<p>promise 实例具有then方法，也就是说，then方法是定义在原型对象promise.prototype上的。它的作用是为 promise 实例添加状态改变时的回调函数。前面说过，then方法的第一个参数是resolved状态的回调函数，第二个参数（可选）是rejected状态的回调函数。</p>\n</blockquote>\n<blockquote>\n<p>then方法返回的是一个新的promise实例（注意，不是原来那个promise实例）。因此可以采用链式写法，即then方法后面再调用另一个then方法。</p>\n</blockquote>\n<h1><a id=\"3Promiseprototypecatch_22\"></a>3.Promise.prototype.catch()</h1>\n<blockquote>\n<p>Promise.prototype.catch方法是.then(null, rejection)或.then(undefined, rejection)的别名，用于指定发生错误时的回调函数。</p>\n</blockquote>\n<h1><a id=\"4Promiseprototypefinally_27\"></a>4.Promise.prototype.finally()</h1>\n<blockquote>\n<p>finally方法用于指定不管 Promise 对象最后状态如何，都会执行的操作。该方法是 ES2018 引入标准的。</p>\n</blockquote>\n<h1><a id=\"5Promiseall_31\"></a>5.Promise.all()</h1>\n<blockquote>\n<p>Promise.all()方法用于将多个 Promise 实例，包装成一个新的 Promise 实例。</p>\n</blockquote>\n<pre><code class=\"lang-\">const p = Promise.all([p1, p2, p3]);\n\n</code></pre>\n<blockquote>\n<p>上面代码中，Promise.all()方法接受一个数组作为参数，p1、p2、p3都是 Promise 实例，如果不是，就会先调用下面讲到的Promise.resolve方法，将参数转为 Promise 实例，再进一步处理。另外，Promise.all()方法的参数可以不是数组，但必须具有 Iterator 接口，且返回的每个成员都是 Promise 实例。</p>\n</blockquote>\n<blockquote>\n<p>p的状态由p1、p2、p3决定，分成两种情况。</p>\n</blockquote>\n<blockquote>\n<p>（1）只有p1、p2、p3的状态都变成fulfilled，p的状态才会变成fulfilled，此时p1、p2、p3的返回值组成一个数组，传递给p的回调函数。</p>\n</blockquote>\n<blockquote>\n<p>（2）只要p1、p2、p3之中有一个被rejected，p的状态就变成rejected，此时第一个被reject的实例的返回值，会传递给p的回调函数。</p>\n</blockquote>\n<h1><a id=\"6Promiserace_46\"></a>6.Promise.race()</h1>\n<blockquote>\n<p>Promise.race()方法同样是将多个 Promise 实例，包装成一个新的 Promise 实例。</p>\n</blockquote>\n<pre><code class=\"lang-\">const p = Promise.race([p1, p2, p3]);\n</code></pre>\n<blockquote>\n<p>上面代码中，只要p1、p2、p3之中有一个实例率先改变状态，p的状态就跟着改变。那个率先改变的 Promise 实例的返回值，就传递给p的回调函数。</p>\n</blockquote>\n<blockquote>\n<p>Promise.race()方法的参数与Promise.all()方法一样，如果不是 Promise 实例，就会先调用下面讲到的Promise.resolve()方法，将参数转为 Promise 实例，再进一步处理。</p>\n</blockquote>\n<h1><a id=\"7PromiseallSettled_58\"></a>7.Promise.allSettled()</h1>\n<p>Promise.allSettled()方法接受一组 Promise 实例作为参数，包装成一个新的 Promise 实例。只有等到所有这些参数实例都返回结果，不管是fulfilled还是rejected，包装实例才会结束。该方法由 ES2020 引入。</p>\n<p>该方法返回的新的 Promise 实例，一旦结束，状态总是fulfilled，不会变成rejected。状态变成fulfilled后，Promise 的监听函数接收到的参数是一个数组，每个成员对应一个传入Promise.allSettled()的 Promise 实例。</p>\n<h1><a id=\"8Promiseany_64\"></a>8.Promise.any()</h1>\n<p>Promise.any()方法接受一组 Promise 实例作为参数，包装成一个新的 Promise 实例。只要参数实例有一个变成fulfilled状态，包装实例就会变成fulfilled状态；如果所有参数实例都变成rejected状态，包装实例就会变成rejected状态。该方法目前是一个第三阶段的提案 。</p>\n<p>Promise.any()跟Promise.race()方法很像，只有一点不同，就是不会因为某个 Promise 变成rejected状态而结束。</p>\n<h1><a id=\"9Promiseresolve_70\"></a>9.Promise.resolve()</h1>\n<p>有时需要将现有对象转为 Promise 对象，Promise.resolve()方法就起到这个作用。</p>\n<h1><a id=\"10Promisereject_74\"></a>10.Promise.reject()</h1>\n<p>Promise.reject(reason)方法也会返回一个新的 Promise 实例，该实例的状态为rejected。</p>\n<h1><a id=\"11Promisetry_78\"></a>11.Promise.try()</h1>\n<p>Promise.try就是模拟try代码块，就像promise.catch模拟的是catch代码块。</p>\n','2020-01-05 12:03:00',0,'javascript','es6,javascript','> 这篇文章是对Promise对象的简单概括，更多详细内容请访问阮一峰老师的[ECMAScript 6 入门](http://es6.ruanyifeng.com/#docs/promise \"ECMAScript 6 入门\")\n\n# 1.基本用法\n```javascript\nconst promise = new Promise(function(resolve, reject) {\n  // ... some code\n\n  if (/* 异步操作成功 */){\n    resolve(value);\n  } else {\n    reject(error);\n  }\n});\n```\n# 2.Promise.prototype.then()\n\n\n> promise 实例具有then方法，也就是说，then方法是定义在原型对象promise.prototype上的。它的作用是为 promise 实例添加状态改变时的回调函数。前面说过，then方法的第一个参数是resolved状态的回调函数，第二个参数（可选）是rejected状态的回调函数。\n\n> then方法返回的是一个新的promise实例（注意，不是原来那个promise实例）。因此可以采用链式写法，即then方法后面再调用另一个then方法。\n\n\n# 3.Promise.prototype.catch()\n\n\n> Promise.prototype.catch方法是.then(null, rejection)或.then(undefined, rejection)的别名，用于指定发生错误时的回调函数。\n\n# 4.Promise.prototype.finally()\n\n> finally方法用于指定不管 Promise 对象最后状态如何，都会执行的操作。该方法是 ES2018 引入标准的。\n\n# 5.Promise.all()\n> Promise.all()方法用于将多个 Promise 实例，包装成一个新的 Promise 实例。\n\n```\nconst p = Promise.all([p1, p2, p3]);\n\n```\n> 上面代码中，Promise.all()方法接受一个数组作为参数，p1、p2、p3都是 Promise 实例，如果不是，就会先调用下面讲到的Promise.resolve方法，将参数转为 Promise 实例，再进一步处理。另外，Promise.all()方法的参数可以不是数组，但必须具有 Iterator 接口，且返回的每个成员都是 Promise 实例。\n\n> p的状态由p1、p2、p3决定，分成两种情况。\n\n> （1）只有p1、p2、p3的状态都变成fulfilled，p的状态才会变成fulfilled，此时p1、p2、p3的返回值组成一个数组，传递给p的回调函数。\n\n> （2）只要p1、p2、p3之中有一个被rejected，p的状态就变成rejected，此时第一个被reject的实例的返回值，会传递给p的回调函数。\n\n# 6.Promise.race()\n\n> Promise.race()方法同样是将多个 Promise 实例，包装成一个新的 Promise 实例。\n```\nconst p = Promise.race([p1, p2, p3]);\n```\n\n\n> 上面代码中，只要p1、p2、p3之中有一个实例率先改变状态，p的状态就跟着改变。那个率先改变的 Promise 实例的返回值，就传递给p的回调函数。\n\n> Promise.race()方法的参数与Promise.all()方法一样，如果不是 Promise 实例，就会先调用下面讲到的Promise.resolve()方法，将参数转为 Promise 实例，再进一步处理。\n\n# 7.Promise.allSettled()\n\nPromise.allSettled()方法接受一组 Promise 实例作为参数，包装成一个新的 Promise 实例。只有等到所有这些参数实例都返回结果，不管是fulfilled还是rejected，包装实例才会结束。该方法由 ES2020 引入。\n\n该方法返回的新的 Promise 实例，一旦结束，状态总是fulfilled，不会变成rejected。状态变成fulfilled后，Promise 的监听函数接收到的参数是一个数组，每个成员对应一个传入Promise.allSettled()的 Promise 实例。\n\n# 8.Promise.any()\n\nPromise.any()方法接受一组 Promise 实例作为参数，包装成一个新的 Promise 实例。只要参数实例有一个变成fulfilled状态，包装实例就会变成fulfilled状态；如果所有参数实例都变成rejected状态，包装实例就会变成rejected状态。该方法目前是一个第三阶段的提案 。\n\nPromise.any()跟Promise.race()方法很像，只有一点不同，就是不会因为某个 Promise 变成rejected状态而结束。\n\n# 9.Promise.resolve()\n\n有时需要将现有对象转为 Promise 对象，Promise.resolve()方法就起到这个作用。\n\n# 10.Promise.reject()\n\nPromise.reject(reason)方法也会返回一个新的 Promise 实例，该实例的状态为rejected。\n\n# 11.Promise.try()\n\nPromise.try就是模拟try代码块，就像promise.catch模拟的是catch代码块。','0',0),(3,'vue-cli3本地跨域配置','<p>打开vue.config.js，添加以下代码</p>\n<pre><div class=\"hljs\"><code class=\"lang-javascript\"> devServer: {\n        <span class=\"hljs-attr\">host</span>: <span class=\"hljs-string\">\"localhost\"</span>,\n        <span class=\"hljs-attr\">port</span>: <span class=\"hljs-number\">8080</span>, <span class=\"hljs-comment\">// 端口号</span>\n        https: <span class=\"hljs-literal\">false</span>, <span class=\"hljs-comment\">// https:{type:Boolean}</span>\n        open: <span class=\"hljs-literal\">true</span>, <span class=\"hljs-comment\">//配置自动启动浏览器</span>\n        <span class=\"hljs-comment\">// proxy: \'http://localhost:4000\' // 配置跨域处理,只有一个代理</span>\n        <span class=\"hljs-comment\">// 配置多个代理</span>\n        proxy: {\n            <span class=\"hljs-string\">\"/api\"</span>: {   \n                <span class=\"hljs-attr\">target</span>: <span class=\"hljs-string\">\"http://localhost:5000/\"</span>,<span class=\"hljs-comment\">// 要访问的接口域名</span>\n               <span class=\"hljs-comment\">// ws: true,// 是否启用websockets</span>\n                changeOrigin: <span class=\"hljs-literal\">true</span>, <span class=\"hljs-comment\">//开启代理：在本地会创建一个虚拟服务端，然后发送请求的数据，并同时接收请求的数据，这样服务端和服务端进行数据的交互就不会有跨域问题</span>\n                pathRewrite: {\n                    <span class=\"hljs-string\">\'^/api\'</span>: <span class=\"hljs-string\">\'\'</span> <span class=\"hljs-comment\">//这里理解成用\'/api\'代替target里面的地址,比如我要调用\'http://40.00.100.100:3002/user/add\'，直接写\'/api/user/add\'即可</span>\n                }\n            },\n            <span class=\"hljs-comment\">//   \"/foo\": {</span>\n            <span class=\"hljs-comment\">//     target: \"&lt;other_url&gt;\"</span>\n            <span class=\"hljs-comment\">//   }</span>\n        }\n    }\n</code></div></pre>\n<p>以后直接在请求前添加/api即可</p>\n<pre><div class=\"hljs\"><code class=\"lang-javascript\">axiosInstance.get(<span class=\"hljs-string\">\'/api/lable\'</span>, {\n        })\n            .then(<span class=\"hljs-function\"><span class=\"hljs-keyword\">function</span> (<span class=\"hljs-params\">response</span>) </span>{\n                <span class=\"hljs-keyword\">let</span> res = response.data;\n                state.HotTags = res\n            })\n            .catch(<span class=\"hljs-function\"><span class=\"hljs-keyword\">function</span> (<span class=\"hljs-params\">err</span>) </span>{\n                <span class=\"hljs-built_in\">console</span>.log(err);\n            });\n\n</code></div></pre>\n','2020-01-05 12:04:05',0,'vue','vue','打开vue.config.js，添加以下代码\n```javascript\n devServer: {\n        host: \"localhost\",\n        port: 8080, // 端口号\n        https: false, // https:{type:Boolean}\n        open: true, //配置自动启动浏览器\n        // proxy: \'http://localhost:4000\' // 配置跨域处理,只有一个代理\n        // 配置多个代理\n        proxy: {\n            \"/api\": {   \n                target: \"http://localhost:5000/\",// 要访问的接口域名\n               // ws: true,// 是否启用websockets\n                changeOrigin: true, //开启代理：在本地会创建一个虚拟服务端，然后发送请求的数据，并同时接收请求的数据，这样服务端和服务端进行数据的交互就不会有跨域问题\n                pathRewrite: {\n                    \'^/api\': \'\' //这里理解成用\'/api\'代替target里面的地址,比如我要调用\'http://40.00.100.100:3002/user/add\'，直接写\'/api/user/add\'即可\n                }\n            },\n            //   \"/foo\": {\n            //     target: \"<other_url>\"\n            //   }\n        }\n    }\n```\n以后直接在请求前添加/api即可 \n\n```javascript\naxiosInstance.get(\'/api/lable\', {\n        })\n            .then(function (response) {\n                let res = response.data;\n                state.HotTags = res\n            })\n            .catch(function (err) {\n                console.log(err);\n            });\n\n```','0',0),(4,'Vue-cli3打包出现空白解决方案','<p>全局安装http-server</p>\n<pre><div class=\"hljs\"><code class=\"lang-js\">D:\\项目\\zhtblog\\dist&gt;npm install http-server -g\n</code></div></pre>\n<p>进入dist文件夹，打开cmd，输入 http-server,打开对应网址，问题解决</p>\n','2020-01-05 12:04:38',0,'vue','vue','全局安装http-server\n```js\nD:\\项目\\zhtblog\\dist>npm install http-server -g\n```\n进入dist文件夹，打开cmd，输入 http-server,打开对应网址，问题解决\n','0',0),(5,'Vuex分模块开发','<h1><a id=\"srcstore_0\"></a>首先在src目录下新建文件夹store</h1>\n<p>在store文件夹下 新建一个model文件夹用来管理vuex模块文件，新建一个index.js用来合并模块，一起导出</p>\n<blockquote>\n<p>结构如下</p>\n</blockquote>\n<img alt=\"\" class=\"has\" height=\"137\" src=\"https://img-blog.csdnimg.cn/20191127221500359.png\" width=\"348\">\n<h1><a id=\"lablejs_7\"></a>打开lable.js，编写模块代码，代码格式如下</h1>\n<pre><div class=\"hljs\"><code class=\"lang-javascript\"><span class=\"hljs-keyword\">const</span> state= {}\n<span class=\"hljs-keyword\">const</span> getters={}\n<span class=\"hljs-keyword\">const</span> mutations={}\n<span class=\"hljs-keyword\">const</span> actions={}\n<span class=\"hljs-keyword\">const</span> modelUser={\n<span class=\"hljs-attr\">state</span>:state,\n<span class=\"hljs-attr\">getters</span>:getters,\n<span class=\"hljs-attr\">mutations</span>:mutations,\n<span class=\"hljs-attr\">actions</span>:actions\n}\n<span class=\"hljs-keyword\">export</span> <span class=\"hljs-keyword\">default</span> modelUser\n\n</code></div></pre>\n<p>我的实例代码如下</p>\n<pre><div class=\"hljs\"><code class=\"lang-javascript\"><span class=\"hljs-keyword\">const</span> state = { <span class=\"hljs-attr\">HotTags</span>: <span class=\"hljs-string\">\"\"</span>, }\n<span class=\"hljs-keyword\">const</span> getters = {\n    <span class=\"hljs-attr\">HotTags</span>: <span class=\"hljs-function\"><span class=\"hljs-params\">state</span> =&gt;</span> {\n        <span class=\"hljs-keyword\">return</span> state.HotTags\n    }\n}\n<span class=\"hljs-keyword\">const</span> mutations = {\n    getHotTags(state) {\n        fetch(<span class=\"hljs-string\">\"/api/mybatis\"</span>)\n            .then(<span class=\"hljs-function\"><span class=\"hljs-params\">response</span> =&gt;</span> response.json())\n            .then(<span class=\"hljs-function\"><span class=\"hljs-params\">json</span> =&gt;</span> {\n                state.HotTags = json\n                <span class=\"hljs-built_in\">console</span>.log(<span class=\"hljs-string\">\"VUEx\"</span>)\n            })\n    }\n}\n<span class=\"hljs-keyword\">const</span> actions = {\n    getHotTags({ commit }) {\n        setTimeout(<span class=\"hljs-function\"><span class=\"hljs-params\">()</span> =&gt;</span> {\n            commit(<span class=\"hljs-string\">\'getHotTags\'</span>)\n        }, <span class=\"hljs-number\">0</span>)\n    }\n}\n<span class=\"hljs-keyword\">const</span> modellable = {\n    <span class=\"hljs-attr\">state</span>: state,\n    <span class=\"hljs-attr\">getters</span>: getters,\n    <span class=\"hljs-attr\">mutations</span>: mutations,\n    <span class=\"hljs-attr\">actions</span>: actions\n}\n<span class=\"hljs-keyword\">export</span> <span class=\"hljs-keyword\">default</span> modellable\n\n</code></div></pre>\n<p>打开index.js文件</p>\n<blockquote>\n<p>引入模块</p>\n</blockquote>\n<pre><div class=\"hljs\"><code class=\"lang-javascript\"><span class=\"hljs-keyword\">import</span> modulelable <span class=\"hljs-keyword\">from</span> <span class=\"hljs-string\">\'./model/lable\'</span>\n</code></div></pre>\n<p>引入vue和vuex</p>\n<pre><div class=\"hljs\"><code class=\"lang-javascript\"><span class=\"hljs-keyword\">import</span> Vue <span class=\"hljs-keyword\">from</span> <span class=\"hljs-string\">\'vue\'</span>\n<span class=\"hljs-keyword\">import</span> Vuex <span class=\"hljs-keyword\">from</span> <span class=\"hljs-string\">\'vuex\'</span>\nVue.use(Vuex)\n</code></div></pre>\n<p>编写导出代码，格式如下</p>\n<pre><div class=\"hljs\"><code class=\"lang-javascript\"><span class=\"hljs-keyword\">const</span> store = <span class=\"hljs-keyword\">new</span> Vuex.Store({\n    <span class=\"hljs-attr\">modules</span>: {\n        <span class=\"hljs-attr\">modulelable</span>: <span class=\"hljs-built_in\">Object</span>.assign({}, {          <span class=\"hljs-comment\">//lable 用户store</span>\n            namespaced: <span class=\"hljs-literal\">true</span>,\n        }, modulelable),\n    }\n})\n<span class=\"hljs-keyword\">export</span> <span class=\"hljs-keyword\">default</span> store\n</code></div></pre>\n<p>打开main.js，引入store 代码块，添加到vue实例中，完成</p>\n<pre><div class=\"hljs\"><code class=\"lang-javascript\"><span class=\"hljs-keyword\">new</span> Vue({\n  router,\n  store,\n  <span class=\"hljs-attr\">render</span>: <span class=\"hljs-function\"><span class=\"hljs-params\">h</span> =&gt;</span> h(App)\n}).$mount(<span class=\"hljs-string\">\'#app\'</span>)\n</code></div></pre>\n<h1><a id=\"_100\"></a>使用方法</h1>\n<h2><a id=\"1_101\"></a>1.直接使用</h2>\n<pre><div class=\"hljs\"><code class=\"lang-javascript\"><span class=\"hljs-keyword\">this</span>.$store.state.modulelable.name\n</code></div></pre>\n<p>在属性前面加入模块名</p>\n<h2><a id=\"2mapState__109\"></a>2.引入mapState 函数</h2>\n<pre><div class=\"hljs\"><code class=\"lang-javascript\"><span class=\"hljs-keyword\">import</span> { mapState } <span class=\"hljs-keyword\">from</span> <span class=\"hljs-string\">\'vuex\'</span>\n</code></div></pre>\n<pre><div class=\"hljs\"><code class=\"lang-javascript\">computed: {\n        ...mapState({\n            <span class=\"hljs-attr\">userName</span>: <span class=\"hljs-function\"><span class=\"hljs-params\">state</span> =&gt;</span> state.modulelable.name <span class=\"hljs-comment\">//modeuleUser</span>\n        })\n    },\n</code></div></pre>\n<h2><a id=\"vuex_121\"></a>使用vuex方法</h2>\n<pre><div class=\"hljs\"><code class=\"lang-javascript\"><span class=\"hljs-keyword\">import</span> { mapGetters } <span class=\"hljs-keyword\">from</span> <span class=\"hljs-string\">\"vuex\"</span>;\n</code></div></pre>\n<p>引入函数</p>\n<pre><div class=\"hljs\"><code class=\"lang-javascript\">computed: {\n        ...mapGetters(<span class=\"hljs-string\">\"modulelable\"</span>,[<span class=\"hljs-string\">\"HotTags\"</span>])\n    },\n</code></div></pre>\n<p>同时也可以和属性引入一样，前面起别名，以上。如果本文对你有帮助，欢迎点赞，或留言评论。</p>\n','2020-01-05 12:06:20',0,'vue','vuex,vue','# 首先在src目录下新建文件夹store\n\n在store文件夹下 新建一个model文件夹用来管理vuex模块文件，新建一个index.js用来合并模块，一起导出\n> 结构如下\n\n<img alt=\"\" class=\"has\" height=\"137\" src=\"https://img-blog.csdnimg.cn/20191127221500359.png\" width=\"348\">\n\n# 打开lable.js，编写模块代码，代码格式如下\n\n```javascript\nconst state= {}\nconst getters={}\nconst mutations={}\nconst actions={}\nconst modelUser={\nstate:state,\ngetters:getters,\nmutations:mutations,\nactions:actions\n}\nexport default modelUser\n\n```\n\n 我的实例代码如下\n\n```javascript\nconst state = { HotTags: \"\", }\nconst getters = {\n    HotTags: state => {\n        return state.HotTags\n    }\n}\nconst mutations = {\n    getHotTags(state) {\n        fetch(\"/api/mybatis\")\n            .then(response => response.json())\n            .then(json => {\n                state.HotTags = json\n                console.log(\"VUEx\")\n            })\n    }\n}\nconst actions = {\n    getHotTags({ commit }) {\n        setTimeout(() => {\n            commit(\'getHotTags\')\n        }, 0)\n    }\n}\nconst modellable = {\n    state: state,\n    getters: getters,\n    mutations: mutations,\n    actions: actions\n}\nexport default modellable\n\n```\n\n打开index.js文件\n\n> 引入模块 \n\n\n```javascript\nimport modulelable from \'./model/lable\'\n```\n\n引入vue和vuex\n\n```javascript\nimport Vue from \'vue\'\nimport Vuex from \'vuex\'\nVue.use(Vuex)\n```\n\n 编写导出代码，格式如下\n\n```javascript\nconst store = new Vuex.Store({\n    modules: {\n        modulelable: Object.assign({}, {          //lable 用户store\n            namespaced: true,\n        }, modulelable),\n    }\n})\nexport default store\n```\n\n打开main.js，引入store 代码块，添加到vue实例中，完成\n\n```javascript\nnew Vue({\n  router,\n  store,\n  render: h => h(App)\n}).$mount(\'#app\')\n```\n\n# 使用方法\n## 1.直接使用\n\n```javascript\nthis.$store.state.modulelable.name\n```\n\n在属性前面加入模块名\n\n## 2.引入mapState 函数\n```javascript\nimport { mapState } from \'vuex\'\n```\n\n```javascript\ncomputed: {\n        ...mapState({\n            userName: state => state.modulelable.name //modeuleUser\n        })\n    },\n```\n## 使用vuex方法\n\n```javascript\nimport { mapGetters } from \"vuex\";\n```\n\n引入函数\n\n```javascript\ncomputed: {\n        ...mapGetters(\"modulelable\",[\"HotTags\"])\n    },\n```\n 同时也可以和属性引入一样，前面起别名，以上。如果本文对你有帮助，欢迎点赞，或留言评论。','0',0),(6,'VUE路由切换时回到顶部','<p>今天使用vue开发的时候遇到这样一个问题，当页面使用动态路由时，都参数变了，页面停在当前位置，很不利于用户的体验</p>\n<p>开始尝试过用push的方法跳转路由，同时将滚动条位置设置为0，如下</p>\n<pre><div class=\"hljs\"><code class=\"lang-javascript\"><span class=\"hljs-keyword\">this</span>.$router.push({ <span class=\"hljs-attr\">name</span>: <span class=\"hljs-string\">\"category\"</span>, <span class=\"hljs-attr\">params</span>: { <span class=\"hljs-attr\">id</span>: val } });\n            <span class=\"hljs-comment\">// document.body.scrollTop = 0;</span>\n            <span class=\"hljs-comment\">// document.documentElement.scrollTop = 0;</span>\n\n</code></div></pre>\n<p>后来看了看官方文档vue-router <a href=\"https://router.vuejs.org/zh/guide/advanced/navigation-guards.html#%E7%BB%84%E4%BB%B6%E5%86%85%E7%9A%84%E5%AE%88%E5%8D%AB\" title=\"API\" target=\"_blank\">API</a></p>\n<h4><a id=\"_12\"></a>完整的导航解析流程</h4>\n<blockquote>\n<p>1.导航被触发。<br />\n2.在失活的组件里调用离开守卫。<br />\n3.调用全局的 beforeEach 守卫。<br />\n4.在重用的组件里调用 beforeRouteUpdate 守卫 (2.2+)。<br />\n5.在路由配置里调用 beforeEnter。<br />\n6.解析异步路由组件。<br />\n7.在被激活的组件里调用 beforeRouteEnter。<br />\n8.调用全局的 beforeResolve 守卫 (2.5+)。<br />\n9.导航被确认。<br />\n10.调用全局的 afterEach 钩子。<br />\n11.触发 DOM 更新。<br />\n12.用创建好的实例调用 beforeRouteEnter 守卫中传给 next 的回调函数。</p>\n</blockquote>\n<p>最终解决方案， 在router上添加一个全局afterEach函数，如下</p>\n<pre><div class=\"hljs\"><code class=\"lang-javascript\">router.afterEach(<span class=\"hljs-function\"><span class=\"hljs-params\">()</span> =&gt;</span> {\n  <span class=\"hljs-built_in\">window</span>.scrollTo(<span class=\"hljs-number\">0</span>, <span class=\"hljs-number\">0</span>)\n})\n</code></div></pre>\n<p>问题解决。</p>\n','2020-01-05 12:07:03',0,'vue','vue','今天使用vue开发的时候遇到这样一个问题，当页面使用动态路由时，都参数变了，页面停在当前位置，很不利于用户的体验\n\n开始尝试过用push的方法跳转路由，同时将滚动条位置设置为0，如下\n\n```javascript\nthis.$router.push({ name: \"category\", params: { id: val } });\n            // document.body.scrollTop = 0;\n            // document.documentElement.scrollTop = 0;\n\n```\n后来看了看官方文档vue-router [API](https://router.vuejs.org/zh/guide/advanced/navigation-guards.html#%E7%BB%84%E4%BB%B6%E5%86%85%E7%9A%84%E5%AE%88%E5%8D%AB \"API\")\n\n#### 完整的导航解析流程\n\n> 1.导航被触发。\n2.在失活的组件里调用离开守卫。\n3.调用全局的 beforeEach 守卫。\n4.在重用的组件里调用 beforeRouteUpdate 守卫 (2.2+)。\n5.在路由配置里调用 beforeEnter。\n6.解析异步路由组件。\n7.在被激活的组件里调用 beforeRouteEnter。\n8.调用全局的 beforeResolve 守卫 (2.5+)。\n9.导航被确认。\n10.调用全局的 afterEach 钩子。\n11.触发 DOM 更新。\n12.用创建好的实例调用 beforeRouteEnter 守卫中传给 next 的回调函数。\n\n最终解决方案， 在router上添加一个全局afterEach函数，如下\n\n```javascript\nrouter.afterEach(() => {\n  window.scrollTo(0, 0)\n})\n```\n问题解决。','0',0),(7,'vue组件传值，子传父，父传子','<h1><a id=\"1_0\"></a>1.子传父</h1>\n<p>首先创建子组件，在其中定义一个input框，定义其数值改变事件如下</p>\n<pre><div class=\"hljs\"><code class=\"lang-html\"> <span class=\"hljs-tag\">&lt;<span class=\"hljs-name\">input</span> <span class=\"hljs-attr\">type</span>=<span class=\"hljs-string\">\"text\"</span> <span class=\"hljs-attr\">v-model</span>=<span class=\"hljs-string\">\"value\"</span> @<span class=\"hljs-attr\">input</span>=<span class=\"hljs-string\">\"Sendout()\"</span> /&gt;</span>\n</code></div></pre>\n<p>定义变量和方法</p>\n<pre><div class=\"hljs\"><code class=\"lang-javascript\">data() {\n        <span class=\"hljs-keyword\">return</span> {\n            <span class=\"hljs-attr\">value</span>: <span class=\"hljs-string\">\"\"</span>\n        };\n    },\n    <span class=\"hljs-attr\">methods</span>: {\n        Sendout() {\n            <span class=\"hljs-built_in\">console</span>.log(<span class=\"hljs-keyword\">this</span>.value);\n            <span class=\"hljs-keyword\">this</span>.$emit(<span class=\"hljs-string\">\"Sendout\"</span>, <span class=\"hljs-keyword\">this</span>.value);\n        }\n    }\n\n</code></div></pre>\n<p>文本框值改变，触发自定义事件，发送数据</p>\n<p>创建父组件</p>\n<p>引入子组件</p>\n<pre><div class=\"hljs\"><code class=\"lang-javascript\">qqq: <span class=\"hljs-function\"><span class=\"hljs-params\">()</span> =&gt;</span> <span class=\"hljs-keyword\">import</span>(<span class=\"hljs-string\">\"@/components/qqq.vue\"</span>)\n</code></div></pre>\n<p>在组件标签上定义自定义方法，如下</p>\n<pre><div class=\"hljs\"><code class=\"lang-html\"><span class=\"hljs-tag\">&lt;<span class=\"hljs-name\">qqq</span> @<span class=\"hljs-attr\">Sendout</span>=<span class=\"hljs-string\">\"Receive($event)\"</span>&gt;</span><span class=\"hljs-tag\">&lt;/<span class=\"hljs-name\">qqq</span>&gt;</span>\n</code></div></pre>\n<p>创建相对应的函数</p>\n<pre><div class=\"hljs\"><code class=\"lang-javascript\">Receive(param) {\n            <span class=\"hljs-built_in\">console</span>.log(param);\n        },\n</code></div></pre>\n<p>此处的param变量即为子组件的值</p>\n<h1><a id=\"2_48\"></a>2.父传子</h1>\n<p>在父组件中，直接对使用的子组件标签进行绑定自定义属性，如下</p>\n<pre><div class=\"hljs\"><code class=\"lang-html\"> <span class=\"hljs-tag\">&lt;<span class=\"hljs-name\">qqq</span> @<span class=\"hljs-attr\">Sendout</span>=<span class=\"hljs-string\">\"Receive($event)\"</span> <span class=\"hljs-attr\">:name</span>=<span class=\"hljs-string\">\"\'name\'\"</span>&gt;</span><span class=\"hljs-tag\">&lt;/<span class=\"hljs-name\">qqq</span>&gt;</span>\n</code></div></pre>\n<p>此处name属性可动态绑定</p>\n<p>在子组件中</p>\n<p>声明props属性</p>\n<pre><div class=\"hljs\"><code class=\"lang-javascript\"> props: [<span class=\"hljs-string\">\"name\"</span>],\n</code></div></pre>\n<p>然后子组件可以直接当成data函数中的变量进行使用</p>\n<h1><a id=\"3_67\"></a>3.非父子组件传值</h1>\n<p>同时引入一个js文件，一个定义事件，一个触发事件，达到传值的目的</p>\n<p>如下，我们可以全局定义一个对象</p>\n<pre><div class=\"hljs\"><code class=\"lang-javascript\"><span class=\"hljs-comment\">//~ 在main.js中加入</span>\nVue.prototype.bus = <span class=\"hljs-keyword\">new</span> Vue()  <span class=\"hljs-comment\">// 这样我们就实现了全局的事件总线对象</span>\n</code></div></pre>\n<pre><div class=\"hljs\"><code class=\"lang-javascript\"><span class=\"hljs-comment\">//~ 组件A中，监听事件</span>\n<span class=\"hljs-keyword\">this</span>.bus.$on(<span class=\"hljs-string\">\'update\'</span>, <span class=\"hljs-function\"><span class=\"hljs-keyword\">function</span>(<span class=\"hljs-params\">data</span>) </span>{\n    <span class=\"hljs-built_in\">console</span>.log(data)  <span class=\"hljs-comment\">// data就是触发update事件带过来的数据</span>\n})\n\n<span class=\"hljs-comment\">//~ 组件B中，触发事件</span>\n<span class=\"hljs-keyword\">this</span>.bus.$emit(<span class=\"hljs-string\">\'update\'</span>, data)  <span class=\"hljs-comment\">// data就是触发update事件要带走的数据</span>\n</code></div></pre>\n<p>以上就是vue组件传值的三种方式。</p>\n','2020-01-05 12:07:58',0,'vue','vue,vue传值','# 1.子传父\n首先创建子组件，在其中定义一个input框，定义其数值改变事件如下\n\n```html\n <input type=\"text\" v-model=\"value\" @input=\"Sendout()\" />\n```\n定义变量和方法\n\n```javascript\ndata() {\n        return {\n            value: \"\"\n        };\n    },\n    methods: {\n        Sendout() {\n            console.log(this.value);\n            this.$emit(\"Sendout\", this.value);\n        }\n    }\n\n```\n\n文本框值改变，触发自定义事件，发送数据\n\n创建父组件\n\n引入子组件\n```javascript\nqqq: () => import(\"@/components/qqq.vue\")\n```\n\n在组件标签上定义自定义方法，如下\n\n```html\n<qqq @Sendout=\"Receive($event)\"></qqq>\n```\n\n 创建相对应的函数\n\n```javascript\nReceive(param) {\n            console.log(param);\n        },\n```\n\n 此处的param变量即为子组件的值\n\n# 2.父传子\n\n 在父组件中，直接对使用的子组件标签进行绑定自定义属性，如下\n\n```html\n <qqq @Sendout=\"Receive($event)\" :name=\"\'name\'\"></qqq>\n```\n\n此处name属性可动态绑定\n\n在子组件中\n\n声明props属性\n```javascript\n props: [\"name\"],\n```\n\n 然后子组件可以直接当成data函数中的变量进行使用\n\n#  3.非父子组件传值\n同时引入一个js文件，一个定义事件，一个触发事件，达到传值的目的\n\n如下，我们可以全局定义一个对象\n```javascript\n//~ 在main.js中加入\nVue.prototype.bus = new Vue()  // 这样我们就实现了全局的事件总线对象\n```\n\n```javascript\n//~ 组件A中，监听事件\nthis.bus.$on(\'update\', function(data) {\n    console.log(data)  // data就是触发update事件带过来的数据\n})\n\n//~ 组件B中，触发事件\nthis.bus.$emit(\'update\', data)  // data就是触发update事件要带走的数据\n```\n以上就是vue组件传值的三种方式。 ','0',0),(8,'webpack入门教程（1）加载css','<h1><a id=\"1_0\"></a>1.安装所需要的模块</h1>\n<pre><div class=\"hljs\"><code class=\"lang-js\">npm install --save-dev css-loader\nnpm install --save-dev style-loader\n</code></div></pre>\n<p>然后直接在js配置文件中引入要使用的css</p>\n<pre><div class=\"hljs\"><code class=\"lang-js\"><span class=\"hljs-keyword\">import</span> css <span class=\"hljs-keyword\">from</span> <span class=\"hljs-string\">\'file.css\'</span>;\n\n</code></div></pre>\n<p>在webpack.config.js配置文件中配置module</p>\n<pre><div class=\"hljs\"><code class=\"lang-js\"><span class=\"hljs-built_in\">module</span>.exports = {\n  <span class=\"hljs-attr\">module</span>: {\n    <span class=\"hljs-attr\">rules</span>: [\n      {\n        <span class=\"hljs-attr\">test</span>: <span class=\"hljs-regexp\">/\\.css$/i</span>,\n        <span class=\"hljs-attr\">use</span>: [<span class=\"hljs-string\">\'style-loader\'</span>, <span class=\"hljs-string\">\'css-loader\'</span>],\n      },\n    ],\n  },\n};\n</code></div></pre>\n<p>其中‘style-loader’一定要写在前面</p>\n<p>####options选项</p>\n<pre><div class=\"hljs\"><code class=\"lang-js\">  <span class=\"hljs-built_in\">module</span>: {\n        <span class=\"hljs-attr\">rules</span>: [ <span class=\"hljs-comment\">//配置加载器, 用来处理源文件, 可以把es6, jsx等转换成js, sass, less等转换成css</span>\n            {\n                <span class=\"hljs-attr\">test</span>: <span class=\"hljs-regexp\">/\\.css$/</span>, <span class=\"hljs-comment\">//配置要处理的文件格式，一般使用正则表达式匹配</span>\n                use: [\n                    {\n                        <span class=\"hljs-attr\">loader</span>: <span class=\"hljs-string\">\"style-loader\"</span>\n                    },\n                    {\n                        <span class=\"hljs-attr\">loader</span>: <span class=\"hljs-string\">\"css-loader\"</span>,\n                        <span class=\"hljs-attr\">options</span>: {\n                            <span class=\"hljs-attr\">modules</span>: <span class=\"hljs-literal\">true</span>, <span class=\"hljs-comment\">// 指定启用css modules</span>\n                        }\n                    }\n                ]\n            }\n        ]\n    },\n</code></div></pre>\n<h2><a id=\"1url_49\"></a>1.url</h2>\n<p>类型：Boolean|Function 默认值：true</p>\n<p>启用/禁用url/ image-set功能处理。控制url()解析。绝对URL和根目录相对URL无法解析。</p>\n<p>值为true或者false时，将启用/禁用url()解析。</p>\n<h1><a id=\"2scss_56\"></a>2.使用scss</h1>\n<p>安装</p>\n<pre><div class=\"hljs\"><code class=\"lang-js\">npm install sass-loader node-sass webpack --save-dev\n</code></div></pre>\n<p>在配置文件中添加以下代码</p>\n<pre><div class=\"hljs\"><code class=\"lang-js\"><span class=\"hljs-comment\">// webpack.config.js</span>\n<span class=\"hljs-built_in\">module</span>.exports = {\n  ...\n  module: {\n    <span class=\"hljs-attr\">rules</span>: [{\n      <span class=\"hljs-attr\">test</span>: <span class=\"hljs-regexp\">/\\.scss$/</span>,\n      <span class=\"hljs-attr\">use</span>: [{\n          <span class=\"hljs-attr\">loader</span>: <span class=\"hljs-string\">\"style-loader\"</span> <span class=\"hljs-comment\">// 将 JS 字符串生成为 style 节点</span>\n      }, {\n          <span class=\"hljs-attr\">loader</span>: <span class=\"hljs-string\">\"css-loader\"</span> <span class=\"hljs-comment\">// 将 CSS 转化成 CommonJS 模块</span>\n      }, {\n          <span class=\"hljs-attr\">loader</span>: <span class=\"hljs-string\">\"sass-loader\"</span> <span class=\"hljs-comment\">// 将 Sass 编译成 CSS</span>\n      }]\n    }]\n  }\n};\n</code></div></pre>\n<p>就可以正常使用scss文件了</p>\n','2020-01-05 12:08:56',0,'webpack','webpack','# 1.安装所需要的模块\n```js\nnpm install --save-dev css-loader\nnpm install --save-dev style-loader\n```\n然后直接在js配置文件中引入要使用的css\n\n```js\nimport css from \'file.css\';\n\n```\n\n在webpack.config.js配置文件中配置module\n\n```js\nmodule.exports = {\n  module: {\n    rules: [\n      {\n        test: /\\.css$/i,\n        use: [\'style-loader\', \'css-loader\'],\n      },\n    ],\n  },\n};\n```\n其中‘style-loader’一定要写在前面\n\n####options选项\n```js\n  module: {\n        rules: [ //配置加载器, 用来处理源文件, 可以把es6, jsx等转换成js, sass, less等转换成css\n            {\n                test: /\\.css$/, //配置要处理的文件格式，一般使用正则表达式匹配\n                use: [\n                    {\n                        loader: \"style-loader\"\n                    },\n                    {\n                        loader: \"css-loader\",\n                        options: {\n                            modules: true, // 指定启用css modules\n                        }\n                    }\n                ]\n            }\n        ]\n    },\n```\n## 1.url\n类型：Boolean|Function 默认值：true\n\n启用/禁用url/ image-set功能处理。控制url()解析。绝对URL和根目录相对URL无法解析。\n\n值为true或者false时，将启用/禁用url()解析。\n\n# 2.使用scss\n\n安装\n```js\nnpm install sass-loader node-sass webpack --save-dev\n```\n在配置文件中添加以下代码\n\n```js\n// webpack.config.js\nmodule.exports = {\n  ...\n  module: {\n    rules: [{\n      test: /\\.scss$/,\n      use: [{\n          loader: \"style-loader\" // 将 JS 字符串生成为 style 节点\n      }, {\n          loader: \"css-loader\" // 将 CSS 转化成 CommonJS 模块\n      }, {\n          loader: \"sass-loader\" // 将 Sass 编译成 CSS\n      }]\n    }]\n  }\n};\n```\n就可以正常使用scss文件了','0',0),(9,'webpack入门教程（2）加载图片','<h1><a id=\"1_0\"></a>1.安装依赖包</h1>\n<pre><div class=\"hljs\"><code class=\"lang-js\">npm install file-loader --save-dev\n</code></div></pre>\n<p>2.配置模块加载器</p>\n<p>打开webpack配置文件</p>\n<pre><div class=\"hljs\"><code class=\"lang-javascript\">  {\n                <span class=\"hljs-attr\">test</span>: <span class=\"hljs-regexp\">/\\.(png|jpe?g|gif)$/i</span>,\n                <span class=\"hljs-attr\">use</span>: [\n                    {\n                        <span class=\"hljs-attr\">loader</span>: <span class=\"hljs-string\">\'file-loader\'</span>,\n                        <span class=\"hljs-comment\">// options: {</span>\n                        <span class=\"hljs-comment\">//     name(file) {</span>\n                        <span class=\"hljs-comment\">//         if (process.env.NODE_ENV === \'development\') {</span>\n                        <span class=\"hljs-comment\">//             return \'[path][name].[ext]\';</span>\n                        <span class=\"hljs-comment\">//         }</span>\n                        <span class=\"hljs-comment\">//         return \'[name].[ext]\';</span>\n                        <span class=\"hljs-comment\">//     },</span>\n                        <span class=\"hljs-comment\">//     outputPath: \'images\',</span>\n                        <span class=\"hljs-comment\">// }</span>\n                    },\n                ],\n            },\n</code></div></pre>\n<h4><a id=\"_30\"></a>图片的使用方法</h4>\n<blockquote>\n<p>1.在主页中</p>\n</blockquote>\n<p>直接引入打包后的路径</p>\n<pre><div class=\"hljs\"><code class=\"lang-html\"><span class=\"hljs-tag\">&lt;<span class=\"hljs-name\">img</span> <span class=\"hljs-attr\">src</span>=<span class=\"hljs-string\">\"\'xxx.jpg\'\"</span>/&gt;</span>\n\n</code></div></pre>\n<blockquote>\n<p>2.在模板页中，模板页里的img<br />\n标签中相对路径的图片不会被loader 解析，因此需要使用require 引用图片</p>\n</blockquote>\n<pre><div class=\"hljs\"><code class=\"lang-html\"><span class=\"hljs-tag\">&lt;<span class=\"hljs-name\">img</span> <span class=\"hljs-attr\">src</span>=<span class=\"hljs-string\">\"${require(\'xxx.jpg\')}\"</span>/&gt;</span>\n\n</code></div></pre>\n<p>3.css中引用</p>\n<pre><div class=\"hljs\"><code class=\"lang-css\"><span class=\"hljs-selector-class\">.layer</span>{\n  //<span class=\"hljs-attribute\">background-image</span>:<span class=\"hljs-built_in\">url</span>(<span class=\"hljs-string\">\"xxx.jpg\"</span>);\n}\n</code></div></pre>\n<h1><a id=\"2urlloader_58\"></a>2.配置url-loader</h1>\n<pre><div class=\"hljs\"><code class=\"lang-js\">npm install url-loader --save-dev\n\n</code></div></pre>\n<p>添加模块解析</p>\n<pre><div class=\"hljs\"><code class=\"lang-js\">{\n                <span class=\"hljs-attr\">test</span>: <span class=\"hljs-regexp\">/\\.(png|svg|jpg|gif)$/</span>,\n                <span class=\"hljs-attr\">use</span>: {\n                    <span class=\"hljs-attr\">loader</span>: <span class=\"hljs-string\">\'url-loader\'</span>,\n                    <span class=\"hljs-attr\">options</span>: {\n                        <span class=\"hljs-attr\">name</span>: <span class=\"hljs-string\">\'images/[name].[ext]\'</span>,\n                        <span class=\"hljs-attr\">limit</span>: <span class=\"hljs-number\">1024</span>\n                    }\n                }\n },\n</code></div></pre>\n<p>以上就是对webpack加载图片的简单使用。</p>\n','2020-01-05 12:09:43',0,'webpack','webpack','# 1.安装依赖包\n\n```js\nnpm install file-loader --save-dev\n```\n\n2.配置模块加载器\n\n打开webpack配置文件\n\n```javascript\n  {\n                test: /\\.(png|jpe?g|gif)$/i,\n                use: [\n                    {\n                        loader: \'file-loader\',\n                        // options: {\n                        //     name(file) {\n                        //         if (process.env.NODE_ENV === \'development\') {\n                        //             return \'[path][name].[ext]\';\n                        //         }\n                        //         return \'[name].[ext]\';\n                        //     },\n                        //     outputPath: \'images\',\n                        // }\n                    },\n                ],\n            },\n```\n\n#### 图片的使用方法\n\n>1.在主页中\n\n直接引入打包后的路径\n\n```html\n<img src=\"\'xxx.jpg\'\"/>\n\n```\n\n>2.在模板页中，模板页里的img\n标签中相对路径的图片不会被loader 解析，因此需要使用require 引用图片\n\n```html\n<img src=\"${require(\'xxx.jpg\')}\"/>\n\n```\n\n3.css中引用\n\n```css\n.layer{\n  //background-image:url(\"xxx.jpg\");\n}\n```\n\n\n# 2.配置url-loader\n\n```js\nnpm install url-loader --save-dev\n\n```\n\n添加模块解析\n\n```js\n{\n                test: /\\.(png|svg|jpg|gif)$/,\n                use: {\n                    loader: \'url-loader\',\n                    options: {\n                        name: \'images/[name].[ext]\',\n                        limit: 1024\n                    }\n                }\n },\n```\n以上就是对webpack加载图片的简单使用。','0',0),(10,'webpack入门教程（3）自动生成清除html文件','<h1><a id=\"1indexhtml_0\"></a>1.自动生成index.html</h1>\n<p>安装插件</p>\n<pre><div class=\"hljs\"><code class=\"lang-js\">npm install --save-dev html-webpack-plugin\n</code></div></pre>\n<p>首先引入我们的插件</p>\n<pre><div class=\"hljs\"><code class=\"lang-js\"><span class=\"hljs-keyword\">let</span> HtmlWebpackPlugin = <span class=\"hljs-built_in\">require</span>(<span class=\"hljs-string\">\'html-webpack-plugin\'</span>);\n</code></div></pre>\n<p>然后在我们的webpack配置文件中编写以下代码</p>\n<pre><div class=\"hljs\"><code class=\"lang-js\">plugins: [\n     <span class=\"hljs-keyword\">new</span> HtmlWebpackPlugin(),\n   ],\n</code></div></pre>\n<p>同时，HtmlWebpackPlugin方法里可以接受一个对象，<br />\n如指点模板文件</p>\n<pre><div class=\"hljs\"><code class=\"lang-js\"><span class=\"hljs-keyword\">new</span> HtmlWebpackPlugin({\n            <span class=\"hljs-attr\">template</span>: <span class=\"hljs-string\">\"./src/index.html\"</span>\n        })\n</code></div></pre>\n<p>此时打包生成的网页文件，除了你webpack中绑定的数据，还有你模板中的代码</p>\n<h1><a id=\"2dist_29\"></a>2.生成前先清楚dist文件夹</h1>\n<p>安装对应插件</p>\n<pre><div class=\"hljs\"><code class=\"lang-js\">npm install --save-dev clean-webpack-plugin\n</code></div></pre>\n<p>在配置文件中引入插件</p>\n<pre><div class=\"hljs\"><code class=\"lang-js\"><span class=\"hljs-keyword\">const</span> { CleanWebpackPlugin } = <span class=\"hljs-built_in\">require</span>(<span class=\"hljs-string\">\'clean-webpack-plugin\'</span>);\n</code></div></pre>\n<p>直接在配置文件中放在最前面即可</p>\n<pre><div class=\"hljs\"><code class=\"lang-js\"> plugins: [\n     <span class=\"hljs-keyword\">new</span> CleanWebpackPlugin(),\n      <span class=\"hljs-keyword\">new</span> HtmlWebpackPlugin({\n        <span class=\"hljs-attr\">title</span>: <span class=\"hljs-string\">\'Output Management\'</span>,\n      }),\n    ],\n</code></div></pre>\n','2020-01-05 12:10:33',0,'webpack','webpack','# 1.自动生成index.html\n安装插件\n```js\nnpm install --save-dev html-webpack-plugin\n```\n\n\n首先引入我们的插件\n\n```js\nlet HtmlWebpackPlugin = require(\'html-webpack-plugin\');\n```\n然后在我们的webpack配置文件中编写以下代码\n\n```js\nplugins: [\n     new HtmlWebpackPlugin(),\n   ],\n```\n同时，HtmlWebpackPlugin方法里可以接受一个对象，\n如指点模板文件\n\n```js\nnew HtmlWebpackPlugin({\n            template: \"./src/index.html\"\n        })\n```\n此时打包生成的网页文件，除了你webpack中绑定的数据，还有你模板中的代码\n\n# 2.生成前先清楚dist文件夹\n\n安装对应插件\n```js\nnpm install --save-dev clean-webpack-plugin\n```\n\n在配置文件中引入插件\n```js\nconst { CleanWebpackPlugin } = require(\'clean-webpack-plugin\');\n```\n\n直接在配置文件中放在最前面即可\n```js\n plugins: [\n     new CleanWebpackPlugin(),\n      new HtmlWebpackPlugin({\n        title: \'Output Management\',\n      }),\n    ],\n```\n','0',0),(11,'webpack入门教程（4）配置文件优化错误信息追踪','<h1><a id=\"1Webpack_0\"></a>1.优化Webpack配置</h1>\n<p>创建build文件夹<br />\n创建三个配置文件，如下</p>\n<blockquote>\n<p>公共配置：把开发和生产环境需要的配置都集中到公共配置文件中，即webpack.common.js<br />\n开发环境配置：把开发环境需要的相关配置放置到webpack.dev.js<br />\n生产环境配置：把生产环境需要的相关配置放置到webpack.prod.js</p>\n</blockquote>\n<p>为了更好的管理和维护这三个文件，需要安装一个webpack-merge插件:<a href=\"https://github.com/survivejs/webpack-merge\" title=\"插件地址\" target=\"_blank\">插件地址</a></p>\n<pre><div class=\"hljs\"><code class=\"lang-js\">npm i webpack-merge -D\n</code></div></pre>\n<p><strong>在公共配置文件webpack.common.js文件中添加相应的配置</strong></p>\n<pre><div class=\"hljs\"><code class=\"lang-js\">\n<span class=\"hljs-keyword\">const</span> webpack = <span class=\"hljs-built_in\">require</span>(<span class=\"hljs-string\">\'webpack\'</span>);\n<span class=\"hljs-keyword\">const</span> path = <span class=\"hljs-built_in\">require</span>(<span class=\"hljs-string\">\'path\'</span>); \n<span class=\"hljs-keyword\">const</span> DIST_PATH = path.resolve(__dirname, <span class=\"hljs-string\">\'../dist/\'</span>); <span class=\"hljs-comment\">// 声明/dist的路径 module.exports = { </span>\n\n<span class=\"hljs-comment\">// 入口JS路径 </span>\n<span class=\"hljs-comment\">// 指示Webpack应该使用哪个模块，来作为构建其内部依赖图的开始 </span>\n\nentry: path.resolve(__dirname,<span class=\"hljs-string\">\'../src/index.js\'</span>), <span class=\"hljs-comment\">// 编译输出的JS入口路径</span>\n\n<span class=\"hljs-comment\">// 告诉Webpack在哪里输出它所创建的bundle，以及如何命名这些文件 </span>\noutput: { \n<span class=\"hljs-attr\">path</span>: DIST_PATH, <span class=\"hljs-comment\">// 创建的bundle生成到哪里 </span>\nfilename: <span class=\"hljs-string\">\'main.js\'</span>, <span class=\"hljs-comment\">// 创建的bundle的名称 </span>\n}, \n<span class=\"hljs-comment\">// 模块解析 </span>\n<span class=\"hljs-built_in\">module</span>: { }, \n<span class=\"hljs-comment\">// 插件</span>\nplugins: [ ] }\n\n</code></div></pre>\n<p><strong>接着给Webpack开发环境配置文件webpack.dev.js添加下面的相关配置：</strong></p>\n<pre><div class=\"hljs\"><code class=\"lang-js\"><span class=\"hljs-keyword\">const</span> webpack = <span class=\"hljs-built_in\">require</span>(<span class=\"hljs-string\">\'webpack\'</span>); \n<span class=\"hljs-keyword\">const</span> path = <span class=\"hljs-built_in\">require</span>(<span class=\"hljs-string\">\'path\'</span>); \n<span class=\"hljs-keyword\">const</span> merge = <span class=\"hljs-built_in\">require</span>(<span class=\"hljs-string\">\'webpack-merge\'</span>); \n<span class=\"hljs-keyword\">const</span> commonConfig = <span class=\"hljs-built_in\">require</span>(<span class=\"hljs-string\">\'./webpack.common.js\'</span>);\n<span class=\"hljs-keyword\">const</span> DIST_PATH = path.resolve(__dirname, <span class=\"hljs-string\">\'../dist/\'</span>); <span class=\"hljs-comment\">// 声明/dist的路径</span>\n <span class=\"hljs-built_in\">module</span>.exports = merge(commonConfig, { \n<span class=\"hljs-attr\">mode</span>: <span class=\"hljs-string\">\'development\'</span>, <span class=\"hljs-comment\">// 设置webpack mode的模式</span>\n<span class=\"hljs-comment\">// 开发环境下需要的相关插件配置</span>\nplugins: [ ],\n<span class=\"hljs-comment\">// 开发服务器</span>\ndevServer: { \n<span class=\"hljs-attr\">hot</span>: <span class=\"hljs-literal\">true</span>, <span class=\"hljs-comment\">// 热更新，无需手动刷新 </span>\ncontentBase: DIST_PATH,\n<span class=\"hljs-comment\">// host: \'0.0.0.0\', // host地址</span>\nport: <span class=\"hljs-number\">8080</span>, <span class=\"hljs-comment\">// 服务器端口 </span>\nhistoryApiFallback: <span class=\"hljs-literal\">true</span>, <span class=\"hljs-comment\">// 该选项的作用所用404都连接到index.html</span>\nproxy: { \n<span class=\"hljs-comment\">// 代理到后端的服务地址，会拦截所有以api开头的请求地址</span>\n<span class=\"hljs-string\">\"/api\"</span>: <span class=\"hljs-string\">\"http://localhost:3000\"</span>\n} }\n})\n</code></div></pre>\n<p><strong>继续给Webpack生产环境配置文件webpack.prod.js添加相关配置：</strong></p>\n<pre><div class=\"hljs\"><code class=\"lang-js\"><span class=\"hljs-keyword\">const</span> webpack = <span class=\"hljs-built_in\">require</span>(<span class=\"hljs-string\">\'webpack\'</span>); \n<span class=\"hljs-keyword\">const</span> path = <span class=\"hljs-built_in\">require</span>(<span class=\"hljs-string\">\'path\'</span>); \n<span class=\"hljs-keyword\">const</span> merge = <span class=\"hljs-built_in\">require</span>(<span class=\"hljs-string\">\'webpack-merge\'</span>); \n<span class=\"hljs-keyword\">const</span> commonConfig = <span class=\"hljs-built_in\">require</span>(<span class=\"hljs-string\">\'./webpack.common.js\'</span>);\n<span class=\"hljs-built_in\">module</span>.exports = merge(commonConfig, {\n		<span class=\"hljs-attr\">mode</span>: <span class=\"hljs-string\">\'production\'</span>, <span class=\"hljs-comment\">// 设置Webpack的mode模式 </span>\n		<span class=\"hljs-comment\">// 生产环境下需要的相关插件配置 </span>\n		plugins: [ ], \n})\n</code></div></pre>\n<p>同时，我们要修改package.json中的scripts中的信息</p>\n<pre><div class=\"hljs\"><code class=\"lang-js\"><span class=\"hljs-string\">\"scripts\"</span>: {\n<span class=\"hljs-string\">\"build\"</span>: <span class=\"hljs-string\">\"webpack --config ./build/webpack.prod.js --mode production\"</span>, \n<span class=\"hljs-string\">\"dev\"</span>: <span class=\"hljs-string\">\"webpack-dev-server --config ./build/webpack.dev.js --mode development --open\"</span>, <span class=\"hljs-string\">\"test\"</span>: <span class=\"hljs-string\">\"echo \\\"Error: no test specified\\\" &amp;&amp; exit 1\"</span> },\n</code></div></pre>\n<p>到这里，配置的基本优化就结束络。</p>\n<h1><a id=\"2source_map__86\"></a>2.使用source map功能, 跟踪源文件错误</h1>\n<p>正常我们编译的js代码报错是直接显示报错信息的，是编译之后的出错位置，不显示源文件中哪里出错，不利于我们调试</p>\n<p>我们可以在配置文件中配置devtool来解决这一问题</p>\n<p>设置devtool</p>\n<p>1、source-map：产生文件，产生行列<br />\n2、eval-source-map：不产生文件，产生行类<br />\n3、cheap-source-map：产生文件，不产生列<br />\n4、cheap-module-eval-source-map：不产生文件，不产生列</p>\n<p>更多选项可查看官网<a href=\"https://webpack.js.org/configuration/devtool/#devtool\" title=\"devtool配置\" target=\"_blank\">devtool配置</a></p>\n<p>在本地调试时，我们可以设置为devtool: ‘inline-source-map’,</p>\n<p>用于说明性目的(但不适合制作)。</p>\n','2020-01-05 12:11:34',0,'webpack','webpack','# 1.优化Webpack配置\n创建build文件夹\n创建三个配置文件，如下\n\n> 公共配置：把开发和生产环境需要的配置都集中到公共配置文件中，即webpack.common.js\n开发环境配置：把开发环境需要的相关配置放置到webpack.dev.js\n生产环境配置：把生产环境需要的相关配置放置到webpack.prod.js\n\n为了更好的管理和维护这三个文件，需要安装一个webpack-merge插件:[插件地址](https://github.com/survivejs/webpack-merge \"插件地址\")\n\n```js\nnpm i webpack-merge -D\n```\n**在公共配置文件webpack.common.js文件中添加相应的配置**\n```js\n\nconst webpack = require(\'webpack\');\nconst path = require(\'path\'); \nconst DIST_PATH = path.resolve(__dirname, \'../dist/\'); // 声明/dist的路径 module.exports = { \n\n// 入口JS路径 \n// 指示Webpack应该使用哪个模块，来作为构建其内部依赖图的开始 \n\nentry: path.resolve(__dirname,\'../src/index.js\'), // 编译输出的JS入口路径\n\n// 告诉Webpack在哪里输出它所创建的bundle，以及如何命名这些文件 \noutput: { \npath: DIST_PATH, // 创建的bundle生成到哪里 \nfilename: \'main.js\', // 创建的bundle的名称 \n}, \n// 模块解析 \nmodule: { }, \n// 插件\nplugins: [ ] }\n\n```\n\n**接着给Webpack开发环境配置文件webpack.dev.js添加下面的相关配置：**\n\n```js\nconst webpack = require(\'webpack\'); \nconst path = require(\'path\'); \nconst merge = require(\'webpack-merge\'); \nconst commonConfig = require(\'./webpack.common.js\');\nconst DIST_PATH = path.resolve(__dirname, \'../dist/\'); // 声明/dist的路径\n module.exports = merge(commonConfig, { \nmode: \'development\', // 设置webpack mode的模式\n// 开发环境下需要的相关插件配置\nplugins: [ ],\n// 开发服务器\ndevServer: { \nhot: true, // 热更新，无需手动刷新 \ncontentBase: DIST_PATH,\n// host: \'0.0.0.0\', // host地址\nport: 8080, // 服务器端口 \nhistoryApiFallback: true, // 该选项的作用所用404都连接到index.html\nproxy: { \n// 代理到后端的服务地址，会拦截所有以api开头的请求地址\n\"/api\": \"http://localhost:3000\"\n} }\n})\n```\n\n**继续给Webpack生产环境配置文件webpack.prod.js添加相关配置：**\n\n```js\nconst webpack = require(\'webpack\'); \nconst path = require(\'path\'); \nconst merge = require(\'webpack-merge\'); \nconst commonConfig = require(\'./webpack.common.js\');\nmodule.exports = merge(commonConfig, {\n		mode: \'production\', // 设置Webpack的mode模式 \n		// 生产环境下需要的相关插件配置 \n		plugins: [ ], \n})\n```\n\n同时，我们要修改package.json中的scripts中的信息\n\n```js\n\"scripts\": {\n\"build\": \"webpack --config ./build/webpack.prod.js --mode production\", \n\"dev\": \"webpack-dev-server --config ./build/webpack.dev.js --mode development --open\", \"test\": \"echo \\\"Error: no test specified\\\" && exit 1\" },\n```\n到这里，配置的基本优化就结束络。\n\n# 2.使用source map功能, 跟踪源文件错误\n\n正常我们编译的js代码报错是直接显示报错信息的，是编译之后的出错位置，不显示源文件中哪里出错，不利于我们调试\n\n我们可以在配置文件中配置devtool来解决这一问题\n\n设置devtool\n\n1、source-map：产生文件，产生行列\n2、eval-source-map：不产生文件，产生行类\n3、cheap-source-map：产生文件，不产生列\n4、cheap-module-eval-source-map：不产生文件，不产生列\n\n更多选项可查看官网[devtool配置](https://webpack.js.org/configuration/devtool/#devtool \"devtool配置\")\n\n\n在本地调试时，我们可以设置为devtool: \'inline-source-map\',\n\n用于说明性目的(但不适合制作)。','0',0),(12,'webpack入门教程（5）简单从js中分离css','<h1><a id=\"1_0\"></a>1.安装插件</h1>\n<pre><div class=\"hljs\"><code class=\"lang-js\">npm install --save-dev mini-css-extract-plugin\n</code></div></pre>\n<h1><a id=\"2_5\"></a>2.修改配置文件</h1>\n<p>修改模块解析</p>\n<pre><div class=\"hljs\"><code class=\"lang-js\">{\n                <span class=\"hljs-attr\">test</span>: <span class=\"hljs-regexp\">/\\.(sa|sc|c)ss$/</span>,  <span class=\"hljs-comment\">// 可以打包后缀为sass/scss/css的文件</span>\n                use: [\n                    {\n                        <span class=\"hljs-attr\">loader</span>: MiniCssExtractPlugin.loader,\n                        },\n                    },\n                    {\n                        <span class=\"hljs-attr\">loader</span>: <span class=\"hljs-string\">\"css-loader\"</span> <span class=\"hljs-comment\">// 将 CSS 转化成 CommonJS 模块</span>\n                    }, {\n                        <span class=\"hljs-attr\">loader</span>: <span class=\"hljs-string\">\"sass-loader\"</span> <span class=\"hljs-comment\">// 将 Sass 编译成 CSS</span>\n                    }\n                ],\n            },\n</code></div></pre>\n<p>使用插件</p>\n<pre><div class=\"hljs\"><code class=\"lang-js\"> <span class=\"hljs-keyword\">new</span> MiniCssExtractPlugin({\n            <span class=\"hljs-comment\">// 这里的配置和webpackOptions.output中的配置相似</span>\n            <span class=\"hljs-comment\">// 即可以通过在名字前加路径，来决定打包后的文件存在的路径</span>\n            filename: devMode ? <span class=\"hljs-string\">\'css/[name].css\'</span> : <span class=\"hljs-string\">\'css/[name].[hash].css\'</span>,\n            <span class=\"hljs-attr\">chunkFilename</span>: devMode ? <span class=\"hljs-string\">\'css/[id].css\'</span> : <span class=\"hljs-string\">\'css/[id].[hash].css\'</span>,\n        }),\n</code></div></pre>\n<p>最基础的配置就完成了</p>\n<p><strong>现在根据运行环境动态配置</strong></p>\n<blockquote>\n<p>获取运行环境</p>\n</blockquote>\n<pre><div class=\"hljs\"><code class=\"lang-js\"><span class=\"hljs-keyword\">const</span> devMode = process.env.NODE_ENV !== <span class=\"hljs-string\">\'production\'</span>\n\n</code></div></pre>\n<p>在MiniCssExtractPlugin.loader模块解析中添加选项</p>\n<p>publicPath公共输出目录</p>\n<p>如下</p>\n<pre><div class=\"hljs\"><code class=\"lang-js\"> publicPath: devMode ? <span class=\"hljs-string\">\'../\'</span> : <span class=\"hljs-string\">\'./\'</span>,   <span class=\"hljs-comment\">// 根据不同环境指定不同的publicPath</span>\n hmr: devMode, <span class=\"hljs-comment\">// 仅dev环境启用HMR功能</span>\n</code></div></pre>\n<p>一般打包后路径出现问题，就与这个路径有关</p>\n<p>同时在我们的插件配置里</p>\n<pre><div class=\"hljs\"><code class=\"lang-js\">filename: devMode ? <span class=\"hljs-string\">\'css/[name].css\'</span> : <span class=\"hljs-string\">\'css/[name].[hash].css\'</span>,\n<span class=\"hljs-attr\">chunkFilename</span>: devMode ? <span class=\"hljs-string\">\'css/[id].css\'</span> : <span class=\"hljs-string\">\'css/[id].[hash].css\'</span>,\n</code></div></pre>\n<p>以上。</p>\n','2020-01-05 12:12:20',0,'webpack','webpack','# 1.安装插件\n```js\nnpm install --save-dev mini-css-extract-plugin\n```\n\n# 2.修改配置文件\n\n修改模块解析\n\n```js\n{\n                test: /\\.(sa|sc|c)ss$/,  // 可以打包后缀为sass/scss/css的文件\n                use: [\n                    {\n                        loader: MiniCssExtractPlugin.loader,\n                        },\n                    },\n                    {\n                        loader: \"css-loader\" // 将 CSS 转化成 CommonJS 模块\n                    }, {\n                        loader: \"sass-loader\" // 将 Sass 编译成 CSS\n                    }\n                ],\n            },\n```\n\n使用插件\n\n```js\n new MiniCssExtractPlugin({\n            // 这里的配置和webpackOptions.output中的配置相似\n            // 即可以通过在名字前加路径，来决定打包后的文件存在的路径\n            filename: devMode ? \'css/[name].css\' : \'css/[name].[hash].css\',\n            chunkFilename: devMode ? \'css/[id].css\' : \'css/[id].[hash].css\',\n        }),\n```\n最基础的配置就完成了\n\n**现在根据运行环境动态配置**\n\n> 获取运行环境\n\n```js\nconst devMode = process.env.NODE_ENV !== \'production\'\n\n```\n\n在MiniCssExtractPlugin.loader模块解析中添加选项\n\npublicPath公共输出目录\n\n如下\n\n```js\n publicPath: devMode ? \'../\' : \'./\',   // 根据不同环境指定不同的publicPath\n hmr: devMode, // 仅dev环境启用HMR功能\n```\n一般打包后路径出现问题，就与这个路径有关\n\n同时在我们的插件配置里\n\n```js\nfilename: devMode ? \'css/[name].css\' : \'css/[name].[hash].css\',\nchunkFilename: devMode ? \'css/[id].css\' : \'css/[id].[hash].css\',\n```\n\n以上。','0',0),(13,'webpack入门教程（6）使用基础多页面开发并分离公共css,js代码','<h1><a id=\"1webpack_0\"></a>1.webpack配置多页面</h1>\n<h2><a id=\"1srcpage1page2_2\"></a>1.在src目录下创建文件夹page1,page2</h2>\n<p>在其目录下创建所需要的文件</p>\n<p><img src=\"https://zhtblog-1300797618.cos.ap-guangzhou.myqcloud.com/2020-1/4/80d0e4e1-8288-4245-9ddc-7f5e779db985.png\" alt=\"\" /></p>\n<h2><a id=\"2_8\"></a>2.修改配置文件入口</h2>\n<pre><div class=\"hljs\"><code class=\"lang-js\"> entry: {\n        <span class=\"hljs-attr\">main1</span>: path.resolve(__dirname, <span class=\"hljs-string\">\"./src/page1/index.js\"</span>),\n        <span class=\"hljs-attr\">main2</span>: path.resolve(__dirname, <span class=\"hljs-string\">\"./src/page2/js/main2.js\"</span>),\n    },\n</code></div></pre>\n<h3><a id=\"3_17\"></a>3.修改出口</h3>\n<pre><div class=\"hljs\"><code class=\"lang-js\"> output: {\n        <span class=\"hljs-comment\">// 编译输出的JS入路径 </span>\n        <span class=\"hljs-comment\">// 告诉Webpack在哪里输出它所创建的bundle，以及如何命名这些文件</span>\n        path: DIST_PATH,   <span class=\"hljs-comment\">// 创建的bundle生成到哪里  </span>\n        filename: <span class=\"hljs-string\">\'js/[name].js\'</span>, <span class=\"hljs-comment\">// 创建的bundle的名称</span>\n        publicPath: <span class=\"hljs-string\">\'../\'</span>,\n    },\n</code></div></pre>\n<p><strong>其中注意</strong>filename不能固定死！</p>\n<p>3.修改HtmlWebpackPlugin插件配置</p>\n<pre><div class=\"hljs\"><code class=\"lang-js\"><span class=\"hljs-keyword\">new</span> HtmlWebpackPlugin({\n            <span class=\"hljs-attr\">filename</span>: __dirname + <span class=\"hljs-string\">\'/dist/page1/index.html\'</span>,\n            <span class=\"hljs-attr\">template</span>: __dirname + <span class=\"hljs-string\">\"/src/page1/index.html\"</span>,\n            <span class=\"hljs-attr\">chunks</span>: [<span class=\"hljs-string\">\'main1\'</span>],\n            <span class=\"hljs-attr\">inlineSource</span>: <span class=\"hljs-string\">\'.(js|css)$\'</span>\n        }),\n<span class=\"hljs-keyword\">new</span> HtmlWebpackPlugin({\n            <span class=\"hljs-attr\">filename</span>: __dirname + <span class=\"hljs-string\">\'/dist/page2/index.html\'</span>,\n            <span class=\"hljs-attr\">template</span>: __dirname + <span class=\"hljs-string\">\"/src/page2/index.html\"</span>,\n            <span class=\"hljs-attr\">chunks</span>: [<span class=\"hljs-string\">\'main2\'</span>],\n            <span class=\"hljs-attr\">inlineSource</span>: <span class=\"hljs-string\">\'.(js|css)$\'</span>\n        }),\n</code></div></pre>\n<p>chunks中写你页面所依赖的输出配置文件</p>\n<p>到这里，一个简单的单页面配置就完成了。</p>\n<h1><a id=\"2cssjs_50\"></a>2.分离公共css,js</h1>\n<p>使用SplitChunksPlugin</p>\n<p>这个webpack 4+ 版本已经内置</p>\n<p>修改配置文件，加入以下代码</p>\n<pre><div class=\"hljs\"><code class=\"lang-js\">optimization: {\n        <span class=\"hljs-attr\">splitChunks</span>: {\n            <span class=\"hljs-attr\">cacheGroups</span>: {\n                <span class=\"hljs-comment\">//打包公共模块</span>\n                commons: {\n                    <span class=\"hljs-attr\">chunks</span>: <span class=\"hljs-string\">\'initial\'</span>, <span class=\"hljs-comment\">//initial表示提取入口文件的公共部分</span>\n                    minChunks: <span class=\"hljs-number\">2</span>, <span class=\"hljs-comment\">//表示提取公共部分最少的文件数</span>\n                    minSize: <span class=\"hljs-number\">0</span>, <span class=\"hljs-comment\">//表示提取公共部分最小的大小</span>\n                    name: <span class=\"hljs-string\">\'commons\'</span> <span class=\"hljs-comment\">//提取出来的文件命名</span>\n                }\n            }\n        }\n    }\n\n</code></div></pre>\n<p>同时，我们要修改HtmlWebpackPlugin 插件，将所提取出来的commons注入到页面中去</p>\n<pre><div class=\"hljs\"><code class=\"lang-js\"> chunks: [<span class=\"hljs-string\">\'main1\'</span>, <span class=\"hljs-string\">\"commons\"</span>],\n</code></div></pre>\n<p>到这里，配置就完成了。</p>\n','2020-01-05 12:26:49',0,'webpack','webpack','# 1.webpack配置多页面\n\n## 1.在src目录下创建文件夹page1,page2\n\n在其目录下创建所需要的文件\n\n![](https://zhtblog-1300797618.cos.ap-guangzhou.myqcloud.com/2020-1/4/80d0e4e1-8288-4245-9ddc-7f5e779db985.png)\n\n## 2.修改配置文件入口\n\n```js\n entry: {\n        main1: path.resolve(__dirname, \"./src/page1/index.js\"),\n        main2: path.resolve(__dirname, \"./src/page2/js/main2.js\"),\n    },\n```\n\n### 3.修改出口\n\n```js\n output: {\n        // 编译输出的JS入路径 \n        // 告诉Webpack在哪里输出它所创建的bundle，以及如何命名这些文件\n        path: DIST_PATH,   // 创建的bundle生成到哪里  \n        filename: \'js/[name].js\', // 创建的bundle的名称\n        publicPath: \'../\',\n    },\n```\n**其中注意**filename不能固定死！\n\n3.修改HtmlWebpackPlugin插件配置\n\n```js\nnew HtmlWebpackPlugin({\n            filename: __dirname + \'/dist/page1/index.html\',\n            template: __dirname + \"/src/page1/index.html\",\n            chunks: [\'main1\'],\n            inlineSource: \'.(js|css)$\'\n        }),\nnew HtmlWebpackPlugin({\n            filename: __dirname + \'/dist/page2/index.html\',\n            template: __dirname + \"/src/page2/index.html\",\n            chunks: [\'main2\'],\n            inlineSource: \'.(js|css)$\'\n        }),\n```\nchunks中写你页面所依赖的输出配置文件\n\n到这里，一个简单的单页面配置就完成了。\n\n# 2.分离公共css,js\n\n使用SplitChunksPlugin\n\n这个webpack 4+ 版本已经内置\n\n修改配置文件，加入以下代码\n\n```js\noptimization: {\n        splitChunks: {\n            cacheGroups: {\n                //打包公共模块\n                commons: {\n                    chunks: \'initial\', //initial表示提取入口文件的公共部分\n                    minChunks: 2, //表示提取公共部分最少的文件数\n                    minSize: 0, //表示提取公共部分最小的大小\n                    name: \'commons\' //提取出来的文件命名\n                }\n            }\n        }\n    }\n\n```\n\n同时，我们要修改HtmlWebpackPlugin 插件，将所提取出来的commons注入到页面中去\n\n```js\n chunks: [\'main1\', \"commons\"],\n```\n到这里，配置就完成了。','1',0),(14,'webpack入门教程（7）使用glob动态配置入口','<h1><a id=\"1glob_0\"></a>1.glob的简单介绍</h1>\n<p>安装</p>\n<pre><div class=\"hljs\"><code class=\"lang-js\">npm install glob -save-dev  \n</code></div></pre>\n<p>glob可以用来匹配路径</p>\n<h2><a id=\"glob_8\"></a>引入glob</h2>\n<pre><div class=\"hljs\"><code class=\"lang-js\"><span class=\"hljs-keyword\">var</span> glob = <span class=\"hljs-built_in\">require</span>(<span class=\"hljs-string\">\"glob\"</span>)\n<span class=\"hljs-comment\">// options is optional</span>\nglob(<span class=\"hljs-string\">\"**/*.js\"</span>, options, <span class=\"hljs-function\"><span class=\"hljs-keyword\">function</span> (<span class=\"hljs-params\">er, files</span>) </span>{\n  <span class=\"hljs-comment\">// 文件是文件名数组。</span>\n  <span class=\"hljs-comment\">// 如果设置了`nonull`选项，则什么也没有</span>\n  <span class=\"hljs-comment\">// 被发现，则文件为[“ ** / *。js”]</span>\n  <span class=\"hljs-comment\">// er是错误对象或null。</span>\n})\n</code></div></pre>\n<p>第一个参数可以用以下方式匹配</p>\n<pre><div class=\"hljs\"><code class=\"lang-js\">在路径部分中使用下列字符具有特殊的神奇含义：\n*匹配单个路径部分中的<span class=\"hljs-number\">0</span>或多个字符。\n?匹配<span class=\"hljs-number\">1</span>字符\n[...]匹配一系列字符，类似于<span class=\"hljs-built_in\">RegExp</span>范围。如果范围的第一个字符是!或^然后它匹配任何不在范围内的字符。\n!(pattern|pattern|pattern)匹配任何不匹配提供的任何模式。\n?(pattern|pattern|pattern)匹配所提供的模式的零或一次。\n+(pattern|pattern|pattern)匹配一个或多个提供的模式。\n*(a|b|c)匹配所提供的模式的零次或更多次。\n@(pattern|pat*|pat?erN)与所提供的模式之一完全匹配。\n**如果“珠星”单独存在于路径部分，则匹配零个或多个目录和搜索匹配的子目录。它不爬行符号链接目录。\n</code></div></pre>\n<h2><a id=\"_36\"></a>*和**的使用方法</h2>\n<pre><div class=\"hljs\"><code class=\"lang-js\">glob(<span class=\"hljs-string\">\"./src/components/**/*.js\"</span>, <span class=\"hljs-function\"><span class=\"hljs-keyword\">function</span> (<span class=\"hljs-params\">er, files</span>) </span>{\n    <span class=\"hljs-built_in\">console</span>.log(files);\n    <span class=\"hljs-keyword\">return</span> files\n});\n<span class=\"hljs-comment\">// [ \'./src/components/index/index.js\',</span>\n<span class=\"hljs-comment\">//    \'./src/components/news/n.js\',</span>\n<span class=\"hljs-comment\">//    \'./src/components/news/news.js\' ]</span>\n</code></div></pre>\n<h2><a id=\"_47\"></a>？的使用方法</h2>\n<pre><div class=\"hljs\"><code class=\"lang-js\">glob(<span class=\"hljs-string\">\"./src/components/**/?.js\"</span>, <span class=\"hljs-function\"><span class=\"hljs-keyword\">function</span> (<span class=\"hljs-params\">er, files</span>) </span>{\n    <span class=\"hljs-built_in\">console</span>.log(files);\n    <span class=\"hljs-keyword\">return</span> files\n});\n<span class=\"hljs-comment\">//[ \'./src/components/news/n.js\' ]</span>\n</code></div></pre>\n<p>有几个“？”就匹配几个字符</p>\n<h2><a id=\"_59\"></a>[…]的使用方法</h2>\n<pre><div class=\"hljs\"><code class=\"lang-js\">glob(<span class=\"hljs-string\">\"./src/components/**/inde[a-z].js\"</span>, <span class=\"hljs-function\"><span class=\"hljs-keyword\">function</span> (<span class=\"hljs-params\">er, files</span>) </span>{\n    <span class=\"hljs-built_in\">console</span>.log(files)\n})\n<span class=\"hljs-comment\">//[ \'./src/components/index/index.js\' ]</span>\n</code></div></pre>\n<p>匹配满足[a-z]条件的路径，相比？方法匹配更为精准一些</p>\n<h2><a id=\"_70\"></a>?（）的使用方法</h2>\n<pre><div class=\"hljs\"><code class=\"lang-js\">glob(<span class=\"hljs-string\">\"./src/components/**/?(news|index|n).js\"</span>, <span class=\"hljs-function\"><span class=\"hljs-keyword\">function</span> (<span class=\"hljs-params\">er, files</span>) </span>{\n    <span class=\"hljs-built_in\">console</span>.log(files)\n});\n<span class=\"hljs-comment\">// [ \'./src/components/index/index.js\',</span>\n<span class=\"hljs-comment\">//     \'./src/components/news/n.js\',</span>\n<span class=\"hljs-comment\">//     \'./src/components/news/news.js\' ]</span>\n</code></div></pre>\n<h2><a id=\"_81\"></a>+（）的使用方法</h2>\n<pre><div class=\"hljs\"><code class=\"lang-js\">glob(<span class=\"hljs-string\">\"./src/components/**/+(in|news|dex).js\"</span>, <span class=\"hljs-function\"><span class=\"hljs-keyword\">function</span> (<span class=\"hljs-params\">er, files</span>) </span>{\n    <span class=\"hljs-built_in\">console</span>.log(files)\n});\n<span class=\"hljs-comment\">// [ \'./src/components/index/index.js\',</span>\n<span class=\"hljs-comment\">//     \'./src/components/news/news.js\' ]</span>\n</code></div></pre>\n<p>本案例中会匹配in.js，news.js，dex.js，innews.js，index.js，newsdex.js 他会先匹配自身是否会匹配上，然后在和其他模式组合在进行匹配。</p>\n<h2><a id=\"_92\"></a>@（）的使用方法</h2>\n<p>他会完整匹配备选模式中的其中一个，只要有一个模式匹配上就会被匹配</p>\n<pre><div class=\"hljs\"><code class=\"lang-js\">glob(<span class=\"hljs-string\">\"./src/components/**/@(index|n|news).js\"</span>, <span class=\"hljs-function\"><span class=\"hljs-keyword\">function</span> (<span class=\"hljs-params\">er, files</span>) </span>{\n    <span class=\"hljs-built_in\">console</span>.log(files)\n});\n<span class=\"hljs-comment\">// [ \'./src/components/index/index.js\',</span>\n<span class=\"hljs-comment\">//     \'./src/components/news/n.js\',</span>\n<span class=\"hljs-comment\">//     \'./src/components/news/news.js\' ]</span>\n</code></div></pre>\n<h2><a id=\"_js_104\"></a>!（）的使用方法，理解为反的意思，其实这个没什么说的， 稍微懂点js的都会。和运算表达式中的！一样。</h2>\n<p>案例中的意思是不要n.js 不要index.js，所以就只剩下new.js了。</p>\n<pre><div class=\"hljs\"><code class=\"lang-js\">glob(<span class=\"hljs-string\">\"./src/components/**/!(n|index).js\"</span>, <span class=\"hljs-function\"><span class=\"hljs-keyword\">function</span> (<span class=\"hljs-params\">er, files</span>) </span>{\n    <span class=\"hljs-built_in\">console</span>.log(files)\n})\n<span class=\"hljs-comment\">// [ \'./src/components/news/news.js\' ]</span>\n</code></div></pre>\n<p>在上述案例中使用的都是异步请求，调用回调得到结果，其实glob也提供了同步返回结果的API ，在这里我只列举一个。</p>\n<pre><div class=\"hljs\"><code class=\"lang-js\"><span class=\"hljs-keyword\">let</span> pattern = <span class=\"hljs-string\">\'./src/components/**/@(index|n|news).js\'</span>;\n<span class=\"hljs-built_in\">console</span>.log(glob.sync(pattern));\n<span class=\"hljs-comment\">// [ \'./src/components/index/index.js\',</span>\n<span class=\"hljs-comment\">//     \'./src/components/news/n.js\',</span>\n<span class=\"hljs-comment\">//     \'./src/components/news/news.js\' ]</span>\n</code></div></pre>\n<h1><a id=\"2_121\"></a>2.动态配置入口</h1>\n<p>引入glob</p>\n<pre><div class=\"hljs\"><code class=\"lang-js\"><span class=\"hljs-keyword\">const</span> glob = <span class=\"hljs-built_in\">require</span>(<span class=\"hljs-string\">\"glob\"</span>)\n</code></div></pre>\n<p>匹配路径</p>\n<pre><div class=\"hljs\"><code class=\"lang-js\"><span class=\"hljs-keyword\">const</span> htmls = glob.sync(<span class=\"hljs-string\">\"src/page?/page?.js\"</span>)\n</code></div></pre>\n<p>我的目录结构为<br />\n<img src=\"https://zhtblog-1300797618.cos.ap-guangzhou.myqcloud.com/2020-1/4/80d0e4e1-8288-4245-9ddc-7f5e779db985.png\" alt=\"\" /></p>\n<p>所以匹配到的是</p>\n<pre><div class=\"hljs\"><code class=\"lang-js\">src/pagea/pagea.js\nsrc/pageb/pageb.js\n</code></div></pre>\n<p>接着定义一个 entrys对象，定义一个 htmlCfg数组，htmlCfg数组添加到插件解析上</p>\n<pre><div class=\"hljs\"><code class=\"lang-js\"><span class=\"hljs-keyword\">const</span> entrys = {}; <span class=\"hljs-comment\">//定义一个 entrys 动态添加入口文件</span>\n<span class=\"hljs-keyword\">const</span> htmlCfgs = []; <span class=\"hljs-comment\">//定义一个 htmlCfg 动态添加入口文件配置</span>\n</code></div></pre>\n<p>遍历返回的目录</p>\n<pre><div class=\"hljs\"><code class=\"lang-js\">htmls.forEach(<span class=\"hljs-function\"><span class=\"hljs-params\">filePath</span> =&gt;</span> {    <span class=\"hljs-comment\">// \"src/page1/page1.js\"</span>\n    <span class=\"hljs-keyword\">let</span> path = filePath.trim().split(<span class=\"hljs-string\">\'/\'</span>); <span class=\"hljs-comment\">//分割路径, [\'src\', \'page1\', \'page1.js\'], 放进 path 数组里</span>\n    <span class=\"hljs-keyword\">let</span> file = path.pop();   <span class=\"hljs-comment\">//\'page1.js\'</span>\n    <span class=\"hljs-keyword\">let</span> name = file.split(<span class=\"hljs-string\">\".\"</span>)[<span class=\"hljs-number\">0</span>];  <span class=\"hljs-comment\">//page1</span>\n    entrys[name] = <span class=\"hljs-string\">\"./\"</span> + filePath\n    htmlCfgs.push(\n        <span class=\"hljs-keyword\">new</span> HtmlWebpackPlugin({\n            <span class=\"hljs-attr\">template</span>: <span class=\"hljs-string\">\"./src/\"</span> + name + <span class=\"hljs-string\">\"/\"</span> + name.trim() + <span class=\"hljs-string\">\".html\"</span>,  <span class=\"hljs-comment\">//  \"./src/page1/page1.html\"</span>\n            chunks: [<span class=\"hljs-string\">\"./dist/\"</span> + name, <span class=\"hljs-string\">\'commons\'</span>],\n            <span class=\"hljs-attr\">filename</span>: name + <span class=\"hljs-string\">\".html\"</span>,\n            <span class=\"hljs-attr\">inlineSource</span>: <span class=\"hljs-string\">\'.(js|css)$\'</span>\n        })\n    )\n});\n</code></div></pre>\n<p>调用js函数获取文件名，以及所需要的路径，如上</p>\n<p>接着修改配置文件</p>\n<p>将entrys和htmlCfg加在配置文件中</p>\n<pre><div class=\"hljs\"><code class=\"lang-js\">entry: entrys,\n   <span class=\"hljs-attr\">plugins</span>: [\n        <span class=\"hljs-keyword\">new</span> CleanWebpackPlugin(),\n        <span class=\"hljs-keyword\">new</span> MiniCssExtractPlugin({\n            <span class=\"hljs-comment\">// 这里的配置和webpackOptions.output中的配置相似</span>\n            <span class=\"hljs-comment\">// 即可以通过在名字前加路径，来决定打包后的文件存在的路径</span>\n            filename: devMode ? <span class=\"hljs-string\">\'css/[name].css\'</span> : <span class=\"hljs-string\">\'css/[name].[hash].css\'</span>,\n            <span class=\"hljs-attr\">chunkFilename</span>: devMode ? <span class=\"hljs-string\">\'css/[id].css\'</span> : <span class=\"hljs-string\">\'css/[id].[hash].css\'</span>,\n        }),\n    ].concat(htmlCfgs),\n</code></div></pre>\n<p>以上动态配置路口就完成了。</p>\n','2020-01-05 12:16:59',0,'webpack','webpack','# 1.glob的简单介绍\n安装\n```js\nnpm install glob -save-dev  \n```\n\nglob可以用来匹配路径\n\n## 引入glob\n\n```js\nvar glob = require(\"glob\")\n// options is optional\nglob(\"**/*.js\", options, function (er, files) {\n  // 文件是文件名数组。\n  // 如果设置了`nonull`选项，则什么也没有\n  // 被发现，则文件为[“ ** / *。js”]\n  // er是错误对象或null。\n})\n```\n\n第一个参数可以用以下方式匹配\n\n```js\n在路径部分中使用下列字符具有特殊的神奇含义：\n*匹配单个路径部分中的0或多个字符。\n?匹配1字符\n[...]匹配一系列字符，类似于RegExp范围。如果范围的第一个字符是!或^然后它匹配任何不在范围内的字符。\n!(pattern|pattern|pattern)匹配任何不匹配提供的任何模式。\n?(pattern|pattern|pattern)匹配所提供的模式的零或一次。\n+(pattern|pattern|pattern)匹配一个或多个提供的模式。\n*(a|b|c)匹配所提供的模式的零次或更多次。\n@(pattern|pat*|pat?erN)与所提供的模式之一完全匹配。\n**如果“珠星”单独存在于路径部分，则匹配零个或多个目录和搜索匹配的子目录。它不爬行符号链接目录。\n```\n\n## \\*和\\**的使用方法\n\n```js\nglob(\"./src/components/**/*.js\", function (er, files) {\n    console.log(files);\n    return files\n});\n// [ \'./src/components/index/index.js\',\n//    \'./src/components/news/n.js\',\n//    \'./src/components/news/news.js\' ]\n```\n## ？的使用方法\n\n```js\nglob(\"./src/components/**/?.js\", function (er, files) {\n    console.log(files);\n    return files\n});\n//[ \'./src/components/news/n.js\' ]\n```\n\n有几个“？”就匹配几个字符\n\n## [...]的使用方法\n\n```js\nglob(\"./src/components/**/inde[a-z].js\", function (er, files) {\n    console.log(files)\n})\n//[ \'./src/components/index/index.js\' ]\n```\n\n匹配满足[a-z]条件的路径，相比？方法匹配更为精准一些\n\n## ?（）的使用方法\n\n```js\nglob(\"./src/components/**/?(news|index|n).js\", function (er, files) {\n    console.log(files)\n});\n// [ \'./src/components/index/index.js\',\n//     \'./src/components/news/n.js\',\n//     \'./src/components/news/news.js\' ]\n```\n\n## +（）的使用方法\n\n```js\nglob(\"./src/components/**/+(in|news|dex).js\", function (er, files) {\n    console.log(files)\n});\n// [ \'./src/components/index/index.js\',\n//     \'./src/components/news/news.js\' ]\n```\n本案例中会匹配in.js，news.js，dex.js，innews.js，index.js，newsdex.js 他会先匹配自身是否会匹配上，然后在和其他模式组合在进行匹配。\n\n## @（）的使用方法\n他会完整匹配备选模式中的其中一个，只要有一个模式匹配上就会被匹配\n\n```js\nglob(\"./src/components/**/@(index|n|news).js\", function (er, files) {\n    console.log(files)\n});\n// [ \'./src/components/index/index.js\',\n//     \'./src/components/news/n.js\',\n//     \'./src/components/news/news.js\' ]\n```\n\n## !（）的使用方法，理解为反的意思，其实这个没什么说的， 稍微懂点js的都会。和运算表达式中的！一样。\n　　案例中的意思是不要n.js 不要index.js，所以就只剩下new.js了。\n```js\nglob(\"./src/components/**/!(n|index).js\", function (er, files) {\n    console.log(files)\n})\n// [ \'./src/components/news/news.js\' ]\n```\n在上述案例中使用的都是异步请求，调用回调得到结果，其实glob也提供了同步返回结果的API ，在这里我只列举一个。\n\n```js\nlet pattern = \'./src/components/**/@(index|n|news).js\';\nconsole.log(glob.sync(pattern));\n// [ \'./src/components/index/index.js\',\n//     \'./src/components/news/n.js\',\n//     \'./src/components/news/news.js\' ]\n```\n# 2.动态配置入口\n\n引入glob\n```js\nconst glob = require(\"glob\")\n```\n\n匹配路径\n```js\nconst htmls = glob.sync(\"src/page?/page?.js\")\n```\n\n我的目录结构为\n![](https://zhtblog-1300797618.cos.ap-guangzhou.myqcloud.com/2020-1/4/80d0e4e1-8288-4245-9ddc-7f5e779db985.png)\n\n所以匹配到的是\n```js\nsrc/pagea/pagea.js\nsrc/pageb/pageb.js\n```\n\n接着定义一个 entrys对象，定义一个 htmlCfg数组，htmlCfg数组添加到插件解析上\n\n```js\nconst entrys = {}; //定义一个 entrys 动态添加入口文件\nconst htmlCfgs = []; //定义一个 htmlCfg 动态添加入口文件配置\n```\n\n遍历返回的目录\n\n```js\nhtmls.forEach(filePath => {    // \"src/page1/page1.js\"\n    let path = filePath.trim().split(\'/\'); //分割路径, [\'src\', \'page1\', \'page1.js\'], 放进 path 数组里\n    let file = path.pop();   //\'page1.js\'\n    let name = file.split(\".\")[0];  //page1\n    entrys[name] = \"./\" + filePath\n    htmlCfgs.push(\n        new HtmlWebpackPlugin({\n            template: \"./src/\" + name + \"/\" + name.trim() + \".html\",  //  \"./src/page1/page1.html\"\n            chunks: [\"./dist/\" + name, \'commons\'],\n            filename: name + \".html\",\n            inlineSource: \'.(js|css)$\'\n        })\n    )\n});\n```\n调用js函数获取文件名，以及所需要的路径，如上\n\n接着修改配置文件\n\n将entrys和htmlCfg加在配置文件中\n```js\nentry: entrys,\n   plugins: [\n        new CleanWebpackPlugin(),\n        new MiniCssExtractPlugin({\n            // 这里的配置和webpackOptions.output中的配置相似\n            // 即可以通过在名字前加路径，来决定打包后的文件存在的路径\n            filename: devMode ? \'css/[name].css\' : \'css/[name].[hash].css\',\n            chunkFilename: devMode ? \'css/[id].css\' : \'css/[id].[hash].css\',\n        }),\n    ].concat(htmlCfgs),\n```\n以上动态配置路口就完成了。','0',0),(15,'webpack入门教程（8）使用babel解析es6语法','<h1><a id=\"1bael_0\"></a>1.bael是什么</h1>\n<blockquote>\n<p>Babel 是一个让我们能够使用 ES 新特性的 JS 编译工具，我们可以在 webpack 中配置 Babel，以便使用 ES6、ES7 标准来编写 JS 代码。<br />\nBabel是JavaScript编译器<br />\nBabel是一个工具链，主要用于在当前和较旧的浏览器或环境中将ECMAScript 2015+代码转换为JavaScript的向后兼容版本。以下是Babel可以为您做的主要事情：</p>\n</blockquote>\n<pre><div class=\"hljs\"><code class=\"lang-javascript\"><span class=\"hljs-comment\">// Babel Input: ES2015 arrow function</span>\n[<span class=\"hljs-number\">1</span>, <span class=\"hljs-number\">2</span>, <span class=\"hljs-number\">3</span>].map(<span class=\"hljs-function\">(<span class=\"hljs-params\">n</span>) =&gt;</span> n + <span class=\"hljs-number\">1</span>);\n\n<span class=\"hljs-comment\">// Babel Output: ES5 equivalent</span>\n[<span class=\"hljs-number\">1</span>, <span class=\"hljs-number\">2</span>, <span class=\"hljs-number\">3</span>].map(<span class=\"hljs-function\"><span class=\"hljs-keyword\">function</span>(<span class=\"hljs-params\">n</span>) </span>{\n  <span class=\"hljs-keyword\">return</span> n + <span class=\"hljs-number\">1</span>;\n});\n</code></div></pre>\n<h1><a id=\"2babelloader__babelcore_14\"></a>2.安装babel-loader 和 @babel/core</h1>\n<pre><code class=\"lang-\">npm i -D  babel-loader\nnpm i -D  @babel/core\n</code></pre>\n<h1><a id=\"3babelloader_20\"></a>3.配置babel-loader模块解析</h1>\n<pre><div class=\"hljs\"><code class=\"lang-javascript\"> {\n        <span class=\"hljs-attr\">test</span>: <span class=\"hljs-regexp\">/\\.m?js$/</span>,\n        <span class=\"hljs-attr\">exclude</span>: <span class=\"hljs-regexp\">/(node_modules|bower_components)/</span>,\n        <span class=\"hljs-attr\">use</span>: { <span class=\"hljs-attr\">loader</span>: <span class=\"hljs-string\">\'babel-loader\'</span> } <span class=\"hljs-comment\">// options 在 .babelrc 定义</span>\n      }\n</code></div></pre>\n<p>打开我们的js入口文件，编写es6代码</p>\n<pre><div class=\"hljs\"><code class=\"lang-javascript\"><span class=\"hljs-keyword\">const</span> func = <span class=\"hljs-function\"><span class=\"hljs-params\">()</span> =&gt;</span> {\n    <span class=\"hljs-built_in\">console</span>.log(<span class=\"hljs-string\">\'hello webpack\'</span>)\n}\nfunc()\n\n<span class=\"hljs-class\"><span class=\"hljs-keyword\">class</span> <span class=\"hljs-title\">User</span> </span>{\n    <span class=\"hljs-keyword\">constructor</span>() {\n        <span class=\"hljs-built_in\">console</span>.log(<span class=\"hljs-string\">\'new User\'</span>)\n    }\n}\n\n<span class=\"hljs-keyword\">const</span> user = <span class=\"hljs-keyword\">new</span> User()\n</code></div></pre>\n<p>在配置文件中添加</p>\n<pre><div class=\"hljs\"><code class=\"lang-javascript\">mode: <span class=\"hljs-string\">\"development\"</span>,\n</code></div></pre>\n<p>因为webpack4已经为我们配置了css,js代码压缩，默认生产环境开启</p>\n<p>此时打包项目</p>\n<p>发现es6语法，并没有转换</p>\n<h1><a id=\"4babelpresetenv_54\"></a>4.安装@babel/preset-env</h1>\n<p>这个包包含了 es6+ 的语法转换规则，如箭头函数、const 等</p>\n<h1><a id=\"5babelpolyfill_58\"></a>5.同时我们安装@babel/polyfill</h1>\n<p>这个包可以让我们使用es6 内置对象和函数的垫片，如 Promise、Array.from 等</p>\n<p>安装完之后，在根目录下创建 .babelrc 文件，进行一些简单配置:</p>\n<pre><div class=\"hljs\"><code class=\"lang-javascript\">{\n  <span class=\"hljs-string\">\"presets\"</span>: [\n    [\n      <span class=\"hljs-string\">\"@babel/preset-env\"</span>,\n      {\n        <span class=\"hljs-string\">\"useBuiltIns\"</span>: <span class=\"hljs-string\">\"entry\"</span>\n      }\n    ]\n  ]\n}\n</code></div></pre>\n<p>在babel7的版本我们可以采用babel.config.js进行配置</p>\n<pre><div class=\"hljs\"><code class=\"lang-javascript\"><span class=\"hljs-comment\">// babel.config.js</span>\n\n<span class=\"hljs-built_in\">module</span>.exports = <span class=\"hljs-function\"><span class=\"hljs-keyword\">function</span> (<span class=\"hljs-params\">api</span>) </span>{\n    api.cache(<span class=\"hljs-literal\">true</span>)\n\n    <span class=\"hljs-keyword\">const</span> presets = [\n        [\n            <span class=\"hljs-string\">\"@babel/preset-env\"</span>,\n            {\n                <span class=\"hljs-string\">\"useBuiltIns\"</span>: <span class=\"hljs-string\">\"usage\"</span>\n            }\n        ]\n    ]\n    <span class=\"hljs-keyword\">const</span> plugins = [\n        [\n            <span class=\"hljs-string\">\"@babel/plugin-transform-runtime\"</span>,\n            {\n                <span class=\"hljs-string\">\"corejs\"</span>: <span class=\"hljs-number\">2</span>\n            }\n        ]\n    ]\n\n    <span class=\"hljs-keyword\">return</span> {\n        presets,\n        plugins\n    }\n}\n</code></div></pre>\n<p>看网上说要在入口js文件中加上import ‘@babel/polyfill’</p>\n<p>我试了一下  不加可以正常解析</p>\n<p>大概是版本的问题吧。</p>\n<p>打包后发现，Js文件过大，把一些不需要的语法也打包进来了</p>\n<p>此时我们修改.babelrc文件</p>\n<p>useBuiltIns: “usage”, “entry”, “false”。默认为 false。</p>\n<blockquote>\n<p>usage: 在每个文件中使用 polyfill 时，为 polyfill 添加特定导入，babel 利用捆绑器只加载一次相同的polyfill。</p>\n</blockquote>\n<blockquote>\n<p>entry: 使用 entry 属性，必须在项目入口处引入一次 @babel/polyfill。然后 babel 在做代码转换的时候，会把</p>\n</blockquote>\n<p>将 .babelrc 下的useBuiltIns改为usage，再执行转换命令，就会发现 polyfill 变成了按需导入。</p>\n<p>**<br />\nbabel 7 还提供了targets，这个配置主要用于指定需要支持的环境，一般是指浏览器版本。（ targets 还可以指定 node、android、ios、electron 等其他环境）**</p>\n<p>设置了 targets，babel 在转换前，会先检查 targets 指定的环境已经支持了哪些新语法和 API，然后就不再转换或者不引入已经支持的内容。</p>\n<h1><a id=\"6babelplugintransformruntimebabelruntime_132\"></a>6.@babel/plugin-transform-runtime、@babel/runtime</h1>\n<p>使用 @babel/polyfill 会对全局对象进行污染，所以可以使用 @babel/plugin-transform-runtime 和@babel/runtime 防止这种现象。</p>\n<p>@babel/plugin-transform-runtime 会在你需要的地方自动引入你使用到的新方法。</p>\n<p>修改 .babelrc 文件：</p>\n<pre><div class=\"hljs\"><code class=\"lang-javascript\">{\n    <span class=\"hljs-string\">\"presets\"</span>: [\n        [\n            <span class=\"hljs-string\">\"@babel/preset-env\"</span>,\n            {\n                <span class=\"hljs-string\">\"useBuiltIns\"</span>: <span class=\"hljs-string\">\"usage\"</span>\n            }\n        ]\n    ],\n    <span class=\"hljs-string\">\"plugins\"</span>: [\n        [\n            <span class=\"hljs-string\">\"@babel/plugin-transform-runtime\"</span>,\n            {\n                <span class=\"hljs-string\">\"corejs\"</span>: <span class=\"hljs-number\">2</span>\n            }\n        ]\n    ]\n}\n</code></div></pre>\n<p>看了上面的做法，你可能会觉得困惑，为什么要一起使用 @babel/plugin-transform-runtime、@babel/runtime 呢，为什么不能单独使用一个？</p>\n<p>其实是因为 babel 转换时，@babel/plugin-transform-runtime 这个插件会自动引入使用到的新方法，而引入的这些 polyfill 包是在 @babel/runtime 里面的，所以 @babel/runtime 需要安装在 dependency（生产环境）下，@babel/plugin-transform-runtime 则安装在 devDependency（开发环境）下。</p>\n<p>同时，博主运行的时候报错，找不到&quot;@babel/runtime-corejs2&quot;: &quot;^7.7.5&quot;模块</p>\n<p>最后安装**@babel/runtime-corejs2&quot;: &quot;^7.7.5**，配置到这里就结束了。</p>\n','2020-01-05 12:26:44',0,'webpack','webpack','# 1.bael是什么\n> Babel 是一个让我们能够使用 ES 新特性的 JS 编译工具，我们可以在 webpack 中配置 Babel，以便使用 ES6、ES7 标准来编写 JS 代码。\nBabel是JavaScript编译器\nBabel是一个工具链，主要用于在当前和较旧的浏览器或环境中将ECMAScript 2015+代码转换为JavaScript的向后兼容版本。以下是Babel可以为您做的主要事情：\n\n```javascript\n// Babel Input: ES2015 arrow function\n[1, 2, 3].map((n) => n + 1);\n\n// Babel Output: ES5 equivalent\n[1, 2, 3].map(function(n) {\n  return n + 1;\n});\n```\n# 2.安装babel-loader 和 @babel/core\n\n```\nnpm i -D  babel-loader\nnpm i -D  @babel/core\n```\n# 3.配置babel-loader模块解析\n```javascript\n {\n        test: /\\.m?js$/,\n        exclude: /(node_modules|bower_components)/,\n        use: { loader: \'babel-loader\' } // options 在 .babelrc 定义\n      }\n```\n\n打开我们的js入口文件，编写es6代码\n```javascript\nconst func = () => {\n    console.log(\'hello webpack\')\n}\nfunc()\n\nclass User {\n    constructor() {\n        console.log(\'new User\')\n    }\n}\n\nconst user = new User()\n```\n在配置文件中添加\n```javascript\nmode: \"development\",\n```\n因为webpack4已经为我们配置了css,js代码压缩，默认生产环境开启\n\n此时打包项目\n\n发现es6语法，并没有转换\n\n# 4.安装@babel/preset-env\n\n这个包包含了 es6+ 的语法转换规则，如箭头函数、const 等\n\n# 5.同时我们安装@babel/polyfill\n\n这个包可以让我们使用es6 内置对象和函数的垫片，如 Promise、Array.from 等\n\n安装完之后，在根目录下创建 .babelrc 文件，进行一些简单配置:\n\n```javascript\n{\n  \"presets\": [\n    [\n      \"@babel/preset-env\",\n      {\n        \"useBuiltIns\": \"entry\"\n      }\n    ]\n  ]\n}\n```\n\n在babel7的版本我们可以采用babel.config.js进行配置\n```javascript\n// babel.config.js\n\nmodule.exports = function (api) {\n    api.cache(true)\n\n    const presets = [\n        [\n            \"@babel/preset-env\",\n            {\n                \"useBuiltIns\": \"usage\"\n            }\n        ]\n    ]\n    const plugins = [\n        [\n            \"@babel/plugin-transform-runtime\",\n            {\n                \"corejs\": 2\n            }\n        ]\n    ]\n\n    return {\n        presets,\n        plugins\n    }\n}\n```\n\n看网上说要在入口js文件中加上import \'@babel/polyfill\'\n\n我试了一下  不加可以正常解析\n\n大概是版本的问题吧。\n\n打包后发现，Js文件过大，把一些不需要的语法也打包进来了\n\n此时我们修改.babelrc文件\n\nuseBuiltIns: \"usage\", \"entry\", \"false\"。默认为 false。\n\n> usage: 在每个文件中使用 polyfill 时，为 polyfill 添加特定导入，babel 利用捆绑器只加载一次相同的polyfill。\n\n> entry: 使用 entry 属性，必须在项目入口处引入一次 @babel/polyfill。然后 babel 在做代码转换的时候，会把\n\n\n将 .babelrc 下的useBuiltIns改为usage，再执行转换命令，就会发现 polyfill 变成了按需导入。\n\n**\nbabel 7 还提供了targets，这个配置主要用于指定需要支持的环境，一般是指浏览器版本。（ targets 还可以指定 node、android、ios、electron 等其他环境）**\n\n设置了 targets，babel 在转换前，会先检查 targets 指定的环境已经支持了哪些新语法和 API，然后就不再转换或者不引入已经支持的内容。\n\n# 6.@babel/plugin-transform-runtime、@babel/runtime\n\n使用 @babel/polyfill 会对全局对象进行污染，所以可以使用 @babel/plugin-transform-runtime 和@babel/runtime 防止这种现象。\n\n@babel/plugin-transform-runtime 会在你需要的地方自动引入你使用到的新方法。\n\n\n修改 .babelrc 文件：\n```javascript\n{\n    \"presets\": [\n        [\n            \"@babel/preset-env\",\n            {\n                \"useBuiltIns\": \"usage\"\n            }\n        ]\n    ],\n    \"plugins\": [\n        [\n            \"@babel/plugin-transform-runtime\",\n            {\n                \"corejs\": 2\n            }\n        ]\n    ]\n}\n```\n\n看了上面的做法，你可能会觉得困惑，为什么要一起使用 @babel/plugin-transform-runtime、@babel/runtime 呢，为什么不能单独使用一个？\n\n其实是因为 babel 转换时，@babel/plugin-transform-runtime 这个插件会自动引入使用到的新方法，而引入的这些 polyfill 包是在 @babel/runtime 里面的，所以 @babel/runtime 需要安装在 dependency（生产环境）下，@babel/plugin-transform-runtime 则安装在 devDependency（开发环境）下。\n\n\n同时，博主运行的时候报错，找不到\"@babel/runtime-corejs2\": \"^7.7.5\"模块\n\n最后安装**@babel/runtime-corejs2\": \"^7.7.5**，配置到这里就结束了。','1',0),(16,'webpack入门教程（9）最新引入第三方库的三种方法','<h1><a id=\"1htmlscript_0\"></a>1.通过html页面script标签引入</h1>\n<p>通常是采用CDN</p>\n<pre><div class=\"hljs\"><code class=\"lang-javascript\">&lt;script src=<span class=\"hljs-string\">\"http://code.jquery.com/jquery-migrate-1.2.1.min.js\"</span>&gt;<span class=\"xml\"><span class=\"hljs-tag\">&lt;/<span class=\"hljs-name\">script</span>&gt;</span></span>.js\n</code></div></pre>\n<pre><div class=\"hljs\"><code class=\"lang-javascript\"><span class=\"hljs-comment\">//网上说要配置这么一段，我试过了好像不用，先贴上来，你们可以尝试一下</span>\n<span class=\"hljs-comment\">// 入口文件</span>\n<span class=\"hljs-keyword\">import</span> $ <span class=\"hljs-keyword\">from</span> <span class=\"hljs-string\">\'jquery\'</span>\n<span class=\"hljs-built_in\">console</span>.log($)\n\n<span class=\"hljs-comment\">//webpack配置</span>\n<span class=\"hljs-built_in\">module</span>.exports = {\n    <span class=\"hljs-attr\">externals</span>: {\n        <span class=\"hljs-attr\">jquery</span>: <span class=\"hljs-string\">\'jQuery\'</span>\n    }\n}\n</code></div></pre>\n<p>在html文件中引入了之后，就可以在入口文件（app.js）中，使用 $(function(){})  了</p>\n<h1><a id=\"2NPM_22\"></a>2.通过NPM包引入</h1>\n<p>以jq为例子</p>\n<pre><div class=\"hljs\"><code class=\"lang-javascript\"> npm install jquery --save;\n</code></div></pre>\n<p>然后我们在配置文件中配置</p>\n<pre><div class=\"hljs\"><code class=\"lang-javascript\">plugins:[\n        <span class=\"hljs-keyword\">new</span> webpack.ProvidePlugin({\n            <span class=\"hljs-attr\">$</span>:<span class=\"hljs-string\">\"jquery\"</span>,    <span class=\"hljs-comment\">//这里的意思是就把 $ 注入模块中 ， 而后面的jquery 就是node_modules目录下的jquery</span>\n        })\n    ]\n</code></div></pre>\n<p>同时我们可以将第三方库分离出来</p>\n<pre><div class=\"hljs\"><code class=\"lang-javascript\">optimization: {\n        <span class=\"hljs-attr\">splitChunks</span>: {\n            <span class=\"hljs-attr\">chunks</span>: <span class=\"hljs-string\">\"all\"</span>, <span class=\"hljs-comment\">// async表示抽取异步模块，all表示对所有模块生效，initial表示对同步模块生效</span>\n            cacheGroups: {\n                <span class=\"hljs-comment\">//打包公共模块</span>\n                <span class=\"hljs-comment\">// vendors: { // 键值可以自定义</span>\n                <span class=\"hljs-comment\">//     //chunks: \'initial\',  //initial表示提取入口文件的公共部分</span>\n                <span class=\"hljs-comment\">//     minChunks: 1, // 代码块至少被引用的次数</span>\n                <span class=\"hljs-comment\">//     test: /[\\\\/]node_modules[\\\\/]/,</span>\n                <span class=\"hljs-comment\">//     name: \"vendors\", // 入口的entry的key</span>\n                <span class=\"hljs-comment\">//     // enforce: true   // 强制 </span>\n                <span class=\"hljs-comment\">//     // priority: -10   //抽取优先级</span>\n                <span class=\"hljs-comment\">// }</span>\n            }\n        }\n    },\n</code></div></pre>\n<p>配置完成后所有通过npm引入的第三方库将被打包成vendors.js,没有使用过的第三库不会被打包</p>\n<h1><a id=\"3_62\"></a>3.引入本地第三方库</h1>\n<p>这种也是网上最少的一种，博客花了三个小时左右才真正解决问题，网上大多都是讲npm引入，或者就是本地引入方法出问题</p>\n<p>简单说一下</p>\n<h2><a id=\"_68\"></a>第一种。</h2>\n<p>通入入口文件引入</p>\n<pre><div class=\"hljs\"><code class=\"lang-javascript\">entrys[<span class=\"hljs-string\">\"vendors\"</span>] = [<span class=\"hljs-string\">\"./src/lib/jquery-3.2.1.js\"</span>]\n</code></div></pre>\n<p>一定要把使用的库放在前面</p>\n<p>然后在HtmlWebpackPlugin插件中配置</p>\n<pre><div class=\"hljs\"><code class=\"lang-javascript\"> chunks: [<span class=\"hljs-string\">\"vendors\"</span>, name, <span class=\"hljs-string\">\'commons\'</span>,],\n</code></div></pre>\n<p>缺点：不管有没有使用，都会被打包进js文件</p>\n<h1><a id=\"_83\"></a>第二种</h1>\n<p>直接在入口js通过路径引入</p>\n<pre><div class=\"hljs\"><code class=\"lang-javascript\"><span class=\"hljs-keyword\">import</span> <span class=\"hljs-string\">\"./../lib/jquery-3.2.1.js\"</span>\n</code></div></pre>\n<p>然后就可以使用了</p>\n<p>看到这里，小伙伴们可能会疑问</p>\n<p>这样的话为什么不直接定义个webpack.ProvidePlugin和<strong>通过NPM包引入</strong>引入一样了</p>\n<p>试过</p>\n<p>我先配置了模块别名</p>\n<pre><div class=\"hljs\"><code class=\"lang-javascript\"> resolve: {\n        <span class=\"hljs-attr\">alias</span>: {\n            <span class=\"hljs-comment\">// vue$: path.resolve(__dirname, \"./src/lib/vue.js\"),</span>\n            <span class=\"hljs-comment\">// vue: path.resolve(__dirname, \"./src/lib/qqq.js\"),</span>\n            <span class=\"hljs-comment\">// jquery: path.resolve(__dirname, \"./src/lib/jquery-3.2.1.js\"),</span>\n        }\n    },\n</code></div></pre>\n<p>然后和npm包引入一样的方法</p>\n<pre><div class=\"hljs\"><code class=\"lang-javascript\"> <span class=\"hljs-keyword\">new</span> webpack.ProvidePlugin({\n            <span class=\"hljs-comment\">// $: \'jquery\',</span>\n            <span class=\"hljs-comment\">// jQuery: \'jquery\',</span>\n            <span class=\"hljs-comment\">// \"window.$\": \'jquery\',</span>\n            <span class=\"hljs-comment\">// \"window.jQuery\": \'jquery\',</span>\n})\n</code></div></pre>\n<p>结果控制台报错，$没有定义，然后我又安装了expose-loader，试图把JQ抛出到全局变量</p>\n<p>配置如下</p>\n<pre><div class=\"hljs\"><code class=\"lang-javascript\"><span class=\"hljs-comment\">//     test: require.resolve(path.resolve(__dirname, \"./src/lib/jquery-3.2.1.js\")),</span>\n            <span class=\"hljs-comment\">//     use: [{</span>\n            <span class=\"hljs-comment\">//         loader: \'expose-loader\',</span>\n            <span class=\"hljs-comment\">//         options: \'jQuery\'</span>\n            <span class=\"hljs-comment\">//     }, {</span>\n            <span class=\"hljs-comment\">//         loader: \'expose-loader\',</span>\n            <span class=\"hljs-comment\">//         options: \'$\'</span>\n            <span class=\"hljs-comment\">//     }]</span>\n            <span class=\"hljs-comment\">// },</span>\n</code></div></pre>\n<p>结果依然显示没有定义</p>\n<p>再后来博主通过imports-loader将模块直接导入入口js文件</p>\n<pre><div class=\"hljs\"><code class=\"lang-javascript\"> <span class=\"hljs-comment\">// {</span>\n            <span class=\"hljs-comment\">//     test: path.resolve(__dirname, \"./src/pagea/pagea.js\"),</span>\n            <span class=\"hljs-comment\">//     exclude: /node_module/,</span>\n            <span class=\"hljs-comment\">//     use: [{</span>\n            <span class=\"hljs-comment\">//         loader: \"imports-loader\",</span>\n            <span class=\"hljs-comment\">//         options: {</span>\n            <span class=\"hljs-comment\">//             $: \'jquery\',</span>\n            <span class=\"hljs-comment\">//             jquery: \'jquery\'</span>\n            <span class=\"hljs-comment\">//         }</span>\n            <span class=\"hljs-comment\">//     }</span>\n            <span class=\"hljs-comment\">//     ]</span>\n            <span class=\"hljs-comment\">// },</span>\n</code></div></pre>\n<p>依然是提示，$没有定义，以上情况，JQ均打包进了js文件中，切在文件顶部</p>\n<p>博主在引入本地第三方库上花了大量时间，</p>\n<h3><a id=\"npmnpmnpm_157\"></a>总结，能用npm引入就用npm引入，不能使用npm引入的第三方库，可以采用上面两种方法引入</h3>\n<h3><a id=\"_158\"></a>能用谷歌就用谷歌，百度了一大堆，能看的，能用的就那么两三个。</h3>\n<p>以上。如果小伙伴们有什么更好的方法，可以在下面留言，同时博主有什么更好的方法也会进行同步更新。</p>\n','2020-01-05 12:19:08',0,'webpack','webpack','# 1.通过html页面script标签引入\n\n通常是采用CDN\n\n```javascript\n<script src=\"http://code.jquery.com/jquery-migrate-1.2.1.min.js\"></script>.js\n```\n```javascript\n//网上说要配置这么一段，我试过了好像不用，先贴上来，你们可以尝试一下\n// 入口文件\nimport $ from \'jquery\'\nconsole.log($)\n\n//webpack配置\nmodule.exports = {\n    externals: {\n        jquery: \'jQuery\'\n    }\n}\n```\n在html文件中引入了之后，就可以在入口文件（app.js）中，使用 $(function(){})  了\n\n# 2.通过NPM包引入\n\n以jq为例子\n\n```javascript\n npm install jquery --save;\n```\n\n然后我们在配置文件中配置\n\n```javascript\nplugins:[\n        new webpack.ProvidePlugin({\n            $:\"jquery\",    //这里的意思是就把 $ 注入模块中 ， 而后面的jquery 就是node_modules目录下的jquery\n        })\n    ]\n```\n同时我们可以将第三方库分离出来\n\n```javascript\noptimization: {\n        splitChunks: {\n            chunks: \"all\", // async表示抽取异步模块，all表示对所有模块生效，initial表示对同步模块生效\n            cacheGroups: {\n                //打包公共模块\n                // vendors: { // 键值可以自定义\n                //     //chunks: \'initial\',  //initial表示提取入口文件的公共部分\n                //     minChunks: 1, // 代码块至少被引用的次数\n                //     test: /[\\\\/]node_modules[\\\\/]/,\n                //     name: \"vendors\", // 入口的entry的key\n                //     // enforce: true   // 强制 \n                //     // priority: -10   //抽取优先级\n                // }\n            }\n        }\n    },\n```\n\n配置完成后所有通过npm引入的第三方库将被打包成vendors.js,没有使用过的第三库不会被打包\n\n# 3.引入本地第三方库\n\n这种也是网上最少的一种，博客花了三个小时左右才真正解决问题，网上大多都是讲npm引入，或者就是本地引入方法出问题\n\n简单说一下\n\n## 第一种。\n通入入口文件引入\n\n```javascript\nentrys[\"vendors\"] = [\"./src/lib/jquery-3.2.1.js\"]\n```\n一定要把使用的库放在前面\n\n然后在HtmlWebpackPlugin插件中配置\n\n```javascript\n chunks: [\"vendors\", name, \'commons\',],\n```\n缺点：不管有没有使用，都会被打包进js文件\n\n# 第二种\n\n直接在入口js通过路径引入\n ```javascript\nimport \"./../lib/jquery-3.2.1.js\"\n```\n\n然后就可以使用了\n\n看到这里，小伙伴们可能会疑问\n\n这样的话为什么不直接定义个webpack.ProvidePlugin和**通过NPM包引入**引入一样了\n\n试过\n\n我先配置了模块别名\n\n```javascript\n resolve: {\n        alias: {\n            // vue$: path.resolve(__dirname, \"./src/lib/vue.js\"),\n            // vue: path.resolve(__dirname, \"./src/lib/qqq.js\"),\n            // jquery: path.resolve(__dirname, \"./src/lib/jquery-3.2.1.js\"),\n        }\n    },\n```\n\n然后和npm包引入一样的方法\n\n```javascript\n new webpack.ProvidePlugin({\n            // $: \'jquery\',\n            // jQuery: \'jquery\',\n            // \"window.$\": \'jquery\',\n            // \"window.jQuery\": \'jquery\',\n})\n```\n结果控制台报错，$没有定义，然后我又安装了expose-loader，试图把JQ抛出到全局变量\n\n配置如下\n```javascript\n//     test: require.resolve(path.resolve(__dirname, \"./src/lib/jquery-3.2.1.js\")),\n            //     use: [{\n            //         loader: \'expose-loader\',\n            //         options: \'jQuery\'\n            //     }, {\n            //         loader: \'expose-loader\',\n            //         options: \'$\'\n            //     }]\n            // },\n```\n结果依然显示没有定义\n\n再后来博主通过imports-loader将模块直接导入入口js文件\n\n```javascript\n // {\n            //     test: path.resolve(__dirname, \"./src/pagea/pagea.js\"),\n            //     exclude: /node_module/,\n            //     use: [{\n            //         loader: \"imports-loader\",\n            //         options: {\n            //             $: \'jquery\',\n            //             jquery: \'jquery\'\n            //         }\n            //     }\n            //     ]\n            // },\n```\n依然是提示，$没有定义，以上情况，JQ均打包进了js文件中，切在文件顶部\n\n\n博主在引入本地第三方库上花了大量时间，\n\n### 总结，能用npm引入就用npm引入，不能使用npm引入的第三方库，可以采用上面两种方法引入\n### 能用谷歌就用谷歌，百度了一大堆，能看的，能用的就那么两三个。\n\n以上。如果小伙伴们有什么更好的方法，可以在下面留言，同时博主有什么更好的方法也会进行同步更新。','0',0),(17,'webpack入门教程（10）常用css应用总结','<h1><a id=\"1css_0\"></a>1.删除没有使用过的css代码</h1>\n<blockquote>\n<p>安装</p>\n</blockquote>\n<pre><div class=\"hljs\"><code class=\"lang-javascript\">npm i -D purifycss-webpack purify-css\n</code></div></pre>\n<p>修改配置文件</p>\n<pre><div class=\"hljs\"><code class=\"lang-javascript\"><span class=\"hljs-keyword\">new</span> PurifyCSSPlugin({\n      <span class=\"hljs-comment\">// Give paths to parse for rules. These should be absolute!</span>\n      paths: glob.sync(path.join(__dirname, <span class=\"hljs-string\">\'./src/**/*.html\'</span>)),\n    })\n</code></div></pre>\n<p>至于glob，是个遍历目录的npm包，具体使用请看，入门<a href=\"https://zhtblog.cn/posts/a60f8311/\" title=\"webpack入门教程（7）使用glob动态配置入口\" target=\"_blank\">webpack入门教程（7）使用glob动态配置入口</a></p>\n<p>这样就完成了，PurifyCSSPlugin会自动删除没有使用过的css代码</p>\n<h2><a id=\"Options_20\"></a>Options</h2>\n<blockquote>\n<p>minimize，启用压缩，默认禁用</p>\n</blockquote>\n<blockquote>\n<p>paths对路径或要遍历的路径的数组。</p>\n</blockquote>\n<blockquote>\n<p>verbose 将此标志设置为从插件获得详细输出</p>\n</blockquote>\n<p><span style=\"color: red;font-weight: 800\">注意！css中没有使用过的动画删不掉</span></p>\n<h1><a id=\"2css_30\"></a>2.自动添加css前缀</h1>\n<blockquote>\n<p>webpack打包时，css自动添加浏览器前缀。我们需要用到一个Loader：postcss-loader，和一个插件：autoprefixer</p>\n</blockquote>\n<pre><div class=\"hljs\"><code class=\"lang-javascript\">npm i -D postcss-loader autoprefixer\n\n</code></div></pre>\n<p>配置模块解析</p>\n<pre><div class=\"hljs\"><code class=\"lang-javascript\">{\n                <span class=\"hljs-attr\">test</span>: <span class=\"hljs-regexp\">/\\.(sa|sc|c)ss$/</span>,  <span class=\"hljs-comment\">// 可以打包后缀为sass/scss/css的文件</span>\n                use: [\n                    {\n                        <span class=\"hljs-attr\">loader</span>: MiniCssExtractPlugin.loader,\n                        <span class=\"hljs-attr\">options</span>: {\n                            <span class=\"hljs-comment\">// 这里可以指定一个 publicPath</span>\n                            <span class=\"hljs-comment\">// 默认使用 webpackOptions.output中的publicPath</span>\n                            <span class=\"hljs-comment\">// publicPath的配置，和plugins中设置的filename和chunkFilename的名字有关</span>\n                            <span class=\"hljs-comment\">// 如果打包后，background属性中的图片显示不出来，请检查publicPath的配置是否有误</span>\n                            <span class=\"hljs-comment\">// publicPath: \'./\',</span>\n                            publicPath: devMode ? <span class=\"hljs-string\">\'../\'</span> : <span class=\"hljs-string\">\'./\'</span>,   <span class=\"hljs-comment\">// 根据不同环境指定不同的publicPath</span>\n                            hmr: devMode, <span class=\"hljs-comment\">// 仅dev环境启用HMR功能</span>\n                        },\n                    },\n                    {\n                        <span class=\"hljs-attr\">loader</span>: <span class=\"hljs-string\">\"css-loader\"</span> <span class=\"hljs-comment\">// 将 CSS 转化成 CommonJS 模块</span>\n                    }, {\n                        <span class=\"hljs-attr\">loader</span>: <span class=\"hljs-string\">\"sass-loader\"</span> <span class=\"hljs-comment\">// 将 Sass 编译成 CSS</span>\n                    }, {\n                        <span class=\"hljs-attr\">loader</span>: <span class=\"hljs-string\">\"postcss-loader\"</span>\n                    }\n                ],\n            },\n</code></div></pre>\n<p>把**“postcss-loader”**放在最后</p>\n<p>然后在webpack.config.js文件同级目录中，新建postcss.config.js文件，并且添加如下代码：</p>\n<pre><div class=\"hljs\"><code class=\"lang-javascript\"><span class=\"hljs-built_in\">module</span>.exports = {\n    <span class=\"hljs-attr\">plugins</span>:[\n        <span class=\"hljs-built_in\">require</span>(<span class=\"hljs-string\">\'autoprefixer\'</span>)\n    ]\n}\n</code></div></pre>\n<p>同时我们也可以不创建postcss.config.js配置文件，直接在主配置文件中引入</p>\n<p>如下：</p>\n<pre><div class=\"hljs\"><code class=\"lang-javascript\">{\n                        <span class=\"hljs-attr\">loader</span>: <span class=\"hljs-string\">\"postcss-loader\"</span>,\n                        <span class=\"hljs-attr\">options</span>: {\n                            <span class=\"hljs-attr\">plugins</span>: [\n                                <span class=\"hljs-built_in\">require</span>(<span class=\"hljs-string\">\'autoprefixer\'</span>)<span class=\"hljs-comment\">//postcss-loader会叫autoprefixer插件添加浏览器前缀</span>\n                            ]\n                        }\n                    }\n</code></div></pre>\n<h1><a id=\"3jscss_93\"></a>3.从js中分离出css</h1>\n<p>可以参考这篇文章<br />\n<a href=\"https://zhtblog.cn/posts/84c73dac/\" title=\"从js中分离css\" target=\"_blank\">从js中分离css</a></p>\n','2020-01-05 12:19:54',0,'webpack','webpack','# 1.删除没有使用过的css代码\n\n> 安装\n\n```javascript\nnpm i -D purifycss-webpack purify-css\n```\n\n修改配置文件\n\n```javascript\nnew PurifyCSSPlugin({\n      // Give paths to parse for rules. These should be absolute!\n      paths: glob.sync(path.join(__dirname, \'./src/**/*.html\')),\n    })\n```\n至于glob，是个遍历目录的npm包，具体使用请看，入门[webpack入门教程（7）使用glob动态配置入口](https://zhtblog.cn/posts/a60f8311/ \"webpack入门教程（7）使用glob动态配置入口\")\n\n这样就完成了，PurifyCSSPlugin会自动删除没有使用过的css代码\n\n## Options\n\n> minimize，启用压缩，默认禁用\n\n> paths对路径或要遍历的路径的数组。\n\n>verbose 将此标志设置为从插件获得详细输出\n\n <span style=\"color: red;font-weight: 800\">注意！css中没有使用过的动画删不掉</span>\n\n# 2.自动添加css前缀\n\n> webpack打包时，css自动添加浏览器前缀。我们需要用到一个Loader：postcss-loader，和一个插件：autoprefixer\n\n```javascript\nnpm i -D postcss-loader autoprefixer\n\n```\n\n配置模块解析\n```javascript\n{\n                test: /\\.(sa|sc|c)ss$/,  // 可以打包后缀为sass/scss/css的文件\n                use: [\n                    {\n                        loader: MiniCssExtractPlugin.loader,\n                        options: {\n                            // 这里可以指定一个 publicPath\n                            // 默认使用 webpackOptions.output中的publicPath\n                            // publicPath的配置，和plugins中设置的filename和chunkFilename的名字有关\n                            // 如果打包后，background属性中的图片显示不出来，请检查publicPath的配置是否有误\n                            // publicPath: \'./\',\n                            publicPath: devMode ? \'../\' : \'./\',   // 根据不同环境指定不同的publicPath\n                            hmr: devMode, // 仅dev环境启用HMR功能\n                        },\n                    },\n                    {\n                        loader: \"css-loader\" // 将 CSS 转化成 CommonJS 模块\n                    }, {\n                        loader: \"sass-loader\" // 将 Sass 编译成 CSS\n                    }, {\n                        loader: \"postcss-loader\"\n                    }\n                ],\n            },\n```\n\n把**\"postcss-loader\"**放在最后\n\n然后在webpack.config.js文件同级目录中，新建postcss.config.js文件，并且添加如下代码：\n\n```javascript\nmodule.exports = {\n    plugins:[\n        require(\'autoprefixer\')\n    ]\n}\n```\n\n同时我们也可以不创建postcss.config.js配置文件，直接在主配置文件中引入\n\n如下：\n\n```javascript\n{\n                        loader: \"postcss-loader\",\n                        options: {\n                            plugins: [\n                                require(\'autoprefixer\')//postcss-loader会叫autoprefixer插件添加浏览器前缀\n                            ]\n                        }\n                    }\n```\n# 3.从js中分离出css\n\n可以参考这篇文章\n[从js中分离css](https://zhtblog.cn/posts/84c73dac/ \"从js中分离css\")','0',0),(18,'webpack人们教程（11）使用typeScript','<h1><a id=\"1txloadertypescript_0\"></a>1.使用tx-loader解析typescript</h1>\n<p>typescript个人比较喜欢，因为大学里相对前端的课程，java和c#的比重较多，习惯了类型声明，和处理一些编译期就可以出现的错误，而javascript有很大一部分问题必须在运行期才能发现</p>\n<p>typescript相对于webpack来说，网上教程较多，这里就不描述了，推荐以下两个网址</p>\n<p><a href=\"https://ts.xcatliu.com/introduction/hello-typescript\" title=\" TypeScript 入门教程\" target=\"_blank\"> TypeScript 入门教程</a> 这个比较基础，适合没有后端语言基础的同学，内容一步一步来，这个教程也是作者学习官方文档后写出来的</p>\n<p><a href=\"https://zhongsp.gitbooks.io/typescript-handbook/content/doc/handbook/Interfaces.html\" title=\"官方TypeScript手册（中文版）\" target=\"_blank\">官方TypeScript手册（中文版）</a>这个是typescript官方的文档，有一定的跨度，比如前面举例子的时候会用到一些后面才介绍的知识点，不过对于有后端语言基础的同学应该没有什么问题</p>\n<h2><a id=\"_10\"></a>安装相关依赖</h2>\n<h3><a id=\"typescript__12\"></a>typescript 相关</h3>\n<pre><div class=\"hljs\"><code class=\"lang-js\">npm install --save-dev typescript\n\n</code></div></pre>\n<h3><a id=\"webpack__18\"></a>webpack 相关</h3>\n<pre><div class=\"hljs\"><code class=\"lang-js\">npm install --save-dev ts-loader\n\n</code></div></pre>\n<h3><a id=\"tsconfigjson_25\"></a>在根目录下创建tsconfig.json配置文件</h3>\n<pre><div class=\"hljs\"><code class=\"lang-js\">{\n    <span class=\"hljs-string\">\"compilerOptions\"</span>: {\n        <span class=\"hljs-string\">\"outDir\"</span>: <span class=\"hljs-string\">\"./dist/\"</span>,\n        <span class=\"hljs-string\">\"noImplicitAny\"</span>: <span class=\"hljs-literal\">true</span>,\n        <span class=\"hljs-string\">\"module\"</span>: <span class=\"hljs-string\">\"commonjs\"</span>,\n        <span class=\"hljs-string\">\"target\"</span>: <span class=\"hljs-string\">\"es6\"</span>,\n        <span class=\"hljs-string\">\"allowJs\"</span>: <span class=\"hljs-literal\">true</span>,\n        <span class=\"hljs-string\">\"sourceMap\"</span>: <span class=\"hljs-literal\">true</span>\n    }\n}\n</code></div></pre>\n<p>更多选项可以查看<a href=\"https://www.tslang.cn/docs/handbook/tsconfig-json.html\" title=\"tsconfig.jsonAPI\" target=\"_blank\">tsconfig.jsonAPI</a></p>\n<p>配置模块解析</p>\n<pre><div class=\"hljs\"><code class=\"lang-js\"> resolve: {\n        <span class=\"hljs-attr\">extensions</span>: [<span class=\"hljs-string\">\".ts\"</span>, <span class=\"hljs-string\">\".tsx\"</span>, <span class=\"hljs-string\">\".js\"</span>]\n    },\n     {\n                <span class=\"hljs-attr\">test</span>: <span class=\"hljs-regexp\">/\\.ts|.tsx$/</span>,\n                <span class=\"hljs-attr\">exclude</span>: [\n                    path.resolve(__dirname, <span class=\"hljs-string\">\'node_modules\'</span>),\n                ],\n                <span class=\"hljs-attr\">use</span>:\n                {\n                    <span class=\"hljs-comment\">// loader: \'ts-loader\',</span>\n                    loader: <span class=\"hljs-string\">\'ts-loader\'</span>,\n                },\n            },\n</code></div></pre>\n<p>然后就可以在项目中正常使用typeScript了。</p>\n<h1><a id=\"2babeltypescript_63\"></a>2.使用babel解析typescript</h1>\n<p>关于babel解析es6请看这篇<a href=\"https://zhtblog.cn/posts/1cfa26d6/\" title=\"babel解析es6\" target=\"_blank\">babel解析es6</a></p>\n<h2><a id=\"_67\"></a>安装依赖</h2>\n<pre><div class=\"hljs\"><code class=\"lang-js\">npm install --save-dev @babel/preset-typescript\n\n</code></div></pre>\n<h3><a id=\"babelconfigjs_74\"></a>修改babel.config.js配置文件</h3>\n<p>babel7之后可以使用babel.config.js作为配置文件</p>\n<pre><div class=\"hljs\"><code class=\"lang-js\"><span class=\"hljs-comment\">// babel.config.js</span>\n\n<span class=\"hljs-built_in\">module</span>.exports = <span class=\"hljs-function\"><span class=\"hljs-keyword\">function</span> (<span class=\"hljs-params\">api</span>) </span>{\n    api.cache(<span class=\"hljs-literal\">true</span>)\n\n    <span class=\"hljs-keyword\">const</span> presets = [\n        [\n            <span class=\"hljs-string\">\"@babel/preset-env\"</span>,\n            {\n                <span class=\"hljs-string\">\"useBuiltIns\"</span>: <span class=\"hljs-string\">\"usage\"</span>\n            }\n        ],\n        [\n            <span class=\"hljs-string\">\'@babel/preset-typescript\'</span>,\n            {\n                <span class=\"hljs-attr\">allExtensions</span>: <span class=\"hljs-literal\">true</span>,        <span class=\"hljs-comment\">// 支持所有文件扩展名</span>\n            },\n        ],\n\n    ]\n    <span class=\"hljs-keyword\">const</span> plugins = [\n        [\n            <span class=\"hljs-string\">\"@babel/plugin-transform-runtime\"</span>,\n            {\n                <span class=\"hljs-string\">\"corejs\"</span>: <span class=\"hljs-number\">2</span>\n            },\n            <span class=\"hljs-string\">\"transform-typescript\"</span>\n        ]\n    ]\n\n    <span class=\"hljs-keyword\">return</span> {\n        presets,\n        plugins\n    }\n}\n</code></div></pre>\n<p>修改webpack配置文件，模块解析</p>\n<pre><div class=\"hljs\"><code class=\"lang-js\">{\n                <span class=\"hljs-attr\">test</span>: <span class=\"hljs-regexp\">/\\.ts|.tsx$/</span>,\n                <span class=\"hljs-attr\">exclude</span>: [\n                    path.resolve(__dirname, <span class=\"hljs-string\">\'node_modules\'</span>),\n                ],\n                <span class=\"hljs-attr\">use</span>:\n                {\n                    <span class=\"hljs-comment\">// loader: \'ts-loader\',</span>\n                    loader: <span class=\"hljs-string\">\'babel-loader\'</span>,\n                },\n            },\n</code></div></pre>\n<p>配置完成。</p>\n','2020-01-05 12:26:42',0,'webpack','webpack','# 1.使用tx-loader解析typescript\n\ntypescript个人比较喜欢，因为大学里相对前端的课程，java和c#的比重较多，习惯了类型声明，和处理一些编译期就可以出现的错误，而javascript有很大一部分问题必须在运行期才能发现\n\ntypescript相对于webpack来说，网上教程较多，这里就不描述了，推荐以下两个网址\n\n[ TypeScript 入门教程](https://ts.xcatliu.com/introduction/hello-typescript \" TypeScript 入门教程\") 这个比较基础，适合没有后端语言基础的同学，内容一步一步来，这个教程也是作者学习官方文档后写出来的\n\n[官方TypeScript手册（中文版）](https://zhongsp.gitbooks.io/typescript-handbook/content/doc/handbook/Interfaces.html \"官方TypeScript手册（中文版）\")这个是typescript官方的文档，有一定的跨度，比如前面举例子的时候会用到一些后面才介绍的知识点，不过对于有后端语言基础的同学应该没有什么问题\n\n## 安装相关依赖\n\n### typescript 相关\n```js\nnpm install --save-dev typescript\n\n```\n\n### webpack 相关\n\n```js\nnpm install --save-dev ts-loader\n\n```\n\n### 在根目录下创建tsconfig.json配置文件\n\n```js\n{\n    \"compilerOptions\": {\n        \"outDir\": \"./dist/\",\n        \"noImplicitAny\": true,\n        \"module\": \"commonjs\",\n        \"target\": \"es6\",\n        \"allowJs\": true,\n        \"sourceMap\": true\n    }\n}\n```\n\n更多选项可以查看[tsconfig.jsonAPI](https://www.tslang.cn/docs/handbook/tsconfig-json.html \"tsconfig.jsonAPI\")\n\n配置模块解析\n\n```js\n resolve: {\n        extensions: [\".ts\", \".tsx\", \".js\"]\n    },\n     {\n                test: /\\.ts|.tsx$/,\n                exclude: [\n                    path.resolve(__dirname, \'node_modules\'),\n                ],\n                use:\n                {\n                    // loader: \'ts-loader\',\n                    loader: \'ts-loader\',\n                },\n            },\n```\n\n然后就可以在项目中正常使用typeScript了。\n\n# 2.使用babel解析typescript\n\n关于babel解析es6请看这篇[babel解析es6](https://zhtblog.cn/posts/1cfa26d6/ \"babel解析es6\")\n\n## 安装依赖\n\n```js\nnpm install --save-dev @babel/preset-typescript\n\n```\n\n### 修改babel.config.js配置文件\nbabel7之后可以使用babel.config.js作为配置文件\n\n```js\n// babel.config.js\n\nmodule.exports = function (api) {\n    api.cache(true)\n\n    const presets = [\n        [\n            \"@babel/preset-env\",\n            {\n                \"useBuiltIns\": \"usage\"\n            }\n        ],\n        [\n            \'@babel/preset-typescript\',\n            {\n                allExtensions: true,        // 支持所有文件扩展名\n            },\n        ],\n\n    ]\n    const plugins = [\n        [\n            \"@babel/plugin-transform-runtime\",\n            {\n                \"corejs\": 2\n            },\n            \"transform-typescript\"\n        ]\n    ]\n\n    return {\n        presets,\n        plugins\n    }\n}\n```\n\n修改webpack配置文件，模块解析\n\n```js\n{\n                test: /\\.ts|.tsx$/,\n                exclude: [\n                    path.resolve(__dirname, \'node_modules\'),\n                ],\n                use:\n                {\n                    // loader: \'ts-loader\',\n                    loader: \'babel-loader\',\n                },\n            },\n```\n\n配置完成。','1',0),(19,'webpack入门教程（12）使用pug模板','<h1><a id=\"1pug_0\"></a>1.pug是什么</h1>\n<blockquote>\n<p>Pug是一款健壮、灵活、功能丰富的HTML模板引擎,专门为 Node.js 平台开发。Pug是由Jade 改名而来。</p>\n</blockquote>\n<blockquote>\n<p>是一种通过缩进（表示标签间的嵌套关系）的方式来编写代码的过程，在编译的过程中，不需要考虑标签是否闭合的问题。可以加快写代码速度，也为代码复用提供了便捷。</p>\n</blockquote>\n<p>类别的话，可以理解为，scss,typescript，这种需要编译的，编程式语言</p>\n<h1><a id=\"2_8\"></a>2.使用</h1>\n<h2><a id=\"_9\"></a>安装相关依赖</h2>\n<pre><div class=\"hljs\"><code class=\"lang-js\">npm install pug pug-html-loader raw-loader --save-dev\n</code></div></pre>\n<p>修改配置文件</p>\n<pre><div class=\"hljs\"><code class=\"lang-js\"> {\n        <span class=\"hljs-attr\">test</span>: <span class=\"hljs-regexp\">/\\.pug$/</span>,\n        <span class=\"hljs-attr\">loader</span>: [<span class=\"hljs-string\">\"raw-loader\"</span>, <span class=\"hljs-string\">\'pug-html-loader\'</span>]\n    ,\n｝\n</code></div></pre>\n<p>就可以正常解析了。</p>\n<h1><a id=\"3vscodepug_25\"></a>3.在vscode中配置pug模板</h1>\n<p>点击左下脚齿轮，点击用户片段，在弹出框中输入pug，</p>\n<p>添加以下代码</p>\n<pre><div class=\"hljs\"><code class=\"lang-javascript\"><span class=\"hljs-string\">\"Pug\"</span>: {\n<span class=\"hljs-string\">\"prefix\"</span>: <span class=\"hljs-string\">\"pug\"</span>,\n<span class=\"hljs-string\">\"body\"</span>: [\n<span class=\"hljs-string\">\"doctype html\"</span>,\n<span class=\"hljs-string\">\"html(lang=\'en\')\"</span>,\n <span class=\"hljs-string\">\"head\"</span>,\n    <span class=\"hljs-string\">\"meta(charset=\'UTF-8\')\"</span>,\n  <span class=\"hljs-string\">\"meta(name=\'viewport\', content=\'width=device-width, initial-scale=1.0\')\"</span>,\n    <span class=\"hljs-string\">\"meta(http-equiv=\'X-UA-Compatible\', content=\'ie=edge\')\"</span>,\n    <span class=\"hljs-string\">\"title Document\"</span>,\n      <span class=\"hljs-string\">\"body\"</span>\n],\n<span class=\"hljs-string\">\"description\"</span>: <span class=\"hljs-string\">\"pug\"</span>\n}\n</code></div></pre>\n','2020-01-05 12:21:47',0,'webpack','webpack','# 1.pug是什么\n> Pug是一款健壮、灵活、功能丰富的HTML模板引擎,专门为 Node.js 平台开发。Pug是由Jade 改名而来。\n\n> 是一种通过缩进（表示标签间的嵌套关系）的方式来编写代码的过程，在编译的过程中，不需要考虑标签是否闭合的问题。可以加快写代码速度，也为代码复用提供了便捷。\n\n类别的话，可以理解为，scss,typescript，这种需要编译的，编程式语言\n\n\n# 2.使用\n## 安装相关依赖\n```js\nnpm install pug pug-html-loader raw-loader --save-dev\n```\n\n修改配置文件\n\n```js\n {\n        test: /\\.pug$/,\n        loader: [\"raw-loader\", \'pug-html-loader\']\n    ,\n｝\n```\n就可以正常解析了。\n\n# 3.在vscode中配置pug模板\n\n点击左下脚齿轮，点击用户片段，在弹出框中输入pug，\n\n添加以下代码\n\n```javascript\n\"Pug\": {\n\"prefix\": \"pug\",\n\"body\": [\n\"doctype html\",\n\"html(lang=\'en\')\",\n \"head\",\n    \"meta(charset=\'UTF-8\')\",\n  \"meta(name=\'viewport\', content=\'width=device-width, initial-scale=1.0\')\",\n    \"meta(http-equiv=\'X-UA-Compatible\', content=\'ie=edge\')\",\n    \"title Document\",\n      \"body\"\n],\n\"description\": \"pug\"\n}\n```','0',0),(20,'webpack入门教程','<h1><a id=\"1webpack_0\"></a>1.初始化webpack项目</h1>\n<p>首先创建一个新目录<br />\n进入新目录里面<br />\n执行</p>\n<pre><div class=\"hljs\"><code class=\"lang-js\">npm init\n</code></div></pre>\n<p>一路回车下去就行了</p>\n<p>此时目录里面多了一个文件package.json</p>\n<p>内容如下</p>\n<pre><div class=\"hljs\"><code class=\"lang-js\">{\n  <span class=\"hljs-string\">\"name\"</span>: <span class=\"hljs-string\">\"aa\"</span>,\n  <span class=\"hljs-string\">\"version\"</span>: <span class=\"hljs-string\">\"1.0.0\"</span>,\n  <span class=\"hljs-string\">\"description\"</span>: <span class=\"hljs-string\">\"\"</span>,\n  <span class=\"hljs-string\">\"main\"</span>: <span class=\"hljs-string\">\"index.js\"</span>,\n  <span class=\"hljs-string\">\"scripts\"</span>: {\n    <span class=\"hljs-string\">\"test\"</span>: <span class=\"hljs-string\">\"echo \\\"Error: no test specified\\\" &amp;&amp; exit 1\"</span>\n  },\n  <span class=\"hljs-string\">\"author\"</span>: <span class=\"hljs-string\">\"\"</span>,\n  <span class=\"hljs-string\">\"license\"</span>: <span class=\"hljs-string\">\"ISC\"</span>\n}\n\n</code></div></pre>\n<h1><a id=\"2WebpackWebpack_27\"></a>2.安装Webpack和初始配置Webpack</h1>\n<p>继续执行代码</p>\n<pre><div class=\"hljs\"><code class=\"lang-js\">npm i webpack webpack-cli webpack-dev-server -D\n</code></div></pre>\n<p>目录结构如下<br />\n<img src=\"https://img-blog.csdnimg.cn/20191203223411940.png?x-oss-process=image/watermark,type_ZmFuZ3poZW5naGVpdGk,shadow_10,text_aHR0cHM6Ly9ibG9nLmNzZG4ubmV0L3FxXzQxNjA2MDI5,size_16,color_FFFFFF,t_70\" alt=\"\" /></p>\n<p>package.json内容如下</p>\n<pre><div class=\"hljs\"><code class=\"lang-js\">{\n  <span class=\"hljs-string\">\"name\"</span>: <span class=\"hljs-string\">\"aa\"</span>,\n  <span class=\"hljs-string\">\"version\"</span>: <span class=\"hljs-string\">\"1.0.0\"</span>,\n  <span class=\"hljs-string\">\"description\"</span>: <span class=\"hljs-string\">\"\"</span>,\n  <span class=\"hljs-string\">\"main\"</span>: <span class=\"hljs-string\">\"index.js\"</span>,\n  <span class=\"hljs-string\">\"scripts\"</span>: {\n    <span class=\"hljs-string\">\"test\"</span>: <span class=\"hljs-string\">\"echo \\\"Error: no test specified\\\" &amp;&amp; exit 1\"</span>\n  },\n  <span class=\"hljs-string\">\"author\"</span>: <span class=\"hljs-string\">\"\"</span>,\n  <span class=\"hljs-string\">\"license\"</span>: <span class=\"hljs-string\">\"ISC\"</span>,\n  <span class=\"hljs-string\">\"devDependencies\"</span>: {\n    <span class=\"hljs-string\">\"webpack\"</span>: <span class=\"hljs-string\">\"^4.41.2\"</span>,\n    <span class=\"hljs-string\">\"webpack-cli\"</span>: <span class=\"hljs-string\">\"^3.3.10\"</span>,\n    <span class=\"hljs-string\">\"webpack-dev-server\"</span>: <span class=\"hljs-string\">\"^3.9.0\"</span>\n  }\n}\n\n</code></div></pre>\n<p>在命令终端使用npm i安装依赖关系时，如果带后缀 -D（或–save-dev） 安装的包会记录在&quot;devDependencies&quot;下；<br />\n如果使用 --save后缀（我们后面会用到）安装的包会记录在&quot;dependencies&quot;下。</p>\n<blockquote>\n<p>两者的区别是：<br />\n“devDependencies”：dev开发时的依赖包<br />\ndependencies：程序运行时的依赖包</p>\n</blockquote>\n<p>新建src文件夹，里面新建index.js文件<br />\n<img src=\"https://img-blog.csdnimg.cn/20191203223722369.png\" alt=\"\" /></p>\n<p>添加以下代码</p>\n<pre><div class=\"hljs\"><code class=\"lang-js\"><span class=\"hljs-built_in\">console</span>.log(<span class=\"hljs-string\">\"Hello, word\"</span>)\n\n</code></div></pre>\n<p>执行以下代码</p>\n<pre><div class=\"hljs\"><code class=\"lang-js\">npx webpack src/index.js\n</code></div></pre>\n<p>此时目录会多一个dist文件，里面有main.js文件</p>\n<p><img src=\"https://img-blog.csdnimg.cn/20191203223946546.png?x-oss-process=image/watermark,type_ZmFuZ3poZW5naGVpdGk,shadow_10,text_aHR0cHM6Ly9ibG9nLmNzZG4ubmV0L3FxXzQxNjA2MDI5,size_16,color_FFFFFF,t_70\" alt=\"\" /></p>\n<p>在dist的目录下新建index.html,测试index.js内容是否打包到了main.js</p>\n<p>引入main.js，运行网页，测试成功</p>\n<h1><a id=\"3_87\"></a>3.创建配置文件</h1>\n<p>新建build目录<br />\n创建webpack.config.js文件</p>\n<p>在里面添加以下配置</p>\n<pre><div class=\"hljs\"><code class=\"lang-js\"><span class=\"hljs-keyword\">var</span> webpack = <span class=\"hljs-built_in\">require</span>(<span class=\"hljs-string\">\"webpack\"</span>);\n<span class=\"hljs-keyword\">var</span> path = <span class=\"hljs-built_in\">require</span>(<span class=\"hljs-string\">\"path\"</span>);\n<span class=\"hljs-keyword\">var</span> DIST_PATH = path.resolve(__dirname, <span class=\"hljs-string\">\'../dist\'</span>);\n<span class=\"hljs-built_in\">module</span>.exports = {\n    <span class=\"hljs-comment\">// 入口JS路径</span>\n    <span class=\"hljs-comment\">// 指示Webpack应该使用哪个模块，来作为构建其内部依赖图的开始</span>\n    entry: path.resolve(__dirname, <span class=\"hljs-string\">\"../src/index.js\"</span>),\n    <span class=\"hljs-attr\">output</span>: {\n        <span class=\"hljs-comment\">// 编译输出的JS入路径 </span>\n        <span class=\"hljs-comment\">// 告诉Webpack在哪里输出它所创建的bundle，以及如何命名这些文件</span>\n        path: DIST_PATH,   <span class=\"hljs-comment\">// 创建的bundle生成到哪里  </span>\n        filename: <span class=\"hljs-string\">\'bundle.js\'</span>, <span class=\"hljs-comment\">// 创建的bundle的名称</span>\n    },\n    <span class=\"hljs-comment\">// 模块解析 </span>\n    <span class=\"hljs-built_in\">module</span>: {\n    },\n    <span class=\"hljs-comment\">// 插件 </span>\n    plugins: [],\n    <span class=\"hljs-comment\">// 开发服务器 </span>\n    devServer: {\n    }\n}\n</code></div></pre>\n<p>此时回到package.json，在“script”添加以下代码</p>\n<pre><div class=\"hljs\"><code class=\"lang-js\"><span class=\"hljs-string\">\"scripts\"</span>: {\n<span class=\"hljs-string\">\"build\"</span>: <span class=\"hljs-string\">\"webpack --config ./build/webpack.config.js --mode production\"</span>, \n<span class=\"hljs-string\">\"test\"</span>: <span class=\"hljs-string\">\"echo \\\"Error: no test specified\\\" &amp;&amp; exit 1\"</span> \n}\n</code></div></pre>\n<p>这样我们可以不用输入</p>\n<blockquote>\n<p>npx webpack src/index.js --output dist/bundle.js --mode none</p>\n</blockquote>\n<p>直接用npm run build代替</p>\n<p>其中“–mode production”表示项目的环境，不配置这个会报警告</p>\n<h1><a id=\"4Server_133\"></a>4.配置Server服务</h1>\n<p>找到刚才编写的webpack.config.js，添加以下代码</p>\n<pre><div class=\"hljs\"><code class=\"lang-js\">{ <span class=\"hljs-attr\">hot</span>: <span class=\"hljs-literal\">true</span>, <span class=\"hljs-comment\">// 热更新，无需手动刷新 contentBase: DIST_PATH, </span>\n<span class=\"hljs-comment\">// host: \'0.0.0.0\', // host地址</span>\nport: <span class=\"hljs-number\">8080</span>, <span class=\"hljs-comment\">// 服务器端口 </span>\nhistoryApiFallback: <span class=\"hljs-literal\">true</span>,<span class=\"hljs-comment\">// 该选项的作用所用404都连接到index.html </span>\nproxy: { \n<span class=\"hljs-string\">\"/api\"</span>: <span class=\"hljs-string\">\"http://localhost:3000\"</span> <span class=\"hljs-comment\">// 代理到后端的服务地址，会拦截所有以api开头的请求地址</span>\n} }\n</code></div></pre>\n<p>和build类似，需要在package.json的scripts中添加相关的命令</p>\n<p>在package.json中</p>\n<pre><div class=\"hljs\"><code class=\"lang-js\"><span class=\"hljs-string\">\"scripts\"</span>: {\n<span class=\"hljs-string\">\"build\"</span>: <span class=\"hljs-string\">\"webpack --config ./build/webpack.config.js --mode production\"</span>,\n<span class=\"hljs-string\">\"dev\"</span>: <span class=\"hljs-string\">\"webpack-dev-server --config ./build/webpack.config.js --mode development --open\"</span>,\n<span class=\"hljs-string\">\"test\"</span>: <span class=\"hljs-string\">\"echo \\\"Error: no test specified\\\" &amp;&amp; exit 1\"</span> }\n</code></div></pre>\n<p>运行npm run dev，打开localhost:8080，就可以看见网站</p>\n<p style=\"color: red\">注意!!!!</p>\n<p style=\"color: red\">开发不能设置output的publicPath,否则页面出不来，因为找不到路径</p>\n<p>可以如下设置</p>\n<pre><div class=\"hljs\"><code class=\"lang-js\"><span class=\"hljs-keyword\">const</span> devMode = process.env.NODE_ENV === <span class=\"hljs-string\">\'production\'</span>\n</code></div></pre>\n<pre><div class=\"hljs\"><code class=\"lang-js\">  output: {\n        <span class=\"hljs-comment\">// 编译输出的JS入路径 </span>\n        <span class=\"hljs-comment\">// 告诉Webpack在哪里输出它所创建的bundle，以及如何命名这些文件</span>\n        path: DIST_PATH,   <span class=\"hljs-comment\">// 创建的bundle生成到哪里  </span>\n        filename: <span class=\"hljs-string\">\'js/[name].js\'</span>, <span class=\"hljs-comment\">// 创建的bundle的名称</span>\n        publicPath: devMode ? <span class=\"hljs-string\">\'./\'</span> : <span class=\"hljs-string\">\"\"</span>,\n    },\n</code></div></pre>\n','2020-01-05 12:23:18',0,'webpack','webpack','# 1.初始化webpack项目\n首先创建一个新目录\n进入新目录里面\n执行\n```js\nnpm init\n```\n一路回车下去就行了\n\n此时目录里面多了一个文件package.json\n\n内容如下\n```js\n{\n  \"name\": \"aa\",\n  \"version\": \"1.0.0\",\n  \"description\": \"\",\n  \"main\": \"index.js\",\n  \"scripts\": {\n    \"test\": \"echo \\\"Error: no test specified\\\" && exit 1\"\n  },\n  \"author\": \"\",\n  \"license\": \"ISC\"\n}\n\n```\n\n# 2.安装Webpack和初始配置Webpack\n\n继续执行代码\n```js\nnpm i webpack webpack-cli webpack-dev-server -D\n```\n\n目录结构如下\n![](https://img-blog.csdnimg.cn/20191203223411940.png?x-oss-process=image/watermark,type_ZmFuZ3poZW5naGVpdGk,shadow_10,text_aHR0cHM6Ly9ibG9nLmNzZG4ubmV0L3FxXzQxNjA2MDI5,size_16,color_FFFFFF,t_70)\n\npackage.json内容如下\n\n```js\n{\n  \"name\": \"aa\",\n  \"version\": \"1.0.0\",\n  \"description\": \"\",\n  \"main\": \"index.js\",\n  \"scripts\": {\n    \"test\": \"echo \\\"Error: no test specified\\\" && exit 1\"\n  },\n  \"author\": \"\",\n  \"license\": \"ISC\",\n  \"devDependencies\": {\n    \"webpack\": \"^4.41.2\",\n    \"webpack-cli\": \"^3.3.10\",\n    \"webpack-dev-server\": \"^3.9.0\"\n  }\n}\n\n```\n\n在命令终端使用npm i安装依赖关系时，如果带后缀 -D（或--save-dev） 安装的包会记录在\"devDependencies\"下；\n如果使用 --save后缀（我们后面会用到）安装的包会记录在\"dependencies\"下。\n\n> 两者的区别是：\n\"devDependencies\"：dev开发时的依赖包\n dependencies：程序运行时的依赖包\n\n新建src文件夹，里面新建index.js文件\n![](https://img-blog.csdnimg.cn/20191203223722369.png)\n\n添加以下代码\n```js\nconsole.log(\"Hello, word\")\n\n```\n执行以下代码\n\n```js\nnpx webpack src/index.js\n```\n此时目录会多一个dist文件，里面有main.js文件\n\n![](https://img-blog.csdnimg.cn/20191203223946546.png?x-oss-process=image/watermark,type_ZmFuZ3poZW5naGVpdGk,shadow_10,text_aHR0cHM6Ly9ibG9nLmNzZG4ubmV0L3FxXzQxNjA2MDI5,size_16,color_FFFFFF,t_70)\n\n在dist的目录下新建index.html,测试index.js内容是否打包到了main.js\n\n引入main.js，运行网页，测试成功\n\n# 3.创建配置文件\n\n新建build目录\n创建webpack.config.js文件\n\n在里面添加以下配置\n\n```js\nvar webpack = require(\"webpack\");\nvar path = require(\"path\");\nvar DIST_PATH = path.resolve(__dirname, \'../dist\');\nmodule.exports = {\n    // 入口JS路径\n    // 指示Webpack应该使用哪个模块，来作为构建其内部依赖图的开始\n    entry: path.resolve(__dirname, \"../src/index.js\"),\n    output: {\n        // 编译输出的JS入路径 \n        // 告诉Webpack在哪里输出它所创建的bundle，以及如何命名这些文件\n        path: DIST_PATH,   // 创建的bundle生成到哪里  \n        filename: \'bundle.js\', // 创建的bundle的名称\n    },\n    // 模块解析 \n    module: {\n    },\n    // 插件 \n    plugins: [],\n    // 开发服务器 \n    devServer: {\n    }\n}\n```\n此时回到package.json，在“script”添加以下代码\n```js\n\"scripts\": {\n\"build\": \"webpack --config ./build/webpack.config.js --mode production\", \n\"test\": \"echo \\\"Error: no test specified\\\" && exit 1\" \n}\n```\n这样我们可以不用输入\n> npx webpack src/index.js --output dist/bundle.js --mode none\n\n直接用npm run build代替\n\n其中“--mode production”表示项目的环境，不配置这个会报警告\n\n\n# 4.配置Server服务\n\n找到刚才编写的webpack.config.js，添加以下代码\n```js\n{ hot: true, // 热更新，无需手动刷新 contentBase: DIST_PATH, \n// host: \'0.0.0.0\', // host地址\nport: 8080, // 服务器端口 \nhistoryApiFallback: true,// 该选项的作用所用404都连接到index.html \nproxy: { \n\"/api\": \"http://localhost:3000\" // 代理到后端的服务地址，会拦截所有以api开头的请求地址\n} }\n```\n\n和build类似，需要在package.json的scripts中添加相关的命令\n\n在package.json中\n\n```js\n\"scripts\": {\n\"build\": \"webpack --config ./build/webpack.config.js --mode production\",\n\"dev\": \"webpack-dev-server --config ./build/webpack.config.js --mode development --open\",\n\"test\": \"echo \\\"Error: no test specified\\\" && exit 1\" }\n```\n\n运行npm run dev，打开localhost:8080，就可以看见网站\n\n<p style=\"color: red\">注意!!!!</p>\n\n<p style=\"color: red\">开发不能设置output的publicPath,否则页面出不来，因为找不到路径</p>\n\n可以如下设置\n\n```js\nconst devMode = process.env.NODE_ENV === \'production\'\n```\n```js\n  output: {\n        // 编译输出的JS入路径 \n        // 告诉Webpack在哪里输出它所创建的bundle，以及如何命名这些文件\n        path: DIST_PATH,   // 创建的bundle生成到哪里  \n        filename: \'js/[name].js\', // 创建的bundle的名称\n        publicPath: devMode ? \'./\' : \"\",\n    },\n```\n','0',0),(21,'关于vue-cli3脚手架中静态资源引入问题','<h1><a id=\"1html_0\"></a>1.在入口html文件中使用</h1>\n<blockquote>\n<p>把静态资源放在public下，此目录下资源都是不经过编译处理的，不要放置有es6的js文件</p>\n</blockquote>\n<blockquote>\n<p>常规导入</p>\n</blockquote>\n<pre><div class=\"hljs\"><code class=\"lang-javascript\"> &lt;script src=<span class=\"hljs-string\">\"js/iconfont.js\"</span> type=<span class=\"hljs-string\">\"text/javascript\"</span>&gt;<span class=\"xml\"><span class=\"hljs-tag\">&lt;/<span class=\"hljs-name\">script</span>&gt;</span></span>\n</code></div></pre>\n<p>目录结构</p>\n<img alt=\"\" class=\"has\" height=\"217\" src=\"https://img-blog.csdnimg.cn/20191127132221254.png?x-oss-process=image/watermark,type_ZmFuZ3poZW5naGVpdGk,shadow_10,text_aHR0cHM6Ly9ibG9nLmNzZG4ubmV0L3FxXzQxNjA2MDI5,size_16,color_FFFFFF,t_70\" width=\"354\">\n<p>发现控制台报以下错误</p>\n<img alt=\"\" class=\"has\" height=\"29\" src=\"https://img-blog.csdnimg.cn/20191127132057866.png\" width=\"845\">\n<blockquote>\n<p>此时我们要在导入地址前面加上&lt;%= BASE_URL %&gt;</p>\n</blockquote>\n<pre><div class=\"hljs\"><code class=\"lang-javascript\">  &lt;script src=<span class=\"hljs-string\">\"&lt;%= BASE_URL %&gt;js/iconfont.js\"</span> type=<span class=\"hljs-string\">\"text/javascript\"</span>&gt;<span class=\"xml\"><span class=\"hljs-tag\">&lt;/<span class=\"hljs-name\">script</span>&gt;</span></span>\n</code></div></pre>\n<p>结果正常显示</p>\n<h1><a id=\"2vue_27\"></a>2.在vue文件的模板中使用静态资源</h1>\n<p>首先配置vue.config.js API文档</p>\n<p>2.1配置publicPath</p>\n<pre><div class=\"hljs\"><code class=\"lang-javascript\">publicPath: process.env.NODE_ENV === <span class=\"hljs-string\">\'production\'</span>\n \n        ? <span class=\"hljs-string\">\'./\'</span>\n \n        : <span class=\"hljs-string\">\'/\'</span>,\n</code></div></pre>\n<p>上面代码意思是判断是否为开发环境</p>\n<p>如果设置了项目名</p>\n<p>可以加在/后面，此方法同时也解决了打包资源后路径出错的问题</p>\n<h3><a id=\"22VUE_44\"></a>2.2配置VUE全局变量</h3>\n<pre><div class=\"hljs\"><code class=\"lang-javascript\">Vue.prototype.$publicPath = process.env.BASE_URL\n</code></div></pre>\n<p>在项目中使用</p>\n<pre><div class=\"hljs\"><code class=\"lang-javascript\">&lt;img :src=<span class=\"hljs-string\">\"$publicPath+\'img/1.jpg\'\"</span>/&gt;\n\n</code></div></pre>\n<p>也可以在组件中定义变量单独使用，如下</p>\n<pre><div class=\"hljs\"><code class=\"lang-javascript\">publicPath: process.env.BASE_URL,\n<span class=\"hljs-comment\">//在data函数中return</span>\n</code></div></pre>\n<h1><a id=\"3CSS_63\"></a>3.在CSS中使用</h1>\n<blockquote>\n<p>因为 sass 文件中无法获取环境变量或 webpack 内的配置，于是最直接的方法就是自定义一个变量，然后在每个需要使用到它的文件引用它。</p>\n</blockquote>\n<pre><div class=\"hljs\"><code class=\"lang-javascript\">$publicPath: <span class=\"hljs-string\">\"/\"</span>;\n.icon-test {\n  <span class=\"hljs-attr\">background</span>: url($baseUrl + <span class=\"hljs-string\">\'imgs/icon_test.png\'</span>) no-repeat;\n}\n</code></div></pre>\n<p>这样设置的问题在于开发环境和生产环境的的publicPath不同，每次打包项目都要修改css中的publicPath，解决方法如下：</p>\n<p>打开vue.config.js，设置以下代码</p>\n<pre><div class=\"hljs\"><code class=\"lang-javascript\"><span class=\"hljs-keyword\">const</span> baseUrl = process.env.NODE_ENV === <span class=\"hljs-string\">\'production\'</span> ? <span class=\"hljs-string\">\'./\'</span> : <span class=\"hljs-string\">\'/\'</span>;\n<span class=\"hljs-built_in\">module</span>.exports = {\n<span class=\"hljs-attr\">css</span>: {\n        <span class=\"hljs-attr\">loaderOptions</span>: {\n            <span class=\"hljs-comment\">// 给 sass-loader 传递选项</span>\n            sass: {\n                <span class=\"hljs-attr\">prependData</span>: <span class=\"hljs-string\">`$publicPath: \"<span class=\"hljs-subst\">${baseUrl}</span>\";`</span>\n            }\n        }\n    },\n}\n</code></div></pre>\n<p>设置完成后，可以直接在项目中使用publicPath</p>\n<p>以上就是vue-cli3对静态处理的三种方式，如果有帮助到你，可以点赞或留言评论，感谢各位。</p>\n','2020-01-05 12:26:37',0,'vue','vue','# 1.在入口html文件中使用\n\n> 把静态资源放在public下，此目录下资源都是不经过编译处理的，不要放置有es6的js文件\n\n> 常规导入\n\n```javascript\n <script src=\"js/iconfont.js\" type=\"text/javascript\"></script>\n```\n目录结构\n\n\n<img alt=\"\" class=\"has\" height=\"217\" src=\"https://img-blog.csdnimg.cn/20191127132221254.png?x-oss-process=image/watermark,type_ZmFuZ3poZW5naGVpdGk,shadow_10,text_aHR0cHM6Ly9ibG9nLmNzZG4ubmV0L3FxXzQxNjA2MDI5,size_16,color_FFFFFF,t_70\" width=\"354\">\n\n发现控制台报以下错误\n\n<img alt=\"\" class=\"has\" height=\"29\" src=\"https://img-blog.csdnimg.cn/20191127132057866.png\" width=\"845\">\n\n\n> 此时我们要在导入地址前面加上<%= BASE_URL %>\n\n```javascript\n  <script src=\"<%= BASE_URL %>js/iconfont.js\" type=\"text/javascript\"></script>\n```\n\n结果正常显示\n\n# 2.在vue文件的模板中使用静态资源\n首先配置vue.config.js API文档\n\n2.1配置publicPath\n```javascript\npublicPath: process.env.NODE_ENV === \'production\'\n \n        ? \'./\'\n \n        : \'/\',\n```\n上面代码意思是判断是否为开发环境\n\n如果设置了项目名\n\n可以加在/后面，此方法同时也解决了打包资源后路径出错的问题\n\n### 2.2配置VUE全局变量\n\n```javascript\nVue.prototype.$publicPath = process.env.BASE_URL\n```\n\n在项目中使用\n\n```javascript\n<img :src=\"$publicPath+\'img/1.jpg\'\"/>\n\n```\n\n也可以在组件中定义变量单独使用，如下\n\n```javascript\npublicPath: process.env.BASE_URL,\n//在data函数中return\n```\n# 3.在CSS中使用\n\n> 因为 sass 文件中无法获取环境变量或 webpack 内的配置，于是最直接的方法就是自定义一个变量，然后在每个需要使用到它的文件引用它。\n\n```javascript\n$publicPath: \"/\";\n.icon-test {\n  background: url($baseUrl + \'imgs/icon_test.png\') no-repeat;\n}\n```\n\n这样设置的问题在于开发环境和生产环境的的publicPath不同，每次打包项目都要修改css中的publicPath，解决方法如下：\n\n打开vue.config.js，设置以下代码\n```javascript\nconst baseUrl = process.env.NODE_ENV === \'production\' ? \'./\' : \'/\';\nmodule.exports = {\ncss: {\n        loaderOptions: {\n            // 给 sass-loader 传递选项\n            sass: {\n                prependData: `$publicPath: \"${baseUrl}\";`\n            }\n        }\n    },\n}\n```\n 设置完成后，可以直接在项目中使用publicPath\n\n以上就是vue-cli3对静态处理的三种方式，如果有帮助到你，可以点赞或留言评论，感谢各位。','1',0),(22,'响应式布局之媒体查询','<h1><a id=\"CSS__0\"></a>CSS 语法</h1>\n<pre><div class=\"hljs\"><code class=\"lang-css\">@<span class=\"hljs-keyword\">media</span> mediatype and|not|only (media feature) {\n    <span class=\"hljs-selector-tag\">CSS-Code</span>;\n}\n</code></div></pre>\n<p>你也可以针对不同的媒体使用不同 stylesheets :</p>\n<pre><div class=\"hljs\"><code class=\"lang-css\">&lt;<span class=\"hljs-selector-tag\">link</span> <span class=\"hljs-selector-tag\">rel</span>=\"<span class=\"hljs-selector-tag\">stylesheet</span>\" <span class=\"hljs-selector-tag\">media</span>=\"<span class=\"hljs-selector-tag\">mediatype</span> <span class=\"hljs-selector-tag\">and</span>|<span class=\"hljs-selector-tag\">not</span>|<span class=\"hljs-selector-tag\">only</span> (<span class=\"hljs-selector-tag\">media</span> <span class=\"hljs-selector-tag\">feature</span>)\" <span class=\"hljs-selector-tag\">href</span>=\"<span class=\"hljs-selector-tag\">mystylesheet</span><span class=\"hljs-selector-class\">.css</span>\"&gt;\n</code></div></pre>\n<p>API</p>\n  <table>\n    <tbody>\n    <tr>\n    <th>值</th>\n    <th>描述</th>\n    		</tr><tr><td>aspect-ratio</td>\n    			<td>定义输出设备中的页面可见区域宽度与高度的比率</td>\n    		</tr><tr><td>color</td>\n    			<td>定义输出设备每一组彩色原件的个数。如果不是彩色设备，则值等于0</td>\n    		</tr><tr><td>color-index</td>\n    			<td>定义在输出设备的彩色查询表中的条目数。如果没有使用彩色查询表，则值等于0</td>\n    		</tr><tr><td>device-aspect-ratio</td>\n    			<td>定义输出设备的屏幕可见宽度与高度的比率。</td>\n    		</tr><tr><td>device-height</td>\n    			<td>定义输出设备的屏幕可见高度。</td>\n    		</tr><tr><td>device-width</td>\n    			<td>定义输出设备的屏幕可见宽度。</td>\n    		</tr><tr><td>grid</td>\n    			<td>用来查询输出设备是否使用栅格或点阵。</td>\n    		</tr><tr><td>height</td>\n    			<td>定义输出设备中的页面可见区域高度。</td>\n    		</tr><tr><td>max-aspect-ratio</td>\n    			<td>定义输出设备的屏幕可见宽度与高度的最大比率。</td>\n    		</tr><tr><td>max-color</td>\n    			<td>定义输出设备每一组彩色原件的最大个数。</td>\n    		</tr><tr><td>max-color-index</td>\n    			<td>定义在输出设备的彩色查询表中的最大条目数。</td>\n    		</tr><tr><td>max-device-aspect-ratio</td>\n    			<td>定义输出设备的屏幕可见宽度与高度的最大比率。</td>\n    		</tr><tr><td>max-device-height</td>\n    			<td>定义输出设备的屏幕可见的最大高度。</td>\n    		</tr><tr><td>max-device-width</td>\n    			<td>定义输出设备的屏幕最大可见宽度。</td>\n    		</tr><tr><td>max-height</td>\n    			<td>定义输出设备中的页面最大可见区域高度。</td>\n    		</tr><tr><td>max-monochrome</td>\n    			<td>定义在一个单色框架缓冲区中每像素包含的最大单色原件个数。</td>\n    		</tr><tr><td>max-resolution</td>\n    			<td>定义设备的最大分辨率。</td>\n    		</tr><tr><td>max-width</td>\n    			<td>定义输出设备中的页面最大可见区域宽度。</td>\n    		</tr><tr><td>min-aspect-ratio</td>\n    			<td>定义输出设备中的页面可见区域宽度与高度的最小比率。</td>\n    		</tr><tr><td>min-color</td>\n    			<td>定义输出设备每一组彩色原件的最小个数。</td>\n    		</tr><tr><td>min-color-index</td>\n    			<td>定义在输出设备的彩色查询表中的最小条目数。</td>\n    		</tr><tr><td>min-device-aspect-ratio</td>\n    			<td>定义输出设备的屏幕可见宽度与高度的最小比率。</td>\n    		</tr><tr><td>min-device-width</td>\n    			<td>定义输出设备的屏幕最小可见宽度。</td>\n    		</tr><tr><td>min-device-height</td>\n    			<td>定义输出设备的屏幕的最小可见高度。</td>\n    		</tr><tr><td>min-height</td>\n    			<td>定义输出设备中的页面最小可见区域高度。</td>\n    		</tr><tr><td>min-monochrome</td>\n    			<td>定义在一个单色框架缓冲区中每像素包含的最小单色原件个数</td>\n    		</tr><tr><td>min-resolution</td>\n    			<td>定义设备的最小分辨率。</td>\n    		</tr><tr><td>min-width</td>\n    			<td>定义输出设备中的页面最小可见区域宽度。</td>\n    		</tr><tr><td>monochrome</td>\n    			<td>定义在一个单色框架缓冲区中每像素包含的单色原件个数。如果不是单色设备，则值等于0</td>\n    		</tr><tr><td>orientation</td>\n    			<td>定义输出设备中的页面可见区域高度是否大于或等于宽度。</td>\n    		</tr><tr><td>resolution</td>\n    			<td>定义设备的分辨率。如：96dpi, 300dpi, 118dpcm</td>\n    		</tr><tr><td>scan</td>\n    			<td>定义电视类设备的扫描工序。</td>\n    		</tr><tr><td>width</td>\n    			<td>定义输出设备中的页面可见区域宽度。</td>\n    		</tr></tbody></table>\n<p>可以使用多个and</p>\n<pre><div class=\"hljs\"><code class=\"lang-css\">@<span class=\"hljs-keyword\">media</span> screen and (min-width: <span class=\"hljs-number\">992px</span>) and (max-width: <span class=\"hljs-number\">1200px</span>) {\n   <span class=\"hljs-selector-class\">.zhtTop</span> {\n       <span class=\"hljs-attribute\">width</span>: auto;\n   }\n}\n</code></div></pre>\n<p>一般网页布局中，让区域快在中间显示，两边留白，此时可以这样配置</p>\n<pre><div class=\"hljs\"><code class=\"lang-css\">@<span class=\"hljs-keyword\">media</span> screen and (min-width: <span class=\"hljs-number\">1200px</span>) {\n    <span class=\"hljs-selector-class\">.zhtTop</span> {\n        <span class=\"hljs-attribute\">width</span>: <span class=\"hljs-number\">1200px</span>;\n        <span class=\"hljs-attribute\">margin</span>: <span class=\"hljs-number\">0</span> auto ;\n    }\n}\n@<span class=\"hljs-keyword\">media</span> screen and (min-width: <span class=\"hljs-number\">992px</span>) and (max-width: <span class=\"hljs-number\">1200px</span>) {\n    <span class=\"hljs-selector-class\">.zhtTop</span> {\n        <span class=\"hljs-attribute\">width</span>: auto;\n    }\n}\n</code></div></pre>\n<p>上述代码表示， 在大于1200px的屏幕下，让块级元素长度变为1200px,左右自适应</p>\n<p>在小于1200px大于992px的屏幕下，让宽度自适应</p>\n<h2><a id=\"auto100_114\"></a>为什么这里用auto而不用100%呢？</h2>\n<p>这是因为</p>\n<h6><a id=\"AUTO_117\"></a>设置AUTO</h6>\n<blockquote>\n<p>不设置width、height时默认为auto，当position不同时显示效果不同，浮动可能会导致其不显示，需要清除浮动。</p>\n</blockquote>\n<blockquote>\n<p>width:auto表示宽度是可变动的，这个div的所有部分（content+margin+padding+border）相加为父元素的width大小，。</p>\n</blockquote>\n<blockquote>\n<p>如果块级元素设置了auto但是却没有显示有两种可能：</p>\n</blockquote>\n<blockquote>\n<p>cotent里没有能将其height支撑的子元素</p>\n</blockquote>\n<blockquote>\n<p>由于定位和浮动导致其不显示，清除浮动或修改定位</p>\n</blockquote>\n<h5><a id=\"100_130\"></a>设置100%</h5>\n<blockquote>\n<p>width、height强制将子元素充满父元素的content。</p>\n</blockquote>\n<blockquote>\n<p>%width:100%子元素的width值为父元素的width值，加margin时不改变子元素width值大小，而是溢出父元素。</p>\n</blockquote>\n<p>总结：auto与子元素有关，100%与父元素有关。以上。</p>\n','2020-01-05 12:27:34',3,'网页布局','网页布局','# CSS 语法\n```css\n@media mediatype and|not|only (media feature) {\n    CSS-Code;\n}\n```\n你也可以针对不同的媒体使用不同 stylesheets :\n\n\n```css\n<link rel=\"stylesheet\" media=\"mediatype and|not|only (media feature)\" href=\"mystylesheet.css\">\n```\nAPI\n  <table>\n    <tbody>\n    <tr>\n    <th>值</th>\n    <th>描述</th>\n    		</tr><tr><td>aspect-ratio</td>\n    			<td>定义输出设备中的页面可见区域宽度与高度的比率</td>\n    		</tr><tr><td>color</td>\n    			<td>定义输出设备每一组彩色原件的个数。如果不是彩色设备，则值等于0</td>\n    		</tr><tr><td>color-index</td>\n    			<td>定义在输出设备的彩色查询表中的条目数。如果没有使用彩色查询表，则值等于0</td>\n    		</tr><tr><td>device-aspect-ratio</td>\n    			<td>定义输出设备的屏幕可见宽度与高度的比率。</td>\n    		</tr><tr><td>device-height</td>\n    			<td>定义输出设备的屏幕可见高度。</td>\n    		</tr><tr><td>device-width</td>\n    			<td>定义输出设备的屏幕可见宽度。</td>\n    		</tr><tr><td>grid</td>\n    			<td>用来查询输出设备是否使用栅格或点阵。</td>\n    		</tr><tr><td>height</td>\n    			<td>定义输出设备中的页面可见区域高度。</td>\n    		</tr><tr><td>max-aspect-ratio</td>\n    			<td>定义输出设备的屏幕可见宽度与高度的最大比率。</td>\n    		</tr><tr><td>max-color</td>\n    			<td>定义输出设备每一组彩色原件的最大个数。</td>\n    		</tr><tr><td>max-color-index</td>\n    			<td>定义在输出设备的彩色查询表中的最大条目数。</td>\n    		</tr><tr><td>max-device-aspect-ratio</td>\n    			<td>定义输出设备的屏幕可见宽度与高度的最大比率。</td>\n    		</tr><tr><td>max-device-height</td>\n    			<td>定义输出设备的屏幕可见的最大高度。</td>\n    		</tr><tr><td>max-device-width</td>\n    			<td>定义输出设备的屏幕最大可见宽度。</td>\n    		</tr><tr><td>max-height</td>\n    			<td>定义输出设备中的页面最大可见区域高度。</td>\n    		</tr><tr><td>max-monochrome</td>\n    			<td>定义在一个单色框架缓冲区中每像素包含的最大单色原件个数。</td>\n    		</tr><tr><td>max-resolution</td>\n    			<td>定义设备的最大分辨率。</td>\n    		</tr><tr><td>max-width</td>\n    			<td>定义输出设备中的页面最大可见区域宽度。</td>\n    		</tr><tr><td>min-aspect-ratio</td>\n    			<td>定义输出设备中的页面可见区域宽度与高度的最小比率。</td>\n    		</tr><tr><td>min-color</td>\n    			<td>定义输出设备每一组彩色原件的最小个数。</td>\n    		</tr><tr><td>min-color-index</td>\n    			<td>定义在输出设备的彩色查询表中的最小条目数。</td>\n    		</tr><tr><td>min-device-aspect-ratio</td>\n    			<td>定义输出设备的屏幕可见宽度与高度的最小比率。</td>\n    		</tr><tr><td>min-device-width</td>\n    			<td>定义输出设备的屏幕最小可见宽度。</td>\n    		</tr><tr><td>min-device-height</td>\n    			<td>定义输出设备的屏幕的最小可见高度。</td>\n    		</tr><tr><td>min-height</td>\n    			<td>定义输出设备中的页面最小可见区域高度。</td>\n    		</tr><tr><td>min-monochrome</td>\n    			<td>定义在一个单色框架缓冲区中每像素包含的最小单色原件个数</td>\n    		</tr><tr><td>min-resolution</td>\n    			<td>定义设备的最小分辨率。</td>\n    		</tr><tr><td>min-width</td>\n    			<td>定义输出设备中的页面最小可见区域宽度。</td>\n    		</tr><tr><td>monochrome</td>\n    			<td>定义在一个单色框架缓冲区中每像素包含的单色原件个数。如果不是单色设备，则值等于0</td>\n    		</tr><tr><td>orientation</td>\n    			<td>定义输出设备中的页面可见区域高度是否大于或等于宽度。</td>\n    		</tr><tr><td>resolution</td>\n    			<td>定义设备的分辨率。如：96dpi, 300dpi, 118dpcm</td>\n    		</tr><tr><td>scan</td>\n    			<td>定义电视类设备的扫描工序。</td>\n    		</tr><tr><td>width</td>\n    			<td>定义输出设备中的页面可见区域宽度。</td>\n    		</tr></tbody></table>\n\n 可以使用多个and\n ```css\n@media screen and (min-width: 992px) and (max-width: 1200px) {\n    .zhtTop {\n        width: auto;\n    }\n}\n```\n\n一般网页布局中，让区域快在中间显示，两边留白，此时可以这样配置\n\n```css\n@media screen and (min-width: 1200px) {\n    .zhtTop {\n        width: 1200px;\n        margin: 0 auto ;\n    }\n}\n@media screen and (min-width: 992px) and (max-width: 1200px) {\n    .zhtTop {\n        width: auto;\n    }\n}\n```\n上述代码表示， 在大于1200px的屏幕下，让块级元素长度变为1200px,左右自适应\n\n在小于1200px大于992px的屏幕下，让宽度自适应\n\n## 为什么这里用auto而不用100%呢？\n这是因为\n\n###### 设置AUTO\n\n> 不设置width、height时默认为auto，当position不同时显示效果不同，浮动可能会导致其不显示，需要清除浮动。\n\n> width:auto表示宽度是可变动的，这个div的所有部分（content+margin+padding+border）相加为父元素的width大小，。\n\n> 如果块级元素设置了auto但是却没有显示有两种可能：\n\n>        cotent里没有能将其height支撑的子元素\n\n>         由于定位和浮动导致其不显示，清除浮动或修改定位\n\n\n#####  设置100%\n\n> width、height强制将子元素充满父元素的content。\n\n> %width:100%子元素的width值为父元素的width值，加margin时不改变子元素width值大小，而是溢出父元素。 \n\n总结：auto与子元素有关，100%与父元素有关。以上。 ','0',0);
/*!40000 ALTER TABLE `articls` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `categories`
--

DROP TABLE IF EXISTS `categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `categories` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '唯一ID',
  `categories` varchar(255) NOT NULL COMMENT '分类名称',
  `display` varchar(10) NOT NULL DEFAULT '\0' COMMENT '是否显示在主页',
  `num` int(10) NOT NULL COMMENT '文章数量',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `categories`
--

LOCK TABLES `categories` WRITE;
/*!40000 ALTER TABLE `categories` DISABLE KEYS */;
INSERT INTO `categories` VALUES (1,'axios','1',1),(2,'javascript','0',1),(3,'vue','1',6),(4,'webpack','1',13),(5,'网页布局','0',1);
/*!40000 ALTER TABLE `categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `draftsarticles`
--

DROP TABLE IF EXISTS `draftsarticles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `draftsarticles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL COMMENT '草稿箱标题',
  `creattime` datetime NOT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '创建时间',
  `markdown` varchar(5000) DEFAULT NULL COMMENT 'md格式文本',
  `tags` varchar(255) DEFAULT NULL COMMENT '标签，以‘ ，’分隔',
  `category` varchar(20) DEFAULT NULL COMMENT '分类',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `draftsarticles`
--

LOCK TABLES `draftsarticles` WRITE;
/*!40000 ALTER TABLE `draftsarticles` DISABLE KEYS */;
/*!40000 ALTER TABLE `draftsarticles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `iplimit`
--

DROP TABLE IF EXISTS `iplimit`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `iplimit` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `IP` varchar(20) NOT NULL,
  `category` varchar(5) NOT NULL COMMENT '"1"为白名单，“0”为黑名单',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `iplimit`
--

LOCK TABLES `iplimit` WRITE;
/*!40000 ALTER TABLE `iplimit` DISABLE KEYS */;
/*!40000 ALTER TABLE `iplimit` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `label`
--

DROP TABLE IF EXISTS `label`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `label` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `name` varchar(255) NOT NULL COMMENT '类别名称',
  `display` varchar(10) NOT NULL COMMENT '是否显示在主页上',
  `num` int(11) NOT NULL COMMENT '文章数',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `label`
--

LOCK TABLES `label` WRITE;
/*!40000 ALTER TABLE `label` DISABLE KEYS */;
INSERT INTO `label` VALUES (1,'axios','1',1),(2,'vue','1',7),(3,'es6','0',1),(4,'javascript','1',1),(5,'vuex','0',1),(6,'vue传值','0',1),(7,'webpack','1',13),(8,'网页布局','0',1);
/*!40000 ALTER TABLE `label` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `notice`
--

DROP TABLE IF EXISTS `notice`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `notice` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '唯一id',
  `notice` varchar(255) NOT NULL COMMENT '博客公告',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `notice`
--

LOCK TABLES `notice` WRITE;
/*!40000 ALTER TABLE `notice` DISABLE KEYS */;
INSERT INTO `notice` VALUES (1,'生活不只眼前的苟且，还有天空和大海。'),(2,'感谢访问本站，若喜欢请收藏 ^_^');
/*!40000 ALTER TABLE `notice` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `visitor`
--

DROP TABLE IF EXISTS `visitor`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `visitor` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ip` varchar(30) DEFAULT NULL,
  `intotime` datetime NOT NULL COMMENT '访客进入时间',
  `place` varchar(20) DEFAULT NULL COMMENT '访客所在地',
  `leavetime` datetime DEFAULT NULL COMMENT '访客离开时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=220 DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `visitor`
--

LOCK TABLES `visitor` WRITE;
/*!40000 ALTER TABLE `visitor` DISABLE KEYS */;
INSERT INTO `visitor` VALUES (210,'171.114.138.137','2020-01-05 11:42:44','湖北省','2020-01-05 11:45:04'),(211,'171.114.138.137','2020-01-05 11:45:05','湖北省','2020-01-05 11:58:05'),(212,'171.114.138.137','2020-01-05 12:01:20','湖北省','2020-01-05 12:17:55'),(213,'171.114.138.137','2020-01-05 12:17:55','湖北省','2020-01-05 12:24:50'),(214,'171.114.138.137','2020-01-05 12:24:51','湖北省','2020-01-05 12:26:01'),(215,'171.114.138.137','2020-01-05 12:26:02','湖北省','2020-01-05 12:26:26'),(216,'171.114.138.137','2020-01-05 12:27:24','湖北省','2020-01-05 12:27:34'),(217,'171.114.138.137','2020-01-05 12:27:34','湖北省','2020-01-05 12:28:14'),(218,'171.114.138.137','2020-01-05 12:28:14','湖北省','2020-01-05 12:28:16'),(219,'171.114.138.137','2020-01-05 12:28:16','湖北省',NULL);
/*!40000 ALTER TABLE `visitor` ENABLE KEYS */;
UNLOCK TABLES;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2020-01-05 12:28:40
