#include <lib/sync.h>
#include <kernel/thread.h>
#include <dev/console.h>

static lock console_lock;

void console_init() {
    lock_init(&console_lock);
}

void console_acquire() {
    lock_acquire(&console_lock);
}

void console_release() {
    lock_release(&console_lock);
}

void console_put_str(char* str) {
    console_acquire();
    puts(str);
    console_release();
}

void console_put_char(uint8_t ch) {
    console_acquire();
    putch(ch);
    console_release();
}

void console_put_int(uint32_t num) {
    console_acquire();
    put_int(num);
    console_release();
}