/*
// Definition for a Node.
class Node {
public:
  int val;
  vector<Node*> neighbors;
  Node() {
    val = 0;
    neighbors = vector<Node*>();
  }
  Node(int _val) {
    val = _val;
    neighbors = vector<Node*>();
  }
  Node(int _val, vector<Node*> _neighbors) {
    val = _val;
    neighbors = _neighbors;
  }
};
*/

class Solution {
  public:
    Node* cloneGraph(Node* node) {
      if (node == NULL) return NULL;
      if (vis.count(node)) return vis[node];

      Node* u = new Node(node->val);
      vis[node] = u;

      for (auto neighbor: node->neighbors)
        u->neighbors.push_back(cloneGraph(neighbor));

      return u;
    }

  private:
    unordered_map<Node*, Node*> vis;
};
