/**
 * Returns a list with nonPassive exceptions for the Turkish passive voice assessment.
 * @returns {Array}             The list with non-passive words
 */
const nonPassivesFullForms = [
	"kullanmak",
	"ulanmak",
	"bağlanmak",
	"alınmak",
	"boşanmak",
	"kaçınmak",
	"hazırlanmak",
	"olunmak",
	"sığınmak",
	"taşınmak",
	"arlanmak",
	"sakınmak",
	"zanmak",
	"tırmanmak",
	"i̇nanmak",
	"arınmak",
	"kullanmak",
	"isınmak",
	"yıkanmak",
	"öğrenmek",
	"öğrenmek",
	"düşünmek",
	"renmek",
	"düşünmek",
	"ünmek",
	"dönmek",
	"değinmek",
	"eğlenmek",
	"lenmek",
	"öğünmek",
	"deyinmek",
	"örenmek",
	"görünmek",
	"öğrenmek",
	"güvenmek",
	"beğenmek",
	"sünmek",
	"geçinmek",
	"tükenmek",
	"kabullenmek",
	"öğrenmek",
	"kabullenmek",
	"sinir",
	"peynir",
	"münir",
	"alınır",
	"kazanır",
	"yorumlanır",
	"kullanır",
	"uygulanır",
	"dayanır",
	"sağlanır",
	"i̇nanır",
	"özenir",
	"elenir",
	"öğrenir",
	"tersinir",
	"yaşanır",
	"toplanır",
	"tanır",
	"senir",
	"rastlanır",
	"renir",
	"münir",
	"kaynaklanır",
	"bağlanır",
	"hazırlanır",
	"güvenir",
	"enir",
	"söylenir",
	"başlanır",
	"davranır",
	"kapanır",
	"oynanır",
	"uzanır",
	"tanımlanır",
	"tanınır",
	"souvenir",
	"öğrenir",
	"taşınır",
	"konteyner",
	"uyanır",
	"beğenir",
	"hesaplanır",
	"sanır",
	"saklanır",
	"yakalanır",
	"aranır",
	"algılanır",
	"hoşlanır",
	"karşılanır",
	"tamamlanır",
	"münir",
	"yayınlanır",
	"yıkanır",
	"tekrarlanır",
	"atanır",
	"bir",
	"karasenir",
	"i̇ndüklenir",
	"zorlanır",
	"avenir",
	"erdenir",
	"kas-sinir",
	"utanır",
	"üstenir",
	"katlanır",
	"beyazpeynir",
	"şekillenir",
	"sonuçlanır",
	"doğranır",
	"narin",
	"faydalanır",
	"kilinir",
	"hızlanır",
	"yararlanır",
	"kutlanır",
	"saptanır",
	"nedendir",
	"kalınır",
	"ayarlanır",
	"kıskanır",
	"hastalanır",
	"suvenir",
	"yapılabilinir",
	"canlanır",
	"ekillenir",
	"hacklenir",
	"haşlanır",
	"sonuçlanır",
	"resetlenir",
	"beğenir",
	"açıklanır",
	"programming-sinir",
	"i̇sindir",
	"odaklanır",
	"pionir",
	"çalınır",
	"peynir",
	"tutuklanır",
	"sınır",
	"taşımalık",
	"anır",
	"kanır",
	"adanır",
	"lanır",
	"ültanır",
	"rastlanır",
	"haktanır",
	"güneysınır",
	"i̇nanır",
	"açılır-kapanır",
	"sağlanır",
	"tanrı tanır",
	"bağlanır",
	"tanır",
	"yansır",
	"kullanır",
	"açıklanır",
	"dizaynır",
	"düşünür",
	"görünür",
	"siyanür",
	"dünür",
	"düşünür",
	"ünür",
	"çürür",
	"ömür",
	"nür",
	"öğünür",
	"onur",
	"aynur",
	"i̇lknur",
	"ayşenur",
	"öznur",
	"konur",
	"binnur",
	"alinur",
	"gülnur",
	"hükmolunur",
	"atanur",
	"rıza nur",
	"yurdanur",
	"şennur",
	"fatmanur",
	"şennur",
	"zinnur",
	"adanur",
	"semanur",
	"elanur",
	"düşünür",
	"baykonur",
	"edanur",
	"göknur",
	"günnur",
	"beyzanur",
	"görünür",
	"nisanur",
	"saynur",
	"mecnur",
	"lunur",
	"stem",
	"cemalnur",
	"i̇lknur",
	"aynur",
	"elnur",
	"addolunur",
	"ayşenur",
	"birnur",
	"sedanur",
	"alanur",
	"esmanur",
	"elifnur",
	"şahnur",
	"aydanur",
	"senanur",
	"ecenur",
	"havvanur",
	"bozunur",
	"bennur",
	"en-nur",
	"tennur",
	"konur",
	"reddolunur",
	"sondur",
	"olunur",
	"şeymanur",
	"şerefnur",
	"fernur",
	"stem",
	"ceynur",
	"zeynur",
	"gökçenur",
	"mervenur",
	"ernur",
	"sonunur",
	"biyobozunur",
	"şemsinur",
	"haşrolunur",
	"incinur",
	"lanıyor",
	"kulanıyor",
	"nıyor",
	"rastlanıyor",
	"kullanıyor",
	"kaynaklanıyor",
	"kazanıyor",
	"yaşanıyor",
	"alınıyor",
	"i̇nanıyor",
	"tanıyor",
	"hazırlanıyor",
	"dayanıyor",
	"söyleniyor",
	"sanıyor",
	"uygulanıyor",
	"yanıyor",
	"eleniyor",
	"davranıyor",
	"aranıyor",
	"öğreniyor",
	"sağlanıyor",
	"kapanıyor",
	"zorlanıyor",
	"tanınıyor",
	"kombinleniyor",
	"yayınlanıyor",
	"oynanıyor",
	"beğeniyor",
	"uyanıyor",
	"planlanıyor",
	"toplanıyor",
	"reniyor",
	"niyor",
	"öğreniyor",
	"bağlanıyor",
	"uzanıyor",
	"algılanıyor",
	"söyleniyor",
	"tanımlanıyor",
	"vurgulanıyor",
	"karşılanıyor",
	"kınıyor",
	"saklanıyor",
	"başlanıyor",
	"yükleniyor",
	"sıralanıyor",
	"alındı",
	"kendi",
	"pazubandı",
	"nındı",
	"irgandı",
	"yapsındı",
	"yarabandı",
	"açıklandı",
	"bağlandı",
	"kendi",
	"efendi",
	"beyefendi",
	"hanımefendi",
	"i̇kindi",
	"hocaefendi",
	"hindi",
	"bindi",
	"gandi",
	"nakşibendi",
	"selendi",
	"beyefendi",
	"bondi",
	"alindi",
	"kazandı",
	"veliefendi",
	"hanendi",
	"hacklendi",
	"burundi",
	"kullandı",
	"i̇vrindi",
	"başlandı",
	"yasandı",
	"lendi",
	"yayınlandı",
	"andı",
	"merkezefendi",
	"demirhindi",
	"vivendi",
	"grandi",
	"ögrendi",
	"aczmendi",
	"mundi",
	"kapandı",
	"hanendi",
	"kandil",
	"i̇nsandı",
	"çinhindi",
	"randi",
	"yandı",
	"şimdi",
	"semerkant",
	"açıklandı",
	"ravalpindi",
	"tamamlandı",
	"kadınefendi",
	"landi",
	"brendi",
	"beğendi",
	"gecekondu",
	"hindu",
	"soundu",
	"katmandu",
	"kundu",
	"olsundu",
	"poundu",
	"katmandu",
	"duşundu",
	"emrolundu",
	"vahyolundu",
	"hindu",
	"lundu",
	"candu",
	"roundu",
	"göründü",
	"paundu",
	"fırdöndü",
	"düşündü",
	"fondü",
	"üründü",
	"gündöndü",
	"mumsöndü",
	"kendü",
	"i̇nanmış",
	"ınmış",
	"i̇spatlanmış",
	"nınmış",
	"bağlanmış",
	"hazırlanmış",
	"lenmiş",
	"hacklenmiş",
	"öğrenmiş",
	"i̇ndüklenmiş",
	"sinterlenmiş",
	"begenmiş",
	"alinmiş",
	"kombinlenmiş",
	"lânetlenmiş",
	"editlenmiş",
	"yenmiş",
	"temperlenmiş",
	"beyenmiş",
	"kazanmiş",
	"olsunmuş",
	"emrolunmuş",
	"lunmuş",
	"yunmuş",
	"özüdönmüş",
	"söylenecek",
	"düşünecek",
	"öğrenecek",
	"lenecek",
	"düşünecek",
	"düzenlenecek",
	"öğrenecek",
	"renecek",
	"nacak",
	"alınacak",
	"lanacak",
	"kazanmıştı",
	"lenmişti",
	"emrolunmuştu",
	"i̇nanıyordu",
	"kullanıyordu",
	"tanıyordu",
	"dayanıyordu",
	"görünüyordu",
	"düşünüyordu",
	"nuyordu",
	"düşünüyordu",
	"ünüyordu",
	"fransa",
	"floransa",
	"lufthansa",
	"prensa",
	"yakınsa",
	"konsa",
	"hansa",
	"sansa",
	"mensa",
	"türkiye-fransa",
	"türbülansa",
	"ofansa",
	"hiltonsa",
	"almanya-fransa",
	"yünsa",
	"jinsa",
	"ınsa",
	"nınsa",
	"winsa",
	"hünsa",
	"extensa",
	"demansa",
	"fıransa",
	"advansa",
	"tnsa",
	"ingiltere-fransa",
	"ambiyansa",
	"ünsa",
	"rönesansa",
	"cheonsa",
	"malpensa",
	"densa",
	"finanse",
	"ense",
	"lanse",
	"adsense",
	"response",
	"defense",
	"sübvanse",
	"pense",
	"intense",
	"expense",
	"alphonse",
	"kompanse",
	"mumkunse",
	"odense",
	"fluminense",
	"ninse",
	"offense",
	"intellisense",
	"nonsense",
	"anse",
	"pfsense",
	"immense",
	"gorunse",
	"hernedense",
	"danse",
	"mightyadsense",
	"hisense",
	"hortense",
	"adriaanse",
	"süspanse",
	"önmeli",
	"ögrenmeli",
	"taşınmaz",
	"kuşkonmaz",
	"sınmaz",
	"alınmaz",
	"taşınmaz",
	"lanmaz",
	"osanmaz",
	"hoşlanmaz",
	"sönmez",
	"dönmez",
	"bölünmez",
	"ersönmez",
	"dönmez",
	"görünmez",
	"üşenmez",
	"sönmez",
	"görünmez",
	"yinmez",
	"sönmez",
	"kullanmak",
	"bağlanmak",
	"boşanmak",
	"hazırlanmak",
	"öğrenmek",
	"öğrenmek",
	"renmek",
	"eğlenmek",
	"lenmek",
	"örenmek",
	"öğrenmek",
	"sığınmak",
	"değinmek",
	"deyinmek",
	"düşünmek",
	"erişilebilir",
	"güvenilir",
	"aktarabilecek",
];

const nonPassiveStems = [
	"sevi",
	"giyi",
	"gezi",
	"ayrı",
	"tıka",
	"ayrı",
	"sarı",
	"övü",
	"boşa",
	"besle",
	"kırı",
	"soyu",
	"yıka",
	"süsle",
	"içle",
	"besle",
	"tara",
	"çeki",
	"çözü",
	"hazırla",
	"üzü",
	"yıkı",
	"yıka",
	"kovu",
	"sıkı",
	"söyle",
	"kaçı",
	"kapa",
	"kası",
	"koru",
	"sarsı",
	"sığı",
	"kurula",
	"yakı",
	"yoru",
	"taşı",
	"uza",
	"takı",
	"yala",
	"atı",
	"iyileş",
	"sinirle",
	"dövü",
];

export {
	nonPassivesFullForms, nonPassiveStems,
};
