import { singleWords as transitionWords } from "./transitionWords";
import transformWordsWithHyphens from "../../../helpers/transform/transformWordsWithHyphens";

/**
 * Returns an array of Slovak function words.
 *
 * @returns {Array} The array filled with the function words.
 */
export const functionWords = [
	"to",
	"sa",
	"je",
	"si",
	"som",
	"a",
	"na",
	"že",
	"čo",
	"nie",
	"v",
	"ako",
	"tak",
	"ale",
	"by",
	"s",
	"mi",
	"o",
	"tu",
	"do",
	"ja",
	"sme",
	"ste",
	"áno",
	"z",
	"len",
	"ma",
	"už",
	"aby",
	"dobre",
	"ho",
	"keď",
	"ak",
	"ty",
	"ti",
	"za",
	"ťa",
	"bol",
	"pre",
	"sú",
	"tam",
	"prečo",
	"niečo",
	"toto",
	"no",
	"teraz",
	"aj",
	"hej",
	"mám",
	"byť",
	"ich",
	"bude",
	"ju",
	"takže",
	"ten",
	"všetko",
	"tom",
	"nič",
	"vás",
	"kde",
	"kto",
	"k",
	"po",
	"bolo",
	"bola",
	"ešte",
	"vám",
	"toho",
	"alebo",
	"jej",
	"má",
	"môj",
	"jeho",
	"máš",
	"viem",
	"vieš",
	"mňa",
	"tým",
	"veľmi",
	"mal",
	"prosím",
	"potom",
	"nikdy",
	"možno",
	"od",
	"nás",
	"ani",
	"so",
	"povedal",
	"chcem",
	"neviem",
	"mu",
	"ďakujem",
	"ísť",
	"vy",
	"naozaj",
	"stále",
	"teba",
	"pretože",
	"viac",
	"chceš",
	"oh",
	"nám",
	"ahoj",
	"on",
	"pred",
	"máme",
	"moja",
	"musím",
	"tie",
	"vo",
	"sem",
	"môžem",
	"dnes",
	"budem",
	"ktorý",
	"niekto",
	"práve",
	"pane",
	"mali",
	"pán",
	"poďme",
	"všetci",
	"pozri",
	"myslíš",
	"či",
	"mať",
	"nemôžem",
	"asi",
	"ktoré",
	"keby",
	"veľa",
	"vždy",
	"tiež",
	"moje",
	"poď",
	"mala",
	"stalo",
	"trochu",
	"my",
	"ľudia",
	"tomu",
	"pri",
	"deň",
	"máte",
	"tú",
	"musíme",
	"iba",
	"tvoj",
	"tento",
	"tá",
	"jeden",
	"bez",
	"chcel",
	"mohol",
	"veci",
	"zo",
	"robiť",
	"ide",
	"dobrý",
	"budeš",
	"ok",
	"mnou",
	"môže",
	"viete",
	"kým",
	"mne",
	"až",
	"presne",
	"môžeš",
	"dosť",
	"vážne",
	"preto",
	"dobré",
	"späť",
	"všetky",
	"tebou",
	"urobiť",
	"deje",
	"robíš",
	"vedieť",
	"prepáč",
	"vďaka",
	"však",
	"musíš",
	"povedala",
	"ona",
	"budeme",
	"nikto",
	"kvôli",
	"lebo",
	"teda",
	"vec",
	"nech",
	"hneď",
	"im",
	"každý",
	"svoje",
	"než",
	"kedy",
	"tvoja",
	"prepáčte",
	"nechcem",
	"rokov",
	"choď",
	"povedz",
	"potrebujem",
	"daj",
	"nemám",
	"svoju",
	"samozrejme",
	"raz",
	"chce",
	"takto",
	"také",
	"mohli",
	"preč",
	"ním",
	"nejaké",
	"idem",
	"spolu",
	"vlastne",
	"problém",
	"musí",
	"žiadne",
	"chcete",
	"vôbec",
	"lepšie",
	"vidieť",
	"môžeme",
	"urobil",
	"tvoje",
	"tebe",
	"dostať",
	"prišiel",
	"hovoriť",
	"vyzerá",
	"ktorá",
	"dlho",
	"kam",
	"niekedy",
	"von",
	"príliš",
	"nich",
	"sám",
	"celý",
	"úplne",
	"tej",
	"určite",
	"nuž",
	"môžete",
	"pod",
	"fajn",
	"váš",
	"seba",
	"aký",
	"nebude",
	"cez",
	"niekoho",
	"u",
	"všetkých",
	"aké",
	"majú",
	"mojej",
	"tých",
	"rýchlo",
	"taký",
	"istý",
	"znamená",
	"môjho",
	"tieto",
	"koľko",
	"predtým",
	"medzi",
	"dať",
	"tejto",
	"čom",
	"chcela",
	"neho",
	"ideme",
	"budú",
	"dva",
	"tri",
	"nebol",
	"nejaký",
	"svoj",
	"podľa",
	"mohla",
	"nájsť",
	"pani",
	"vaše",
	"budete",
	"ľúto",
	"pozrite",
	"zajtra",
	"moju",
	"hovorí",
	"ktorú",
	"túto",
	"hore",
	"dostal",
	"super",
	"ďalej",
	"naše",
	"vedel",
	"tomto",
	"náš",
	"chvíľu",
	"dal",
	"proste",
	"vie",
	"okej",
	"jedno",
	"pohode",
	"dole",
	"aspoň",
	"vaša",
	"nej",
	"táto",
	"jedna",
	"i",
	"oni",
	"robí",
	"poviem",
	"nemôžeš",
	"dve",
	"ku",
	"skôr",
	"ktorí",
	"radšej",
	"zlé",
	"páči",
	"nami",
	"dúfam",
	"skoro",
	"čože",
	"ňou",
	"nemá",
	"proti",
	"nemal",
	"neskôr",
	"jednu",
	"iné",
	"odtiaľto",
	"nad",
	"hovoril",
	"prvý",
	"vami",
	"svojho",
	"musíte",
	"zdá",
	"skvelé",
	"dobrá",
	"znova",
	"koho",
	"och",
	"minút",
	"sebe",
	"nebolo",
	"musieť",
	"nebudem",
	"okolo",
	"dvaja",
	"príde",
	"nemôže",
	"veľký",
	"vidíš",
	"prišli",
	"tohto",
	"ideš",
	"tvoju",
	"uvidíme",
	"celé",
	"sama",
	"haló",
	"čokoľvek",
	"nemáš",
	"musel",
	"jedného",
	"vrátiť",
	"buď",
	"potrebujeme",
	"taká",
	"nebola",
	"vonku",
	"spraviť",
	"prišla",
	"moc",
	"pokiaľ",
	"skutočne",
	"žiadny",
	"svojej",
	"dám",
	"malý",
	"pekne",
	"co",
	"ňu",
	"odísť",
	"nechať",
	"inak",
	"prísť",
	"zatiaľ",
	"vtedy",
	"najlepšie",
	"sebou",
	"celú",
	"možné",
	"povedali",
	"iste",
	"znovu",
	"dajte",
	"páni",
	"predsa",
	"dobrú",
	"čím",
	"istá",
	"ach",
	"dokonca",
	"videli",
	"žiť",
	"poďte",
	"niekde",
	"ďalší",
	"iný",
	"spôsob",
	"nemáme",
	"toľko",
	"ňom",
	"nemôžeme",
	"nový",
	"spravil",
	"robíte",
	"zle",
	"tvojej",
	"naša",
	"akoby",
	"robím",
	"pekné",
	"pôjdem",
	"cestu",
	"zase",
	"hodín",
	"nimi",
	"oci",
	"oči",
	"dá",
	"okrem",
	"chápem",
	"pripravený",
	"chceli",
	"konečne",
	"aká",
	"ano",
	"mojom",
	"mojich",
	"veľké",
	"priamo",
	"počas",
	"nechceš",
	"jediný",
	"týchto",
	"rozumiem",
	"zdravím",
	"môžu",
	"urobila",
	"mohlo",
	"nové",
	"robil",
	"chcú",
	"jednoducho",
	"choďte",
	"prípad",
	"mimo",
	"nepovedal",
	"isté",
	"neskoro",
	"povedzte",
	"tvojho",
	"dostali",
	"pravdepodobne",
	"vašu",
	"vecí",
	"svojich",
	"nechcel",
	"ďalšie",
	"ze",
	"nejakú",
	"týmto",
	"vziať",
	"dni",
	"jo",
	"päť",
	"nevieš",
	"odkiaľ",
	"malé",
	"mrzí",
	"našej",
	"ďaleko",
	"úžasné",
	"nemohol",
	"nevidel",
	"okay",
	"obaja",
	"všetkým",
	"dvoch",
	"nemali",
	"žiadna",
	"dní",
	"dr.",
	"nemala",
	"potrebovať",
	"zostať",
	"ktorého",
	"sam",
	"rovnako",
	"rokmi",
	"malo",
	"vyzeráš",
	"potrebuješ",
	"strane",
	"dňa",
	"jediná",
	"oveľa",
	"urobím",
	"ó",
	"zastaviť",
	"vašej",
	"nikoho",
	"najprv",
	"nevedel",
	"najlepší",
	"našich",
	"takmer",
	"čau",
	"dostala",
	"ktorých",
	"začal",
	"nemusíš",
	"opäť",
	"urobili",
	"ktorej",
	"aha",
	"stačí",
	"išiel",
	"zlý",
	"čase",
	"chceme",
	"začať",
	"moji",
	"niekoľko",
	"nevie",
	"povieš",
	"našu",
	"nemôžete",
	"naspäť",
	"pôjdeme",
	"štyri",
	"poznáš",
	"sveta",
	"robia",
	"chlape",
	"rozprávať",
	"spať",
	"pekný",
	"veľká",
	"nemáte",
	"nechce",
	"nakoniec",
	"ono",
	"mysli",
	"všade",
	"vzal",
	"blízko",
	"chcieť",
	"nášho",
	"akú",
	"vášho",
	"naposledy",
	"vidíte",
	"šiel",
	"odkedy",
	"neboli",
	"vedeli",
	"možnosť",
	"ah",
	"stať",
	"každého",
	"vnútri",
	"hodinu",
	"prvé",
	"vrátim",
	"menej",
	"nehovor",
	"nebudeš",
	"čakať",
	"urob",
	"žiaden",
	"um",
	"odtiaľ",
	"malá",
	"musela",
	"nejako",
	"okamžite",
	"mojou",
	"poslal",
	"prvá",
	"záleží",
	"iného",
	"ne",
	"ha",
	"skvelý",
	"čoho",
	"š",
	"new",
	"šťastie",
	"jedlo",
	"zmysel",
	"čoskoro",
	"snažím",
	"nechajte",
	"you",
	"treba",
	"hodiny",
	"ocko",
	"dala",
	"yeah",
	"nechal",
	"zomrel",
	"pracovať",
	"madam",
	"priatelia",
	"časť",
	"ruku",
	"počuť",
	"telefón",
	"krv",
	"zem",
	"chyba",
	"mesta",
	"správy",
	"práci",
	"charlie",
	"láska",
	"mesto",
	"jack",
	"strach",
	"volám",
	"školy",
	"kamoš",
	"našla",
	"neboj",
	"tvár",
	"počula",
	"syna",
	"zavolať",
	"zemi",
	"rodinu",
	"pamätáš",
	"polícia",
	"roku",
	"odišiel",
	"párty",
	"verím",
	"nerob",
	"skutočnosti",
	"meste",
	"zbrane",
	"dali",
	"auta",
	"cesty",
	"uveriť",
	"zistiť",
	"chlapče",
	"dcéra",
	"pána",
	"tou",
	"zavolám",
	"dievčatá",
	"volal",
	"vypadni",
	"myslieť",
	"šťastný",
	"radi",
	"chlapík",
	"hovorila",
	"tím",
	"hlavy",
	"nejde",
	"cesta",
	"jasne",
	"peňazí",
	"muži",
	"vrátil",
	"škole",
	"pol",
	"hovoríte",
	"večeru",
	"sex",
	"miesta",
	"druhý",
	"odo",
	"snažil",
	"michael",
	"sľubujem",
	"hovoria",
	"šéf",
	"žije",
	"zachrániť",
	"šesť",
	"nikomu",
	"rovno",
	"dostane",
	"dolu",
	"musia",
	"výborne",
	"posledný",
	"vezmi",
	"posledné",
	"jediné",
	"náhodou",
	"každú",
	"dávno",
	"začína",
	"jednej",
	"nevadí",
	"napríklad",
	"svojom",
	"mesiac",
	"dostanem",
	"zobrať",
	"tvojom",
	"zabudol",
	"môcť",
	"často",
	"existuje",
	"dostaneme",
	"povie",
	"celá",
	"druhej",
	"mimochodom",
	"žiadnu",
	"pôjde",
	"nejaká",
	"snáď",
	"nechcela",
	"mesiacov",
	"ostatní",
	"navždy",
	"desať",
	"museli",
	"urobíme",
	"horšie",
	"keďže",
	"sami",
	"najskôr",
	"robíme",
	"všetkom",
	"pozrime",
	"hovorili",
	"tvojich",
	"vezmem",
	"zober",
	"nedá",
	"trošku",
	"chvíľku",
	"ktorým",
	"nemu",
	"mojím",
	"lepší",
	"dáš",
	"sto",
	"dvadsať",
	"devätnásť",
	"osemnásť",
	"sedemnásť",
	"šestnásť",
	"dvakrát",
	"pätnásť",
	"štrnásť",
	"trinásty",
	"trinásť",
	"dvanásty",
	"dvanásť",
	"jedenásty",
	"jedenásť",
	"desiaty",
	"deviaty",
	"deväť",
	"ôsmy",
	"osem",
	"siedmy",
	"sedem",
	"šiesty",
	"piaty",
	"štvrtý",
	"tretí",
	"tí",
	"tými",
	"mojim",
	"môjmu",
	"mojimi",
	"nim",
	"ony",
	"akonáhle",
	"kedže",
	"hoci",
	"lenže",
	"nakoľko",
	"pokým",
	"tobôž",
	"čiže",
	"vedľa",
	"napriek",
	"nadol",
	"oproti",
	"plus",
	"nahor",
	"dvojslovné",
	"namiesto",
	"trojslovné",
	"navyše",
	"tamto",
	"včera",
	"nedávno",
	"ihneď",
	"kdekoľvek",
	"nikde",
	"celkom",
	"tvrdo",
	"pomaly",
	"opatrne",
	"ťažko",
	"sotva",
	"väčšinou",
	"absolútne",
	"spoločne",
	"osamote",
	"zvyčajne",
	"príležitostne",
	"zriedka",
	"tisíc",
	"milión",
];

export const all = transformWordsWithHyphens( functionWords.concat( transitionWords ) );
export default all;
