/**
 * Returns a list of non-participles which would incorrectly be recognized as participles if they weren't filtered.
 * @returns {Array} The list with non-participles.
 */
export default [
	"gebraad",
	"gemoed",
	"gebed",
	"gebied",
	"gebod",
	"gebodsbord",
	"geboorte-eiland",
	"geboortestad",
	"gebruikspaard",
	"gedachtewereld",
	"gedenkblad",
	"gedenknaald",
	"gedichtenwedstrijd",
	"gedoogakkoord",
	"gedoogbeleid",
	"geduld",
	"geestenwereld",
	"geesteskind",
	"geestestoestand",
	"geesteswereld",
	"gehandicaptenbeleid",
	"gehoorafstand",
	"gehoorsafstand",
	"geitenbaard",
	"geitenhuid",
	"geld",
	"geldhond",
	"geldvoorraad",
	"geleidehond",
	"gelijkekansenbeleid",
	"geloofsdaad",
	"geloofsinhoud",
	"geluidswand",
	"gelukskind",
	"gemeenschapsraad",
	"gemeentebeleid",
	"gemeenteraad",
	"gemeenteraadslid",
	"gemoedstoestand",
	"genadeverbond",
	"genderbeleid",
	"geneesmiddelenbeleid",
	"generaalsbewind",
	"geslachtsdaad",
	"gespreksavond",
	"gespreksflard",
	"getijdengebied",
	"gevangenisbeleid",
	"gevangeniswereld",
	"gevechtsafstand",
	"gevelwand",
	"gevoelstoestand",
	"gevoelswereld",
	"gewelddaad",
	"geweldigaard",
	"geweldverbod",
	"gezelschapshond",
	"gezichtsafstand",
	"gezichtshuid",
	"gezinsbeleid",
	"gezinsbond",
	"gezinshoofd",
	"gezinslid",
	"gezinspaard",
	"gezinstoestand",
	"gezondheidsbeleid",
	"gezondheidstoestand",
	"gezondheidszorgbeleid",
	"gecentreerd",
	"geserreerd",
	"gepolitoerd",
	"gebocheld",
	"gebrild",
	"gegleufd",
	"gekarteld",
	"gemeubeld",
	"gesausd",
	"geaccidenteerd",
	"geaccrediteerd",
	"geacheveerd",
	"geaderd",
	"geaggregeerd",
	"geagiteerd",
	"geallieerd",
	"geanimeerd",
	"geanticipeerd",
	"gearticuleerd",
	"geassorteerd",
	"gebenedijd",
	"gebiedend",
	"geblaseerd",
	"geblindeerd",
	"geborneerd",
	"gebronzeerd",
	"gebrouilleerd",
	"gebruind",
	"gecharmeerd",
	"gechromeerd",
	"geciviliseerd",
	"geclausuleerd",
	"gecoiffeerd",
	"geconditioneerd",
	"geconstipeerd",
	"gecontinueerd",
	"gecoöpteerd",
	"gecrispeerd",
	"gecultiveerd",
	"gedecideerd",
	"gedecolleteerd",
	"gedegouteerd",
	"gedemilitariseerd",
	"gedemodeerd",
	"gedesillusioneerd",
	"gedesinteresseerd",
	"gedetailleerd",
	"gediplomeerd",
	"gedisciplineerd",
	"gedisponeerd",
	"gedistingeerd",
	"gedomicilieerd",
	"gedoteerd",
	"gedupeerd",
	"geëigend",
	"geestdodend",
	"geestverruimend",
	"geëxalteerd",
	"geëxponeerd",
	"gefigureerd",
	"gefingeerd",
	"geflatteerd",
	"geforceerd",
	"gefumeerd",
	"gegeerd",
	"gegeneerd",
	"gegradueerd",
	"gegriepeerd",
	"gehaaid",
	"gehandschoend",
	"gehavend",
	"gehomologeerd",
	"gehorend",
	"geïllustreerd",
	"geïmponeerd",
	"geïmproviseerd",
	"geïncrimineerd",
	"geïrriteerd",
	"geklasseerd",
	"gekmakend",
	"gekuifd",
	"gekwalificeerd",
	"gelardeerd",
	"geldend",
	"geldverslindend",
	"geleed",
	"geleidend",
	"gelieerd",
	"geliefkoosd",
	"gelijkluidend",
	"gelinieerd",
	"geluiddempend",
	"geluidswerend",
	"geluidwerend",
	"gemarineerd",
	"gematteerd",
	"gemiddeld",
	"geoccupeerd",
	"geoutilleerd",
	"geparaffineerd",
	"geparfumeerd",
	"gepatenteerd",
	"gepermitteerd",
	"geplafonneerd",
	"geplisseerd",
	"gepredisponeerd",
	"geprefabriceerd",
	"gepreoccupeerd",
	"geproportioneerd",
	"geraffineerd",
	"gerandomiseerd",
	"gereformeerd",
	"gereglementeerd",
	"geresigneerd",
	"geresponsabiliseerd",
	"gerimpeld",
	"geringschattend",
	"geruchtmakend",
	"geruststellend",
	"gesatureerd",
	"gesauteerd",
	"geschakeerd",
	"gesepareerd",
	"geseponeerd",
	"gesofisticeerd",
	"gesoigneerd",
	"gespeend",
	"gespikkeld",
	"gestresseerd",
	"geurenblind",
	"gevergeerd",
	"geverseerd",
	"gezaghebbend",
	"gezagsondermijnend",
	"gezichtsbepalend",
	"gezinsvervangend",
	"gezwind",
	"geit",
	"gedragstherapeut",
	"geveltoerist",
	"gezant",
	"gerant",
	"gerst",
	"gerstenat",
	"geut",
	"gebarenkunst",
	"gebedsbijeenkomst",
	"gebekvecht",
	"gebiedsagent",
	"gebit",
	"geboorterecht",
	"gebruikersovereenkomst",
	"gebruiksrecht",
	"gebruiksvoorschrift",
	"gedragsvoorschrift",
	"geest",
	"geestdrift",
	"geesteskracht",
	"geestesproduct",
	"geestkracht",
	"gefluit",
	"gehandicaptensport",
	"geheimhoudingsplicht",
	"geheimschrift",
	"geheugenkunst",
	"gehoorapparaat",
	"geitenteelt",
	"gekloot",
	"geldautomaat",
	"geldingskracht",
	"geldingszucht",
	"geldkist",
	"geldmarkt",
	"geldmarkttekort",
	"geldpot",
	"geldsoort",
	"geldtekort",
	"geldtransport",
	"gelduitgifteautomaat",
	"geldzucht",
	"gelegenheidsargument",
	"geloofsgenoot",
	"geluidseffect",
	"geluidsoverlast",
	"geluidspoort",
	"gemaksproduct",
	"gemakzucht",
	"gemberpot",
	"gemeenschapsrecht",
	"gemeenteadvocaat",
	"gemeenteraadsbesluit",
	"gemeenterecht",
	"gemeentewet",
	"gemeentewiet",
	"gemoedsrust",
	"geneeskracht",
	"geneeskundestudent",
	"geneeskunst",
	"geneesmiddelenfabrikant",
	"geneesmiddelenmarkt",
	"generatieconflict",
	"generatiegenoot",
	"generatiepact",
	"generatiestudent",
	"genetkat",
	"genocidewet",
	"genot",
	"genotsproduct",
	"genotzucht",
	"gent",
	"geodeet",
	"geologiedocent",
	"gereedschapskist",
	"gerucht",
	"geruchtencircuit",
	"geschiedenisdocent",
	"geschiedenisstudent",
	"geschiet",
	"geschrift",
	"gespreksgenoot",
	"gesprekspunt",
	"getijdenkracht",
	"gevangenispoort",
	"gevecht",
	"gevechtskracht",
	"gevechtssport",
	"gevellijst",
	"gevelornament",
	"gewest",
	"gewetensangst",
	"gewetensconflict",
	"gewicht",
	"gewinzucht",
	"gewondentransport",
	"gewoonterecht",
	"gewricht",
	"gezagsapparaat",
	"gezinsbudget",
	"gezinsrapport",
	"gezondheidseffect",
	"gezondheidsklacht",
	"gezondheidsproduct",
	"gezondheidsrecht",
	"gezondheidswet",
	"gezondheidswinst",
	"gerokt",
	"gevlekt",
	"gebuikt",
	"gesaust",
	"gebiedsgericht",
	"geel-zwart",
	"gehandicapt",
	"gereformeerd-vrijgemaakt",
	"gestuikt",
	"geëtst",
	"bed",
	"bediendevakbond",
	"bedrijfsbeleid",
	"bedrijfsblad",
	"bedrijfspand",
	"bedrijfswereld",
	"bedrijvenbond",
	"beekdonderpad",
	"beeld",
	"beginselakkoord",
	"begintoestand",
	"begripsinhoud",
	"begrotingsakkoord",
	"begrotingsbeleid",
	"behandelaanbod",
	"beheerraad",
	"beheersgebied",
	"behoud",
	"beiaard",
	"bejaardenbeleid",
	"bekerwedstrijd",
	"belastinggebied",
	"belastinggeld",
	"belastingschuld",
	"beleggingsbeleid",
	"beleggingspand",
	"beleid",
	"beleidsdaad",
	"beleidsgebied",
	"belevingswereld",
	"belplafond",
	"beltegoed",
	"bemanningslid",
	"Bemiddelingsraad",
	"bendehoofd",
	"bendelid",
	"benedenstad",
	"benefietwedstrijd",
	"benoemingenbeleid",
	"benuttingsgraad",
	"berberpaard",
	"beregeningsverbod",
	"bergeend",
	"berggebied",
	"bergland",
	"bergpaard",
	"bergpad",
	"bergwand",
	"beroepsarbeid",
	"beroepsverbod",
	"beroepswereld",
	"beschermingsbeleid",
	"beschermingsgebied",
	"beslissingswedstrijd",
	"besparingsbeleid",
	"bestand",
	"bestandsakkoord",
	"besteleend",
	"besturenbond",
	"bestuursakkoord",
	"bestuursbeleid",
	"bestuurshoofd",
	"bestuurslid",
	"beukenblad",
	"beursmaand",
	"beursrecord",
	"beurswaakhond",
	"beurswereld",
	"beveiligingsbeleid",
	"bevolkingsbeleid",
	"bewind",
	"bewustzijnsinhoud",
	"bewustzijnstoestand",
	"bezuinigingsbeleid",
	"beenhard",
	"bebrild",
	"beangstigend",
	"bebaard",
	"bedeesd",
	"bederfwerend",
	"bedreigend",
	"bedrijvend",
	"bedroevend",
	"beduidend",
	"beduusd",
	"bedwelmend",
	"beeldbepalend",
	"beeldend",
	"beeldvormend",
	"beeldvullend",
	"begeleidend",
	"begerenswaard",
	"begrijpend",
	"behartenswaard",
	"behartigenswaard",
	"behoudend",
	"bejaard",
	"beklagenswaard",
	"beklemmend",
	"belanghebbend",
	"belangstellend",
	"belangwekkend",
	"belastingbesparend",
	"belastingbetalend",
	"beledigend",
	"beleerd",
	"beleidsadviserend",
	"belendend",
	"belerend",
	"bemoedigend",
	"benauwend",
	"benijdenswaard",
	"bepalend",
	"beperkend",
	"beregoed",
	"berekenend",
	"beroemd",
	"beroepsblind",
	"beschaamd",
	"beschamend",
	"beschouwend",
	"beschrijvend",
	"besdragend",
	"beslissend",
	"bestaand",
	"bestverkopend",
	"beteuterd",
	"betoverend",
	"betraand",
	"betreffend",
	"betreurenswaard",
	"bevelend",
	"bevelhebbend",
	"bevestigend",
	"bevoegd",
	"bevredigend",
	"bevreemdend",
	"bevriend",
	"bewonderenswaard",
	"bewustzijnsverruimend",
	"bezwarend",
	"beest",
	"berggeit",
	"betaalkracht",
	"beerput",
	"bergamot",
	"beschuit",
	"beademingsapparaat",
	"beddenfabrikant",
	"bedeltocht",
	"bedevaart",
	"bedevaartstocht",
	"bediendecontract",
	"bedieningsfout",
	"bedilzucht",
	"bedoeïenentent",
	"bedrijfsadvocaat",
	"bedrijfsfeest",
	"bedrijfsfysiotherapeut",
	"bedrijfsmanagement",
	"bedrijfsopbrengst",
	"bedrijfsrestaurant",
	"bedrijfsresultaat",
	"bedrijfssport",
	"bedrijfswinst",
	"bedrijvenmarkt",
	"bedrust",
	"beeldhouwkunst",
	"beeldmoment",
	"beeldrecht",
	"beeldsnijkunst",
	"beestenmarkt",
	"beet",
	"begeleidwonenproject",
	"beginnersfout",
	"beginpunt",
	"begrippenapparaat",
	"begrotingsdebat",
	"begrotingsrecht",
	"begrotingstekort",
	"behaagzucht",
	"behandelingsresultaat",
	"behoudzucht",
	"bejaardenpaspoort",
	"bekerplant",
	"bekerwinst",
	"beklagrecht",
	"beklemrecht",
	"belangenconflict",
	"belastingafdracht",
	"belastingbiljet",
	"belastingconsulent",
	"belastingdienst",
	"belastingexpert",
	"belastingopbrengst",
	"belastingplicht",
	"belastingrecht",
	"belastingspecialist",
	"belastingwet",
	"beleggersmarkt",
	"beleggingsexpert",
	"beleggingsmarkt",
	"beleggingsopbrengst",
	"beleggingsproduct",
	"beleggingsresultaat",
	"beleidsaspect",
	"beleidsdebat",
	"beleidsfout",
	"beleidsresultaat",
	"beleidsspecialist",
	"belevingsrestaurant",
	"belgicist",
	"belminuut",
	"beltegoedkaart",
	"bemoeizucht",
	"benefiet",
	"benefietconcert",
	"benoemingsbesluit",
	"benzinelucht",
	"benzinemarkt",
	"benzinetekort",
	"beoordelingsfout",
	"beoordelingsrapport",
	"berghut",
	"bergklimaat",
	"berglucht",
	"bergrit",
	"bergsport",
	"bergtijdrit",
	"bergtocht",
	"berichtendienst",
	"berkenhout",
	"bermmonument",
	"bermrecreant",
	"bermsloot",
	"bermtoerist",
	"beroepsdiplomaat",
	"beroepsernst",
	"beroepsfout",
	"beroepsgenoot",
	"beroepsjournalist",
	"beroepskracht",
	"beroepsrecht",
	"beroepssoldaat",
	"beroepssport",
	"berufsverbot",
	"beschermingsbesluit",
	"beschikkingsrecht",
	"beslismoment",
	"beslissingsrecht",
	"besluit",
	"bestaansrecht",
	"bestandsformaat",
	"bestelbiljet",
	"bestelkaart",
	"bestuursapparaat",
	"bestuursassistent",
	"bestuursbesluit",
	"bestuursconflict",
	"bestuurskracht",
	"bestuurskundedocent",
	"bestuursmandaat",
	"bestuursprocesrecht",
	"bestuursrecht",
	"betaalautomaat",
	"betaaldienst",
	"betaalkaart",
	"betaalopdracht",
	"betalingsbalanstekort",
	"betalingsopdracht",
	"bètastudent",
	"beterschapskaart",
	"betrouwbaarheidsrit",
	"beukenhout",
	"beursapparaat",
	"beursklimaat",
	"beurskrant",
	"beursmarkt",
	"beursstudent",
	"beurt",
	"beverrat",
	"bevoegdheidsconflict",
	"bevrijdingsconcert",
	"bevrijdingsfeest",
	"bewaarplicht",
	"bewegingsapparaat",
	"bewegingsdocent",
	"bewegingskunst",
	"bewijskracht",
	"bewijsrecht",
	"bewustwordingsproject",
	"bezemkast",
	"bezit",
	"bezitsrecht",
	"bezoekrecht",
	"bezuinigingsdrift",
	"bezuinigingsopdracht",
	"bezwaarschrift",
	"beroepsgericht",
	"bedompt",
	"bedrijfsgericht",
	"beginselvast",
	"beleidsgericht",
	"bewolkt",
	"bezweet",
	"verbeterblad",
	"verband",
	"verbeeldingswereld",
	"verbod",
	"verbodsbord",
	"verbond",
	"verdwaalarmband",
	"verdwijnwoord",
	"verenigingsblad",
	"verenigingslid",
	"verfhuid",
	"vergismoord",
	"vergunningenbeleid",
	"verhalenpad",
	"verhalenwedstrijd",
	"verkeersaanbod",
	"verkeersbeleid",
	"verkeersbord",
	"verkiezingsavond",
	"verkleinwoord",
	"verkoopbeleid",
	"verkoopverbod",
	"vernieuwingsbeleid",
	"verpleeghuisbed",
	"verraad",
	"verschijningsverbod",
	"verstand",
	"vertoningsverbod",
	"vertrekbeleid",
	"vervalmaand",
	"vervoerbeleid",
	"vervoersaanbod",
	"vervoersbeleid",
	"vervoersbond",
	"vervoersverbod",
	"vervolgingsbeleid",
	"verwijderingsbeleid",
	"verzamelbeleid",
	"verzekeringswereld",
	"verzetsdaad",
	"verzetsheld",
	"verzuimbeleid",
	"verdragend",
	"verkeersremmend",
	"verbazend",
	"verbazingwekkend",
	"verbijsterend",
	"verblindend",
	"verbluffend",
	"verbouwereerd",
	"verdaagd",
	"verdedigend",
	"verdovend",
	"vereend",
	"verfrissend",
	"vergelijkend",
	"verhalend",
	"verheffend",
	"verheugend",
	"verkikkerd",
	"verklarend",
	"verkwikkend",
	"verkwistend",
	"verlammend",
	"verlangend",
	"verliesgevend",
	"verlieslatend",
	"verlieslijdend",
	"verlokkend",
	"verlossend",
	"vermeend",
	"vermeldenswaard",
	"vermeldingswaard",
	"vermoeiend",
	"vermogend",
	"vernederend",
	"vernietigend",
	"verontrustend",
	"verpletterend",
	"verrassend",
	"verscheurend",
	"verschillend",
	"verslaafd",
	"verspringend",
	"verstikkend",
	"verstrekkend",
	"verstrooid",
	"vertederend",
	"vertrouwenwekkend",
	"vertwijfeld",
	"vervelend",
	"verwaand",
	"verwarrend",
	"verwoestend",
	"verzachtend",
	"verziend",
	"verzoenend",
	"verwant",
	"verantwoordingsplicht",
	"verbandkist",
	"verbeeldingskracht",
	"verbintenissenrecht",
	"verblijfsrecht",
	"verbrandingsproduct",
	"verbroederingsfeest",
	"verdedigingsfout",
	"verdragsrecht",
	"verdriet",
	"verdringingseffect",
	"veredelingsproduct",
	"verenigingsrecht",
	"verffabrikant",
	"verfpot",
	"verfrest",
	"vergiet",
	"vergoedingslimiet",
	"vergrotingsapparaat",
	"vergunningplicht",
	"verhaalsrecht",
	"verhuiskist",
	"verhuurboot",
	"verjaardagsfeest",
	"verjaardagsgast",
	"verjaardagstaart",
	"verjaarfeest",
	"verjaringsfeest",
	"verkeersagent",
	"verkeersinfarct",
	"verkeersmanagement",
	"verkeersmarkt",
	"verkeersoverlast",
	"verkeerswet",
	"verkenningstocht",
	"verkiezingsbijeenkomst",
	"verkiezingsbiljet",
	"verkiezingsdebat",
	"verkiezingsinkt",
	"verkiezingsresultaat",
	"verkiezingswinst",
	"verkleedkist",
	"verkoopapparaat",
	"verkoopargument",
	"verkoopopbrengst",
	"verkoopopdracht",
	"verkooprecht",
	"verkoopresultaat",
	"verkopersmarkt",
	"verlatingsangst",
	"verlovingsfeest",
	"verminderingskaart",
	"vermogensrecht",
	"vermogenstekort",
	"vermogenswinst",
	"vernielzucht",
	"vernietigingskracht",
	"vernieuwingsdebat",
	"vernieuwingsproject",
	"veroveringstocht",
	"veroveringszucht",
	"verpleegassistent",
	"verrassingseffect",
	"verrassingsfeest",
	"verrijkingsmarkt",
	"verruimingskandidaat",
	"verschoningsrecht",
	"verschot",
	"versproduct",
	"versterfrecht",
	"vertaalfout",
	"vertaalproject",
	"vertaalrecht",
	"vertebraat",
	"vertegenwoordigingsrecht",
	"vervangingsmarkt",
	"vervoersmanagement",
	"vervoersmarkt",
	"vervolgbijeenkomst",
	"vervolgingsapparaat",
	"vervolgopdracht",
	"vervolgproject",
	"vervreemdingseffect",
	"verwijt",
	"verzakingsrecht",
	"verzamelkrant",
	"verzekeringsagent",
	"verzekeringsmarkt",
	"verzekeringsproduct",
	"verzekeringsrecht",
	"verzekeringsresultaat",
	"verzetskrant",
	"verzoeningsbijeenkomst",
	"verzorgingsproduct",
	"slingerpad",
	"avondgebed",
	"bibbergeld",
	"dageraad",
	"drinkgeld",
	"kalfsgebraad",
	"leefgeld",
	"ochtendgebed",
	"ongelukskind",
	"vluggerd",
	"voltigeerpaard",
	"voltigepaard",
	"aandachtsgebied",
	"aanlijngebod",
	"aardbevingsgebied",
	"abonnementsgeld",
	"achtergrondgeluid",
	"achterstandsgebied",
	"actiegebied",
	"afzetgebied",
	"akkerbouwgebied",
	"alpengebied",
	"amazonegebied",
	"ambtsgebied",
	"ambtsgewaad",
	"antigeluid",
	"aspergebed",
	"autonomiegebied",
	"baggereiland",
	"bangerd",
	"bijgeluid",
	"bijstandsgeld",
	"binnenduingebied",
	"blindengeleidehond",
	"blowgebodsbord",
	"boezemgebied",
	"bongerd",
	"bosgebied",
	"bridgeavond",
	"bridgebond",
	"bridgewedstrijd",
	"broedgebied",
	"brongebied",
	"budgetbeleid",
	"burgerbewind",
	"centrumgebied",
	"collegelid",
	"computergebied",
	"concentratiegebied",
	"conceptregeerakkoord",
	"concessiegebied",
	"conflictgebied",
	"contactgeluid",
	"crisisgebied",
	"cultuurgebied",
	"dankgebed",
	"deelgebied",
	"deelnemingenbeleid",
	"deltagebied",
	"deskundigheidsgebied",
	"dierengeluid",
	"doelgebied",
	"doodsgewaad",
	"doorgangsgebied",
	"dopgeld",
	"douanegebied",
	"drempelgeld",
	"driekoningenavond",
	"duinengebied",
	"duingebied",
	"eigendomsvoorbehoud",
	"energiegebied",
	"engerd",
	"eurogebied",
	"feestgewaad",
	"filmgebied",
	"foerageergebied",
	"formuliergebed",
	"frequentiegebied",
	"frontgebied",
	"functioneringsgebied",
	"gangenpaard",
	"gitaargeluid",
	"gitaargeweld",
	"golfgebied",
	"golflengtegebied",
	"graangebied",
	"grachtengebied",
	"grensgebied",
	"groeigebied",
	"groengebied",
	"groepsgeluid",
	"groepsgeweld",
	"grondgebied",
	"grondwaterbeschermingsgebied",
	"haflingerpaard",
	"handelsgebied",
	"havengebied",
	"heidegebied",
	"helikoptergeld",
	"herkomstgebied",
	"herwaarderingsgebied",
	"hogedrukgebied",
	"hogeronderwijsbeleid",
	"hongersnood",
	"hoogveengebied",
	"ICT-gebied",
	"immigratiegebied",
	"inburgeringsbeleid",
	"indicatiegebied",
	"industriegebied",
	"ingeland",
	"inkomgeld",
	"interessegebied",
	"jachtgebied",
	"jagershond",
	"jongerenbeleid",
	"jongerenblad",
	"kantorengebied",
	"kassengebied",
	"keelgeluid",
	"kennisgebied",
	"kerngebied",
	"kernwinkelgebied",
	"kijkgeld",
	"kindergeld",
	"kleigebied",
	"kloostergewaad",
	"knipooggeweld",
	"kogelwond",
	"koorgebed",
	"krapgeldbeleid",
	"krijgsgeweld",
	"krimpgebied",
	"kruisgebed",
	"kunstgebied",
	"kustgebied",
	"kwelgebied",
	"lagedrukgebied",
	"landbouwgebied",
	"langeafstandspaard",
	"langebaanwedstrijd",
	"langetermijnbeleid",
	"leefgebied",
	"leergebied",
	"leerstofgebied",
	"legerpaard",
	"legervoorraad",
	"levensgebied",
	"lidgeld",
	"logeerbed",
	"luchtvaartgebied",
	"luistergeld",
	"machtsgebied",
	"managementbeleid",
	"mandaatgebied",
	"manegepaard",
	"marktgebied",
	"mededelingenblad",
	"mededelingenbord",
	"mediageweld",
	"merengebied",
	"middaggebed",
	"middengebied",
	"mijngebied",
	"milieubeschermingsgebied",
	"milieugebied",
	"misgewaad",
	"missiegebied",
	"modegebied",
	"moerasgebied",
	"morgengebed",
	"Morgenland",
	"morgenstond",
	"moslimgebied",
	"motorgeluid",
	"muilkorfgebod",
	"nachtgewaad",
	"nagelbed",
	"natuurbeschermingsgebied",
	"natuurgebied",
	"natuurgeweld",
	"natuurontwikkelingsgebied",
	"NAVO-gebied",
	"NAVO-grondgebied",
	"nederzettingenbeleid",
	"neerslaggebied",
	"negerkind",
	"no-gogebied",
	"noodgebied",
	"noordpoolgebied",
	"Noordzeegebied",
	"oceaangebied",
	"octrooigebied",
	"oefengebied",
	"oerwoudgeluid",
	"oliegebied",
	"omgevingsbeleid",
	"omgevingsgeluid",
	"onderwijsgebied",
	"onderzoeksgebied",
	"onrustgebied",
	"ontwikkelingsgebied",
	"oorlogsgebied",
	"oorlogsgeweld",
	"oorsprongsgebied",
	"operatiegebied",
	"opleidingenaanbod",
	"opmarsgebied",
	"overgangsgebied",
	"overlastgebied",
	"overstromingsgebied",
	"overwinteringsgebied",
	"paaigebied",
	"partnergeweld",
	"ploegenwedstrijd",
	"poldergebied",
	"politiegeweld",
	"potpoldergebied",
	"presentiegeld",
	"priestergewaad",
	"regeerakkoord",
	"regelafstand",
	"regenboogkind",
	"regenboogzebrapad",
	"regenwoud",
	"regeringsaanbod",
	"regeringsbeleid",
	"regeringsraad",
	"regeringsstad",
	"reizigersaanbod",
	"richtingenstrijd",
	"roggebrood",
	"rouwgewaad",
	"rugzakgeld",
	"rustgebied",
	"rustgeld",
	"sabotagedaad",
	"samenwerkingsgebied",
	"schandegeld",
	"Schengenakkoord",
	"schietgebed",
	"schoolgeld",
	"servicegeweld",
	"slangenhuid",
	"sleutelgeld",
	"slotgebed",
	"smeekgebed",
	"smeergeldstad",
	"spaargeld",
	"spanningsgebied",
	"spiegelbeeld",
	"spiegelwand",
	"sportgebied",
	"spraakgeluid",
	"stemgeluid",
	"stiltegebied",
	"stoelgeld",
	"stormgeweld",
	"straatgeluid",
	"straatgeweld",
	"strafschopgebied",
	"supportersgeweld",
	"taalgebied",
	"tegelpad",
	"tegelwand",
	"tegenbod",
	"tegengeluid",
	"tegengeweld",
	"tegenspoed",
	"tegenwind",
	"televisiegeweld",
	"tussengebied",
	"uitgaansgeweld",
	"uitgeefbeleid",
	"uitgeversverbond",
	"uitgeverswereld",
	"ultrageluid",
	"vaargebied",
	"vagebond",
	"vakantiegeld",
	"veertigurengebed",
	"vegetariërsbond",
	"vingerhoed",
	"vliegtuiggeluid",
	"vluchtelingenbeleid",
	"voetbalgeweld",
	"vogelgeluid",
	"vogelwereld",
	"volksgezondheidsbeleid",
	"voorzieningenaanbod",
	"vormgevingsbeleid",
	"vredesgeluid",
	"vreemdelingenbeleid",
	"vrijdaggebed",
	"vrijgezellenavond",
	"vrijwilligersbeleid",
	"vuurwapengeweld",
	"wapengeweld",
	"waterbergingsgebied",
	"watergebied",
	"watergeweld",
	"werkgelegenheidsbeleid",
	"werkgeversaanbod",
	"werkgeversbond",
	"werkgeversverbond",
	"wetgevingsbeleid",
	"wiegenkind",
	"wijngebied",
	"wintersportgebied",
	"wisselgeld",
	"woestijngebied",
	"zakgeld",
	"zangersbond",
	"zeegebied",
	"zeehavengebied",
	"ziektegeld",
	"zigeunerkind",
	"zigeunerpaard",
	"zondegeld",
	"zorgenkind",
	"zwangerschapsmaand",
	"zwijggeld",
	"agent",
	"afgezant",
	"dirigent",
	"echtgenoot",
	"morgendienst",
	"apologeet",
	"budgetsupermarkt",
	"burgerdienst",
	"changement",
	"dorpsgenoot",
	"huisgenoot",
	"krankzinnigengesticht",
	"muggenbeet",
	"nagerecht",
	"omgevingsportret",
	"politieagent",
	"tijgerkat",
	"tussengerecht",
	"vogelmijt",
	"voorgerecht",
	"wegenwacht",
	"wegenzout",
	"wijkagent",
	"wisselagent",
	"zeegezicht",
	"zorgbudget",
	"aankoopbudget",
	"aardappelgerecht",
	"accountmanagement",
	"achterhoedegevecht",
	"adoptieagent",
	"advertentiebudget",
	"afspiegelingskabinet",
	"agendahedonist",
	"algemenebijstandswet",
	"amandelgeest",
	"ambtenarengerecht",
	"apengezicht",
	"arbeidsgerecht",
	"aspergerobot",
	"aspergeteelt",
	"assetmanagement",
	"baggerboot",
	"baggermarkt",
	"baggeropdracht",
	"baggerproject",
	"baggerschuit",
	"baggervloot",
	"balkanvergeet-mij-niet",
	"barricadegevecht",
	"bijgerecht",
	"boemerangeffect",
	"bouwmanagement",
	"bovengebit",
	"branchegenoot",
	"bridgejournalist",
	"bridgesport",
	"budget",
	"budgetrecht",
	"budgettekort",
	"bugnugget",
	"burgemeestersambt",
	"burgemeesterspost",
	"burgerdocent",
	"burgerplicht",
	"burgerpot",
	"burgerpresident",
	"burgerrecht",
	"burgerschapsrecht",
	"buurtagent",
	"buurtgenoot",
	"capaciteitsmanagement",
	"casemanagement",
	"celgenoot",
	"chef-dirigent",
	"CIA-agent",
	"clubgenoot",
	"coalitiegenoot",
	"collectiemanagement",
	"collegebesluit",
	"collegekaart",
	"collegestudent",
	"competentiemanagement",
	"crisismanagement",
	"defensiebudget",
	"depannagedienst",
	"deskundigenrapport",
	"disgenoot",
	"dopingexpert",
	"draagvleugelboot",
	"dreigement",
	"driekoningenfeest",
	"dubbelagent",
	"dwerggeit",
	"eerstgeboorterecht",
	"eigendomsrecht",
	"elftalgenoot",
	"enkelgewricht",
	"etalageruit",
	"ex-agent",
	"ex-echtgenoot",
	"exploitatiebudget",
	"FBI-agent",
	"fractiegenoot",
	"gadget",
	"garagepoort",
	"glogetuigschrift",
	"groentegerecht",
	"groentenugget",
	"grondgevecht",
	"halfgeleiderfabrikant",
	"halsgerecht",
	"halsgewricht",
	"hamburgerrestaurant",
	"hamburgertent",
	"handelsagent",
	"handgewricht",
	"hanengevecht",
	"hengelsport",
	"hersengadget",
	"heupgewricht",
	"hogeschooldocent",
	"hogeschoolstudent",
	"hokjesgeest",
	"hondengevecht",
	"hoofdagent",
	"hoofdgerecht",
	"horlogekast",
	"hotelmanagement",
	"huishoudbudget",
	"hulpagent",
	"huwelijksvermogensrecht",
	"inburgeringsplicht",
	"inburgeringstraject",
	"informatiemanagement",
	"ingenieursdienst",
	"ingenieursstudent",
	"inlichtingenrapport",
	"interim-management",
	"internetevangelist",
	"investeringsbudget",
	"inzagerecht",
	"jaarbudget",
	"jongerenkrant",
	"jongerenpaspoort",
	"kaakgewricht",
	"kaasgerecht",
	"kaasnugget",
	"kalfsgehakt",
	"kamergenoot",
	"kant-en-klaargerecht",
	"kantongerecht",
	"kennismanagement",
	"kipnugget",
	"klasgenoot",
	"kniegewricht",
	"kogelgewricht",
	"kooigevecht",
	"kredietmanagement",
	"kroegentocht",
	"kruidnagelsigaret",
	"kunstbudget",
	"kunstgeschiedenisdocent",
	"kunstgeschiedenisstudent",
	"kunstmanagement",
	"kussengevecht",
	"kwaliteitsmanagement",
	"kwelgeest",
	"lamsgehakt",
	"langetermijneffect",
	"leeftijdgenoot",
	"leeftijdsgenoot",
	"legercommandant",
	"legerdienst",
	"legerkrant",
	"legerpredikant",
	"legertent",
	"lievelingsgerecht",
	"logeergast",
	"lotgenotencontact",
	"loungerestaurant",
	"low budget",
	"lozingenbesluit",
	"luchtagent",
	"luchtgevecht",
	"lunchgerecht",
	"macrobudget",
	"management",
	"managementfout",
	"melkgeit",
	"mens-erger-je-niet",
	"mergelgrot",
	"milieumanagement",
	"miljoenenbudget",
	"mobiliteitsbudget",
	"moddergevecht",
	"monumentenbudget",
	"morgenlicht",
	"morgenpost",
	"motoragent",
	"muggenbult",
	"narcotica-agent",
	"NAVO-bondgenoot",
	"negerhut",
	"nepagent",
	"nugget",
	"ondergebit",
	"onderwijsbudget",
	"onderwijsmanagement",
	"onderzoeksbudget",
	"onderzoeksgerecht",
	"on-en-minvermogenkaart",
	"ongevallenwet",
	"onteigeningswet",
	"orgelconcert",
	"orgeldocent",
	"orgelkast",
	"overheidsbudget",
	"overheidsmanagement",
	"overnamegevecht",
	"overnemingsgevecht",
	"paardengebit",
	"passagebiljet",
	"pastagerecht",
	"persagent",
	"personeelsbudget",
	"personeelsmanagement",
	"plaggenhut",
	"ploegentijdrit",
	"pluimgewicht",
	"politiebudget",
	"polsgewricht",
	"postzegelformaat",
	"prestigeproject",
	"prins-regent",
	"procesmanagement",
	"productiebudget",
	"projectmanagement",
	"pseudovogelpest",
	"publiciteitsagent",
	"raffinageproduct",
	"reclamebudget",
	"reegeit",
	"regeerambt",
	"regelzucht",
	"regenboogtricot",
	"regenput",
	"regent",
	"regentaat",
	"regenwaterput",
	"regeringsapparaat",
	"regeringsbesluit",
	"regeringsbudget",
	"regeringskrant",
	"regeringsrapport",
	"regeringssoldaat",
	"reisagent",
	"reisbudget",
	"restauratiebudget",
	"rijksbudget",
	"rijstgerecht",
	"risicomanagement",
	"röntgenapparaat",
	"ruggenmergsvocht",
	"rundergehakt",
	"scharniergewricht",
	"scheidsgerecht",
	"schijngevecht",
	"schimmengevecht",
	"schoolagent",
	"schoolbegeleidingsdienst",
	"schoolgenoot",
	"schoolwijkagent",
	"schoudergewricht",
	"sergeant",
	"slangenbeet",
	"slangenhout",
	"slingerplant",
	"slowfoodgerecht",
	"soortgenoot",
	"spiegelgevecht",
	"spiegelkast",
	"spiegelruit",
	"spiegelschrift",
	"spiegeltent",
	"spinazienugget",
	"sportmanagement",
	"spronggewricht",
	"stagedocent",
	"stageopdracht",
	"stagerapport",
	"stierengevecht",
	"straatgevecht",
	"streekgerecht",
	"stressmanagement",
	"studentenbudget",
	"subsidiebudget",
	"taalgenoot",
	"tafelgenoot",
	"tafelgenot",
	"teamgeest",
	"tegenargument",
	"tegeneffect",
	"tegenkracht",
	"tentoonstellingsbudget",
	"tijdgeest",
	"tijdgenoot",
	"tijdmanagement",
	"tijdsgewricht",
	"tijgerpunt",
	"timemanagement",
	"titanengevecht",
	"titelgevecht",
	"topdirigent",
	"topmanagement",
	"totaalbudget",
	"totaalgewicht",
	"tweegevecht",
	"tweevingertest",
	"twintigeurobiljet",
	"undercoveragent",
	"urgentierecht",
	"veiligheidsagent",
	"veiligheidsarrangement",
	"veiligheidsmanagement",
	"vijftigeurobiljet",
	"vingerplant",
	"visgerecht",
	"visnugget",
	"vleesgerecht",
	"vleugelboot",
	"vliegenkast",
	"vliegerfeest",
	"vluchtelingenrecht",
	"vluchtelingentransport",
	"VN-gezant",
	"vogelmarkt",
	"vogeltjesmarkt",
	"vogelvangst",
	"vogelvlucht",
	"volksgericht",
	"voorlichtingsbudget",
	"vrachtwagenfabrikant",
	"vrachtwagenmarkt",
	"vragersmarkt",
	"vredegerecht",
	"vreemdelingenangst",
	"vreemdelingenbesluit",
	"vreemdelingendebat",
	"vreemdelingenrecht",
	"vreemdelingenstemrecht",
	"vuistgevecht",
	"vuurgevecht",
	"watergeest",
	"watergevecht",
	"watermanagement",
	"wegenbouwproject",
	"wereldtitelgevecht",
	"werkgelegenheidseffect",
	"werkgelegenheidsproject",
	"werkingsbudget",
	"wervelgewricht",
	"wetenschapsbudget",
	"wetgevingsproject",
	"wintergerst",
	"wintergezicht",
	"wrevelagent",
	"zadelgewricht",
	"zagevent",
	"zanger-componist",
	"zanger-gitarist",
	"zangerscast",
	"zangvogelsport",
	"zeegevecht",
	"zegelrecht",
	"zegetocht",
	"zelfmanagement",
	"ziekenhuisbudget",
	"zwangerschapstest",
	"goedgevuld",
	"aangebrand",
	"welgevuld",
	"afgeborsteld",
	"donkergekleurd",
	"goedgevormd",
	"welgevormd",
	"allesverzengend",
	"bontgekleurd",
	"doorgewinterd",
	"goedgehumeurd",
	"goedgeluimd",
	"goedgezind",
	"haatdragend",
	"kegeldragend",
	"lichtgekleurd",
	"nagelbijtend",
	"ongekleurd",
	"ongemanierd",
	"ongeverfd",
	"rentedragend",
	"risicodragend",
	"roodgekleurd",
	"slechtgehumeurd",
	"slechtgezind",
	"vruchtdragend",
	"welgemanierd",
	"welgezind",
	"welopgevoed",
	"woldragend",
	"zaaddragend",
	"zorgdragend",
	"aanbodgestuurd",
	"aangehuwd",
	"aangetekend",
	"aangetrouwd",
	"aanliggend",
	"aanmatigend",
	"aanvoegend",
	"achtereenvolgend",
	"achterliggend",
	"afgewend",
	"allesdoordringend",
	"allesvernietigend",
	"alleszeggend",
	"almogend",
	"alvermogend",
	"angstaanjagend",
	"bijstandsgerechtigd",
	"bloeddrukverhogend",
	"bloeddrukverlagend",
	"bloemdragend",
	"braakliggend",
	"brandvertragend",
	"breedgerand",
	"brildragend",
	"cholesterolverlagend",
	"christelijk-gereformeerd",
	"computergestuurd",
	"diepliggend",
	"doodgemoedereerd",
	"doordringend",
	"doorslaggevend",
	"dreigend",
	"drempelverlagend",
	"dringend",
	"dwingend",
	"eerstvolgend",
	"eierleggend",
	"Engelssprekend",
	"ergerniswekkend",
	"felgekleurd",
	"godtergend",
	"goedgekleed",
	"goedgemanierd",
	"goudgerand",
	"grensverleggend",
	"handenwringend",
	"hemeltergend",
	"hiernavolgend",
	"hogergenoemd",
	"hoogdringend",
	"hoopgevend",
	"indringend",
	"ingebeeld",
	"ingekankerd",
	"ingekeerd",
	"ingenaaid",
	"ingewikkeld",
	"ingeworteld",
	"intrigerend",
	"knoldragend",
	"kogelwerend",
	"laaggeletterd",
	"leidinggevend",
	"levensbedreigend",
	"levensbeëindigend",
	"levensverlengend",
	"lichtgevend",
	"lichtgewond",
	"liggend",
	"losliggend",
	"maatgevend",
	"meedogend",
	"minvermogend",
	"moedgevend",
	"naastliggend",
	"navolgend",
	"neerbuigend",
	"niet-geleidend",
	"nietszeggend",
	"normgevend",
	"oergezond",
	"omliggend",
	"onaangediend",
	"onbevredigend",
	"ondergewaardeerd",
	"onderliggend",
	"ondeugend",
	"ongeaccepteerd",
	"ongeanimeerd",
	"ongearticuleerd",
	"ongeautoriseerd",
	"ongecensureerd",
	"ongeciviliseerd",
	"ongeclausuleerd",
	"ongecompliceerd",
	"ongeconcentreerd",
	"ongeconditioneerd",
	"ongecontroleerd",
	"ongecoördineerd",
	"ongecorrigeerd",
	"ongecultiveerd",
	"ongedateerd",
	"ongedefinieerd",
	"ongedifferentieerd",
	"ongediplomeerd",
	"ongedisciplineerd",
	"ongedoubleerd",
	"ongeëmancipeerd",
	"ongeëmotioneerd",
	"ongeforceerd",
	"ongefrankeerd",
	"ongefundeerd",
	"ongegeneerd",
	"ongehavend",
	"ongehonoreerd",
	"ongeïdentificeerd",
	"ongeïnformeerd",
	"ongeïnspireerd",
	"ongeïnteresseerd",
	"ongekend",
	"ongekwalificeerd",
	"ongeleerd",
	"ongelimiteerd",
	"ongelinieerd",
	"ongematteerd",
	"ongemeend",
	"ongemeubileerd",
	"ongemonteerd",
	"ongemotiveerd",
	"ongemotoriseerd",
	"ongenuanceerd",
	"ongeoefend",
	"ongeopend",
	"ongeordend",
	"ongeorganiseerd",
	"ongepaneerd",
	"ongepermitteerd",
	"ongeprepareerd",
	"ongepubliceerd",
	"ongeraffineerd",
	"ongerealiseerd",
	"ongeregistreerd",
	"ongereglementeerd",
	"ongereguleerd",
	"ongesigneerd",
	"ongespecificeerd",
	"ongestoffeerd",
	"ongestructureerd",
	"ongestudeerd",
	"ongesubsidieerd",
	"ongevaccineerd",
	"ongewapend",
	"onsamenhangend",
	"onuitgenodigd",
	"onuitgevoerd",
	"onvermogend",
	"onwelgezind",
	"opeenvolgend",
	"opvliegend",
	"opvolgend",
	"orthodox-gereformeerd",
	"overtuigend",
	"overwegend",
	"overweldigend",
	"plaatsvervangend",
	"prangend",
	"raadgevend",
	"redengevend",
	"rentegevend",
	"rolbevestigend",
	"roodgeverfd",
	"rustgevend",
	"samenhangend",
	"schermdragend",
	"schrikaanjagend",
	"slechtgekleed",
	"sneldrogend",
	"statusverhogend",
	"stilzwijgend",
	"supergezond",
	"tegemoetkomend",
	"tergend",
	"toegevend",
	"toonaangevend",
	"tussenliggend",
	"uitdagend",
	"uitgekiend",
	"uitgeregend",
	"uitgerekend",
	"uitnodigend",
	"vakoverstijgend",
	"veelzeggend",
	"vigerend",
	"vleesvervangend",
	"vliegend",
	"volgend",
	"voorbijgestreefd",
	"vraaggestuurd",
	"vreesaanjagend",
	"Wajonggerechtigd",
	"waterbergend",
	"watergekoeld",
	"welgekend",
	"welgemeend",
	"werkgelegenheidsbevorderend",
	"wetgevend",
	"winstgevend",
	"witgehandschoend",
	"witgepleisterd",
	"witgeschilderd",
	"witgeverfd",
	"zelfcorrigerend",
	"zelfdragend",
	"zelfreinigend",
	"zelfvernietigend",
	"zelfverzorgend",
	"zieltogend",
	"zingevend",
	"zoetgeurend",
	"zogenaamd",
	"zogenoemd",
	"zwaargehavend",
	"zwaargewapend",
	"zwaargewond",
	"zwaarwegend",
	"zwartgeverfd",
	"zwijgend",
	"doelgericht",
	"ontwikkelingsgericht",
	"zwartgerokt",
	"arbeidsmarktgericht",
	"functiegericht",
	"goedgemutst",
	"kindgericht",
	"aanbodgericht",
	"aangedampt",
	"actiegericht",
	"arbeidsongeschikt",
	"brongericht",
	"buurtgericht",
	"cliëntgericht",
	"competentiegericht",
	"consumentgericht",
	"divergent",
	"doelgroepgericht",
	"doodongerust",
	"effectgericht",
	"ervaringsgericht",
	"exportgericht",
	"groepsgericht",
	"ingemaakt",
	"ingeroest",
	"innovatiegericht",
	"intelligent",
	"klantgericht",
	"kortgerokt",
	"maatschappijgericht",
	"marktgericht",
	"mensgericht",
	"nagelvast",
	"natuurgericht",
	"niet-gericht",
	"ongekuist",
	"ongericht",
	"onuitgebracht",
	"onuitgepakt",
	"onuitgewerkt",
	"oplossingsgericht",
	"persoonsgericht",
	"praktijkgericht",
	"prestatiegericht",
	"probleemgericht",
	"procesgericht",
	"productgericht",
	"publieksgericht",
	"resultaatgericht",
	"roodgelakt",
	"taakgericht",
	"themagericht",
	"toekomstgericht",
	"toepassingsgericht",
	"vakgericht",
	"voortgezet",
	"vraaggericht",
	"wijkgericht",
	"witgekalkt",
	"witgelakt",
	"zelfgemaakt",
	"zwartgelakt",
	"morgennacht",
	"negenduizend",
	"negenentwintigduizend",
	"negenhonderd",
	"negenhonderdduizend",
	"negentienduizend",
	"negentienhonderd",
	"negentigduizend",
	"morgenochtend",
	"desgevallend",
	"morgenavond",
	"zogezegd",
	"nergensland",
	"ontbijtbord",
	"onthaalbeleid",
	"onthaalkind",
	"ontmoedigingsbeleid",
	"ontmoetingsavond",
	"ontwapeningsakkoord",
	"ontwerpakkoord",
	"ontwerplandbouwakkoord",
	"ontwerpwedstrijd",
	"ontwikkelingsbeleid",
	"ontwikkelingshulpbeleid",
	"ontwikkelingsland",
	"ontbeend",
	"ontbrekend",
	"onthullend",
	"onthutsend",
	"ontkennend",
	"ontluisterend",
	"ontoereikend",
	"ontslagnemend",
	"ontsmettend",
	"ontspannend",
	"ontstekingsremmend",
	"ontstellend",
	"ontwapenend",
	"ontwijkend",
	"ontwikkeld",
	"ontzagwekkend",
	"ontzettend",
	"ontbijt",
	"onthardingszout",
	"ontzet",
	"ontbijtbuffet",
	"ontbindingsrecht",
	"ontdekkingstocht",
	"onterecht",
	"ontkoppelingsbesluit",
	"ontmijningsdienst",
	"ontslagbesluit",
	"ontslagdecreet",
	"ontslagrecht",
	"ontvangst",
	"ontwerpbesluit",
	"ontwerpfout",
	"ontwerpgrondwet",
	"ontwerpopdracht",
	"ontwerprapport",
	"ontwerpwet",
	"ontwikkelingspot",
	"ontwikkelingsproject",
	"herdershond",
	"herenakkoord",
	"herenblad",
	"herfstavond",
	"herfstblad",
	"herfstdraad",
	"herfstmaand",
	"herfstochtend",
	"herfstwind",
	"herkeuringsraad",
	"heroïnehond",
	"herseninhoud",
	"herstelbeleid",
	"hervormingsbeleid",
	"herfst",
	"hermafrodiet",
	"hert",
	"heraut",
	"herfstlucht",
	"heraanplant",
	"herdenkingsbijeenkomst",
	"herdenkingsconcert",
	"herdenkingsfeest",
	"heremietkreeft",
	"herfstnacht",
	"herfsttint",
	"herinneringskunst",
	"herkomst",
	"heroïnespuit",
	"heroïnetransport",
	"heroïnevangst",
	"herroepingsrecht",
	"hersenkracht",
	"hersenvlucht",
	"hersenvocht",
	"hersteldienst",
	"herstelrecht",
	"hervormingsproject",
	"erwt",
	"ernst",
	"erbovenuit",
	"ereambt",
	"eregast",
	"erepunt",
	"erfenisrecht",
	"erfrecht",
	"ergotherapeut",
	"ernaast",
	"eronderuit",
	"eropuit",
	"ertussenuit",
	"eruit",
	"ervanuit",
	"erytrocyt",
	"eredivisiewedstrijd",
	"erelid",
	"erfgoedbeleid",
	"erkenningsbeleid",
	"errond",
	"ervaringswereld",
	"gebaart",
	"gebeurt",
	"gebiedt",
	"gebood",
	"gedenkt",
	"gedraagt",
	"geeuwt",
	"gehoorzamt",
	"geilt",
	"geldt",
	"geelt",
	"gelooft",
	"geneest",
	"geniet",
	"genoot",
	"gerust",
	"geurt",
	"geeft",
	"besnuffelt",
	"bedeelt",
	"bedelt",
	"bekeert",
	"beugelt",
	"beamt",
	"beantwoordt",
	"beargumenteert",
	"beatblogt",
	"becijfert",
	"becommentariërt",
	"beconcurreert",
	"bedaart",
	"bedelft",
	"bedenkt",
	"bederft",
	"bedient",
	"bediscussiërt",
	"bedoelt",
	"bedraagt",
	"bedreigt",
	"bedriegt",
	"bedrijft",
	"bedroeft",
	"bedwingt",
	"beëindigt",
	"beeldbelt",
	"beetneemt",
	"beft",
	"begaat",
	"begeleidt",
	"begeert",
	"begeeft",
	"begint",
	"begraaft",
	"begrijpt",
	"begroeit",
	"behaalt",
	"behandelt",
	"behangt",
	"beheert",
	"behoedt",
	"behoeft",
	"behoort",
	"behoudt",
	"beïnvloedt",
	"bekent",
	"bekeurt",
	"bekijkt",
	"beklaagt",
	"bekleedt",
	"beklemt",
	"beklimt",
	"bekomt",
	"bekritiseert",
	"bekroont",
	"belandt",
	"beledigt",
	"belegt",
	"belemmert",
	"beleeft",
	"belt",
	"beloont",
	"belooft",
	"belparkeert",
	"beluistert",
	"bemeesteert",
	"bemeubelt",
	"bemoedigt",
	"bemoeit",
	"benadert",
	"benauwt",
	"beneemt",
	"bengelt",
	"benieuwt",
	"benoemt",
	"beogt",
	"beoordeelt",
	"bepaalt",
	"bepoteelt",
	"bereidt",
	"berekent",
	"berooft",
	"beschaamt",
	"beschaaft",
	"beschermt",
	"beschildert",
	"beschouwt",
	"beschrijft",
	"beschuldigt",
	"beslaat",
	"besloot",
	"besnijdt",
	"bespaart",
	"bespeurt",
	"bespioneert",
	"bespreekt",
	"bespringt",
	"bestaat",
	"bestempelt",
	"bestrijdt",
	"bestreed",
	"bestudeert",
	"bestuurt",
	"beswaffeelt",
	"betekent",
	"betert",
	"betont",
	"betonneert",
	"betovert",
	"betreedt",
	"betreft",
	"betrekt",
	"betreurt",
	"betwijfelt",
	"beult",
	"bevalt",
	"beeft",
	"bevindt",
	"bevoordeliigt",
	"bevordert",
	"bevraagt",
	"bevriest",
	"bewapent",
	"beweert",
	"bewijst",
	"bewondert",
	"bewoont",
	"bewonersparkeert",
	"bezaait",
	"bezeert",
	"beziet",
	"bezat",
	"bezoekt",
	"bezorgt",
	"bezuinigt",
	"bezweert",
	"verlaat",
	"verliet",
	"verschaalt",
	"verspringt",
	"vertelt",
	"veraangenaamt",
	"verabsoluteert",
	"verachtvoudiigt",
	"veradeemt",
	"verafgoodt",
	"verafschuwt",
	"veralgemeent",
	"verandert",
	"verankert",
	"verantwoordt",
	"verarmt",
	"verbabbelt",
	"verbaliseert",
	"verbant",
	"verbaast",
	"verbeeldt",
	"verbeidt",
	"verbergt",
	"verbetert",
	"verbeuzelt",
	"verbiedt",
	"verbood",
	"verbijstert",
	"verbindt",
	"verblijft",
	"verblindt",
	"verbouwt",
	"verbrandt",
	"verbreekt",
	"verdappert",
	"verdedigt",
	"verdeelt",
	"verdenkt",
	"verdient",
	"verdort",
	"verdooft",
	"verdraait",
	"verdraagt",
	"verdrijft",
	"verdringt",
	"verdrinkt",
	"verdroogt",
	"verdubbelt",
	"verdwaalt",
	"verdwijnt",
	"vereenvoudigt",
	"vet",
	"verenigt",
	"vereert",
	"vergaat",
	"vergadeert",
	"vergelijkt",
	"vergt",
	"vergeet",
	"vergat",
	"vergeeft",
	"vergiftigt",
	"vergoedt",
	"vergrendelt",
	"verhaalt",
	"verhangt",
	"verheldert",
	"verheugt",
	"verhindert",
	"verhoogt",
	"verhongert",
	"verhoudt",
	"verhuist",
	"verhuurt",
	"verifiërt",
	"verjaagt",
	"verkent",
	"verkeert",
	"verkiest",
	"verklaart",
	"verkleedt",
	"verkleint",
	"verkleurt",
	"verknoeit",
	"verkoopt",
	"verkreukelt",
	"verkrijgt",
	"verlaagt",
	"verlamt",
	"verlangt",
	"verleidt",
	"verleent",
	"verlengt",
	"verliest",
	"verloocheent",
	"verloopt",
	"verlooft",
	"verluiert",
	"verlummelt",
	"vermagert",
	"vermaalt",
	"vermangelt",
	"vermeldt",
	"vermengt",
	"vermenigvuldigt",
	"vermijdt",
	"vermindert",
	"vermoedt",
	"vermoeit",
	"vermolmt",
	"vermomt",
	"vermoordt",
	"vernauwt",
	"verneemt",
	"vernevelt",
	"vernielt",
	"vernietigt",
	"vernieuwt",
	"vernikkelt",
	"vernoemt",
	"vernummert",
	"veronaangenaamt",
	"veronachtzaamt",
	"veronderstelt",
	"verontheiliigt",
	"verontreinigt",
	"verontschuldigt",
	"veroordeelt",
	"veroorlooft",
	"verootmoediigt",
	"veropenbaart",
	"verordonneert",
	"verovert",
	"verpandt",
	"verpaupert",
	"verpietert",
	"verplegt",
	"verplettert",
	"verpulvert",
	"verraadt",
	"verried",
	"verrechtvaardiigt",
	"verregeent",
	"verreist",
	"verrekeent",
	"verrijdt",
	"verrijst",
	"verroert",
	"verrolt",
	"verronselt",
	"verruigt",
	"verruilt",
	"verruuwt",
	"verscheurt",
	"verschijnt",
	"verschilt",
	"verschimmelt",
	"verschoont",
	"verschraalt",
	"verschrijft",
	"verschroeit",
	"verschrompelt",
	"verschuilt",
	"versiert",
	"versimpelt",
	"versjachert",
	"versjouwt",
	"verslaat",
	"verslechtert",
	"versleutelt",
	"verslijt",
	"versleet",
	"verslindt",
	"verslond",
	"versluiert",
	"versluist",
	"versmaadt",
	"versmalt",
	"versmoort",
	"versnelt",
	"versnijdt",
	"versnippert",
	"versobert",
	"versoepelt",
	"versombert",
	"verspeelt",
	"verspeent",
	"verspert",
	"verspiedt",
	"verspilt",
	"verspint",
	"versplintert",
	"verspreidt",
	"verstaat",
	"verstond",
	"verstaalt",
	"verstart",
	"verstelt",
	"versteent",
	"versterft",
	"versteviigt",
	"verstijft",
	"verstilt",
	"verstomt",
	"verstoort",
	"verstoot",
	"verstiet",
	"verstouwt",
	"verstramt",
	"verstrengt",
	"verstrijkt",
	"verstrooit",
	"verstuift",
	"verstuurt",
	"verstuuwt",
	"versuikert",
	"versukkelt",
	"vertaalt",
	"vertedert",
	"vertegenwoordigt",
	"vertekeent",
	"verteert",
	"vertienvoudiigt",
	"vertilt",
	"vertimmert",
	"vertint",
	"vertoeft",
	"vertoont",
	"vertoornt",
	"vertraagt",
	"vertreedt",
	"vertroebelt",
	"vertroetelt",
	"vertrouwt",
	"vertwijfelt",
	"vervaagt",
	"vervaalt",
	"vervalt",
	"vervangt",
	"vervelt",
	"verft",
	"verveent",
	"verviervoudiigt",
	"vervijfvoudiigt",
	"vervliegt",
	"vervloeit",
	"vervluchtiigt",
	"vervoedeert",
	"vervoegt",
	"vervoert",
	"vervolgt",
	"vervollediigt",
	"vervordert",
	"vervormt",
	"vervreemdt",
	"vervroegt",
	"vervuilt",
	"vervult",
	"verwaait",
	"verwaardiigt",
	"verwaarloost",
	"verwarmt",
	"verwart",
	"verwaseemt",
	"verwatert",
	"verwedt",
	"verwelkoomt",
	"verweert",
	"verwerpt",
	"verwerft",
	"verweeft",
	"verwijdt",
	"verwijdert",
	"verwijlt",
	"verwijft",
	"verwikkelt",
	"verwildert",
	"verwint",
	"verwintert",
	"verwisselt",
	"verwittiigt",
	"verwondt",
	"verwondert",
	"verwoont",
	"verwoordt",
	"verwringt",
	"verwurgt",
	"verzaagt",
	"verzandt",
	"verzegelt",
	"verzegt",
	"verzeilt",
	"verzekert",
	"verzelfstandiigt",
	"verzendt",
	"verzengt",
	"verzesvoudiigt",
	"verzilvert",
	"verzinnebeeldt",
	"verzint",
	"verzoekt",
	"verzoent",
	"verzoolt",
	"verzuilt",
	"verzuurt",
	"verzusteert",
	"verzwagert",
	"verzwaart",
	"verzwelgt",
	"verzwendelt",
	"verzweert",
	"verzwijgt",
	"ontbiedt",
	"ontbood",
	"ontbeet",
	"ontbindt",
	"ontbolstert",
	"ontbraamt",
	"ontbreekt",
	"ontcijfert",
	"ontdoet",
	"ontdeed",
	"ontdooit",
	"ontdubbelt",
	"onteert",
	"onterft",
	"ontgaat",
	"ontgeldt",
	"ontglijdt",
	"ontgloeit",
	"ontgraaft",
	"ontgrendelt",
	"ontgroeit",
	"ontgroent",
	"onthaalt",
	"onthalst",
	"onthardt",
	"onthaart",
	"ontheft",
	"ontheiligt",
	"onthoofdt",
	"onthoudt",
	"onthield",
	"onthult",
	"ontkent",
	"ontketeent",
	"ontkiemt",
	"ontkleurt",
	"ontkoomt",
	"ontkoppelt",
	"ontlaadt",
	"ontleent",
	"ontleert",
	"ontloopt",
	"ontluist",
	"ontmengt",
	"ontmijnt",
	"ontmoedigt",
	"ontmythologiseert",
	"ontneemt",
	"ontradicaliseert",
	"ontroert",
	"ontrommeelt",
	"ontruimt",
	"ontslaat",
	"ontspant",
	"ontspult",
	"ontstaat",
	"ontstond",
	"ontsteekt",
	"ontvangt",
	"ontvoert",
	"ontvolgt",
	"ontvoogdt",
	"ontvriendt",
	"ontvriest",
	"ontwerpt",
	"ontwijkt",
	"ontwikkelt",
	"ontzwavelt",
	"herdenkt",
	"herdacht",
	"ergert",
	"ekent",
	"eruitzit",
	"ervaart",
	"erft",
];

