/**
 * Returns a list of all participles used for the Italian passive voice assessment.
 * For each participle, versions for all four possible suffixes (-o, -a, -e, -i) are included.
 * @returns {Array} The list with participles.
 */
export default [
	"abalienat",
	"abbacchiat",
	"abbacinat",
	"abbadat",
	"abbagliat",
	"abbaiat",
	"abballat",
	"abbambinat",
	"abbancat",
	"abbandonat",
	"abbarbagliat",
	"abbarbat",
	"abbarcat",
	"abbaruffat",
	"abbassat",
	"abbatacchiat",
	"abbattut",
	"abbatuffolat",
	"abbelit",
	"abbellat",
	"abbellit",
	"abbendat",
	"abbeverat",
	"abbiadat",
	"abbicat",
	"abbigliat",
	"abbinat",
	"abbindolat",
	"abbioccat",
	"abbiosciat",
	"abbisciat",
	"abbittat",
	"abboccat",
	"abboffat",
	"abbominat",
	"abbonacciat",
	"abbonat",
	"abbonit",
	"abbordat",
	"abborracciat",
	"abborrat",
	"abborrit",
	"abbottinat",
	"abbottonat",
	"abbozzacchiat",
	"abbozzat",
	"abbozzolat",
	"abbracciat",
	"abbraciat",
	"abbrancat",
	"abbreviat",
	"abbriccat",
	"abbrigliat",
	"abbrivat",
	"abbriviat",
	"abbrividit",
	"abbronzat",
	"abbrostolat",
	"abbrostolit",
	"abbruciacchiat",
	"abbruciat",
	"abbrunat",
	"abbrunit",
	"abbruscat",
	"abbrusciat",
	"abbrustiat",
	"abbrustolat",
	"abbrustolit",
	"abbrutit",
	"abbruttit",
	"abbuffat",
	"abbuiat",
	"abbuonat",
	"abburattat",
	"abbuzzit",
	"abdicat",
	"abdott",
	"abiettat",
	"abilitat",
	"abissat",
	"abitat",
	"abituat",
	"abiurat",
	"abolit",
	"abominat",
	"abondat",
	"aborrit",
	"abortit",
	"abras",
	"abrogat",
	"abusat",
	"accaffat",
	"accagionat",
	"accagliat",
	"accalappiat",
	"accalcat",
	"accaldat",
	"accallat",
	"accalorat",
	"accalorit",
	"accambiat",
	"accampat",
	"accampionat",
	"accanalat",
	"accanat",
	"accaneggiat",
	"accanit",
	"accantonat",
	"accaparrat",
	"accapezzat",
	"accapigliat",
	"accapottat",
	"accappiat",
	"accappiettat",
	"accapponat",
	"accappucciat",
	"accaprettat",
	"accareggiat",
	"accarezzat",
	"accarnat",
	"accarpionat",
	"accartocciat",
	"accasat",
	"accasciat",
	"accasellat",
	"accasermat",
	"accastellat",
	"accastellinat",
	"accatarrat",
	"accatastat",
	"accattat",
	"accattivat",
	"accavalcat",
	"accavalciat",
	"accavallat",
	"accavezzat",
	"accecat",
	"acceffat",
	"accelerat",
	"accellerat",
	"accennat",
	"accensat",
	"accentat",
	"accentrat",
	"accentuat",
	"acceppat",
	"accerchiat",
	"accercinat",
	"accertat",
	"acces",
	"accessoriat",
	"accettat",
	"acchetat",
	"acchiappat",
	"acchiocciolat",
	"acchitat",
	"acchiudut",
	"acciabattat",
	"acciaiat",
	"acciambellat",
	"acciarpat",
	"acciecat",
	"accigliat",
	"acciglionat",
	"accignut",
	"accincignat",
	"accint",
	"acciocchit",
	"acciottolat",
	"accipigliat",
	"accismat",
	"accis",
	"acciucchit",
	"acciuffat",
	"accivettat",
	"acclamat",
	"acclarat",
	"acclimatat",
	"acclus",
	"accoccat",
	"accoccolat",
	"accoccovat",
	"accodat",
	"accollat",
	"accoltellat",
	"accolt",
	"accomandat",
	"accomiatat",
	"accommiatat",
	"accomodat",
	"accompagnat",
	"accomunat",
	"acconciat",
	"acconigliat",
	"accontat",
	"accontentat",
	"accoppat",
	"accoppiat",
	"accorat",
	"accorciat",
	"accorcit",
	"accordat",
	"accordellat",
	"accorpat",
	"accort",
	"accosciat",
	"accostat",
	"accostumat",
	"accotonat",
	"accottimat",
	"accovacciat",
	"accovat",
	"accovonat",
	"accozzat",
	"accreditat",
	"accresciut",
	"accrespat",
	"accucciat",
	"accucciolat",
	"accudit",
	"acculat",
	"acculturat",
	"accumulat",
	"accumunat",
	"accusat",
	"acetificat",
	"acetilat",
	"acetit",
	"acidat",
	"acidificat",
	"acidulat",
	"acquadernat",
	"acquarellat",
	"acquartierat",
	"acquat",
	"acquattat",
	"acquerellat",
	"acquetat",
	"acquietat",
	"acquisit",
	"acquistat",
	"acromatizzat",
	"acuit",
	"acuminat",
	"acutizzat",
	"adacquat",
	"adagiat",
	"adattat",
	"addaziat",
	"addebbiat",
	"addebitat",
	"addecimat",
	"addensat",
	"addentat",
	"addentellat",
	"addentrat",
	"addestrat",
	"addett",
	"addiacciat",
	"addimandat",
	"addimesticat",
	"addimorat",
	"addimostrat",
	"addipanat",
	"addirizzat",
	"additat",
	"additivat",
	"addizionat",
	"addobbat",
	"addocilit",
	"addogliat",
	"addolcat",
	"addolciat",
	"addolcit",
	"addolorat",
	"addomandat",
	"addomesticat",
	"addoppiat",
	"addormentat",
	"addossat",
	"addott",
	"addottorat",
	"addottrinat",
	"addrizzat",
	"adduat",
	"addugliat",
	"adeguat",
	"adempit",
	"adempiut",
	"adequat",
	"aderizzat",
	"adescat",
	"adibit",
	"adirat",
	"adit",
	"adiuvat",
	"adizzat",
	"adocchiat",
	"adombrat",
	"adonat",
	"adonestat",
	"adontat",
	"adoperat",
	"adoprat",
	"adorat",
	"adornat",
	"adottat",
	"adsorbit",
	"aduggiat",
	"adugnat",
	"adulat",
	"adulterat",
	"adunat",
	"adunghiat",
	"adusat",
	"aerat",
	"aereat",
	"aerotrainat",
	"aerotrasportat",
	"affabulat",
	"affaccendat",
	"affacchinat",
	"affacciat",
	"affagottat",
	"affaldat",
	"affamat",
	"affamigliat",
	"affannat",
	"affardellat",
	"affascinat",
	"affastellat",
	"affaticat",
	"affattucchiat",
	"affatturat",
	"affermat",
	"afferrat",
	"affettat",
	"affezionat",
	"affiancat",
	"affiatat",
	"affibbiat",
	"affidat",
	"affienat",
	"affievolit",
	"affigliat",
	"affigurat",
	"affilat",
	"affilettat",
	"affiliat",
	"affinat",
	"affiochit",
	"affiorat",
	"affisat",
	"affissat",
	"affiss",
	"affittat",
	"affittit",
	"afflitt",
	"afflosciat",
	"affocat",
	"affogat",
	"affogliat",
	"affollat",
	"affoltat",
	"affondat",
	"afforcat",
	"afforestat",
	"afforzat",
	"affossat",
	"affralit",
	"affrancat",
	"affrant",
	"affratellat",
	"affrenat",
	"affrenellat",
	"affrescat",
	"affrettat",
	"affrittellat",
	"affrontat",
	"affumat",
	"affumicat",
	"affumigat",
	"affuocat",
	"affusolat",
	"africanizzat",
	"ageminat",
	"agevolat",
	"aggallat",
	"agganciat",
	"aggangherat",
	"aggarbat",
	"aggattonat",
	"aggavignat",
	"aggelat",
	"aggettivat",
	"agghiacciat",
	"agghiadat",
	"agghiaiat",
	"agghindat",
	"aggiaccat",
	"aggiogat",
	"aggiornat",
	"aggirat",
	"aggiucchit",
	"aggiudicat",
	"aggiuntat",
	"aggiunt",
	"aggiustat",
	"agglomerat",
	"agglutinat",
	"aggomitolat",
	"aggottat",
	"aggradit",
	"aggraffat",
	"aggranchiat",
	"aggranchit",
	"aggrandit",
	"aggrappat",
	"aggraticciat",
	"aggravat",
	"aggredit",
	"aggregat",
	"aggrevat",
	"aggricciat",
	"aggrinzat",
	"aggrinzit",
	"aggrommat",
	"aggrondat",
	"aggroppat",
	"aggrottat",
	"aggrovigliat",
	"aggrumat",
	"aggruppat",
	"aggruzzolat",
	"agguagliat",
	"agguantat",
	"agguardat",
	"agguatat",
	"aggueffat",
	"agitat",
	"agognat",
	"agrarizzat",
	"aguatat",
	"agucchiat",
	"agunat",
	"agurat",
	"aguzzat",
	"aitat",
	"aiutat",
	"aizzat",
	"alat",
	"alberat",
	"albergat",
	"alcalinizzat",
	"alchilat",
	"alchimiat",
	"alchimizzat",
	"alcolizzat",
	"alcoolizzat",
	"alenat",
	"alesat",
	"alettat",
	"alfabetat",
	"alfabetizzat",
	"alidit",
	"alienat",
	"alimentat",
	"allacciat",
	"allagat",
	"allappat",
	"allargat",
	"allascat",
	"allattat",
	"alleat",
	"allegat",
	"alleggerit",
	"alleggiat",
	"allegorizzat",
	"alleluiat",
	"allenat",
	"allenit",
	"allentat",
	"allertat",
	"allessat",
	"allestit",
	"allettat",
	"allevat",
	"alleviat",
	"allibat",
	"allibit",
	"allibrat",
	"allicciat",
	"allietat",
	"allindat",
	"allineat",
	"allis",
	"allocat",
	"allogat",
	"alloggiat",
	"allontanat",
	"allottat",
	"allucchettat",
	"allucciolat",
	"allucinat",
	"allumat",
	"alluminat",
	"alluminiat",
	"allungat",
	"allupat",
	"allus",
	"alluzzat",
	"alogenat",
	"alonat",
	"alpeggiat",
	"alterat",
	"alternat",
	"alzat",
	"amalgamat",
	"amareggiat",
	"amaricat",
	"amat",
	"ambientat",
	"ambiguat",
	"ambit",
	"americanizzat",
	"amicat",
	"ammaccat",
	"ammaestrat",
	"ammainat",
	"ammalat",
	"ammaliat",
	"ammalinconit",
	"ammaltat",
	"ammanettat",
	"ammanicat",
	"ammanierat",
	"ammanigliat",
	"ammannat",
	"ammannellat",
	"ammannit",
	"ammansat",
	"ammansit",
	"ammantat",
	"ammantellat",
	"ammarat",
	"ammarezzat",
	"ammassat",
	"ammassellat",
	"ammassicciat",
	"ammatassat",
	"ammattonat",
	"ammazzat",
	"ammelmat",
	"ammencit",
	"ammendat",
	"ammennicolat",
	"ammess",
	"ammetat",
	"ammezzit",
	"amministrat",
	"amminutat",
	"ammirat",
	"ammiserit",
	"ammobiliat",
	"ammodernat",
	"ammodernizzat",
	"ammogliat",
	"ammoinat",
	"ammollat",
	"ammollit",
	"ammonit",
	"ammonticchiat",
	"ammonticellat",
	"ammorbat",
	"ammorbidat",
	"ammorbidit",
	"ammorsat",
	"ammortat",
	"ammortit",
	"ammortizzat",
	"ammorzat",
	"ammosciat",
	"ammoscit",
	"ammostat",
	"ammotinat",
	"ammucchiat",
	"ammulinat",
	"ammusat",
	"ammutat",
	"ammutinat",
	"amnistiat",
	"amoracciat",
	"ampiat",
	"ampliat",
	"amplificat",
	"amputat",
	"anagrammat",
	"analizzat",
	"anamorfizzat",
	"anastomizzat",
	"anatematizzat",
	"anatomizzat",
	"anchilosat",
	"ancis",
	"ancorat",
	"andicappat",
	"anellat",
	"anemizzat",
	"anestetizzat",
	"angariat",
	"anglicizzat",
	"angolat",
	"angosciat",
	"angustiat",
	"animat",
	"annacquat",
	"annaffiat",
	"annasat",
	"annaspat",
	"annaspicat",
	"annebbiat",
	"annegat",
	"annerat",
	"annerit",
	"anness",
	"annestat",
	"annichilat",
	"annichilit",
	"annidat",
	"annientat",
	"annitrit",
	"annobilit",
	"annodat",
	"annodicchiat",
	"annoiat",
	"annotat",
	"annottat",
	"annottolat",
	"annoverat",
	"annullat",
	"annunciat",
	"annunziat",
	"annusat",
	"annuvolat",
	"anodizzat",
	"anonimizzat",
	"antecedut",
	"antepost",
	"antergat",
	"anticheggiat",
	"antichizzat",
	"anticipat",
	"anticonosciut",
	"antidatat",
	"antivedut",
	"antivist",
	"antologizzat",
	"antropizzat",
	"antropomorfizzat",
	"aocchiat",
	"aombrat",
	"aonestat",
	"aontat",
	"apert",
	"apocopat",
	"apologizzat",
	"apostatat",
	"apostrofat",
	"appaciat",
	"appacificat",
	"appagat",
	"appaiat",
	"appalesat",
	"appallottolat",
	"appaltat",
	"appanettat",
	"appannat",
	"apparat",
	"apparecchiat",
	"apparentat",
	"apparigliat",
	"apparit",
	"appartat",
	"appassionat",
	"appastat",
	"appastellat",
	"appellat",
	"appennellat",
	"appercepit",
	"appertizzat",
	"appesantit",
	"appesit",
	"appes",
	"appestat",
	"appetit",
	"appezzat",
	"appiacevolit",
	"appianat",
	"appiastrat",
	"appiatat",
	"appiattat",
	"appiattit",
	"appiccat",
	"appiccicat",
	"appiccolit",
	"appiedat",
	"appigionat",
	"appigliat",
	"appinzat",
	"appiombat",
	"appioppat",
	"appisolat",
	"applaudit",
	"applicat",
	"appoderat",
	"appoggiat",
	"appollaiat",
	"appoppat",
	"apportat",
	"appostat",
	"appost",
	"appratit",
	"appresentat",
	"appres",
	"appressat",
	"apprestat",
	"apprettat",
	"apprezzat",
	"approcciat",
	"approfittat",
	"approfondat",
	"approfondit",
	"approntat",
	"appropinquat",
	"appropriat",
	"approssimat",
	"approvat",
	"approvisionat",
	"approvvigionat",
	"appruat",
	"appulcrat",
	"appuntat",
	"appuntellat",
	"appuntit",
	"appurat",
	"appuzzat",
	"arabescat",
	"arabizzat",
	"arat",
	"arbitrat",
	"arborat",
	"arcaizzat",
	"arcat",
	"architettat",
	"archiviat",
	"arcuat",
	"ardit",
	"areat",
	"argentat",
	"arginat",
	"argomentat",
	"arguit",
	"arianizzat",
	"arieggiat",
	"armat",
	"armonizzat",
	"aromatizzat",
	"arpeggiat",
	"arpionat",
	"arponat",
	"arrabattat",
	"arraffat",
	"arraffiat",
	"arrandellat",
	"arrangiat",
	"arrapat",
	"arrapinat",
	"arrappat",
	"arrazzat",
	"arrecat",
	"arredat",
	"arreggimentat",
	"arrembat",
	"arrenat",
	"arresis",
	"arres",
	"arrestat",
	"arretrat",
	"arricchit",
	"arricciat",
	"arricciolat",
	"arriffat",
	"arringat",
	"arrischiat",
	"arrisicat",
	"arris",
	"arrocat",
	"arroccat",
	"arrochit",
	"arrogat",
	"arrolat",
	"arroncat",
	"arronzat",
	"arrosat",
	"arrossat",
	"arrostat",
	"arrostit",
	"arrotat",
	"arrotolat",
	"arrotondat",
	"arrovellat",
	"arroventat",
	"arroventit",
	"arrovesciat",
	"arrubinat",
	"arruffat",
	"arruffianat",
	"arrugginit",
	"arruncigliat",
	"arruolat",
	"arruvidit",
	"arsicciat",
	"ars",
	"artefatt",
	"articolat",
	"artigliat",
	"asces",
	"asciat",
	"asciolvut",
	"asciugat",
	"ascoltat",
	"ascos",
	"ascost",
	"ascritt",
	"asfaltat",
	"asfissiat",
	"aspers",
	"aspettat",
	"aspirat",
	"asportat",
	"aspreggiat",
	"assaettat",
	"assaggiat",
	"assalit",
	"assaltat",
	"assaporat",
	"assaporit",
	"assassinat",
	"assecondat",
	"assecurat",
	"assediat",
	"asseggiat",
	"assegnat",
	"assembiat",
	"assemblat",
	"assembrat",
	"assemprat",
	"assentat",
	"asserit",
	"asserragliat",
	"asservit",
	"assestat",
	"assetat",
	"assettat",
	"asseverat",
	"assibilat",
	"assicurat",
	"assiderat",
	"assiemat",
	"assiepat",
	"assillat",
	"assimigliat",
	"assimilat",
	"assiomatizzat",
	"assis",
	"assistit",
	"associat",
	"assodat",
	"assoggettat",
	"assolcat",
	"assoldat",
	"assolt",
	"assolutizzat",
	"assomat",
	"assommat",
	"assonat",
	"assonnat",
	"assopit",
	"assorbit",
	"assordat",
	"assordit",
	"assortit",
	"assottigliat",
	"assuefatt",
	"assunt",
	"asteggiat",
	"astenut",
	"asters",
	"astratt",
	"astrett",
	"atomizzat",
	"atrofizzat",
	"atrovat",
	"attaccat",
	"attagliat",
	"attanagliat",
	"attardat",
	"attediat",
	"atteggiat",
	"attempat",
	"attendat",
	"attentat",
	"attenuat",
	"attenut",
	"attergat",
	"atterrat",
	"atterrit",
	"atterzat",
	"attes",
	"attestat",
	"atticizzat",
	"attillat",
	"attint",
	"attirat",
	"attivat",
	"attivizzat",
	"attizzat",
	"attorcigliat",
	"attorniat",
	"attort",
	"attoscat",
	"attossicat",
	"attraccat",
	"attrappit",
	"attratt",
	"attraversat",
	"attrezzat",
	"attribuit",
	"attristat",
	"attristit",
	"attruppat",
	"attualizzat",
	"attuat",
	"attuffat",
	"attutat",
	"attutit",
	"auggiat",
	"augumentat",
	"augurat",
	"aulit",
	"aumentat",
	"aunghiat",
	"ausat",
	"auscultat",
	"auspicat",
	"autenticat",
	"autentificat",
	"autoaccusat",
	"autoaffondat",
	"autoalimentat",
	"autoassolt",
	"autocandidat",
	"autocensurat",
	"autocitat",
	"autocommiserat",
	"autoconsumat",
	"autoconvint",
	"autodefinit",
	"autodenunciat",
	"autodistrutt",
	"autofinanziat",
	"autogestit",
	"autogovernat",
	"autografat",
	"autoincensat",
	"autointersecat",
	"autoinvitat",
	"autolesionat",
	"autolimitat",
	"automaticizzat",
	"automatizzat",
	"automotivat",
	"autonominat",
	"autoproclamat",
	"autoprodott",
	"autoprotett",
	"autopubblicat",
	"autopubblicizzat",
	"autoregolamentat",
	"autoregolat",
	"autoridott",
	"autoriparat",
	"autorizzat",
	"autosomministrat",
	"autosostenut",
	"autosuggestionat",
	"autotassat",
	"autotrapiantat",
	"autotrasportat",
	"autovalutat",
	"avallat",
	"avampat",
	"avanzat",
	"avariat",
	"avint",
	"aviolanciat",
	"aviotrasportat",
	"avocat",
	"avolterat",
	"avuls",
	"avutacel",
	"avut",
	"avvallat",
	"avvalorat",
	"avvals",
	"avvantaggiat",
	"avvelat",
	"avvelenat",
	"avventat",
	"avventurat",
	"avverat",
	"avversat",
	"avvertit",
	"avvezzat",
	"avviat",
	"avvicendat",
	"avvicinat",
	"avvignat",
	"avvilit",
	"avviluppat",
	"avvinat",
	"avvinchiat",
	"avvinghiat",
	"avvint",
	"avvisat",
	"avvistat",
	"avvitat",
	"avviticchiat",
	"avvitit",
	"avvivat",
	"avvolt",
	"avvoltolat",
	"aziendalizzat",
	"azionat",
	"azotat",
	"azzannat",
	"azzardat",
	"azzeccat",
	"azzerat",
	"azzimat",
	"azzittat",
	"azzittit",
	"azzoppat",
	"azzoppit",
	"azzuffat",
	"azzurrat",
	"bacat",
	"baccagliat",
	"bacchettat",
	"bacchiat",
	"baciat",
	"badat",
	"bagnat",
	"baipassat",
	"balbettat",
	"balcanizzat",
	"ballat",
	"baloccat",
	"balzat",
	"banalizzat",
	"bancat",
	"bandit",
	"bannat",
	"baraccat",
	"barattat",
	"barbarizzat",
	"barcamenat",
	"bardat",
	"barellat",
	"barrat",
	"barricat",
	"basat",
	"basciat",
	"basculat",
	"bassat",
	"bastat",
	"bastionat",
	"bastit",
	"bastonat",
	"battezzat",
	"battut",
	"bazzicat",
	"beatificat",
	"beat",
	"beccat",
	"beccheggiat",
	"becchettat",
	"beffat",
	"beffeggiat",
	"bendat",
	"benedett",
	"beneficat",
	"benvolut",
	"berlusconizzat",
	"bersagliat",
	"bestemmiat",
	"bevut",
	"biadat",
	"bianchettat",
	"bianchit",
	"biascicat",
	"biasimat",
	"biasmat",
	"bidonat",
	"biennalizzat",
	"biforcat",
	"bigiat",
	"bilanciat",
	"binat",
	"bindolat",
	"biodegradat",
	"biografat",
	"bipartit",
	"bisbigliat",
	"biscottat",
	"bisecat",
	"bisellat",
	"bisognat",
	"bissat",
	"bistrat",
	"bistrattat",
	"bitumat",
	"bituminat",
	"blandit",
	"bleffat",
	"blindat",
	"bloccat",
	"bloggat",
	"bluffat",
	"bobinat",
	"boccheggiat",
	"bocciat",
	"boicottat",
	"bollat",
	"bollit",
	"bombardat",
	"bombat",
	"bonderizzat",
	"bonificat",
	"bootat",
	"borbottat",
	"bordat",
	"boriat",
	"borrat",
	"borseggiat",
	"braccat",
	"bracciat",
	"bramat",
	"bramit",
	"brancicat",
	"brandeggiat",
	"brandit",
	"brasat",
	"bravat",
	"brevettat",
	"breviat",
	"brillantat",
	"brillat",
	"brinat",
	"broccat",
	"brocciat",
	"broccolat",
	"brontolat",
	"bronzat",
	"brucat",
	"bruciacchiat",
	"bruciat",
	"brunit",
	"bruscat",
	"bruschinat",
	"brutalizzat",
	"bruttat",
	"bucat",
	"bucherellat",
	"bufat",
	"buffat",
	"bufferizzat",
	"buggerat",
	"bugnat",
	"bulicat",
	"bulinat",
	"bullettat",
	"bullonat",
	"burattat",
	"burlat",
	"burocratizzat",
	"burrificat",
	"buscat",
	"buttat",
	"butterat",
	"bypassat",
	"cablat",
	"cabrat",
	"cacat",
	"cacciat",
	"cadenzat",
	"cadmiat",
	"caducat",
	"cagat",
	"caggiat",
	"cagionat",
	"cagliat",
	"calafatat",
	"calamitat",
	"calandrat",
	"calat",
	"calcat",
	"calciat",
	"calcificat",
	"calcolat",
	"caldeggiat",
	"calettat",
	"calibrat",
	"calmat",
	"calmierat",
	"calpestat",
	"calumat",
	"calunniat",
	"calzat",
	"cambiat",
	"camerat",
	"campionat",
	"campit",
	"camuffat",
	"canalizzat",
	"cancellat",
	"cancerizzat",
	"candeggiat",
	"candidat",
	"candit",
	"canforat",
	"cangiat",
	"cannat",
	"canneggiat",
	"cannibalizzat",
	"cannoneggiat",
	"canonizzat",
	"cantat",
	"canterellat",
	"canticchiat",
	"cantilenat",
	"canzonat",
	"caolinizzat",
	"capacitat",
	"capeggiat",
	"capillarizzat",
	"capitalizzat",
	"capitanat",
	"capitaneggiat",
	"capit",
	"capitozzat",
	"capivolt",
	"caponat",
	"capotat",
	"capottat",
	"capovolt",
	"capponat",
	"captat",
	"caramellat",
	"caramellizzat",
	"caratat",
	"caratterizzat",
	"carbonizzat",
	"carbossilat",
	"carburat",
	"carcat",
	"carcerat",
	"cardat",
	"carenat",
	"carezzat",
	"cariat",
	"caricat",
	"caricaturat",
	"caricaturizzat",
	"carotat",
	"carpionat",
	"carpit",
	"carreggiat",
	"carrozzat",
	"cartavetrat",
	"carteggiat",
	"cartellinat",
	"cartografat",
	"cartolarizzat",
	"cartonat",
	"cascolat",
	"cassat",
	"cass",
	"castigat",
	"castrat",
	"casualizzat",
	"catabolizzat",
	"catalizzat",
	"catalogat",
	"catapultat",
	"catechizzat",
	"categorizzat",
	"cateterizzat",
	"catramat",
	"cattolicizzat",
	"catturat",
	"causat",
	"cautelat",
	"cauterizzat",
	"cauzionat",
	"cavalcat",
	"cavatasel",
	"cavat",
	"cazzat",
	"cazziat",
	"cazzottat",
	"cedrat",
	"cedut",
	"celat",
	"celebrat",
	"cellofanat",
	"cementat",
	"cementificat",
	"cennat",
	"censit",
	"censurat",
	"centellat",
	"centellinat",
	"centimetrat",
	"centinat",
	"centralizzat",
	"centrat",
	"centrifugat",
	"centuplicat",
	"cerat",
	"cercat",
	"cerchiat",
	"cernut",
	"certificat",
	"cesellat",
	"cessat",
	"cestinat",
	"cheratinizzat",
	"chetat",
	"chiamat",
	"chiappat",
	"chiarificat",
	"chiarit",
	"chiaroscurat",
	"chiavat",
	"chiazzat",
	"chiest",
	"chilificat",
	"chilometrat",
	"chimificat",
	"chinat",
	"chinizzat",
	"chiodat",
	"chiosat",
	"chius",
	"choccat",
	"ciancicat",
	"cianfrinat",
	"cianfrugliat",
	"ciangottat",
	"ciattat",
	"cibat",
	"cicatrizzat",
	"ciccat",
	"cicchettat",
	"ciclizzat",
	"ciclostilat",
	"cifrat",
	"cilindrat",
	"cimat",
	"cimentat",
	"cincischiat",
	"cinematografat",
	"cintat",
	"cint",
	"cioncat",
	"ciondolat",
	"circolat",
	"circoncint",
	"circoncis",
	"circondat",
	"circondott",
	"circonfless",
	"circonfluit",
	"circonfus",
	"circonscritt",
	"circonvenut",
	"circoscritt",
	"circostanziat",
	"circuit",
	"circumcint",
	"circumnavigat",
	"citat",
	"ciucciat",
	"ciurmat",
	"civettat",
	"civilizzat",
	"clamat",
	"classat",
	"classicizzat",
	"classificat",
	"cliccat",
	"climatizzat",
	"clivat",
	"clonat",
	"cloroformizzat",
	"clorurat",
	"clusterizzat",
	"co-dirett",
	"coacervat",
	"coadiuvat",
	"coagulat",
	"coalizzat",
	"coartat",
	"coccolat",
	"codificat",
	"coeditat",
	"coesistit",
	"cofinanziat",
	"cofirmat",
	"cofondat",
	"cogestit",
	"cogitat",
	"coglionat",
	"cognosciut",
	"coibentat",
	"coincis",
	"cointeressat",
	"cointestat",
	"coinvolt",
	"cokificat",
	"colat",
	"colettat",
	"collassat",
	"collaudat",
	"collazionat",
	"collegat",
	"collettivizzat",
	"collezionat",
	"collimat",
	"colliquat",
	"collis",
	"collocat",
	"colluttat",
	"colmat",
	"colonizzat",
	"colorat",
	"colorit",
	"colorizzat",
	"colpevolizzat",
	"colpit",
	"coltellat",
	"coltivat",
	"colt",
	"coltrat",
	"comandat",
	"combattut",
	"combinat",
	"comburut",
	"comicizzat",
	"cominciat",
	"commemorat",
	"commendat",
	"commensurat",
	"commentat",
	"commercializzat",
	"commess",
	"comminat",
	"commiserat",
	"commissariat",
	"commissionat",
	"commisurat",
	"commoss",
	"commutat",
	"comodat",
	"compaginat",
	"comparit",
	"compartimentalizzat",
	"compartit",
	"compassionat",
	"compatibilizzat",
	"compatit",
	"compattat",
	"compendiat",
	"compenetrat",
	"compensat",
	"comperat",
	"compiaciut",
	"compiant",
	"compilat",
	"compitat",
	"compiut",
	"complessat",
	"complessificat",
	"compless",
	"completat",
	"complicat",
	"complimentat",
	"comportat",
	"compostat",
	"compost",
	"comprat",
	"compravendut",
	"compres",
	"compress",
	"compromess",
	"comprovat",
	"compulsat",
	"compunt",
	"computat",
	"computerizzat",
	"comunicat",
	"comunistizzat",
	"concatenat",
	"concedut",
	"concelebrat",
	"concentrat",
	"concepit",
	"concertat",
	"concess",
	"concettat",
	"concettualizzat",
	"conchius",
	"conciat",
	"conciliat",
	"concimat",
	"concitat",
	"conclamat",
	"conclus",
	"concordat",
	"concott",
	"concretat",
	"concretizzat",
	"conculcat",
	"concupit",
	"condannat",
	"condensat",
	"condit",
	"condivis",
	"condizionat",
	"condolut",
	"condonat",
	"condott",
	"confatt",
	"confederat",
	"conferit",
	"confermat",
	"confessat",
	"confettat",
	"confezionat",
	"conficcat",
	"confidat",
	"configurat",
	"confinat",
	"confint",
	"confiscat",
	"confitt",
	"conformat",
	"confortat",
	"confricat",
	"confrontat",
	"confus",
	"confutat",
	"congedat",
	"congegnat",
	"congelat",
	"congestionat",
	"congetturat",
	"congiunt",
	"conglobat",
	"conglomerat",
	"conglutinat",
	"congratulat",
	"congregat",
	"conguagliat",
	"coniat",
	"coniugat",
	"connaturat",
	"conness",
	"connotat",
	"connumerat",
	"conosciut",
	"conquistat",
	"consacrat",
	"consapevolizzat",
	"consegnat",
	"conseguit",
	"consentit",
	"conservat",
	"considerat",
	"consigliat",
	"consistit",
	"consociat",
	"consolat",
	"consolidat",
	"consorziat",
	"conspars",
	"conspers",
	"constatat",
	"constrett",
	"construit",
	"consultat",
	"consumat",
	"consunt",
	"contabilizzat",
	"contagiat",
	"containerizzat",
	"contaminat",
	"contat",
	"contattat",
	"conteggiat",
	"contemperat",
	"contemplat",
	"contentat",
	"contenut",
	"contes",
	"contestat",
	"contestualizzat",
	"contingentat",
	"continuat",
	"contornat",
	"contort",
	"contrabbandat",
	"contraccambiat",
	"contraddett",
	"contraddistint",
	"contradett",
	"contraffatt",
	"contrappesat",
	"contrappost",
	"contrappuntat",
	"contrariat",
	"contrassegnat",
	"contrastat",
	"contrat",
	"contrattaccat",
	"contrattat",
	"contratt",
	"contravvals",
	"contristat",
	"controbattut",
	"controbilanciat",
	"controdatat",
	"controfirmat",
	"controindicat",
	"controllat",
	"controminat",
	"contronotat",
	"contropropost",
	"controprovat",
	"controquerelat",
	"controsoffittat",
	"controstampat",
	"controventat",
	"conturbat",
	"contus",
	"convalidat",
	"convenut",
	"convenzionat",
	"convertit",
	"convint",
	"convitat",
	"convocat",
	"convogliat",
	"convolt",
	"coobat",
	"cooptat",
	"coordinat",
	"coperchiat",
	"copert",
	"copiaincollat",
	"copiat",
	"copolimerizzat",
	"coppellat",
	"coprodott",
	"corazzat",
	"corbellat",
	"corcat",
	"cordonat",
	"coreografat",
	"coricat",
	"cornificat",
	"coronat",
	"corredat",
	"correlat",
	"corresponsabilizzat",
	"corrett",
	"corricchiat",
	"corrispost",
	"corroborat",
	"corros",
	"corrott",
	"corrucciat",
	"corrugat",
	"cors",
	"corteat",
	"corteggiat",
	"cortocircuitat",
	"coruscat",
	"cosat",
	"coscritt",
	"cospars",
	"cospers",
	"costatat",
	"costeggiat",
	"costellat",
	"costernat",
	"costicchiat",
	"costipat",
	"costituit",
	"costituzionalizzat",
	"costrett",
	"costruit",
	"costudit",
	"cotonat",
	"cott",
	"covat",
	"coventrizzat",
	"coverchiat",
	"craccat",
	"creat",
	"credut",
	"cremat",
	"crepat",
	"cresciut",
	"cresimat",
	"crespat",
	"criminalizzat",
	"crioconcentrat",
	"criptat",
	"cristallizzat",
	"cristianizzat",
	"criticat",
	"crittat",
	"crittografat",
	"crivellat",
	"crocchiat",
	"crocefiss",
	"crocefitt",
	"crocifiss",
	"crocifitt",
	"crogiolat",
	"cromat",
	"cronicizzat",
	"cronometrat",
	"crostat",
	"crucciat",
	"crucifiss",
	"crucifitt",
	"cuccat",
	"cucinat",
	"cucit",
	"cullat",
	"cumulat",
	"cuntat",
	"curat",
	"curvat",
	"curvat",
	"custodit",
	"customizzat",
	"damascat",
	"damaschinat",
	"damat",
	"dannat",
	"danneggiat",
	"danzat",
	"dardeggiat",
	"datat",
	"dat",
	"dattilografat",
	"dattiloscritt",
	"daziat",
	"deacidificat",
	"deattivat",
	"debbiat",
	"debellat",
	"debilitat",
	"decaffeinat",
	"decaffeinizzat",
	"decalcat",
	"decalcificat",
	"decantat",
	"decapat",
	"decapitat",
	"decappottat",
	"decarbossilat",
	"decarburat",
	"decatizzat",
	"decelerat",
	"decentralizzat",
	"decentrat",
	"decerebrat",
	"decernut",
	"decespugliat",
	"deciferat",
	"decifrat",
	"decimalizzat",
	"decimat",
	"decis",
	"declamat",
	"declassat",
	"declassificat",
	"declinat",
	"declorat",
	"decodificat",
	"decolonizzat",
	"decolorat",
	"decompartimentat",
	"decompilat",
	"decompost",
	"decompress",
	"deconcentrat",
	"decondizionat",
	"decongelat",
	"decongestionat",
	"decontaminat",
	"decontestualizzat",
	"decontratt",
	"decorat",
	"decorticat",
	"decostruit",
	"decrementat",
	"decretat",
	"decriminalizzat",
	"decriptat",
	"decrittat",
	"decuplicat",
	"decurtat",
	"dedicat",
	"dedott",
	"defacciat",
	"defalcat",
	"defascistizzat",
	"defecat",
	"defenestrat",
	"deferit",
	"defilat",
	"definit",
	"defiscalizzat",
	"defitt",
	"deflazionat",
	"deflemmat",
	"deflorat",
	"defogliat",
	"defoliat",
	"deforestat",
	"deformat",
	"defosforat",
	"defosforilat",
	"deframmentat",
	"defraudat",
	"degassat",
	"degassificat",
	"deglutit",
	"degnat",
	"degradat",
	"degustat",
	"deidratat",
	"deidrogenat",
	"deificat",
	"deindicizzat",
	"deindustrializzat",
	"deionizzat",
	"delegat",
	"delegificat",
	"delegittimat",
	"delibat",
	"deliberat",
	"delimitat",
	"delineat",
	"delirat",
	"deliziat",
	"delocalizzat",
	"delucidat",
	"delus",
	"demagnetizzat",
	"demandat",
	"demanializzat",
	"demarcat",
	"demeritat",
	"demers",
	"demetallizzat",
	"demilitarizzat",
	"demineralizzat",
	"demistificat",
	"demitizzat",
	"democratizzat",
	"demodulat",
	"demolit",
	"demoltiplicat",
	"demonetat",
	"demonetizzat",
	"demonizzat",
	"demoralizzat",
	"demors",
	"demotivat",
	"denaturalizzat",
	"denaturat",
	"denazificat",
	"denazionalizzat",
	"denicotinizzat",
	"denigrat",
	"denitrificat",
	"denocciolat",
	"denominat",
	"denotat",
	"dentellat",
	"denuclearizzat",
	"denudat",
	"denunciat",
	"denunziat",
	"deodorat",
	"deossidat",
	"deossigenat",
	"deostruit",
	"depauperat",
	"depenalizzat",
	"depennat",
	"depilat",
	"depint",
	"depistat",
	"deplorat",
	"depolarizzat",
	"depolimerizzat",
	"depoliticizzat",
	"depolverizzat",
	"deportat",
	"depositat",
	"depost",
	"depotenziat",
	"depravat",
	"deprecat",
	"depredat",
	"depress",
	"depressurizzat",
	"deprezzat",
	"deprivat",
	"deprotonat",
	"depuls",
	"depurat",
	"dequalificat",
	"deratizzat",
	"derattizzat",
	"dereferenziat",
	"deregolamentat",
	"deregolat",
	"derequisit",
	"deresponsabilizzat",
	"deris",
	"derubat",
	"derubricat",
	"desacralizzat",
	"desalat",
	"desalinizzat",
	"descolarizzat",
	"descritt",
	"desecretat",
	"desegretat",
	"deselezionat",
	"desensibilizzat",
	"desessualizzat",
	"desiat",
	"desiderat",
	"designat",
	"desinat",
	"desirat",
	"desolat",
	"desolforat",
	"desonorizzat",
	"desorbit",
	"desossidat",
	"desquamat",
	"destabilizzat",
	"destagionalizzat",
	"destalinizzat",
	"destatalizzat",
	"destatizzat",
	"destat",
	"destinat",
	"destituit",
	"destoricizzat",
	"destreggiat",
	"destrutt",
	"destrutturat",
	"desunt",
	"detassat",
	"detenut",
	"deteriorat",
	"determinat",
	"deters",
	"detestat",
	"detonat",
	"detort",
	"detossificat",
	"detratt",
	"detronizzat",
	"dettagliat",
	"dettat",
	"dett",
	"deturpat",
	"deumidificat",
	"devastat",
	"deventat",
	"deviat",
	"deviscerat",
	"devitalizzat",
	"devitaminizzat",
	"devolut",
	"dezippat",
	"diaframmat",
	"diagnosticat",
	"diagonalizzat",
	"diagrammat",
	"dializzat",
	"dialogat",
	"dialogizzat",
	"diazotat",
	"dibattut",
	"diboscat",
	"dichiarat",
	"diesat",
	"diesizzat",
	"difes",
	"diffamat",
	"differit",
	"diffidat",
	"diffrant",
	"diffratt",
	"diffus",
	"digerit",
	"digitalizzat",
	"digitat",
	"digiunt",
	"digrassat",
	"digrignat",
	"digrossat",
	"dilacerat",
	"dilaniat",
	"dilapidat",
	"dilatat",
	"dilavat",
	"dilazionat",
	"dileggiat",
	"dileguat",
	"dilettat",
	"dilett",
	"diliscat",
	"dilucidat",
	"diluit",
	"dilungat",
	"dimagrat",
	"dimandat",
	"dimenat",
	"dimensionat",
	"dimenticat",
	"dimerizzat",
	"dimess",
	"dimezzat",
	"diminuit",
	"dimissionat",
	"dimostrat",
	"dimunt",
	"dinamizzat",
	"dinoccat",
	"dipanat",
	"dipelat",
	"dipint",
	"diplomat",
	"dipost",
	"diradat",
	"diramat",
	"dirett",
	"direzionat",
	"dirimut",
	"diroccat",
	"dirottat",
	"dirott",
	"dirozzat",
	"disabilitat",
	"disabituat",
	"disaccentat",
	"disaccoppiat",
	"disaccordat",
	"disacerbat",
	"disacidat",
	"disacidificat",
	"disacidit",
	"disaerat",
	"disaffezionat",
	"disaggregat",
	"disalberat",
	"disallineat",
	"disamat",
	"disambiguat",
	"disaminat",
	"disamorat",
	"disancorat",
	"disanimat",
	"disappannat",
	"disapplicat",
	"disappres",
	"disapprovat",
	"disarcionat",
	"disarmat",
	"disarticolat",
	"disascost",
	"disassemblat",
	"disassuefatt",
	"disatomizzat",
	"disattes",
	"disattivat",
	"disattrezzat",
	"disavvezzat",
	"disboscat",
	"disbrigat",
	"discacciat",
	"discalzat",
	"discantat",
	"discaricat",
	"discernut",
	"disces",
	"disceverat",
	"dischiest",
	"dischius",
	"discint",
	"disciolt",
	"disciplinat",
	"discolorat",
	"discolpat",
	"discommess",
	"discompagnat",
	"discompost",
	"disconclus",
	"disconfitt",
	"discongiunt",
	"disconness",
	"disconosciut",
	"discopert",
	"discordat",
	"discosces",
	"discostat",
	"discreditat",
	"discresciut",
	"discriminat",
	"discritt",
	"discucit",
	"discuoiat",
	"discuss",
	"disdegnat",
	"disdettat",
	"disdett",
	"diseccat",
	"diseccitat",
	"diseducat",
	"disegnat",
	"diserbat",
	"diseredat",
	"disertat",
	"disert",
	"disfatt",
	"disgelat",
	"disgiunt",
	"disgraziat",
	"disgregat",
	"disgustat",
	"disidentificat",
	"disiderat",
	"disidratat",
	"disillus",
	"disimballat",
	"disimparat",
	"disimpegnat",
	"disimpress",
	"disincagliat",
	"disincantat",
	"disincentivat",
	"disincrostat",
	"disindustrializzat",
	"disinfestat",
	"disinfettat",
	"disinflazionat",
	"disinformat",
	"disingannat",
	"disingranat",
	"disinibit",
	"disinnamorat",
	"disinnescat",
	"disinnestat",
	"disinquinat",
	"disinserit",
	"disinstallat",
	"disintasat",
	"disintegrat",
	"disinteressat",
	"disintes",
	"disintossicat",
	"disinvestit",
	"disinvolt",
	"disistimat",
	"dislocat",
	"dismess",
	"disobbedit",
	"disobbligat",
	"disonorat",
	"disordinat",
	"disorganizzat",
	"disorientat",
	"disormeggiat",
	"disossat",
	"disossidat",
	"disostruit",
	"disotterrat",
	"disparit",
	"dispensat",
	"dispent",
	"disperdut",
	"dispers",
	"dispes",
	"dispiegat",
	"dispint",
	"dispogliat",
	"dispost",
	"dispregiat",
	"disprezzat",
	"dispromess",
	"disproporzionat",
	"disputat",
	"disqualificat",
	"disrott",
	"dissacrat",
	"dissalat",
	"dissaldat",
	"dissanguat",
	"dissecat",
	"disseccat",
	"disselciat",
	"dissellat",
	"disseminat",
	"dissepolt",
	"disseppellit",
	"dissequestrat",
	"disserrat",
	"dissestat",
	"dissetat",
	"dissezionat",
	"dissigillat",
	"dissimulat",
	"dissipat",
	"dissociat",
	"dissodat",
	"dissolt",
	"dissomigliat",
	"dissotterrat",
	"dissuas",
	"dissuggellat",
	"distaccat",
	"distanziat",
	"distes",
	"distillat",
	"distint",
	"distolt",
	"distort",
	"distratt",
	"distrett",
	"distribuit",
	"districat",
	"distrigat",
	"distrutt",
	"disturbat",
	"disubbidit",
	"disumanat",
	"disumanizzat",
	"disunit",
	"disusat",
	"disvedut",
	"disvelat",
	"disvestit",
	"disviat",
	"disvist",
	"disvolt",
	"disvolut",
	"dittongat",
	"divallat",
	"divaricat",
	"divelt",
	"diversificat",
	"divertit",
	"divezzat",
	"divinat",
	"divincolat",
	"divinizzat",
	"divis",
	"divolt",
	"divorat",
	"divorziat",
	"divulgat",
	"documentat",
	"dogat",
	"dogmatizzat",
	"dolcificat",
	"dollarizzat",
	"dolorat",
	"dolut",
	"domandat",
	"domat",
	"domesticat",
	"domiciliat",
	"dominat",
	"donat",
	"dondolat",
	"dopat",
	"doppiat",
	"dorat",
	"dosat",
	"dotat",
	"dovut",
	"dragat",
	"drammatizzat",
	"drappeggiat",
	"drenat",
	"dribblat",
	"drizzat",
	"drogat",
	"dugliat",
	"duplicat",
	"duramificat",
	"ebraizzat",
	"eccedut",
	"eccepit",
	"eccettuat",
	"eccitat",
	"echeggiat",
	"eclissat",
	"economizzat",
	"edificat",
	"editat",
	"edott",
	"educat",
	"edulcorat",
	"effettuat",
	"efficientat",
	"effigiat",
	"effint",
	"effluit",
	"effus",
	"egemonizzat",
	"eguagliat",
	"eiettat",
	"elaborat",
	"elargit",
	"elasticizzat",
	"elementarizzat",
	"elemosinat",
	"elencat",
	"elett",
	"elettrificat",
	"elettrizzat",
	"elettrocoagulat",
	"elettrolizzat",
	"elevat",
	"eliminat",
	"elis",
	"elitrasportat",
	"ellenizzat",
	"elogiat",
	"elucidat",
	"elucubrat",
	"eluit",
	"elus",
	"emanat",
	"emancipat",
	"emarginat",
	"embricat",
	"emendat",
	"emess",
	"emozionat",
	"empit",
	"empiut",
	"emulat",
	"emulsionat",
	"emunt",
	"encomiat",
	"endocitat",
	"energizzat",
	"enfatizzat",
	"enfiat",
	"entusiasmat",
	"enucleat",
	"enumerat",
	"enunciat",
	"epicureggiat",
	"epurat",
	"equalizzat",
	"equilibrat",
	"equipaggiat",
	"equiparat",
	"eradicat",
	"eras",
	"ereditat",
	"erett",
	"erogat",
	"eroicizzat",
	"eros",
	"erotizzat",
	"erpicat",
	"ers",
	"erudit",
	"eruttat",
	"esacerbat",
	"esagerat",
	"esagitat",
	"esalat",
	"esaltat",
	"esaminat",
	"esasperat",
	"esaudit",
	"esaurit",
	"esautorat",
	"esborsat",
	"esclamat",
	"esclus",
	"escogitat",
	"escomiat",
	"escoriat",
	"escoss",
	"escuss",
	"esecrat",
	"esecutat",
	"eseguit",
	"esemplificat",
	"esentat",
	"esercitat",
	"esfoliat",
	"esibit",
	"esilarat",
	"esiliat",
	"esimut",
	"esitat",
	"esonerat",
	"esorbitat",
	"esorcizzat",
	"esortat",
	"espans",
	"espars",
	"esperimentat",
	"esperit",
	"espettorat",
	"espiantat",
	"espiat",
	"espirat",
	"espletat",
	"esplicat",
	"esplicitat",
	"esplorat",
	"esplos",
	"esportat",
	"espost",
	"espress",
	"espropriat",
	"espugnat",
	"espuls",
	"espunt",
	"espurgat",
	"essiccat",
	"essut",
	"estasiat",
	"estenuat",
	"esterificat",
	"esteriorizzat",
	"esterminat",
	"esternalizzat",
	"esternat",
	"estes",
	"estimat",
	"estint",
	"estirpat",
	"estivat",
	"estort",
	"estradat",
	"estraniat",
	"estrapolat",
	"estratt",
	"estremizzat",
	"estrinsecat",
	"estromess",
	"estrus",
	"estubat",
	"esulcerat",
	"esultat",
	"esumat",
	"eterificat",
	"eterizzat",
	"eternat",
	"eternizzat",
	"etichettat",
	"etossilat",
	"euforizzat",
	"europeizzat",
	"evacuat",
	"evangelizzat",
	"evas",
	"evet",
	"evidenziat",
	"evint",
	"evirat",
	"eviscerat",
	"evitat",
	"evocat",
	"evolt",
	"evolut",
	"evuls",
	"fabbricat",
	"faccettat",
	"facilitat",
	"fagocitat",
	"falciat",
	"falcidiat",
	"fallit",
	"falsat",
	"falsificat",
	"familiarizzat",
	"fanatizzat",
	"fantasticat",
	"farcit",
	"farfugliat",
	"fasciat",
	"fascicolat",
	"fascistizzat",
	"fattacel",
	"fatt",
	"fattorizzat",
	"fatturat",
	"favellat",
	"favoreggiat",
	"favorit",
	"faxat",
	"fecondat",
	"fedecommess",
	"federalizzat",
	"federat",
	"felicitat",
	"felpat",
	"feltrat",
	"femminilizzat",
	"fendut",
	"ferit",
	"fermat",
	"fermentat",
	"ferrat",
	"fertilizzat",
	"fess",
	"fessurat",
	"festeggiat",
	"festonat",
	"feudalizzat",
	"fiaccat",
	"fiammeggiat",
	"fiancheggiat",
	"ficcat",
	"fidanzat",
	"fidat",
	"fidecommess",
	"fidelizzat",
	"figliat",
	"figurat",
	"filat",
	"filettat",
	"filmat",
	"filosofat",
	"filtrat",
	"finalizzat",
	"finanziat",
	"finital",
	"finit",
	"finlandizzat",
	"fintat",
	"fint",
	"fiocinat",
	"fiondat",
	"fiorettat",
	"firmat",
	"fiscalizzat",
	"fischiat",
	"fischiettat",
	"fissat",
	"fissionat",
	"fitt",
	"fiutat",
	"flagellat",
	"flaggat",
	"flambat",
	"flangiat",
	"flemmatizzat",
	"fless",
	"flippat",
	"flottat",
	"fluidificat",
	"fluidizzat",
	"fluorizzat",
	"fluorurat",
	"focalizzat",
	"focheggiat",
	"foderat",
	"foggiat",
	"fognat",
	"folgorat",
	"follat",
	"fomentat",
	"fonat",
	"fondat",
	"foracchiat",
	"foraggiat",
	"forat",
	"forestat",
	"forfettizzat",
	"forgiat",
	"formalizzat",
	"format",
	"formattat",
	"formilat",
	"formulat",
	"fornit",
	"fortificat",
	"forviat",
	"forwardat",
	"forzat",
	"fosfatat",
	"fosforat",
	"fosforilat",
	"fossilizzat",
	"fotocompost",
	"fotocopiat",
	"fotografat",
	"fottut",
	"fracassat",
	"fraintes",
	"framess",
	"frammentat",
	"frammess",
	"frammezzat",
	"frammischiat",
	"franceseggiat",
	"francesizzat",
	"frangiat",
	"frant",
	"frantumat",
	"frappat",
	"frappost",
	"fraseggiat",
	"frastagliat",
	"frastornat",
	"fratturat",
	"frazionat",
	"freddat",
	"fregat",
	"fregiat",
	"frenat",
	"frequentat",
	"fresat",
	"frettat",
	"friendzonat",
	"fritt",
	"frizionat",
	"frodat",
	"frollat",
	"fronteggiat",
	"frugat",
	"fruit",
	"frullat",
	"frusciat",
	"frustat",
	"frustrat",
	"fruttat",
	"fucilat",
	"fucinat",
	"fugat",
	"fuggit",
	"fulminat",
	"fumat",
	"fumigat",
	"funestat",
	"funt",
	"funzionat",
	"fuoriuscit",
	"fuorviat",
	"fus",
	"fustellat",
	"fustigat",
	"gabbat",
	"gabellat",
	"gallat",
	"gallicizzat",
	"gallonat",
	"galvanizzat",
	"gambizzat",
	"garantit",
	"garnettat",
	"garrotat",
	"garzat",
	"gasat",
	"gassat",
	"gassificat",
	"gazat",
	"gelatinizzat",
	"gelat",
	"gelificat",
	"gemellat",
	"gemicat",
	"geminat",
	"generalizzat",
	"generat",
	"gentrificat",
	"genufless",
	"geometrizzat",
	"georeferenziat",
	"gerarchizzat",
	"germanizzat",
	"gestit",
	"gettat",
	"gettonat",
	"ghermit",
	"ghettizzat",
	"ghigliottinat",
	"ghindat",
	"gibollat",
	"gingillat",
	"ginnat",
	"giocat",
	"gioit",
	"gionglat",
	"giovaneggiat",
	"giovat",
	"girandolat",
	"girat",
	"giudicat",
	"giulebbat",
	"giuntat",
	"giunt",
	"giuracchiat",
	"giurat",
	"giustappost",
	"giustificat",
	"giustiziat",
	"glamourizzat",
	"glassat",
	"glissat",
	"globalizzat",
	"gloriat",
	"glorificat",
	"glossat",
	"godronat",
	"godut",
	"goffrat",
	"gommat",
	"gonfiat",
	"googlat",
	"gottat",
	"governat",
	"gradinat",
	"gradit",
	"gradualizzat",
	"graduat",
	"graffat",
	"graffiat",
	"graffit",
	"graficat",
	"grafitat",
	"gramolat",
	"granagliat",
	"grandinat",
	"granellat",
	"granit",
	"granulat",
	"graticciat",
	"graticolat",
	"gratificat",
	"gratinat",
	"grattat",
	"grattugiat",
	"gravat",
	"graziat",
	"grecheggiat",
	"grecizzat",
	"gremit",
	"gridat",
	"griffat",
	"grigliat",
	"grippat",
	"groccat",
	"grondat",
	"grugat",
	"grugnit",
	"guadagnat",
	"gualcit",
	"guardat",
	"guarit",
	"guarnit",
	"guastat",
	"guatat",
	"guerreggiat",
	"gufat",
	"guidat",
	"gustat",
	"hackerat",
	"handicappat",
	"ibernat",
	"ibridat",
	"idealizzat",
	"ideat",
	"identificat",
	"ideologizzat",
	"idolatrat",
	"idoleggiat",
	"idratat",
	"idrogenat",
	"idrolizzat",
	"iettat",
	"igienizzat",
	"ignifugat",
	"ignorat",
	"illanguidit",
	"illeggiadrit",
	"illividit",
	"illuminat",
	"illus",
	"illustrat",
	"imbacuccat",
	"imbaldanzit",
	"imballat",
	"imbalsamat",
	"imbambolat",
	"imbandierat",
	"imbandit",
	"imbarbarit",
	"imbarcat",
	"imbarilat",
	"imbastardit",
	"imbastit",
	"imbattut",
	"imbavagliat",
	"imbeccat",
	"imbellettat",
	"imbellit",
	"imbestialit",
	"imbestiat",
	"imbevut",
	"imbiaccat",
	"imbiancat",
	"imbianchit",
	"imbibit",
	"imbiettat",
	"imbiondit",
	"imbizzarrit",
	"imboccat",
	"imbonit",
	"imborghesit",
	"imboscat",
	"imboschit",
	"imbottat",
	"imbottigliat",
	"imbottit",
	"imbozzimat",
	"imbracat",
	"imbracciat",
	"imbragat",
	"imbrancat",
	"imbrattat",
	"imbrecciat",
	"imbrigliat",
	"imbrillantinat",
	"imbroccat",
	"imbrodat",
	"imbrogliat",
	"imbronciat",
	"imbruttit",
	"imbucat",
	"imbudellat",
	"imbullettat",
	"imbullonat",
	"imburrat",
	"imbussolat",
	"imbustat",
	"imbutit",
	"imitat",
	"immagazzinat",
	"immaginat",
	"immalinconit",
	"immatricolat",
	"immedesimat",
	"immers",
	"immess",
	"immischiat",
	"immiserit",
	"immobilizzat",
	"immolat",
	"immortalat",
	"immunizzat",
	"immusonit",
	"impaccat",
	"impacchettat",
	"impacciat",
	"impadronit",
	"impaginat",
	"impagliat",
	"impalat",
	"impalcat",
	"impallat",
	"impallinat",
	"impalmat",
	"impaludat",
	"impanat",
	"impaniat",
	"impannat",
	"impantanat",
	"impaperat",
	"impapocchiat",
	"impappinat",
	"imparentat",
	"imparruccat",
	"impartit",
	"impastat",
	"impasticcat",
	"impasticciat",
	"impastocchiat",
	"impastoiat",
	"impataccat",
	"impattat",
	"impaurit",
	"impavesat",
	"impeciat",
	"impedicat",
	"impedit",
	"impegnat",
	"impegolat",
	"impelagat",
	"impellicciat",
	"impennacchiat",
	"impennat",
	"impensierit",
	"impepat",
	"imperlat",
	"impermalit",
	"impermeabilizzat",
	"imperniat",
	"impersonat",
	"impersonificat",
	"impestat",
	"impetrat",
	"impiallacciat",
	"impiantat",
	"impiastrat",
	"impiastricciat",
	"impiccat",
	"impicciat",
	"impicciolit",
	"impiccolit",
	"impidocchiat",
	"impiegat",
	"impietosit",
	"impietrit",
	"impigliat",
	"impigrit",
	"impilat",
	"impillaccherat",
	"impinguat",
	"impint",
	"impinzat",
	"impiombat",
	"impipat",
	"impiumat",
	"implementat",
	"implicat",
	"implorat",
	"impollinat",
	"impolpat",
	"impoltronit",
	"impolverat",
	"impomatat",
	"imporcat",
	"imporporat",
	"importat",
	"importunat",
	"impossessat",
	"impossibilitat",
	"impostat",
	"impost",
	"impratichit",
	"impregnat",
	"impres",
	"impressionat",
	"impress",
	"imprestat",
	"impreziosit",
	"imprigionat",
	"impromess",
	"improntat",
	"improsciuttit",
	"impugnat",
	"impuntit",
	"impunturat",
	"impupat",
	"imputat",
	"impuzzolentit",
	"inabilitat",
	"inabissat",
	"inacerbit",
	"inacetit",
	"inacidit",
	"inacutit",
	"inaffiat",
	"inalat",
	"inalberat",
	"inalveat",
	"inalzat",
	"inamidat",
	"inanellat",
	"inarcat",
	"inargentat",
	"inaridit",
	"inasprit",
	"inastat",
	"inattivat",
	"inaugurat",
	"incacchiat",
	"incalcinat",
	"incalorit",
	"incalzat",
	"incamerat",
	"incamiciat",
	"incamminat",
	"incanaglit",
	"incanalat",
	"incannat",
	"incannucciat",
	"incaponit",
	"incappottat",
	"incappucciat",
	"incaprettat",
	"incapricciat",
	"incapsulat",
	"incarcerat",
	"incardinat",
	"incaricat",
	"incarnat",
	"incarrozzat",
	"incartat",
	"incartocciat",
	"incartonat",
	"incasellat",
	"incasinat",
	"incassat",
	"incastellat",
	"incastonat",
	"incastrat",
	"incatenat",
	"incatramat",
	"incattivit",
	"incavat",
	"incavigliat",
	"incavolat",
	"incazzat",
	"incellofanat",
	"incendiat",
	"incenerit",
	"incensat",
	"incentivat",
	"incentrat",
	"inceppat",
	"incerat",
	"incernierat",
	"incerottat",
	"inces",
	"incettat",
	"inchiappettat",
	"inchiavardat",
	"inchiest",
	"inchinat",
	"inchiodat",
	"inchiostrat",
	"incipriat",
	"incis",
	"incistat",
	"incitat",
	"inciuccat",
	"incivilit",
	"inclinat",
	"inclus",
	"incoccat",
	"incocciat",
	"incoiat",
	"incollat",
	"incolonnat",
	"incolpat",
	"incominciat",
	"incomodat",
	"incontrat",
	"incoraggiat",
	"incordat",
	"incornat",
	"incorniciat",
	"incoronat",
	"incorporat",
	"incott",
	"incravattat",
	"incrementat",
	"increspat",
	"incretinit",
	"incriminat",
	"incrinat",
	"incrociat",
	"incrostat",
	"incrudelit",
	"incrudit",
	"incruscat",
	"incubat",
	"inculat",
	"inculcat",
	"incuneat",
	"incuoiat",
	"incuorat",
	"incupit",
	"incuriosit",
	"incurvat",
	"incuss",
	"indagat",
	"indebitat",
	"indebolit",
	"indemaniat",
	"indennizzat",
	"indett",
	"indicat",
	"indicizzat",
	"indignat",
	"indirett",
	"indirizzat",
	"indispettit",
	"indispost",
	"individualizzat",
	"individuat",
	"indolenzit",
	"indorat",
	"indossat",
	"indott",
	"indottom",
	"indottrinat",
	"indovinat",
	"indugiat",
	"indult",
	"indurat",
	"indurit",
	"industrializzat",
	"industriat",
	"inebetit",
	"inebriat",
	"inerit",
	"inerpicat",
	"infagottat",
	"infamat",
	"infangat",
	"infarcit",
	"infarinat",
	"infastidit",
	"infatuat",
	"infeltrit",
	"inferit",
	"inferocit",
	"infert",
	"infervorat",
	"infestat",
	"infettat",
	"infeudat",
	"infiacchit",
	"infialat",
	"infialettat",
	"infiammat",
	"infiascat",
	"infibulat",
	"inficiat",
	"infilat",
	"infiltrat",
	"infilzat",
	"infingardit",
	"infinocchiat",
	"infint",
	"infioccat",
	"infiocchettat",
	"infiochit",
	"infiorat",
	"infirmat",
	"infischiat",
	"infiss",
	"infittit",
	"inflazionat",
	"infless",
	"inflitt",
	"influenzat",
	"infocat",
	"infoderat",
	"infognat",
	"infoibat",
	"infoltit",
	"inforcat",
	"informatizzat",
	"informat",
	"informicolat",
	"informicolit",
	"infornaciat",
	"infornat",
	"infortunat",
	"infoscat",
	"infossat",
	"infradiciat",
	"inframess",
	"inframezzat",
	"inframmess",
	"inframmezzat",
	"infrancesat",
	"infrappost",
	"infrascat",
	"infrattat",
	"infreddat",
	"infronzolat",
	"infuocat",
	"infurbit",
	"infuriat",
	"ingabbiat",
	"ingaggiat",
	"ingagliardit",
	"ingannat",
	"ingarbugliat",
	"ingavonat",
	"ingegnat",
	"ingegnerizzat",
	"ingelosit",
	"ingemmat",
	"ingenerat",
	"ingentilit",
	"ingerit",
	"ingessat",
	"inghiaiat",
	"inghiottit",
	"inghirlandat",
	"ingiallit",
	"ingigantit",
	"inginocchiat",
	"ingioiellat",
	"ingiunt",
	"ingiuriat",
	"inglesizzat",
	"inglobat",
	"ingoffit",
	"ingoiat",
	"ingolfat",
	"ingollat",
	"ingolosit",
	"ingombrat",
	"ingommat",
	"ingorgat",
	"ingozzat",
	"ingranat",
	"ingrandit",
	"ingrassat",
	"ingraticciat",
	"ingraticolat",
	"ingravidat",
	"ingraziat",
	"ingraziosit",
	"ingrigit",
	"ingrommat",
	"ingrossat",
	"ingrullit",
	"inguaiat",
	"inguainat",
	"ingualdrappat",
	"inguantat",
	"ingurgitat",
	"inibit",
	"iniettat",
	"inimicat",
	"inizializzat",
	"iniziat",
	"inmillat",
	"innacquat",
	"innaffiat",
	"innalzat",
	"innamorat",
	"innastat",
	"innervat",
	"innervosit",
	"innescat",
	"innestat",
	"innevat",
	"innocentat",
	"innocuizzat",
	"innovat",
	"inoculat",
	"inoltrat",
	"inondat",
	"inorgoglit",
	"inorpellat",
	"inorridit",
	"inquadrat",
	"inquietat",
	"inquisit",
	"insabbiat",
	"insacchettat",
	"insalat",
	"insaldat",
	"insalivat",
	"insanguinat",
	"insaponat",
	"insaporit",
	"inscatolat",
	"inscenat",
	"inscritt",
	"insecchit",
	"insediat",
	"insegnat",
	"inseguit",
	"insellat",
	"inselvatichit",
	"inserit",
	"insidiat",
	"insignit",
	"insilat",
	"insinuat",
	"insolentit",
	"insonnolit",
	"insonorizzat",
	"insordit",
	"insospettit",
	"insozzat",
	"inspessit",
	"inspirat",
	"installat",
	"instaurat",
	"insterilit",
	"instillat",
	"instituit",
	"instradat",
	"insudiciat",
	"insufflat",
	"insultat",
	"insuperbit",
	"intabaccat",
	"intabarrat",
	"intaccat",
	"intagliat",
	"intarsiat",
	"intasat",
	"intascat",
	"intavolat",
	"integrat",
	"intelaiat",
	"intelat",
	"intellettualizzat",
	"intenebrat",
	"intenerit",
	"intensificat",
	"intentat",
	"intepidit",
	"intercalat",
	"intercambiat",
	"intercettat",
	"intercis",
	"interclus",
	"intercollegat",
	"interconness",
	"interconvertit",
	"interdett",
	"interessat",
	"interfacciat",
	"interfogliat",
	"interfoliat",
	"interiorizzat",
	"interlacciat",
	"interlineat",
	"intermess",
	"intermezzat",
	"internalizzat",
	"internat",
	"internazionalizzat",
	"interpellat",
	"interpenetrat",
	"interpolat",
	"interpost",
	"interpretat",
	"interpunt",
	"interrat",
	"interrogat",
	"interrott",
	"intersecat",
	"intervallat",
	"intervistat",
	"intes",
	"intessut",
	"intestardit",
	"intestat",
	"intiepidit",
	"intimat",
	"intimidit",
	"intimorit",
	"intint",
	"intirizzit",
	"intitolat",
	"intonacat",
	"intonat",
	"intontit",
	"intorbidat",
	"intorbidit",
	"intorpidit",
	"intortat",
	"intossicat",
	"intralciat",
	"intramess",
	"intramezzat",
	"intrappolat",
	"intrapres",
	"intrattenut",
	"intravedut",
	"intravist",
	"intravvedut",
	"intravvist",
	"intrecciat",
	"intricat",
	"intrigat",
	"intrinsecat",
	"intrippat",
	"intris",
	"introdott",
	"introfless",
	"introiettat",
	"introitat",
	"intromess",
	"intronat",
	"intronizzat",
	"intrudut",
	"intrufolat",
	"intrugliat",
	"intruppat",
	"intrus",
	"intubat",
	"intubettat",
	"intuit",
	"inumat",
	"inumidit",
	"inurbat",
	"inutilizzat",
	"invaghit",
	"invaginat",
	"invalidat",
	"invasat",
	"invas",
	"invelenit",
	"inventariat",
	"inventat",
	"invenut",
	"inverdit",
	"invergat",
	"inverniciat",
	"investigat",
	"investit",
	"invetriat",
	"inviat",
	"invidiat",
	"invigorit",
	"inviluppat",
	"invischiat",
	"invitat",
	"invocat",
	"invogliat",
	"involat",
	"involgarit",
	"involtat",
	"involt",
	"inzaccherat",
	"inzeppat",
	"inzigat",
	"inzolfat",
	"inzuccat",
	"inzuccherat",
	"inzuppat",
	"iodurat",
	"ionizzat",
	"ipertrofizzat",
	"ipnotizzat",
	"ipostatizzat",
	"ipotecat",
	"ipotizzat",
	"iridat",
	"irradiat",
	"irraggiat",
	"irreggimentat",
	"irretit",
	"irrigat",
	"irrigidit",
	"irris",
	"irritat",
	"irrobustit",
	"irrogat",
	"irrorat",
	"irrugginit",
	"irruvidit",
	"ischeletrit",
	"iscritt",
	"islamizzat",
	"isolat",
	"isomerizzat",
	"ispanizzat",
	"ispessit",
	"ispezionat",
	"ispirat",
	"issat",
	"istallat",
	"istanziat",
	"istaurat",
	"isterilit",
	"istigat",
	"istillat",
	"istituit",
	"istituzionalizzat",
	"istoriat",
	"istradat",
	"istruit",
	"istupidit",
	"italianeggiat",
	"italianizzat",
	"iterat",
	"iudicat",
	"killerat",
	"labbreggiat",
	"labializzat",
	"laccat",
	"lacerat",
	"laconizzat",
	"lacrimat",
	"ladroneggiat",
	"lagnat",
	"lagrimat",
	"laicizzat",
	"lambiccat",
	"lambit",
	"lamentat",
	"laminat",
	"lanciat",
	"lapidat",
	"lappat",
	"lardat",
	"lardellat",
	"largit",
	"larvat",
	"lascat",
	"lasciat",
	"lastricat",
	"latinizzat",
	"laudat",
	"laureat",
	"lavat",
	"lavorat",
	"leccat",
	"legalizzat",
	"legat",
	"leggicchiat",
	"leggiucchiat",
	"legittimat",
	"legittimizzat",
	"legnat",
	"lemmatizzat",
	"lenit",
	"lesinat",
	"lesionat",
	"les",
	"lessat",
	"lett",
	"levat",
	"levigat",
	"liberalizzat",
	"liberat",
	"licenziat",
	"lievitat",
	"liftat",
	"lignificat",
	"limat",
	"limitat",
	"linciat",
	"linearizzat",
	"lineat",
	"linkat",
	"liofilizzat",
	"liquefatt",
	"liquidat",
	"lisat",
	"lisciat",
	"lisciviat",
	"listat",
	"litografat",
	"livellat",
	"lizzat",
	"lobotomizzat",
	"localizzat",
	"locat",
	"lodat",
	"logorat",
	"lordat",
	"lottat",
	"lottizzat",
	"lubrificat",
	"lucchettat",
	"lucidat",
	"lucrat",
	"lumeggiat",
	"luppolizzat",
	"lusingat",
	"lussat",
	"lustrat",
	"macadamizzat",
	"macchiat",
	"macchinat",
	"macellat",
	"macerat",
	"macinat",
	"maciullat",
	"maggesat",
	"maggiorat",
	"magnat",
	"magnetizzat",
	"magnificat",
	"maiolicat",
	"maledett",
	"malfatt",
	"malignat",
	"malmenat",
	"malmess",
	"maltat",
	"maltrattat",
	"malvedut",
	"malversat",
	"malvist",
	"malvolut",
	"mandat",
	"mandrinat",
	"manducat",
	"maneggiat",
	"manganat",
	"manganellat",
	"mangiat",
	"mangiucchiat",
	"manifatturat",
	"manifestat",
	"manimess",
	"manipolat",
	"manlevat",
	"manomess",
	"manoscritt",
	"manovrat",
	"mansuefatt",
	"mantecat",
	"mantenutas",
	"mantenut",
	"manualizzat",
	"manutenut",
	"mappat",
	"marcat",
	"marchiat",
	"marcit",
	"marezzat",
	"marginalizzat",
	"marginat",
	"margottat",
	"marimess",
	"marinat",
	"maritat",
	"marmorizzat",
	"marnat",
	"marocchinat",
	"martellat",
	"martellinat",
	"martirizzat",
	"martoriat",
	"mascherat",
	"maschiat",
	"maschiettat",
	"mascolinizzat",
	"massacrat",
	"massaggiat",
	"massellat",
	"massicciat",
	"massificat",
	"massimat",
	"massimizzat",
	"mastectomizzat",
	"masterizzat",
	"masticat",
	"masturbat",
	"matematizzat",
	"materializzat",
	"matricolat",
	"mattonat",
	"maturat",
	"mazziat",
	"mazzolat",
	"meccanizzat",
	"medagliat",
	"mediat",
	"medicalizzat",
	"medicat",
	"meditat",
	"membrat",
	"memorizzat",
	"menat",
	"mendicat",
	"menomat",
	"mentovat",
	"menzionat",
	"meravigliat",
	"mercanteggiat",
	"mercerizzat",
	"mercificat",
	"meriat",
	"meridionalizzat",
	"meritat",
	"merlat",
	"merlettat",
	"mers",
	"mesciat",
	"mesciut",
	"mescolat",
	"mescut",
	"mesmerizzat",
	"messaggiat",
	"mess",
	"messoc",
	"mestat",
	"mesticat",
	"mestruat",
	"metabolizzat",
	"metaforeggiat",
	"metaforizzat",
	"metallizzat",
	"metamorfizzat",
	"metamorfosat",
	"metanizzat",
	"metilat",
	"metodizzat",
	"microfilmat",
	"microfonat",
	"microminiaturizzat",
	"micronizzat",
	"mietut",
	"migliorat",
	"militarizzat",
	"millantat",
	"millimetrat",
	"mimat",
	"mimeografat",
	"mimetizzat",
	"minacciat",
	"minat",
	"minchionat",
	"mineralizzat",
	"miniat",
	"miniaturizzat",
	"minimizzat",
	"minuit",
	"minuzzat",
	"miracolat",
	"miscelat",
	"mischiat",
	"misconosciut",
	"missat",
	"mistificat",
	"misturat",
	"misurat",
	"miticizzat",
	"mitigat",
	"mitizzat",
	"mitragliat",
	"mitrat",
	"mixat",
	"mobiliat",
	"mobilitat",
	"mobilizzat",
	"modanat",
	"modellat",
	"modellizzat",
	"moderat",
	"modernizzat",
	"modificat",
	"modulat",
	"molat",
	"molestat",
	"mollat",
	"molleggiat",
	"moltiplicat",
	"monacat",
	"mondat",
	"mondializzat",
	"monetarizzat",
	"monetat",
	"monetizzat",
	"monitorat",
	"monitorizzat",
	"monocromatizzat",
	"monopolizzat",
	"monottongat",
	"montat",
	"monumentalizzat",
	"mordenzat",
	"mordicchiat",
	"mormorat",
	"morphat",
	"morsicat",
	"morsicchiat",
	"mors",
	"mortasat",
	"mortificat",
	"moss",
	"mostrat",
	"motivat",
	"motorizzat",
	"motteggiat",
	"movimentat",
	"mozzat",
	"mugolat",
	"mulcit",
	"multat",
	"multiplexat",
	"mummificat",
	"municipalizzat",
	"munit",
	"munt",
	"murat",
	"musat",
	"musicat",
	"mussat",
	"mutat",
	"mutilat",
	"mutizzat",
	"mutuat",
	"nappat",
	"narcotizzat",
	"narrativizzat",
	"narrat",
	"nasalizzat",
	"nascos",
	"nascost",
	"nastrat",
	"naturaleggiat",
	"naturalizzat",
	"nauseat",
	"naverat",
	"navicat",
	"navigat",
	"nazificat",
	"nazionalizzat",
	"nebulizzat",
	"necessitat",
	"necrosat",
	"necrotizzat",
	"negat",
	"negativizzat",
	"neglett",
	"negoziat",
	"negreggiat",
	"neologizzat",
	"nerbat",
	"nericat",
	"nettat",
	"neutralizzat",
	"nevat",
	"nevicat",
	"nevischiat",
	"nevrotizzat",
	"nichelat",
	"niellat",
	"ninfeggiat",
	"ninnat",
	"ninnolat",
	"nitratat",
	"nitrificat",
	"nobilitat",
	"noiat",
	"noleggiat",
	"nomat",
	"nominalizzat",
	"nominat",
	"normalizzat",
	"normat",
	"notat",
	"notificat",
	"notiziat",
	"notricat",
	"noverat",
	"nuclearizzat",
	"nudricat",
	"nullificat",
	"numerat",
	"numerizzat",
	"nuotat",
	"nutrit",
	"obbiettat",
	"obbliat",
	"obbligat",
	"oberat",
	"obiettat",
	"obiettivat",
	"obiettivizzat",
	"obiurgat",
	"obliat",
	"obliterat",
	"obnubilat",
	"occasionat",
	"occhieggiat",
	"occidentalizzat",
	"occis",
	"occlus",
	"occultat",
	"occupat",
	"ocheggiat",
	"odiat",
	"odorat",
	"odorizzat",
	"offerit",
	"offert",
	"offes",
	"officiat",
	"offiziat",
	"offuscat",
	"ofiziat",
	"oggettivat",
	"oggettivizzat",
	"oggettualizzat",
	"oliat",
	"olit",
	"olografat",
	"oltraggiat",
	"oltrapassat",
	"oltrepassat",
	"omaggiat",
	"ombrat",
	"ombreggiat",
	"omess",
	"omogeneizzat",
	"omogenizzat",
	"omologat",
	"ondat",
	"ondulat",
	"onestat",
	"onnubilat",
	"onorat",
	"opacat",
	"opacizzat",
	"operat",
	"opinat",
	"oppiat",
	"oppignorat",
	"oppilat",
	"oppost",
	"oppress",
	"oppugnat",
	"oprat",
	"opsonizzat",
	"optat",
	"opzionat",
	"orbitat",
	"orchestrat",
	"ordinat",
	"ordit",
	"orecchiat",
	"organat",
	"organicat",
	"organizzat",
	"orgasmat",
	"orientalizzat",
	"orientat",
	"originat",
	"origliat",
	"orizzontat",
	"orlat",
	"orlettat",
	"ormat",
	"ormeggiat",
	"ornat",
	"orpellat",
	"orrat",
	"orripilat",
	"ortogonalizzat",
	"osannat",
	"osat",
	"osculat",
	"oscurat",
	"ospedalizzat",
	"ospitat",
	"ossedut",
	"ossequiat",
	"osservat",
	"ossessionat",
	"ossidat",
	"ossificat",
	"ossitonizzat",
	"ostacolat",
	"osteggiat",
	"ostentat",
	"ostinat",
	"ostracizzat",
	"ostruit",
	"ottemperat",
	"ottenebrat",
	"ottenut",
	"ottimalizzat",
	"ottimat",
	"ottimizzat",
	"ottonat",
	"ottriat",
	"ottuplicat",
	"otturat",
	"ottus",
	"ottuss",
	"ovalizzat",
	"ovariectomizzat",
	"ovattat",
	"overcloccat",
	"ovrat",
	"ovviat",
	"ozieggiat",
	"ozonizzat",
	"pacat",
	"pacciamat",
	"pacificat",
	"padroneggiat",
	"paganizzat",
	"pagat",
	"paginat",
	"palafittat",
	"palatalizzat",
	"palat",
	"palesat",
	"palettat",
	"palettizzat",
	"palificat",
	"palleggiat",
	"pallettizzat",
	"palpat",
	"palpeggiat",
	"panat",
	"panneggiat",
	"panoramicat",
	"pappat",
	"paracadutat",
	"parafat",
	"paraffinat",
	"parafrasat",
	"paragonat",
	"paragrafat",
	"paralizzat",
	"parallelizzat",
	"parametrat",
	"parametrizzat",
	"parassitat",
	"parat",
	"parcat",
	"parcellizzat",
	"parcheggiat",
	"pareggiat",
	"parificat",
	"parkerizzat",
	"parlat",
	"parlucchiat",
	"parodiat",
	"partecipat",
	"particolareggiat",
	"particolarizzat",
	"partizionat",
	"partorit",
	"parzializzat",
	"pasciut",
	"pascolat",
	"passat",
	"passeggiat",
	"passionat",
	"passivat",
	"pasticciat",
	"pastorizzat",
	"pasturat",
	"patinat",
	"patit",
	"patrocinat",
	"patteggiat",
	"pattugliat",
	"pattuit",
	"paventat",
	"pavesat",
	"pavimentat",
	"pavoneggiat",
	"pazziat",
	"pedinat",
	"pedonalizzat",
	"peggiorat",
	"pelat",
	"pellettizzat",
	"penalizzat",
	"penetrat",
	"pennellat",
	"pensat",
	"pensionat",
	"pentit",
	"pepat",
	"peptonizzat",
	"peragrat",
	"percentualizzat",
	"percepit",
	"percolat",
	"percors",
	"percoss",
	"perdonat",
	"perdott",
	"perdut",
	"perequat",
	"perfatt",
	"perfezionat",
	"perforat",
	"performat",
	"perit",
	"periziat",
	"perlustrat",
	"permeat",
	"permess",
	"perorat",
	"perpetrat",
	"perpetuat",
	"perplimut",
	"perquisit",
	"perscrutat",
	"perseguitat",
	"perseguit",
	"pers",
	"personalizzat",
	"personificat",
	"persuas",
	"perturbat",
	"pervas",
	"pervertit",
	"pesat",
	"pescat",
	"pestat",
	"petrarcheggiat",
	"pettegolat",
	"pettinat",
	"piagat",
	"piaggiat",
	"piallat",
	"pianeggiat",
	"pianificat",
	"piantat",
	"piantatal",
	"piantat",
	"piant",
	"piantonat",
	"piantumat",
	"piastrellat",
	"piatit",
	"piazzat",
	"picchettat",
	"picchiat",
	"picchierellat",
	"picchiettat",
	"picconat",
	"piegat",
	"pieghettat",
	"pietrificat",
	"pigiat",
	"pigliat",
	"pigmentat",
	"pignorat",
	"pigolat",
	"pilotat",
	"pimentat",
	"pint",
	"pinzat",
	"piombat",
	"piovigginat",
	"piovut",
	"pipat",
	"pippat",
	"piratat",
	"pirogenat",
	"pisciat",
	"pitoccat",
	"pittat",
	"pitturat",
	"pizzicat",
	"pizzicottat",
	"placat",
	"placcat",
	"plagiat",
	"plasmat",
	"plasticat",
	"plastificat",
	"platinat",
	"plissettat",
	"pluralizzat",
	"poetat",
	"poeticizzat",
	"poggiat",
	"polarizzat",
	"poligrafat",
	"polimerizzat",
	"politicizzat",
	"polverizzat",
	"pomiciat",
	"pompat",
	"ponderat",
	"ponzat",
	"popolarizzat",
	"popolat",
	"poppat",
	"porcellanat",
	"porfirizzat",
	"portat",
	"portes",
	"port",
	"porzionat",
	"posat",
	"posdatat",
	"positivizzat",
	"posizionat",
	"pospost",
	"possedut",
	"postat",
	"postdatat",
	"posteggiat",
	"posticipat",
	"postillat",
	"post",
	"postsincronizzat",
	"postulat",
	"potabilizzat",
	"potat",
	"potenziat",
	"potut",
	"pralinat",
	"praticat",
	"preaccennat",
	"preannunciat",
	"preannunziat",
	"preavvertit",
	"preavvisat",
	"precaricat",
	"precedut",
	"precettat",
	"precint",
	"precisat",
	"preclus",
	"precompilat",
	"precompress",
	"preconfezionat",
	"preconizzat",
	"preconosciut",
	"precors",
	"precostituit",
	"predat",
	"predefinit",
	"predestinat",
	"predeterminat",
	"predett",
	"predicat",
	"predigerit",
	"predilett",
	"predispost",
	"preelett",
	"preesistut",
	"prefabbricat",
	"prefat",
	"prefatt",
	"prefazionat",
	"preferit",
	"prefigurat",
	"prefinanziat",
	"prefissat",
	"prefiss",
	"preformat",
	"pregat",
	"pregiat",
	"pregiudicat",
	"pregustat",
	"preimpregnat",
	"prelevat",
	"premeditat",
	"premescolat",
	"premess",
	"premiat",
	"premonit",
	"premunit",
	"premurat",
	"premut",
	"prenotat",
	"preoccupat",
	"preordinat",
	"preparat",
	"prepensionat",
	"prepigmentat",
	"prepost",
	"preprogrammat",
	"preraffreddat",
	"prerefrigerat",
	"preregistrat",
	"preregolat",
	"preriscaldat",
	"pres",
	"presagit",
	"presaput",
	"presasel",
	"prescelt",
	"prescritt",
	"presedut",
	"presegnalat",
	"preselezionat",
	"presentat",
	"presentit",
	"preservat",
	"presidiat",
	"presiedut",
	"pres",
	"pressat",
	"press",
	"pressurizzat",
	"prestabilit",
	"prestampat",
	"prestat",
	"prestigiat",
	"presunt",
	"presuppost",
	"pretermess",
	"pretes",
	"pretrattat",
	"prevaricat",
	"prevedut",
	"prevendut",
	"preventivat",
	"prevenut",
	"previst",
	"prezzat",
	"prezzolat",
	"principiat",
	"privatizzat",
	"privat",
	"privilegiat",
	"problematizzat",
	"procacciat",
	"processat",
	"proclamat",
	"procrastinat",
	"procreat",
	"procurat",
	"prodigat",
	"prodott",
	"profanat",
	"proferit",
	"professat",
	"professionalizzat",
	"profetat",
	"profetizzat",
	"profferit",
	"profilat",
	"profondat",
	"profumat",
	"profus",
	"progettat",
	"prognosticat",
	"programmat",
	"proibit",
	"proiettat",
	"proletarizzat",
	"prolungat",
	"promanat",
	"promess",
	"promoss",
	"promozionat",
	"promulgat",
	"pronosticat",
	"pronunciat",
	"pronunziat",
	"propagandat",
	"propagat",
	"propagginat",
	"propalat",
	"propinat",
	"propiziat",
	"proporzionat",
	"propost",
	"propugnat",
	"propuls",
	"prorogat",
	"prosciolt",
	"prosciugat",
	"proscritt",
	"proseguit",
	"prospettat",
	"prosternat",
	"prostes",
	"prostituit",
	"prostrat",
	"prosunt",
	"protes",
	"protestat",
	"protett",
	"protocollat",
	"protonat",
	"protratt",
	"protrus",
	"provat",
	"provedut",
	"provincializzat",
	"provist",
	"provocat",
	"provvedut",
	"provvist",
	"psicanalizzat",
	"psichiatrizzat",
	"psicoanalizzat",
	"psicologizzat",
	"pubblicat",
	"pubblicizzat",
	"puddellat",
	"pugnalat",
	"pulit",
	"pungolat",
	"punit",
	"puntat",
	"punteggiat",
	"puntellat",
	"punt",
	"puntualizzat",
	"punzecchiat",
	"punzonat",
	"purgat",
	"purificat",
	"putit",
	"putrefatt",
	"putrit",
	"quadrat",
	"quadrettat",
	"quadriennalizzat",
	"quadruplicat",
	"qualificat",
	"quantificat",
	"quantizzat",
	"querelat",
	"questuat",
	"quetat",
	"quietanzat",
	"quietat",
	"quintessenziat",
	"quintuplicat",
	"quotat",
	"quotizzat",
	"rabberciat",
	"rabboccat",
	"rabbonit",
	"rabbuffat",
	"rabuffat",
	"raccapezzat",
	"raccapricciat",
	"raccattat",
	"raccerchiat",
	"racces",
	"racchetat",
	"racchius",
	"raccolt",
	"raccolt",
	"raccomandat",
	"raccomodat",
	"raccontat",
	"raccorciat",
	"raccorcit",
	"raccordat",
	"raccostat",
	"raccozzat",
	"racemizzat",
	"racimolat",
	"radazzat",
	"raddensat",
	"raddobbat",
	"raddolcit",
	"raddoppiat",
	"raddott",
	"raddrizzat",
	"radiat",
	"radicalizzat",
	"radioassistit",
	"radioattivat",
	"radiocomandat",
	"radiodiffus",
	"radiografat",
	"radioguidat",
	"radiolocalizzat",
	"radiomarcat",
	"radiotelegrafat",
	"radiotrasmess",
	"radunat",
	"raffazzonat",
	"raffermat",
	"raffigurat",
	"raffilat",
	"raffinat",
	"rafforzat",
	"raffreddat",
	"raffrenat",
	"raffrescat",
	"raffrontat",
	"raggelat",
	"raggentilit",
	"ragghiat",
	"raggirat",
	"raggiunt",
	"raggiustat",
	"raggomitolat",
	"raggranchiat",
	"raggranchit",
	"raggranellat",
	"raggrinzat",
	"raggrinzit",
	"raggrumat",
	"raggruppat",
	"raggruzzolat",
	"ragguagliat",
	"ralingat",
	"rallegrat",
	"rallentat",
	"ramat",
	"ramazzat",
	"rammagliat",
	"rammaricat",
	"rammemorat",
	"rammendat",
	"rammentat",
	"rammodernat",
	"rammollit",
	"rammorbidit",
	"rampognat",
	"randellat",
	"randomizzat",
	"rannicchiat",
	"rannuvolat",
	"ranzat",
	"rapat",
	"rapinat",
	"rapit",
	"rappacificat",
	"rappat",
	"rappattumat",
	"rappezzat",
	"rapportat",
	"rappresantat",
	"rappresentat",
	"rappres",
	"rarefatt",
	"rasat",
	"raschiat",
	"raschiettat",
	"rasentat",
	"ras",
	"raspat",
	"rassegnat",
	"rasserenat",
	"rassettat",
	"rassicurat",
	"rassodat",
	"rassomigliat",
	"rassottigliat",
	"rassunt",
	"rastrellat",
	"rastremat",
	"rateat",
	"rateizzat",
	"ratificat",
	"ratinat",
	"rattizzat",
	"rattoppat",
	"rattort",
	"rattrappit",
	"rattristat",
	"rattristit",
	"raunat",
	"ravvalorat",
	"ravvedut",
	"ravviat",
	"ravvicinat",
	"ravviluppat",
	"ravvisat",
	"ravvist",
	"ravvivat",
	"ravvolt",
	"ravvoltolat",
	"razionalizzat",
	"razionat",
	"razziat",
	"razzolat",
	"realizzat",
	"reassunt",
	"recapitat",
	"recat",
	"recedut",
	"recensit",
	"recepit",
	"recidivat",
	"recintat",
	"recint",
	"reciprocat",
	"recis",
	"recitat",
	"reclamat",
	"reclamizzat",
	"reclinat",
	"reclus",
	"reclutat",
	"recuperat",
	"redarguit",
	"redatt",
	"redazzat",
	"reddut",
	"redent",
	"redistribuit",
	"redott",
	"referenziat",
	"refertat",
	"refilat",
	"refless",
	"reflettut",
	"refrant",
	"refrigerat",
	"regalat",
	"regimat",
	"regimentat",
	"regionalizzat",
	"registrat",
	"regolamentat",
	"regolarizzat",
	"regolat",
	"reidratat",
	"reificat",
	"reimbarcat",
	"reimmers",
	"reimmess",
	"reimparat",
	"reimpastat",
	"reimpiantat",
	"reimpiegat",
	"reimportat",
	"reimpostat",
	"reincarcerat",
	"reincaricat",
	"reincarnat",
	"reincis",
	"reincontrat",
	"reindirizzat",
	"reindustrializzat",
	"reinfettat",
	"reingaggiat",
	"reinizializzat",
	"reinnestat",
	"reinoltrat",
	"reinscritt",
	"reinsediat",
	"reinserit",
	"reinstallat",
	"reinstaurat",
	"reintegrat",
	"reinterpretat",
	"reintitolat",
	"reintrodott",
	"reinventat",
	"reinvestit",
	"reiterat",
	"relativizzat",
	"relazionat",
	"relegat",
	"remixat",
	"remunerat",
	"renderizzat",
	"reperit",
	"repertat",
	"replicat",
	"repress",
	"repuls",
	"reputat",
	"requisit",
	"resciss",
	"resecat",
	"resettat",
	"residuat",
	"resinificat",
	"res",
	"resolat",
	"resolt",
	"respint",
	"respirat",
	"responsabilizzat",
	"respost",
	"restaurat",
	"restituit",
	"resunt",
	"resuscitat",
	"reticolat",
	"retinat",
	"retribuit",
	"retrocedut",
	"retrocess",
	"retrodatat",
	"rettificat",
	"rett",
	"reumatizzat",
	"revisionat",
	"revocat",
	"riabbassat",
	"riabbellit",
	"riabbonat",
	"riabbottonat",
	"riabbracciat",
	"riabilitat",
	"riabitat",
	"riabituat",
	"riaccadut",
	"riaccasat",
	"riacces",
	"riaccettat",
	"riacchiappat",
	"riacciuffat",
	"riaccolt",
	"riaccomodat",
	"riaccompagnat",
	"riaccordat",
	"riaccostat",
	"riaccreditat",
	"riacquisit",
	"riacquistat",
	"riacutizzat",
	"riadattat",
	"riaddestrat",
	"riaddormentat",
	"riadoperat",
	"riaffacciat",
	"riaffermat",
	"riafferrat",
	"riaffiorat",
	"riaffittat",
	"riaffrontat",
	"riagganciat",
	"riaggiornat",
	"riaggiustat",
	"riaggravat",
	"riaggregat",
	"riagguantat",
	"rialimentat",
	"riallacciat",
	"riallargat",
	"riallineat",
	"riallocat",
	"riallungat",
	"rialzat",
	"riamat",
	"riambientat",
	"riammalat",
	"riammess",
	"riammodernat",
	"riammogliat",
	"rianimat",
	"rianness",
	"riannodat",
	"riannunciat",
	"riapert",
	"riappacificat",
	"riappaltat",
	"riapparecchiat",
	"riapparit",
	"riappes",
	"riappiccicat",
	"riapplicat",
	"riappres",
	"riapprodat",
	"riappropriat",
	"riapprovat",
	"riarmat",
	"riarrangiat",
	"riarredat",
	"riascoltat",
	"riasfaltat",
	"riassalit",
	"riassaporat",
	"riassegnat",
	"riassemblat",
	"riassestat",
	"riassettat",
	"riassicurat",
	"riassociat",
	"riassopit",
	"riassorbit",
	"riassunt",
	"riattaccat",
	"riattat",
	"riattes",
	"riattint",
	"riattivat",
	"riattizzat",
	"riattraversat",
	"riaumentat",
	"riavut",
	"riavventat",
	"riavvertit",
	"riavviat",
	"riavvicinat",
	"riavvint",
	"riavvisat",
	"riavvistat",
	"riavvolt",
	"riazzuffat",
	"ribaciat",
	"ribadit",
	"ribaltat",
	"ribassat",
	"ribattezzat",
	"ribattut",
	"ribellat",
	"ribenedett",
	"ribevut",
	"ributtat",
	"ricacciat",
	"ricalat",
	"ricalcat",
	"ricalcificat",
	"ricalcitrat",
	"ricalcolat",
	"ricalibrat",
	"ricamat",
	"ricambiat",
	"ricanalizzat",
	"ricandidat",
	"ricantat",
	"ricapitalizzat",
	"ricapitolat",
	"ricaricat",
	"ricategorizzat",
	"ricattat",
	"ricavat",
	"ricelebrat",
	"ricercat",
	"ricetrasmess",
	"ricettat",
	"ricevut",
	"richiamat",
	"richiest",
	"richius",
	"riciclat",
	"ricint",
	"ricircolat",
	"riclassificat",
	"ricodificat",
	"ricollegat",
	"ricollocat",
	"ricolmat",
	"ricolonizzat",
	"ricolorat",
	"ricolorit",
	"ricoltivat",
	"ricombinat",
	"ricominciat",
	"ricommess",
	"ricomparit",
	"ricompattat",
	"ricompensat",
	"ricomperat",
	"ricompilat",
	"ricompiut",
	"ricompost",
	"ricomprat",
	"ricompress",
	"ricomunicat",
	"riconcedut",
	"riconcess",
	"riconciliat",
	"ricondizionat",
	"ricondott",
	"riconfermat",
	"riconfezionat",
	"riconfigurat",
	"riconfortat",
	"riconfus",
	"ricongelat",
	"ricongiunt",
	"riconness",
	"riconosciut",
	"riconquistat",
	"riconsacrat",
	"riconsegnat",
	"riconsiderat",
	"riconsigliat",
	"riconsolat",
	"ricontat",
	"ricontattat",
	"ricontrattat",
	"ricontratt",
	"ricontrollat",
	"riconvalidat",
	"riconvenut",
	"riconvertit",
	"riconvint",
	"riconvocat",
	"riconvogliat",
	"ricopert",
	"ricopiat",
	"ricordat",
	"ricoricat",
	"ricorrett",
	"ricospars",
	"ricostituit",
	"ricostrett",
	"ricostruit",
	"ricott",
	"ricoverat",
	"ricreat",
	"ricristallizzat",
	"ricrocifiss",
	"ricucit",
	"ricuperat",
	"ricusat",
	"ridat",
	"ridecorat",
	"ridefinit",
	"ridenominat",
	"ridestat",
	"rideterminat",
	"ridett",
	"ridicolizzat",
	"ridigitat",
	"ridimensionat",
	"ridipint",
	"ridisces",
	"ridisciolt",
	"ridisciplinat",
	"ridiscuss",
	"ridisegnat",
	"ridisfatt",
	"ridispost",
	"ridistes",
	"ridistint",
	"ridistribuit",
	"ridivis",
	"ridomandat",
	"ridonat",
	"ridondat",
	"ridorat",
	"ridotat",
	"ridott",
	"ridovut",
	"riecheggiat",
	"riedificat",
	"rieducat",
	"rielaborat",
	"rielett",
	"riemess",
	"riempit",
	"riempiut",
	"rientrat",
	"riepilogat",
	"riequilibrat",
	"riequipaggiat",
	"riesaminat",
	"rieseguit",
	"riesercitat",
	"riesplos",
	"riesportat",
	"riespost",
	"riespress",
	"riespuls",
	"riestes",
	"riesumat",
	"rietichettat",
	"rievaporat",
	"rievocat",
	"rifabbricat",
	"rifasciat",
	"rifatt",
	"rifendut",
	"riferit",
	"rifermat",
	"rifermentat",
	"rifess",
	"rificcat",
	"rifilat",
	"rifiltrat",
	"rifinanziat",
	"rifinit",
	"rifirmat",
	"rifischiat",
	"rifiss",
	"rifiutat",
	"rifless",
	"riflettut",
	"rifocillat",
	"rifoderat",
	"rifondat",
	"riforestat",
	"riforgiat",
	"riformat",
	"riformattat",
	"riformulat",
	"rifornit",
	"rifrant",
	"rifritt",
	"rifrugat",
	"rifuggit",
	"rifugiat",
	"rifus",
	"rigassificat",
	"rigat",
	"rigelat",
	"rigenerat",
	"rigettat",
	"righettat",
	"rigiocat",
	"rigirat",
	"rigiudicat",
	"rigiunt",
	"rigodut",
	"rigonfiat",
	"rigovernat",
	"riguadagnat",
	"riguardat",
	"rigurgitat",
	"rilanciat",
	"rilasciat",
	"rilassat",
	"rilavat",
	"rilavorat",
	"rilegat",
	"rilett",
	"rilevat",
	"rilocalizzat",
	"rimagliat",
	"rimandat",
	"rimaneggiat",
	"rimangiat",
	"rimappat",
	"rimarcat",
	"rimarchiat",
	"rimarginat",
	"rimaritat",
	"rimasticat",
	"rimat",
	"rimbacuccat",
	"rimbaldanzit",
	"rimbarcat",
	"rimbeccat",
	"rimbecillit",
	"rimbellit",
	"rimbiancat",
	"rimbiondit",
	"rimboccat",
	"rimbombat",
	"rimborsat",
	"rimboscat",
	"rimboschit",
	"rimbrottat",
	"rimediat",
	"rimembrat",
	"rimemorat",
	"rimenat",
	"rimeritat",
	"rimescolat",
	"rimess",
	"rimestat",
	"rimilitarizzat",
	"rimirat",
	"rimischiat",
	"rimisurat",
	"rimodellat",
	"rimodernat",
	"rimodulat",
	"rimondat",
	"rimontat",
	"rimorchiat",
	"rimors",
	"rimoss",
	"rimostrat",
	"rimotivat",
	"rimpacchettat",
	"rimpadronit",
	"rimpaginat",
	"rimpagliat",
	"rimpannucciat",
	"rimpastat",
	"rimpatriat",
	"rimpiallacciat",
	"rimpiant",
	"rimpiattat",
	"rimpiazzat",
	"rimpicciolit",
	"rimpiccolit",
	"rimpiegat",
	"rimpinguat",
	"rimpinzat",
	"rimpolpat",
	"rimpossessat",
	"rimpress",
	"rimproverat",
	"rimuginat",
	"rimunerat",
	"rimunt",
	"rimusicat",
	"rimutat",
	"rinarrat",
	"rinascost",
	"rincalcat",
	"rincalzat",
	"rincamminat",
	"rincantucciat",
	"rincarat",
	"rincarcerat",
	"rincarnat",
	"rincentrat",
	"rinchiest",
	"rinchiodat",
	"rinchius",
	"rincitrullit",
	"rincivilit",
	"rincoglionit",
	"rincollat",
	"rincominciat",
	"rincontrat",
	"rincoraggiat",
	"rincorat",
	"rincorporat",
	"rincors",
	"rincretinit",
	"rincrudit",
	"rinculcat",
	"rincuorat",
	"rindossat",
	"rindurit",
	"rinegoziat",
	"rinfacciat",
	"rinfagottat",
	"rinfiammat",
	"rinfiancat",
	"rinfilat",
	"rinfittit",
	"rinfocolat",
	"rinfoderat",
	"rinforzat",
	"rinfrancat",
	"rinfrant",
	"rinfrescat",
	"rinfus",
	"ringagliardit",
	"ringalluzzit",
	"ringiovanit",
	"ringiovenit",
	"ringoiat",
	"ringorgat",
	"ringraziat",
	"ringuainat",
	"rinnamorat",
	"rinnegat",
	"rinnestat",
	"rinnovat",
	"rinnovellat",
	"rinociut",
	"rinomat",
	"rinominat",
	"rinormalizzat",
	"rinquadrat",
	"rinsaccat",
	"rinsaldat",
	"rinsanguat",
	"rinselvatichit",
	"rinselvat",
	"rinserrat",
	"rintanat",
	"rintasat",
	"rintascat",
	"rintavolat",
	"rintenerit",
	"rinterrat",
	"rinterrogat",
	"rintes",
	"rintiepidit",
	"rintoccat",
	"rintonacat",
	"rintontit",
	"rintorpidit",
	"rintracciat",
	"rintrodott",
	"rintronat",
	"rintuzzat",
	"rinunciat",
	"rinunziat",
	"rinutrit",
	"rinvangat",
	"rinvasat",
	"rinvenut",
	"rinverdit",
	"rinvestit",
	"rinviat",
	"rinvigorit",
	"rinvilit",
	"rinvitat",
	"rinvoltat",
	"rinvolt",
	"rinvoltolat",
	"rinzaffat",
	"rinzeppat",
	"riobbligat",
	"rioccupat",
	"rioffert",
	"rioffes",
	"rioperat",
	"riordinat",
	"riorganizzat",
	"riorientat",
	"riosservat",
	"riottenut",
	"riottimizzat",
	"riotturat",
	"ripagat",
	"riparametrizzat",
	"riparat",
	"ripartit",
	"ripassat",
	"ripercors",
	"ripercoss",
	"riperdut",
	"ripers",
	"ripesat",
	"ripescat",
	"ripestat",
	"ripetut",
	"ripianat",
	"ripianificat",
	"ripiantat",
	"ripiant",
	"ripicchiat",
	"ripiegat",
	"ripigliat",
	"ripint",
	"ripiovut",
	"ripitturat",
	"riplasmat",
	"ripolarizzat",
	"ripopolat",
	"riportat",
	"riport",
	"riposat",
	"riposizionat",
	"ripossedut",
	"ripost",
	"ripotut",
	"ripresentat",
	"ripres",
	"riprestat",
	"ripretes",
	"riprincipiat",
	"ripristinat",
	"riprivatizzat",
	"riprodott",
	"riprogettat",
	"riprogrammat",
	"ripromess",
	"ripropost",
	"riprotett",
	"riprovat",
	"riprovvedut",
	"riprovvist",
	"ripubblicat",
	"ripudiat",
	"ripugnat",
	"ripulit",
	"ripuntat",
	"ripunt",
	"ripurgat",
	"riputat",
	"riquadrat",
	"riqualificat",
	"rires",
	"rirott",
	"risaldat",
	"risalit",
	"risaltat",
	"risalutat",
	"risanat",
	"risaput",
	"risarcit",
	"riscalat",
	"riscaldat",
	"riscattat",
	"riscelt",
	"risces",
	"rischiarat",
	"rischiat",
	"risciacquat",
	"risciolt",
	"riscommess",
	"riscontat",
	"riscontrat",
	"risconvolt",
	"riscopert",
	"riscoppiat",
	"riscors",
	"riscoss",
	"riscritt",
	"risecat",
	"risedut",
	"risegat",
	"risegnat",
	"riselciat",
	"riselezionat",
	"riseminat",
	"risentit",
	"riseppellit",
	"riserbat",
	"riservat",
	"risicat",
	"risigillat",
	"risistemat",
	"ris",
	"risoffiat",
	"risoggiunt",
	"risolat",
	"risolidificat",
	"risollevat",
	"risolt",
	"risommat",
	"risommers",
	"risonat",
	"risorpassat",
	"risospes",
	"risospint",
	"risottomess",
	"risparmiat",
	"rispars",
	"rispecchiat",
	"rispedit",
	"rispent",
	"rispers",
	"rispettat",
	"rispiegat",
	"rispint",
	"rispolverat",
	"risposat",
	"rispost",
	"rissat",
	"ristabilit",
	"ristagnat",
	"ristampat",
	"ristaurat",
	"ristes",
	"ristilizzat",
	"ristorat",
	"ristrett",
	"ristrutt",
	"ristrutturat",
	"ristuccat",
	"ristudiat",
	"risucchiat",
	"risultat",
	"risuolat",
	"risuonat",
	"risuscitat",
	"risvegliat",
	"risvolt",
	"ritagliat",
	"ritarat",
	"ritardat",
	"ritemprat",
	"ritentat",
	"ritenut",
	"riters",
	"rites",
	"ritint",
	"ritirat",
	"ritoccat",
	"ritolt",
	"ritort",
	"ritracciat",
	"ritradott",
	"ritrascors",
	"ritrascritt",
	"ritrasferit",
	"ritrasformat",
	"ritrasmess",
	"ritraspost",
	"ritrattat",
	"ritratt",
	"ritrovat",
	"ritualizzat",
	"rituffat",
	"riudit",
	"riunificat",
	"riunit",
	"riusat",
	"riutilizzat",
	"rivaccinat",
	"rivaleggiat",
	"rivalorizzat",
	"rivals",
	"rivalutat",
	"rivangat",
	"rivedut",
	"rivelat",
	"rivendicat",
	"rivendut",
	"riverberat",
	"riverit",
	"riverniciat",
	"riversat",
	"rivestit",
	"rivettat",
	"rivint",
	"rivisitat",
	"rivissut",
	"rivist",
	"rivitalizzat",
	"rivivificat",
	"rivoltat",
	"rivolt",
	"rivoltolat",
	"rivolut",
	"rivoluzionat",
	"rizappat",
	"rizzat",
	"robotizzat",
	"rodat",
	"rogat",
	"rollat",
	"romanizzat",
	"romanticizzat",
	"romanzat",
	"roncolat",
	"rosicat",
	"rosicchiat",
	"ros",
	"rosolat",
	"rotacizzat",
	"rotat",
	"roteat",
	"rotolat",
	"rottamat",
	"rott",
	"rovesciat",
	"rovinat",
	"rovistat",
	"rubacchiat",
	"rubat",
	"rullat",
	"ruminat",
	"ruotat",
	"russificat",
	"ruzzolat",
	"sabbiat",
	"sabotat",
	"saccarificat",
	"saccheggiat",
	"sacralizzat",
	"sacramentat",
	"sacrificat",
	"saettat",
	"saggiat",
	"sagginat",
	"sagomat",
	"salamoiat",
	"salariat",
	"salassat",
	"salat",
	"saldat",
	"salificat",
	"salinizzat",
	"salit",
	"salmeggiat",
	"salmistrat",
	"salpat",
	"saltat",
	"salutat",
	"salvaguardat",
	"salvat",
	"sanat",
	"sancit",
	"sanforizzat",
	"sanificat",
	"sanitizzat",
	"santificat",
	"sanzionat",
	"saponificat",
	"saput",
	"sarchiat",
	"sarchiellat",
	"sartiat",
	"satellizzat",
	"satinat",
	"satireggiat",
	"satisfatt",
	"satollat",
	"saturat",
	"saziat",
	"sbaccellat",
	"sbaciucchiat",
	"sbafat",
	"sbaffat",
	"sbalestrat",
	"sballat",
	"sballottat",
	"sballottolat",
	"sbalordit",
	"sbalzat",
	"sbancat",
	"sbandat",
	"sbandierat",
	"sbandit",
	"sbaraccat",
	"sbaragliat",
	"sbarazzat",
	"sbarbat",
	"sbarcat",
	"sbardat",
	"sbarrat",
	"sbassat",
	"sbastit",
	"sbatacchiat",
	"sbattezzat",
	"sbattut",
	"sbeccat",
	"sbeffeggiat",
	"sbellicat",
	"sbendat",
	"sbertucciat",
	"sbiadit",
	"sbiancat",
	"sbianchit",
	"sbiellat",
	"sbiettat",
	"sbigottit",
	"sbilanciat",
	"sbirbat",
	"sbirciat",
	"sbizzarrit",
	"sbloccat",
	"sbobinat",
	"sboccat",
	"sbocconcellat",
	"sbollentat",
	"sbolognat",
	"sborniat",
	"sborsat",
	"sboscat",
	"sbottonat",
	"sbozzat",
	"sbozzimat",
	"sbozzolat",
	"sbracat",
	"sbracciat",
	"sbraciat",
	"sbraitat",
	"sbranat",
	"sbrancat",
	"sbrattat",
	"sbreccat",
	"sbriciolat",
	"sbrigat",
	"sbrigliat",
	"sbrinat",
	"sbrindellat",
	"sbrodolat",
	"sbrogliat",
	"sbronzat",
	"sbruffat",
	"sbucciat",
	"sbudellat",
	"sbuffat",
	"sbugiardat",
	"sbullettat",
	"sbullonat",
	"sburrat",
	"scacazzat",
	"scacchiat",
	"scacciat",
	"scaccolat",
	"scadenzat",
	"scafat",
	"scaffalat",
	"scagionat",
	"scagliat",
	"scaglionat",
	"scalat",
	"scalcat",
	"scalcinat",
	"scaldat",
	"scalettat",
	"scalfat",
	"scalfit",
	"scalmanat",
	"scaloppat",
	"scalpat",
	"scalpellat",
	"scalpellinat",
	"scaltrit",
	"scalzat",
	"scambiat",
	"scamiciat",
	"scamosciat",
	"scamozzat",
	"scampat",
	"scampatal",
	"scampat",
	"scamuffat",
	"scanalat",
	"scancellat",
	"scandagliat",
	"scandalizzat",
	"scandit",
	"scannat",
	"scannellat",
	"scannerat",
	"scannerizat",
	"scannerizzat",
	"scansat",
	"scansionat",
	"scapecchiat",
	"scapezzat",
	"scapicollat",
	"scapigliat",
	"scapitozzat",
	"scapocchiat",
	"scappat",
	"scappellat",
	"scappottat",
	"scapricciat",
	"scapsulat",
	"scarabocchiat",
	"scaracchiat",
	"scaraventat",
	"scarcerat",
	"scardassat",
	"scardat",
	"scardinat",
	"scaricat",
	"scarificat",
	"scarmigliat",
	"scarnat",
	"scarnificat",
	"scarnit",
	"scarrellat",
	"scarrocciat",
	"scarrozzat",
	"scarruffat",
	"scartabellat",
	"scartat",
	"scartavetrat",
	"scartinat",
	"scartocciat",
	"scassat",
	"scassinat",
	"scatenat",
	"scattat",
	"scavalcat",
	"scavallat",
	"scavat",
	"scavezzat",
	"scazzottat",
	"scekerat",
	"scelt",
	"scempiat",
	"sceneggiat",
	"scernut",
	"scervellat",
	"sces",
	"sceverat",
	"schedat",
	"schedulat",
	"scheggiat",
	"scheletrit",
	"schematizzat",
	"schermat",
	"schermit",
	"schermografat",
	"schernit",
	"schiacciat",
	"schiaffat",
	"schiaffeggiat",
	"schiantat",
	"schiarit",
	"schiavardat",
	"schiavizzat",
	"schiccherat",
	"schierat",
	"schifat",
	"schinciat",
	"schioccat",
	"schiodat",
	"schiumat",
	"schius",
	"schivat",
	"schizzat",
	"schizzettat",
	"sciabolat",
	"sciabordat",
	"sciacquat",
	"scialacquat",
	"sciamanizzat",
	"sciamannat",
	"sciancat",
	"sciancrat",
	"scimmieggiat",
	"scimmiottat",
	"scint",
	"scioccat",
	"sciolinat",
	"sciolt",
	"sciorinat",
	"scippat",
	"sciroppat",
	"sciss",
	"sciupacchiat",
	"sciupat",
	"sclamat",
	"sclerosat",
	"sclerotizzat",
	"scoccat",
	"scocciat",
	"scodat",
	"scodellat",
	"scoiat",
	"scolarizzat",
	"scolat",
	"scollacciat",
	"scollat",
	"scollegat",
	"scolorat",
	"scolorit",
	"scolpat",
	"scolpit",
	"scombaciat",
	"scombinat",
	"scombussolat",
	"scommess",
	"scomodat",
	"scompaginat",
	"scompagnat",
	"scompartit",
	"scompattat",
	"scompensat",
	"scompiacut",
	"scompigliat",
	"scompost",
	"scomputat",
	"scomunicat",
	"sconcertat",
	"sconciat",
	"sconclus",
	"sconfessat",
	"sconficcat",
	"sconﬁtt",
	"sconfortat",
	"sconfus",
	"scongelat",
	"scongiurat",
	"sconness",
	"sconosciut",
	"sconquassat",
	"sconsacrat",
	"sconsigliat",
	"sconsolat",
	"scontat",
	"scontentat",
	"scontornat",
	"scontort",
	"scontrat",
	"sconvolt",
	"scopat",
	"scoperchiat",
	"scopert",
	"scopiazzat",
	"scoraggiat",
	"scoraggit",
	"scorat",
	"scorazzat",
	"scorciat",
	"scorcit",
	"scordat",
	"scoreggiat",
	"scorificat",
	"scornat",
	"scorniciat",
	"scoronat",
	"scorporat",
	"scorrazzat",
	"scorreggiat",
	"scorrett",
	"scors",
	"scortat",
	"scortecciat",
	"scorticat",
	"scort",
	"scorzat",
	"scosces",
	"scosciat",
	"scoss",
	"scostat",
	"scostolat",
	"scotennat",
	"scoticat",
	"scotolat",
	"scotomizzat",
	"scottat",
	"scott",
	"scovat",
	"scovert",
	"scozzat",
	"scozzonat",
	"screditat",
	"scremat",
	"screpolat",
	"screziat",
	"scribacchiat",
	"scriminat",
	"scristianizzat",
	"scritt",
	"scritturat",
	"scroccat",
	"scrocchiat",
	"scrollat",
	"scrostat",
	"scrutat",
	"scrutinat",
	"scucit",
	"scudisciat",
	"scuffiat",
	"sculacciat",
	"sculettat",
	"scuoiat",
	"scuriosat",
	"scurit",
	"scusat",
	"sdaziat",
	"sdebitat",
	"sdegnat",
	"sdemanializzat",
	"sdentat",
	"sdilinquit",
	"sdoganat",
	"sdolut",
	"sdoppiat",
	"sdraiat",
	"sdrammatizzat",
	"sdrucit",
	"secat",
	"seccat",
	"secernut",
	"secolarizzat",
	"secondat",
	"secretat",
	"secret",
	"sedat",
	"sedentarizzat",
	"sedott",
	"segat",
	"seghettat",
	"segmentat",
	"segnalat",
	"segnat",
	"segnoreggiat",
	"segregat",
	"segretat",
	"seguitat",
	"seguit",
	"selciat",
	"selezionat",
	"sellat",
	"sembrat",
	"sementat",
	"semicint",
	"seminat",
	"semplificat",
	"senilizzat",
	"sensibilizzat",
	"sensorizzat",
	"sentenziat",
	"sentit",
	"sentitasel",
	"sentit",
	"sentit",
	"separat",
	"sepolt",
	"seppellit",
	"sequenziat",
	"sequestrat",
	"serbat",
	"serrat",
	"servit",
	"servoassistit",
	"sessualizzat",
	"sestuplicat",
	"setacciat",
	"setificat",
	"settat",
	"settorializzat",
	"settuplicat",
	"seviziat",
	"sezionat",
	"sfaccettat",
	"sfagliat",
	"sfaldat",
	"sfalsat",
	"sfamat",
	"sfanalat",
	"sfangat",
	"sfarinat",
	"sfasat",
	"sfasciat",
	"sfatat",
	"sfatt",
	"sfavillat",
	"sfavorit",
	"sfegatat",
	"sfeltrat",
	"sfendut",
	"sferragliat",
	"sferrat",
	"sferzat",
	"sfess",
	"sfiancat",
	"sfiatat",
	"sfiat",
	"sfibbiat",
	"sfibrat",
	"sfidat",
	"sfiduciat",
	"sfigurat",
	"sfilat",
	"sfilettat",
	"sfinit",
	"sfioccat",
	"sfiorat",
	"sfittat",
	"sfocat",
	"sfociat",
	"sfoderat",
	"sfogat",
	"sfoggiat",
	"sfogliat",
	"sfollat",
	"sfoltit",
	"sfondat",
	"sforacchiat",
	"sforat",
	"sforbiciat",
	"sformat",
	"sfornaciat",
	"sfornat",
	"sfornit",
	"sforzat",
	"sfottut",
	"sfracellat",
	"sfrangiat",
	"sfrascat",
	"sfratat",
	"sfrattat",
	"sfrecciat",
	"sfregat",
	"sfregiat",
	"sfrenat",
	"sfrisat",
	"sfrondat",
	"sfrucugliat",
	"sfruculiat",
	"sfruttat",
	"sfumat",
	"sfuocat",
	"sgamat",
	"sganasciat",
	"sganciat",
	"sgarbugliat",
	"sgattaiolat",
	"sgelat",
	"sghiacciat",
	"sgocciolat",
	"sgolat",
	"sgomberat",
	"sgombrat",
	"sgomentat",
	"sgominat",
	"sgomitat",
	"sgomitolat",
	"sgonfiat",
	"sgorbiat",
	"sgottat",
	"sgovernat",
	"sgozzat",
	"sgraffiat",
	"sgraffignat",
	"sgranat",
	"sgranchit",
	"sgranellat",
	"sgrassat",
	"sgravat",
	"sgretolat",
	"sgridat",
	"sgrommat",
	"sgrondat",
	"sgroppat",
	"sgrossat",
	"sgrovigliat",
	"sgrugnat",
	"sguainat",
	"sgualcit",
	"sguanciat",
	"sguarnit",
	"sguinzagliat",
	"sgusciat",
	"shakerat",
	"shoccat",
	"shuntat",
	"sigillat",
	"siglat",
	"significat",
	"signoreggiat",
	"silenziat",
	"silicizzat",
	"sillabat",
	"sillogizzat",
	"silurat",
	"simboleggiat",
	"simbolizzat",
	"simmetrizzat",
	"simpatizzat",
	"simulat",
	"sincerat",
	"sincopat",
	"sincretizzat",
	"sincronizzat",
	"sindacalizzat",
	"sindacat",
	"singolarizzat",
	"sinistrat",
	"sinizzat",
	"sinterizzat",
	"sintetizzat",
	"sintonizzat",
	"siringat",
	"sistematizzat",
	"sistemat",
	"situat",
	"slabbrat",
	"slacciat",
	"slamat",
	"slanciat",
	"slappolat",
	"slargat",
	"slavizzat",
	"slegat",
	"slentat",
	"slinguat",
	"slogat",
	"sloggat",
	"sloggiat",
	"slombat",
	"slungat",
	"smaccat",
	"smacchiat",
	"smagliat",
	"smagnetizzat",
	"smagrit",
	"smaliziat",
	"smallat",
	"smaltat",
	"smaltit",
	"smammat",
	"smanacciat",
	"smangiat",
	"smantellat",
	"smarcat",
	"smarginat",
	"smarrit",
	"smascellat",
	"smascherat",
	"smaterializzat",
	"smattonat",
	"smembrat",
	"smentit",
	"smerciat",
	"smerdat",
	"smerigliat",
	"smerlat",
	"smerlettat",
	"smessal",
	"smess",
	"smezzat",
	"smidollat",
	"smielat",
	"smilitarizzat",
	"sminat",
	"sminuit",
	"sminuzzat",
	"smistat",
	"smitizzat",
	"smobiliat",
	"smobilitat",
	"smobilizzat",
	"smoccolat",
	"smollicat",
	"smonacat",
	"smontat",
	"smorbat",
	"smorzat",
	"smoss",
	"smozzicat",
	"smunt",
	"smurat",
	"smussat",
	"smutandat",
	"snaturat",
	"snazionalizzat",
	"snebbiat",
	"snellit",
	"snervat",
	"snidat",
	"sniffat",
	"snobbat",
	"snocciolat",
	"snodat",
	"snudat",
	"sobbarcat",
	"sobbollit",
	"sobillat",
	"socchius",
	"soccors",
	"soddisfatt",
	"sodisfatt",
	"sodomizzat",
	"sofferit",
	"soffermat",
	"soffert",
	"soffiat",
	"soffocat",
	"soffregat",
	"soffritt",
	"soffus",
	"sofisticat",
	"soggettivat",
	"soggettivizzat",
	"sogghignat",
	"soggiogat",
	"soggiunt",
	"sogguardat",
	"sognat",
	"solarizzat",
	"solcat",
	"soleggiat",
	"solennizzat",
	"solfeggiat",
	"solfitat",
	"solfonat",
	"solforat",
	"solidificat",
	"solit",
	"sollazzat",
	"sollecitat",
	"solleticat",
	"sollevat",
	"solt",
	"solubilizzat",
	"solut",
	"soluzionat",
	"solvatat",
	"somatizzat",
	"someggiat",
	"somigliat",
	"sommat",
	"sommers",
	"sommess",
	"somministrat",
	"sommoss",
	"sonat",
	"sondat",
	"sonorizzat",
	"sopit",
	"soppalcat",
	"soppesat",
	"soppiantat",
	"sopportat",
	"soppost",
	"soppress",
	"sopraddotat",
	"sopraeccitat",
	"sopraedificat",
	"sopraelevat",
	"sopraffat",
	"sopraffatt",
	"sopraggiunt",
	"sopraintes",
	"soprammess",
	"soprannominat",
	"soprapost",
	"soprappres",
	"soprascritt",
	"sopraspes",
	"soprassaturat",
	"soprassedut",
	"sopravanzat",
	"sopravvalutat",
	"sopravvedut",
	"sopravvint",
	"sopravvist",
	"sopreccitat",
	"sopredificat",
	"soprelevat",
	"soprintes",
	"sorbettat",
	"sorbit",
	"sorgiunt",
	"sormontat",
	"sorpassat",
	"sorpres",
	"sorras",
	"sorrett",
	"sorseggiat",
	"sorteggiat",
	"sortit",
	"sorvegliat",
	"sorvolat",
	"soscritt",
	"sospes",
	"sospettat",
	"sospint",
	"sospirat",
	"sostantivat",
	"sostanziat",
	"sostentat",
	"sostenut",
	"sostituit",
	"sottaciut",
	"sotterrat",
	"sottes",
	"sottintes",
	"sottoalimentat",
	"sottocapitalizzat",
	"sottodivis",
	"sottoespost",
	"sottofirmat",
	"sottolineat",
	"sottomess",
	"sottomurat",
	"sottopagat",
	"sottopassat",
	"sottopost",
	"sottorappresentat",
	"sottoris",
	"sottoscritt",
	"sottostimat",
	"sottosviluppat",
	"sottotitolat",
	"sottovalutat",
	"sottratt",
	"soverchiat",
	"sovesciat",
	"sovietizzat",
	"sovracapitalizzat",
	"sovraccaricat",
	"sovradimensionat",
	"sovraeccitat",
	"sovraespost",
	"sovraffaticat",
	"sovraffollat",
	"sovraggiunt",
	"sovraimpost",
	"sovraintes",
	"sovralimentat",
	"sovramodulat",
	"sovrappopolat",
	"sovrappost",
	"sovrariscaldat",
	"sovrasaturat",
	"sovrascritt",
	"sovrastampat",
	"sovrastat",
	"sovrastimat",
	"sovrautilizzat",
	"sovreccitat",
	"sovrespost",
	"sovrimpost",
	"sovrintes",
	"sovvenut",
	"sovvenzionat",
	"sovvertit",
	"spaccat",
	"spacchettat",
	"spacciat",
	"spaginat",
	"spaiat",
	"spalancat",
	"spalat",
	"spalcat",
	"spalleggiat",
	"spalmat",
	"spammat",
	"spampanat",
	"spampinat",
	"spanat",
	"spanciat",
	"spandut",
	"spannat",
	"spannocchiat",
	"spans",
	"spantanat",
	"spant",
	"spaparacchiat",
	"spaparanzat",
	"spappolat",
	"sparat",
	"sparecchiat",
	"sparigliat",
	"sparit",
	"sparlat",
	"sparpagliat",
	"spartit",
	"spassat",
	"spassatosel",
	"spastoiat",
	"spaurat",
	"spaurit",
	"spaventat",
	"spazializzat",
	"spaziat",
	"spazieggiat",
	"spazientit",
	"spazzat",
	"spazzolat",
	"specchiat",
	"specializzat",
	"specificat",
	"specillat",
	"specolat",
	"spedit",
	"spegnat",
	"spelacchiat",
	"spelat",
	"spellat",
	"spennacchiat",
	"spennat",
	"spennellat",
	"spent",
	"spenzolat",
	"sperat",
	"sperimentat",
	"spernacchiat",
	"speronat",
	"sperperat",
	"spersonalizzat",
	"sperticat",
	"spesat",
	"spes",
	"spessit",
	"spettacolarizzat",
	"spettinat",
	"spezzat",
	"spezzettat",
	"spezziat",
	"spezzonat",
	"spiaccicat",
	"spianat",
	"spiantat",
	"spiat",
	"spiattellat",
	"spiazzat",
	"spiccat",
	"spicciat",
	"spiccicat",
	"spicciolat",
	"spicconat",
	"spidocchiat",
	"spiegat",
	"spiegazzat",
	"spietrat",
	"spifferat",
	"spigionat",
	"spignorat",
	"spigolat",
	"spigrit",
	"spillat",
	"spilluzzicat",
	"spiluccat",
	"spint",
	"spintonat",
	"spiombat",
	"spiralizzat",
	"spirantizzat",
	"spirat",
	"spiritualizzat",
	"spiumat",
	"spizzicat",
	"spodestat",
	"spoetizzat",
	"spogliat",
	"spolettat",
	"spoliat",
	"spoliticizzat",
	"spollonat",
	"spolmonat",
	"spolpat",
	"spoltronit",
	"spolverat",
	"spolverizzat",
	"spompat",
	"spompinat",
	"sponsorizzat",
	"spopolat",
	"spoppat",
	"sporcat",
	"sportat",
	"sport",
	"sposat",
	"spossedut",
	"spossessat",
	"spostat",
	"spost",
	"sprangat",
	"sprecat",
	"spregiat",
	"spremut",
	"spretat",
	"sprezzat",
	"sprigionat",
	"sprimacciat",
	"spromess",
	"spronat",
	"sprotett",
	"sprovincializzat",
	"sprovvedut",
	"sprovvist",
	"spruzzat",
	"spugnat",
	"spulat",
	"spulciat",
	"spuntat",
	"spuntellat",
	"spupazzat",
	"spurgat",
	"sputacchiat",
	"sputat",
	"sputtanat",
	"squadernat",
	"squadrat",
	"squagliat",
	"squagliatasel",
	"squagliat",
	"squalificat",
	"squamat",
	"squarciat",
	"squartat",
	"squassat",
	"squattrinat",
	"squilibrat",
	"squinternat",
	"sradicat",
	"srotolat",
	"srugginit",
	"stabbiat",
	"stabilit",
	"stabilizzat",
	"stabulat",
	"staccat",
	"stacciat",
	"staffat",
	"staffilat",
	"staggiat",
	"staggit",
	"stagionat",
	"stagliat",
	"stagnat",
	"stamburat",
	"stampat",
	"stampigliat",
	"stanat",
	"stancat",
	"standardizzat",
	"stangat",
	"stanziat",
	"stappat",
	"starat",
	"starnazzat",
	"stasat",
	"statalizzat",
	"statizzat",
	"statuit",
	"stazzat",
	"stazzonat",
	"steccacciat",
	"steccat",
	"stecchit",
	"stecconat",
	"stemperat",
	"stempiat",
	"stenografat",
	"stereotipat",
	"sterilit",
	"sterilizzat",
	"sterminat",
	"sterpat",
	"sterrat",
	"sterzat",
	"stes",
	"stigliat",
	"stigmatizzat",
	"stilat",
	"stilettat",
	"stilizzat",
	"stillat",
	"stimat",
	"stimolat",
	"stint",
	"stipat",
	"stipendiat",
	"stipulat",
	"stiracchiat",
	"stirat",
	"stivat",
	"stizzit",
	"stoccat",
	"stolt",
	"stomacat",
	"stonat",
	"stondat",
	"stoppat",
	"stordit",
	"storicizzat",
	"stornat",
	"storpiat",
	"stortat",
	"stort",
	"stozzat",
	"strabenedett",
	"strabuzzat",
	"stracannat",
	"straccat",
	"stracciat",
	"stracott",
	"strafogat",
	"stragodut",
	"stralciat",
	"stralodat",
	"stralunat",
	"stramaledett",
	"stramortit",
	"strangolat",
	"straniat",
	"stranit",
	"straorzat",
	"strapagat",
	"strapazzat",
	"straperdut",
	"strapers",
	"strappat",
	"strasaput",
	"strascicat",
	"strascinat",
	"strasformat",
	"stratificat",
	"strattonat",
	"stravaccat",
	"stravint",
	"stravolt",
	"stravolut",
	"straziat",
	"stregat",
	"stremat",
	"stressat",
	"striat",
	"stridulat",
	"strigat",
	"strigliat",
	"strillat",
	"striminzit",
	"strimpellat",
	"strinat",
	"stringat",
	"strisciat",
	"stritolat",
	"strizzat",
	"strofinat",
	"strombat",
	"strombazzat",
	"stroncat",
	"stronzat",
	"stropicciat",
	"stroppat",
	"stroppiat",
	"strozzat",
	"struccat",
	"strumentalizzat",
	"strumentat",
	"strusciat",
	"strutt",
	"strutturalizzat",
	"strutturat",
	"stuccat",
	"studiacchiat",
	"studiat",
	"stuellat",
	"stufat",
	"stupefatt",
	"stupit",
	"stuprat",
	"sturat",
	"stutat",
	"stuzzicat",
	"suas",
	"subaffittat",
	"subappaltat",
	"subbiat",
	"subdelegat",
	"subissat",
	"subit",
	"sublicenziat",
	"sublimat",
	"sublocat",
	"subodorat",
	"subordinat",
	"subornat",
	"suburbanizzat",
	"sucat",
	"succhiat",
	"succhiellat",
	"succiat",
	"succint",
	"succis",
	"suddistint",
	"suddivis",
	"suffissat",
	"suffiss",
	"suffragat",
	"suffumicat",
	"suffus",
	"suggellat",
	"suggerit",
	"suggestionat",
	"suicidat",
	"sunteggiat",
	"sunt",
	"suolat",
	"suonat",
	"superat",
	"superpagat",
	"superraffreddat",
	"supervalutat",
	"supervisionat",
	"supplicat",
	"supplit",
	"supportat",
	"suppost",
	"suppurat",
	"surclassat",
	"surfat",
	"surgelat",
	"surraffreddat",
	"surriscaldat",
	"surrogat",
	"survoltat",
	"suscitat",
	"susseguit",
	"sussidiat",
	"sussunt",
	"sussurrat",
	"suturat",
	"svaccat",
	"svagat",
	"svaligiat",
	"svalutat",
	"svapat",
	"svariat",
	"svasat",
	"svecchiat",
	"svegliat",
	"svelat",
	"svelenit",
	"sveltit",
	"svelt",
	"svenat",
	"svendut",
	"sventagliat",
	"sventat",
	"sventolat",
	"sventrat",
	"sverginat",
	"svergognat",
	"svergolat",
	"sverminat",
	"sverniciat",
	"svestit",
	"svettat",
	"svezzat",
	"sviat",
	"svignatosel",
	"svigorit",
	"svilit",
	"svillaneggiat",
	"sviluppat",
	"svinat",
	"svincolat",
	"sviolinat",
	"svirgolat",
	"svirilizzat",
	"svisat",
	"sviscerat",
	"svitat",
	"sviticchiat",
	"svolat",
	"svolazzat",
	"svolt",
	"svolut",
	"svuotat",
	"tabuizzat",
	"tabulat",
	"taccat",
	"taccheggiat",
	"tacciat",
	"tacitat",
	"taciut",
	"tagliat",
	"taglieggiat",
	"tagliuzzat",
	"talebanizzat",
	"tallonat",
	"tampinat",
	"tamponat",
	"tangut",
	"tannat",
	"tappat",
	"tappezzat",
	"tarat",
	"tardat",
	"targat",
	"tariffat",
	"tarlat",
	"tarmat",
	"taroccat",
	"tarpat",
	"tartagliat",
	"tartassat",
	"tartufat",
	"tassat",
	"tassellat",
	"tastat",
	"tasteggiat",
	"tatuat",
	"tecnicizzat",
	"tecnologizzat",
	"tedeschizzat",
	"tediat",
	"teflonat",
	"telecomandat",
	"telecontrollat",
	"telediffus",
	"telefonat",
	"telegrafat",
	"teleguidat",
	"telematizzat",
	"telemetrat",
	"teleradiotrasmess",
	"teletrasmess",
	"teletrasportat",
	"tematizzat",
	"temperat",
	"tempestat",
	"tempificat",
	"templatizzat",
	"temporizzat",
	"temprat",
	"temut",
	"tentat",
	"tenut",
	"teologizzat",
	"teorizzat",
	"tepefatt",
	"terebrat",
	"terminat",
	"termostatat",
	"terrazzat",
	"terrificat",
	"terrorizzat",
	"ters",
	"terzarolat",
	"terziarizzat",
	"terziat",
	"tesat",
	"tesaurizzat",
	"tes",
	"tesserat",
	"testat",
	"testificat",
	"testimoniat",
	"timbrat",
	"tindalizzat",
	"tinteggiat",
	"tint",
	"tipicizzat",
	"tipizzat",
	"tippat",
	"tiranneggiat",
	"tirat",
	"titillat",
	"titolat",
	"toccat",
	"toelettat",
	"tollerat",
	"tolt",
	"tonalizzat",
	"tonificat",
	"tonneggiat",
	"tonsurat",
	"torchiat",
	"tormentat",
	"tornit",
	"torrefatt",
	"tort",
	"tortoreggiat",
	"torturat",
	"tosat",
	"toscaneggiat",
	"toscanizzat",
	"tostat",
	"totalizzat",
	"traboccat",
	"trabuccat",
	"tracannat",
	"tracciat",
	"tradit",
	"tradott",
	"trafficat",
	"trafilat",
	"trafitt",
	"traforat",
	"trafugat",
	"traghettat",
	"traguardat",
	"trainat",
	"tralasciat",
	"tralignat",
	"tramandat",
	"tramat",
	"trambasciat",
	"tramess",
	"tramestat",
	"tramezzat",
	"tramortit",
	"tramutat",
	"tranciat",
	"trangugiat",
	"tranquillat",
	"tranquillizzat",
	"transatt",
	"transces",
	"transcodificat",
	"transcors",
	"transcritt",
	"transennat",
	"transfluit",
	"transfus",
	"transistorizzat",
	"translitterat",
	"transpost",
	"transricevut",
	"transustanziat",
	"transvedut",
	"transvist",
	"trapanat",
	"trapassat",
	"trapiantat",
	"traportat",
	"trapost",
	"trappost",
	"trapuntat",
	"trapunt",
	"trarott",
	"trasandat",
	"trasbordat",
	"trascelt",
	"trasces",
	"trascinat",
	"trascors",
	"trascritt",
	"trascurat",
	"trasdott",
	"trasferit",
	"trasfigurat",
	"trasformat",
	"trasfus",
	"trasgredit",
	"traslat",
	"traslitterat",
	"traslocat",
	"trasmess",
	"trasmutat",
	"trasparit",
	"traspirat",
	"trasportat",
	"traspost",
	"trastullat",
	"trasudat",
	"trasvolat",
	"trasvolt",
	"trattat",
	"tratteggiat",
	"trattenut",
	"tratt",
	"traumatizzat",
	"travagliat",
	"travalicat",
	"travasat",
	"travedut",
	"traversat",
	"travestit",
	"traviat",
	"travisat",
	"travist",
	"travolt",
	"trebbiat",
	"triangolat",
	"tribbiat",
	"tribolat",
	"tributat",
	"triennalizzat",
	"trimestralizzat",
	"trincat",
	"trincerat",
	"trinciat",
	"tripartit",
	"triplicat",
	"trisecat",
	"trisezionat",
	"tritat",
	"triturat",
	"trivellat",
	"trollat",
	"trombat",
	"troncat",
	"tropicalizzat",
	"trovat",
	"truccat",
	"trucidat",
	"truffat",
	"tuffat",
	"tumefatt",
	"tumulat",
	"turat",
	"turbat",
	"turlupinat",
	"tutelat",
	"twittat",
	"ubbidit",
	"ubbligat",
	"ubicat",
	"ubidit",
	"ubiquitinat",
	"ubriacat",
	"uccellat",
	"uccellinat",
	"uccis",
	"udit",
	"ufficializzat",
	"ufficiat",
	"uggit",
	"ugnat",
	"uguagliat",
	"ulcerat",
	"ulit",
	"ulolat",
	"ultimat",
	"ultracentrifugat",
	"ululat",
	"umanat",
	"umanizzat",
	"umettat",
	"umidificat",
	"umidit",
	"umiliat",
	"uncinat",
	"unguentat",
	"unificat",
	"uniformat",
	"unit",
	"univerbat",
	"universaleggiat",
	"universalizzat",
	"untat",
	"unt",
	"uperizzat",
	"urbanizzat",
	"urgenzat",
	"urlat",
	"urtacchiat",
	"urtat",
	"urticchiat",
	"usat",
	"usciolat",
	"usolat",
	"ustionat",
	"usucapit",
	"usurat",
	"usurpat",
	"utilitat",
	"utilizzat",
	"vaccinat",
	"vagabondeggiat",
	"vagellat",
	"vagheggiat",
	"vagillat",
	"vagliat",
	"valcat",
	"valicat",
	"validat",
	"valorizzat",
	"vals",
	"valutat",
	"vanagloriat",
	"vanat",
	"vandalizzat",
	"vangat",
	"vangelizzat",
	"vanificat",
	"vanit",
	"vantaggiat",
	"vantat",
	"vaporat",
	"vaporizzat",
	"varat",
	"varcat",
	"variat",
	"vasectomizzat",
	"vaticinat",
	"vedovat",
	"vedut",
	"vegetat",
	"veggiat",
	"vegliat",
	"veicolat",
	"velarizzat",
	"velat",
	"velettat",
	"velinat",
	"vellicat",
	"vellutat",
	"velocizzat",
	"vendemmiat",
	"vendicat",
	"vendicchiat",
	"venducchiat",
	"vendut",
	"venerat",
	"vengiat",
	"ventagliat",
	"ventilat",
	"ventolat",
	"verbalizzat",
	"vergat",
	"vergheggiat",
	"vergognat",
	"vergolat",
	"verificat",
	"verminat",
	"vernalizzat",
	"verniciat",
	"verrinat",
	"versat",
	"verseggiat",
	"versificat",
	"verticalizzat",
	"vessat",
	"vestit",
	"vestit",
	"vetrificat",
	"vetrinat",
	"vetrioleggiat",
	"vettovagliat",
	"vezzeggiat",
	"viaggiat",
	"vicinat",
	"vicitat",
	"videochattat",
	"videochiamat",
	"videocomunicat",
	"videoregistrat",
	"videotrasmess",
	"vidimat",
	"vigilat",
	"vigliat",
	"vigoreggiat",
	"vigorit",
	"vilificat",
	"vilipes",
	"villaneggiat",
	"vincolat",
	"vint",
	"violat",
	"violentat",
	"violinat",
	"virgolat",
	"virgoleggiat",
	"virgolettat",
	"virilizzat",
	"virtualizzat",
	"visionat",
	"visitat",
	"vissut",
	"vistat",
	"vist",
	"visualizzat",
	"vitaliziat",
	"vitalizzat",
	"vitaminizzat",
	"vittimizzat",
	"vituperat",
	"vivacizzat",
	"vivandat",
	"vivificat",
	"vivisezionat",
	"viziat",
	"vocabolarizzat",
	"vocalizzat",
	"vocat",
	"vociferat",
	"volantinat",
	"volatilizzat",
	"volgarizzat",
	"volicchiat",
	"volpeggiat",
	"voltat",
	"volt",
	"voltolat",
	"volturat",
	"voluminizzat",
	"volut",
	"volutoc",
	"vomitat",
	"vorat",
	"votat",
	"vulcanizzat",
	"vuotat",
	"wappat",
	"wikificat",
	"xerocopiat",
	"zaffat",
	"zampat",
	"zampettat",
	"zampillat",
	"zannat",
	"zappat",
	"zappettat",
	"zapponat",
	"zavorrat",
	"zeppat",
	"zigrinat",
	"zigzagat",
	"zimbellat",
	"zincat",
	"zinnat",
	"zipolat",
	"zippat",
	"zirlat",
	"zittit",
	"zizzagat",
	"zoccolat",
	"zollat",
	"zombat",
	"zonat",
	"zonizzat",
	"zoppat",
	"zoppeggiat",
	"zoppicat",
	"zucconat",
	"zufolat",
	"zumat",
	"zuppat",
];

