/*
 * Adapted from: Kornai, A, Halácsy, P, Nagy, V, Oravecz, Cs, Trón, V, and Varga, D (2006). Web-based frequency
 * dictionaries for medium density languages. In: Proceedings of the 2nd International Workshop on Web as Corpus,
 * edited by Adam Kilgarriff, Marco Baroni  ACL-06, pages 1-9, under Creative Commons Attribution-ShareAlike 4.0
 * Internation (CC BY-SA 4.0) license. Common Crawl Terms of Use apply. The corpus user-interface can be found here:
 * http://szotar.mokk.bme.hu/szoszablya/searchq.php
 */

/**
 * Returns a list of the participles used for the Hungarian passive voice assessment.
 * This list only includes participles ending in -re and -ra.
 *
 * @returns {Array}                The list with participles.
 */
export default [
	// Participles ending in -re.
	"megvételre",
	"megrendezésre",
	"képzésre",
	"kifejezésre",
	"következtetésre",
	"fejlesztésre",
	"bevezetésre",
	"kezelésre",
	"ellenőrzésre",
	"elhelyezésre",
	"értékesítésre",
	"cselekvésre",
	"beépítésre",
	"intézkedésre",
	"kifizetésre",
	"működésre",
	"értékelésre",
	"egyeztetésre",
	"rögzítésre",
	"megjelenésre",
	"meghirdetésre",
	"fizetésre",
	"megbeszélésre",
	"bejelentésre",
	"bekezdésre",
	"közreműködésre",
	"teljesítésre",
	"elküldésre",
	"kivitelezésre",
	"kihirdetésre",
	"korszerűsítésre",
	"előterjesztésre",
	"üzemeltetésre",
	"szerződéskötésre",
	"visszafizetésre",
	"befektetésre",
	"minősítésre",
	"telepítésre",
	"megfigyelésre",
	"berendezésre",
	"megerősítésre",
	"megtekintésre",
	"feltüntetésre",
	"megkülönböztetésre",
	"befizetésre",
	"megszüntetésre",
	"kinevezésre",
	"előkészítésre",
	"felmentésre",
	"megszervezésre",
	"gyógykezelésre",
	"mérlegelésre",
	"végkielégítésre",
	"engedélyezésre",
	"kihelyezésre",
	"megsemmisítésre",
	"előrelépésre",
	"tenyésztésre",
	"elnevezésre",
	"befejezésre",
	"ismétlésre",
	"egyesülésre",
	"közvetítésre",
	"lekérdezésre",
	"szervezésre",
	"csökkentésre",
	"területfejlesztésre",
	"költségtérítésre",
	"felfüggesztésre",
	"frissítésre",
	"vámfizetésre",
	"kifejlesztésre",
	"elhelyezkedésre",
	"teremtésre",
	"megjelölésre",
	"töltésre",
	"kiegyenlítésre",
	"kifejtésre",
	"megépítésre",
	"átszervezésre",
	"termesztésre",
	"felemelkedésre",
	"átépítésre",
	"áremelésre",
	"áthelyezésre",
	"újjáépítésre",
	"megbecsülésre",
	"átültetésre",
	"visszaigénylésre",
	"feljegyzésre",
	"törlesztésre",
	"helyettesítésre",
	"követelésre",
	"érvelésre",
	"elkülönítésre",
	"átképzésre",
	"kiértékelésre",
	"térítésre",
	"továbbfejlesztésre",
	"ösztönzésre",
	"szerkesztésre",
	"megítélésre",
	"letöltésre",
	"selejtezésre",
	"segélyezésre",
	"érintkezésre",
	"emelkedésre",
	"megküldésre",
	"erősítésre",
	"felderítésre",
	"védésre",
	"elbeszélgetésre",
	"megemlítésre",
	"felépítésre",
	"megfejtésre",
	"mentesítésre",
	"előfizetésre",
	"megtervezésre",
	"szakképesítésre",
	"hitelesítésre",
	"megnevezésre",
	"érvényesítésre",
	"számonkérésre",
	"terjeszkedésre",
	"beterjesztésre",
	"összevetésre",
	"jogsértésre",
	"véglegesítésre",
	"kiküldetésre",
	"megörökítésre",
	"kivégzésre",
	"költözésre",
	"megtérülésre",
	"kézbesítésre",
	"közmegegyezésre",
	"idézésre",
	"kirekesztésre",
	"visszaesésre",
	"beszerelésre",
	"beültetésre",
	"kiterjesztésre",
	"kifüggesztésre",
	"leépítésre",
	"megismerkedésre",
	"végzésre",
	"részletfizetésre",
	"megfizetésre",
	"kiürítésre",
	"ízesítésre",
	"méregtelenítésre",
	"rendszerezésre",
	"felterjesztésre",
	"szemléltetésre",
	"megtermékenyítésre",
	"lekötésre",
	"kiegyezésre",
	"előrejelzésre",
	"ellenvetésre",
	"növelésre",
	"képesítésre",
	"beszedésre",
	"ellenjegyzésre",
	"áttelepítésre",
	"egységesítésre",
	"akadálymentesítésre",
	"előtörlesztésre",
	// Participles ending in -ra.
	"azonosításra",
	"aktiválásra",
	"hasznosításra",
	"foglalkoztatásra",
	"finanszírozásra",
	"megfinanszírozásra",
	"benyújtásra",
	"pontosításra",
	"forgalmazásra",
	"beszállításra",
	"felzárkózásra",
	"továbbításra",
	"differenciálásra",
	"folyósításra",
	"kiszállításra",
	"átcsoportosításra",
	"kártalanításra",
	"továbbgondolásra",
	"felzárkóztatásra",
	"megválaszolásra",
	"átállásra",
	"számlázásra",
	"fotózásra",
	"megvásárlásra",
	"felszámításra",
	"kiszámlázásra",
	"lehívásra",
	"leszámlázásra",
	"továbbjutásra",
	"szaporításra",
	"raktározásra",
	"kinyomtatásra",
	"reklámozásra",
	"újrahasznosításra",
	"archiválásra",
	"elővásárlásra",
	"visszautalásra",
	"létrehozásra",
	"tanúsításra",
	"ártalmatlanításra",
	"adományozásra",
	"kisorsolásra",
	"utalványozásra",
	"átgondolásra",
	"azonosulásra",
	"postázásra",
	"televíziózásra",
	"átsorolásra",
	"finomításra",
	"privatizálásra",
	"dokumentálásra",
	"beiskolázásra",
	"digitalizálásra",
	"újragondolásra",
	"aktualizálásra",
	"delegálásra",
	"pályáztatásra",
	"voksolásra",
	"felhordásra",
	"moderálásra",
	"áthaladásra",
	"gyámolításra",
	"lajstromozásra",
	"sokszorosításra",
	"elsajátításra",
	"szigorításra",
	"klónozásra",
	"elhatárolódásra",
	"elbontásra",
	"kiaknázásra",
	"befolyásolásra",
	"renoválásra",
	"kivárásra",
	"feliratozásra",
	"akkreditálásra",
	"parkosításra",
	"szakosodásra",
	"legyártásra",
	"továbbgondolkodásra",
	"magánosításra",
	"összehangolásra",
	"megvilágosodásra",
	"titkosításra",
	"integrálásra",
	"visszaadásra",
	"rangsorolásra",
	"kilábalásra",
	"szponzorálásra",
	"szankcionálásra",
	"modernizálásra",
	"leltározásra",
	"koordinálásra",
	"apostolkodásra",
	"definiálásra",
	"komposztálásra",
	"elvándorlásra",
	"átváltásra",
	"kódolásra",
	"naplózásra",
	"adagolásra",
	"megtámadásra",
	"exportálásra",
	"betáplálásra",
	"kompenzálásra",
	"kapaszkodásra",
	"áthallgatásra",
	"dedikálásra",
	"beindításra",
	"kimunkálásra",
	"hamisításra",
	"megigazulásra",
	"újratárgyalásra",
	"visszaszállításra",
	"megalapításra",
	"szabványosításra",
	"tartósításra",
	"meditálásra",
	"palackozásra",
	"bírságolásra",
	"listázásra",
	"liberalizálásra",
	"iskoláztatásra",
	"auditálásra",
	"monitorozásra",
	"visszapótlásra",
	"sugalmazásra",
	"kipostázásra",
	"előrejutásra",
	"gyarapításra",
	"visszaosztásra",
	"konzerválásra",
	"adóztatásra",
	"decentralizálásra",
	"diagnosztizálásra",
	"harmonizálásra",
	"konszolidálásra",
	"átszállításra",
	"realizálásra",
	"beazonosításra",
	"szelektálásra",
	"újraszabályozásra",
	"kihúzásra",
	"optimalizálásra",
	"bevizsgálásra",
	"kiválogatásra",
	"leosztásra",
	"szállítmányozásra",
	"torzításra",
	"visszaigazolásra",
	"visszaszolgáltatásra",
	"rehabilitálásra",
	"továbbtartásra",
	"darabolásra",
	"felhasználásra",
	"bemutatásra",
	"ellátásra",
	"felújításra",
	"kialakításra",
	"átadásra",
	"kiállításra",
	"feldolgozásra",
	"módosításra",
	"változásra",
	"kiosztásra",
	"beavatkozásra",
	"megvalósításra",
	"megállapodásra",
	"jóváhagyásra",
	"szabályozásra",
	"változtatásra",
	"elszámolásra",
	"felhívásra",
	"meghallgatásra",
	"elbírálásra",
	"végrehajtásra",
	"lemondásra",
	"elhatározásra",
	"kiírásra",
	"megfogalmazásra",
	"népszavazásra",
	"kiválasztásra",
	"hozzájárulásra",
	"bemutatkozásra",
	"felszólalásra",
	"elutasításra",
	"megvitatásra",
	"levonásra",
	"átutalásra",
	"kizárásra",
	"előállításra",
	"bizonyításra",
	"kárpótlásra",
	"nyomtatásra",
	"felállításra",
	"beszámításra",
	"pótlásra",
	"publikálásra",
	"megbízásra",
	"felbontásra",
	"megválasztásra",
	"kibocsátásra",
	"kivizsgálásra",
	"lebontásra",
	"feltárásra",
	"felosztásra",
	"visszavonásra",
	"elosztásra",
	"felvásárlásra",
	"megbocsátásra",
	"szétosztásra",
	"megújításra",
	"megnyitásra",
	"korlátozásra",
	"bérbeadásra",
	"eltiltásra",
	"elbocsátásra",
	"meghosszabbításra",
	"bebocsátásra",
	"levágásra",
	"restaurálásra",
	"felajánlásra",
	"kivágásra",
	"kormányalakításra",
	"megmunkálásra",
	"osztályozásra",
	"sorozatgyártásra",
	"betakarításra",
	"leszámolásra",
];
