import { singleWords as transitionWords } from "./transitionWords";
import transformWordsWithHyphens from "../../../helpers/transform/transformWordsWithHyphens";
/**
 * Returns an object with function words.
 *
 * @returns {Object} The object filled with various categories of function word arrays..
 */

const cardinalNumerals = [
	// 1-10
	"אחת", "אחד", "שתים", "שנים", "שתיים", "שלש", "שלשה", "ארבע", "ארבעה", "חמש", "חמשה", "שש",
	"ששה", "שבע", "שבעה", "שמונה", "שמונה", "תשע", "תשעה", "עשר", "עשרה",
	// 20
	"עשרים",
	// 100
	"מאה",
	// 1000
	"אלף",
	// Million
	"מיליון",
	// Billion
	"מילירד",
];

const ordinalNumerals = [
	// Ordinals for 1-10; for higher numbers ordinal numerals are the same as the cardinals.
	"ראשון", "ראשונה", "שני", "שניה", "שלישי", "שלישית", "רביעי", "רביעית", "חמישי", "חמישית", "ששי", "ששית", "שביעי",
	"שביעית", "שמיני", "שמינית", "תשיעי", "תשיעית", "עשירי", "עשירית",
];

const personalPronouns = [
	"אני‎", "אנחנו‎", "אנו‎", "אתה‎", "את‎", "אתם‎", "אתן‎", "הוא‎", "היא‎", "הם‎", "הן‎",
	// Personal pronouns - prefixed forms
	"שאני", "שאתה", "שהוא", "ואני", "שהיא",

];

const demonstrativePronouns = [
	// Demonstrative pronoun "ze"
	"זה", "זאת", "זו", "ההוא", "ההיא", "איזה", "איזו", "אלה", "אלו", "ההם", "ההן", "אילו",
	"לזה",
	// Demonstrative pronoun "ze" - prefixed forms
	"הזה", "שזה",
];

const interrogatives = [
	// What
	"מה",
	// Who
	"מי",
	// Why
	"למה",
	// How much/many
	"כמה",
	// Particle for y/n questions
	"האם",
	// Where
	"איפה",
	// Which
	"איזה", "איזו", "אילו",
	// When
	"מתי",
	"כאשר",
	// How
	"איך",
	// If
	"אי",
	// Unless
	"אלמלא",
];

const quantifiers = [
	// All
	"כולם", "כול",
	// Most
	"רוב",
	// Part
	"חלק",
	// Less
	"פחות",
	// Few, little
	"מעט",
	// Many, much
	"הרבה",
	// Many, numerous
	"רב", "רבה", "רבים", "רבות",
	// At least
	"לפחות",
];

const reflexivePronouns = [
	"עצמי", "לעצמי", "בעצמי",
	"עצמך", "לעצמך", "בעצמך",
	"עצמך", "לעצמך", "בעצמך",
	"עצמו",	"עצמה", "עצמנו", "עצמכם", "עצמכן", "עצמם", "עצמן",
];

const indefinitePronouns = [
	// Something
	"משהו",
	// Someone
	"מישהו", "מישהי",
	// Nothing
	"כלום",
];

const prepositions = [
	// Each paradigm is one preposition with different pronominal affixes and possibly prefixes
	// Definite object preposition
	"את", "אותי", "אותנו", "אותך", "אתכם", "אתכן", "אותו", "אותה", "אותם", "אותן", "שאת",
	// Possessive preposition
	"של", "שלי", "שלנו", "שלך", "שלכם", "שלכן", "שלו", "שלהם", "שלהן",
	// To/for/of
	"לי", "לך", "לו", "לה", "לנו", "לכם", "לכן", "להם", "להן",
	// On/upon
	"על", "עליי", "עלינו", "עליך", "עלייך", "עליכם", "עליכן", "עליו", "עליה", "עליהם", "עליהן",
	"גבי", "גבנו", "גבך", "גבה", "גבנו", "גבכם", "גבכן", "גבם", "גבן",
	// To/towards/into
	"אל", "אליי", "אלינו", "אליך", "אלייך", "אליכם", "אליכן", "אליו", "אליה", "אליהם", "אליהן", "ואל",
	// With
	"עם", "איתי", "עימי", "איתנו", "עימנו", "איתך", "עימך", "איתכם", "איתכן", "איתו", "איתה", "איתם", "עימם",
	// As
	"כמו", "כמוני", "כמונו", "כמוך", "כמוך", "כמוכם", "כמוכן", "כמוהו", "כמוה", "כמוהם", "כמוהן", "כמוכם", "כמוכן",
	// Before
	"לפני", "לפניי", "לפנינו", "לפניך", "לפנייך", "לפניו", "לפניה", "לפניכם", "לפניכן", "לפניהם", "לפניהן",
	// In
	"ובכן", "בן", "בי", "בנו", "בך", "בכם", "בכן", "בו", "בה", "בהם", "בהן",
	// Because
	"בגלל", "בגללי", "בגללנו", "בגללך", "בגללכם", "בגללכן", "בגללו", "בגללה", "בגללם", "בגללן",
	// After
	"אחר", "אחריי", "אחרינו", "אחריך", "אחרייך", "אחריכם", "אחריכן", "אחריו", "אחריה", "אחריהם", "אחריהן",
	// For the sake of
	"בשביל", "בשבילי", "בשבילנו", "בשבילך", "בשבילו", "בשבילה", "בשבילכם", "בשבילכן", "בשבילם", "בשבילן",
	// Instead of
	"במקום", "במקומי", "במקומנו", "במקומך", "במקומו", "במקומה", "במקומכם", "במקומכן", "במקומם", "במקומן",
	// Until, up to
	"עד",
	// About
	"אודות", "אודותי", "אודותנו", "אודותך", "אודותכם", "אודותכן", "אודותו", "אודותה", "אודותם", "אודותן",
	// Behind
	"מאחורי", "מאחוריי", "מאחורינו", "מאחוריך", "מאחורייך", "מאחוריכם", "מאחוריכן", "מאחוריו", "מאחוריה", "מאחוריהם", "מאחוריהן",
	// At
	"אצל", "אצלי", "אצלנו", "אצלך", "אצלך", "אצלכם", "אצלכן", "אצלו", "אצלה", "אצלם", "אצלן",
	// By means of
	"באמצעות", "באמצעותי", "באמצעותנו", "באמצעותך", "באמצעותכם", "באמצעותכן", "באמצעותו", "באמצעותה", "באמצעותם", "באמצעותן",
	// Due to
	"בזכות", "בזכותי", "בזכותנו", "בזכותך", "בזכותכם", "בזכותכן", "בזכותו", "בזכותה", "בזכותם", "בזכותן",
	// Between
	"ביני", "בינינו", "בינך", "ביניכם", "ביניכן", "בינו", "בינה", "ביניהם", "ביניהן",
	// Without
	"בלעדיי", "בלעדינו", "בלעדיך", "בלעדייך", "בלעדיכם", "בלעדיכן", "בלעדיו", "בלעדיה", "בלעדיהם", "בלעדיהן",
	// In favor of
	"בעד", "בעדי", "בעדנו", "בעדך", "בעדך", "בעדכם", "בעדכן", "בעדו", "בעדה", "בעדם", "בעדן",
	// As a result of
	"בעקבות", "בעקבי", "בעקביי", "בעקבינו", "בעקביך", "בעקבייך", "בעקביכם", "בעקביכן", "בעקביו", "בעקביה", "בעקביהם", "בעקביהן",
	// Facing
	"בפני", "בפניי", "בפנינו", "בפניך", "בפנייך", "בפניכם", "בפניכן", "בפניו", "בפניה", "בפניהם", "בפניהן",
	// Among
	"בקרב", "בקרבי", "בקרבנו", "בקרבך", "בקרבך", "בקרבכם", "בקרבכן", "בקרבו", "בקרבה", "בקרבם", "בקרבן",
	// On behalf of
	"בשם", "בשמי", "בשמנו", "בשמך", "בשמך", "בשמכם", "בשמכן", "בשמו", "בשמה", "בשמם", "בשמן",
	// Inside
	"בתוך", "בתוכי", "בתוכנו", "בתוכך", "בתוכך", "בתוככם", "בתוככן", "בתוכו", "בתוכה", "בתוכם", "בתוכן",
	// As
	"כמוני", "כמונו", "כמוך", "כמוך", "כמוכם", "כמוכן", "כמוהו", "כמוה", "כמוהם", "כמוהן",
	// In relation
	"כלפי", "כלפיי", "כלפינו", "כלפיך", "כלפייך", "כלפיכם", "כלפיכן", "כלפיו", "כלפיה", "כלפיהם", "כלפיהן",
	// Against
	"כנגד", "כנגדי", "כנגדנו", "כנגדך", "כנגדך", "כנגדכם", "כנגדכן", "כנגדו", "כנגדה", "כנגדם", "כנגדן",
	// Along
	"לאורך", "לאורכי", "לאורכנו", "לאורכך", "לאורכך", "לאורככם", "לאורככן", "לאורכו", "לאורכה", "לאורכם", "לאורכן",
	// Regarding
	"לגבי", "לגביי", "לגבינו", "לגביך", "לגבייך", "לגביכם", "לגביכן", "לגביו", "לגביה", "לגביהם", "לגביהן",
	// According to
	"לדברי", "לדבריי", "לדברינו", "לדבריך", "לדברייך", "לדבריכם", "לדבריכן", "לדבריו", "לדבריה", "לדבריהם", "לדבריהן",
	// Near
	"ליד", "לידי", "לידנו", "לידך", "לידך", "לידכם", "לידכן", "לידו", "לידה", "לידם", "לידן",
	// For the sake of
	"למען", "למעני", "למעננו", "למענך", "למענך", "למענכם", "למענכן", "למענו", "למענה", "למענם", "למענן",
	// According to
	"לפי", "לפי", "לפינו", "לפיך", "לפיך", "לפיכם", "לפיכן", "לפיו", "לפיהו", "לפיה", "לפיהם", "לפיהן",
	// Towards
	"לקראת", "לקראתי", "לקראתנו", "לקראתך", "לקראתך", "לקראתכם", "לקראתכן", "לקראתו", "לקראתה", "לקראתם", "לקראתן",
	// Across
	"לרוחב", "לרוחבי", "לרוחבנו", "לרוחבך", "לרוחבך", "לרוחבכם", "לרוחבכן", "לרוחבו", "לרוחבה", "לרוחבם", "לרוחבן",
	// Opposite
	"מול", "מולי", "מולנו", "מולך", "מולך", "מולכם", "מולכן", "מולו", "מולה", "מולם", "מולן",
	// From
	"מן", "ממני", "ממנו", "מאיתנו", "ממך", "ממך", "מכם", "מכן", "ממנו", "ממנה", "מהם", "מהן",
	// Over
	"מעל", "מעליי", "מעלינו", "מעליך", "מעלייך", "מעליכם", "מעליכן", "מעליו", "מעליה", "מעליהם", "מעליהן",
	// From
	"מפני", "מפניי", "מפנינו", "מפניך", "מפנייך", "מפניכם", "מפניכן", "מפניו", "מפניה", "מפניהם", "מפניהן",
	// Below
	"מתחת", "מתחתיי", "מתחתינו", "מתחתיך", "מתחתייך", "מתחתיכם", "מתחתיכן", "מתחתיו", "מתחתיה", "מתחתיהם", "מתחתם", "מתחתיהן", "מתחתן",
	// For
	"עבור", "עבורי", "עבורנו", "עבורך", "עבורכם", "עבורכן", "עבורו", "עבורה", "עבורם", "עבורן",
	// Under
	"תחת", "תחתיי", "תחתינו", "תחתיך", "תחתייך", "תחתיכם", "תחתיכן", "תחתיו", "תחתיה", "תחתיהם", "תחתם", "תחתיהן", "תחתן",
	// Compared with
	"לעומת", "לעומתי", "לעומתנו", "לעומתך", "לעומתך", "לעומתכם", "לעומתכן", "לעומתו", "לעומתה", "לעומתם", "לעומתן",
	// Part of according to
	"פי",
];

const conjunctions = [
	// But
	"אבל",
	"אך",
	"אלא",
	// If
	"אם",
	// Then
	"אז",
	// Or
	"או",
	// In order to
	"כדי",
	// Because
	"כי",
	// Indeed
	"אכן",
	// By the way
	"אגב",
	// However
	"אולם",
	// Although
	"אע״פ",
	// Relative clause marker
	"אשר",
	// While
	"בעוד",
	// And/or
	"ו/או",
	// Since
	"יען",
	// Were it not for
	"לולא",
	// Unless
	"פן",
];

const interviewVerbs = [
	// Say
	"אומר", "אומרת", "אומרים", "אומרות", "אמרתי", "אמרנו", "אמרת", "אמרתם", "אמרתן", "אמר", "אמרה", "אמרו", "נאמר",
	"תאמר", "תאמרי", "תאמרו", "תאמרנה", "יאמר", "תאמר", "תאמרנה", "יאמר", "יאמרו", "אמור", "אמרי", "אמורנה",
	// Speak
	"מדבר", "מדברת", "מדברים", "מדברות", "דיברתי", "דיברנו", "דיברת", "דיברתם", "דיברתן", "דיבר", "דיברה", "דיברו", "אדבר",
	"נדבר", "תדבר", "תדברי", "תדברו", "תדברנה", "ידבר", "ידברו", "דבר‏", "דברי‏", "דברו‏", "דברנה‏", "לדבר",
	// Understand
	"מבין", "מבינה", "מבינים", "מבינות", "הבנתי", "הבינותי", "הבנו", "הבינונו", "הבנת", "הבינות", "הבנתם", "הבינותם",
	"הבנתן", "הבינותן", "הבין", "הבינה", "הבינו", "אבין", "נבין", "תבין", "תביני", "תבינו", "תבנה", "יבין", "יבינו", "תבינינה", "הבן‏",
	"הביני‏", "הבנה‏", "להבין",
	// Believe
	"מאמין", "מאמינה", "מאמינים", "מאמינות", "האמנתי", "האמנו", "האמנת", "האמנתם", "האמנתן", "האמין", "האמינה",
	"האמינו", "אאמין", "נאמין", "תאמין", "תאמיני", "תאמינו", "תאמנה", "יאמין", "יאמינו", "האמן‏", "האמיני‏", "האמינו‏",
	"האה‏", "להאמין",
	// Know
	"יודע", "יודעת", "יודעים", "יודעות", "ידעתי", "ידענו", "ידעת", "ידעתם", "ידעתן", "ידע", "ידעה", "ידעו", "אדע", "נדע", "תדע",
	"תדעי", "תדעו", "תדענה", "דע‏", "דעי‏", "דעו‏", "דענה‏", "לדעת",
	// Ask
	"שואל", "שואלת", "שואלים", "שואלות", "שאלתי", "שאלנו", "שאלת", "שאלתם", "שאלתן", "שאל", "שאלה", "שאלו", "אשאל",
	"נשאל", "תשאל", "תשאלי", "תשאלו", "תשאלנה", "ישאל", "ישאלו", "שאל‏", "שאלי‏", "שאלו‏", "שאלנה‏", "לשאול",
];

const intensifiers = [
	// Very
	"מאוד",
	// Definitely
	"בהחלט",
	// The most
	"ביותר",
	// Terribly
	"נורא",
	// Completely
	"לגמרי",
	// Enough
	"די",
];

const auxiliariesAndDelexicalizedVerbs = [
	// To be - infinitive
	"להיות",
	// To be - past
	"היי", "הייתי", "יהיה", "היית", "הייתה", "היינו", "הייתם", "הייתן", "היו",
	// To be - future
	"אהיה", "תהיה", "תהיי", "יהיה", "נהיה", "תהיו", "תהיינה", "יהיו", "היינה",
	// There is
	"יש", "שיש",
	// Here is
	"הנה",
	// There is not
	"אין",
	// Want
	"רוצה", "רוצים", "רציתי", "רצה",
	// Can
	"יכול", "יכולה", "יכולים", "נוכל",
	// Should
	"צריך", "צריכה",
	// Must
	"חייב",
	// Do, make
	"לעשות", "עושה",
	// Think
	"חושב", "חשבתי", "חושבת",
	// See
	"נראה", "לראות", "רואה",
	// Come
	"בוא",
	// Go
	"הולך", "ללכת", "הולכת", "הלכתי", "הלכת", "הלכת", "הלך", "הלכה", "אלך", "תלך", "תלכי", "ילך", "לכי", "הולכים", "הולכות",
	"הלכנו", "הלכתם", "הלכתן", "הלכו", "נלך", "תלכו", "תלכנה", "ילכו", "לכו", "לכנה",
	// To be sorry
	"מצטער",
	// Happen
	"קרה", "קורה",
	// Love
	"אוהב",
	// Put
	"שום",
	// Use
	"להשתמש",
	// Try
	"לנסות", "מנסה",
	// Take
	"לוקח", "אקח",
	// Put
	"לשים",
	// Give
	"נותן", "נותנת", "נותנים", "נותנות", "נת", "תינתנו", "נתת", "נתתם", "נתתן", "נתן", "נתנה", "נתנו", "אתן", "ניתן", "תיתן",
	"תיתני", "תיתנותיתנה", "ייתןנתתתיתן", "ייתנו", "תיתנה", "תן‏", "תני‏", "תנו‏", "תנה‏", "לתת",
];

const generalAdjectivesAdverbs = [
	// Only
	"רק",
	// All
	"כל",
	// More
	"יותר",
	// Here
	"כאן",
	// So, such
	"כך", "כה",
	// Right, correct
	"נכון",
	// Now
	"עכשיו",
	"עכשיו",
	// There
	"שם",
	// Forward
	"קדימה",
	// Also
	"אף",
	// Yet, still
	"עוד",
	// Really
	"באמת",
	"ממש",
	// Maybe
	"אולי",
	// Already
	"כבר",
	// Here
	"פה",
	// Slightly
	"קצת",
	// Still
	"עדיין",
	// Just
	"בדיוק",
	// Again
	"שוב",
	// Always
	"תמיד",
	// Even
	"אפילו",
	// Certainly
	"בטח",
	// Late
	"מאוחר",
	// Recently
	"לאחרונה",
	// Soon
	"בקרוב",
	// Immediately
	"מיד",
	// Outside
	"בחוץ",
	// Fast
	"מהר",
	// Hard
	"קשה",
	// Slowly
	"לאט",
	// Mostly
	"לרוב",
	// Almost
	"כמעט",
	// Usually
	"בדרך",
	"כלל",
	// Sometimes
	"לפעמים",
	// Together
	"יחד",
	// Alone
	"לבד",
	// Backwards
	"אחורה",
	// As if
	"כאילו",
	// Too
	"גם",
	// Approximately
	"בערך",
	// The most
	"הכי",
	// Full
	"מלא", "מלאה", "מלאים", "מלאות",
	// Good
	"טוב", "טובה", "טובים", "טובות",
	// New
	"חדש", "חדשה", "חדשים", "חדשות",
	// Old
	"ישן", "ישנה", "ישנים", "ישנות",
	// Young
	"צעיn", "צעירה", "צעירים", "צעירות",
	// Big
	"גדול", "גדולה", "גדולים", "גדולות",
	// Easy
	"קל", "קלה", "קלים", "קלות",
	// Fast
	"מהיר", "מהירה", "מהירים", "מהירות",
	// Far
	"רחוק", "רחוקה", "רחוקים", "רחוקות",
	// Nice
	"נחמד", "נחמדה", "נחמדים", "נחמדות",
	// Special
	"מיוחד", "מיוחדת", "מיוחדים", "מיוחדות",
	// Simple
	"פשוט", "פשוטה", "פשוטים", "פשוטות",
	// Small
	"קטן", "קטנה", "קטנים", "קטנות",
	// Long
	"ארוך", "ארוכה", "ארוכים", "ארוכות",
	// Short
	"קצר", "קצרה", "קצרים", "קצרות",
	// Low
	"נמוך", "נמוכה", "נמוכים", "נמוכות",
	// Complete
	"שלם", "שלמה", "שלמים", "שלמות",
	// High
	"גבוה", "גבוהה", "גבוהים", "גבוהות",
	// Important
	"חשוב", "חשובה", "חשובים", "חשובות",
];

const interjections = [
	// Ha (laughter)
	"ח",
	// Oh
	"הו",
	// Wow
	"וואו",
];

// These words and abbreviations are frequently used in recipes in lists of ingredients.
const recipeWords = [
	// Kg
	"ק\"ג",
	// G
	"ג'",
	// Gram
	"גרם",
	// Cl
	"סמ\"ק",
	// Ml
	"מ\"ל",
	// Liter
	"ליטר",
	// Tbsp
	"כף",
	// Tsp
	"כפית",
	// Cup
	"כוס", "כוסות",
];

const timeWords = [
	// Today
	"היום",
	// Yesterday
	"אתמול",
	// Tomorrow
	"מחר",
	// Day
	"יום", "ימים",
	// Week
	"שבוע",	"בשבוע", "שבועות",
	// Hour
	"שעה", "שעות",
	// Minute
	"דקה", "דקות",
	// Moment
	"רגע", "רגעים",
	// Month
	"חודש", "חודשים",
	// Year
	"שנה", "שנים", "השנה",
];

const vagueNouns = [
	// Thing
	"דבר",
	// Time(s)
	"פעם", "פעמים",
	// Time
	"זמן", 	"הזמן",
	// All
	"הכל", "בכל",
	// Men
	"אנשים",
	// Place (used in multiple constructions such as e.g. "everywhere")
	"מקום",
	// Time (used for some adverbial constructions)
	"לעתים",
	// Number (e.g. in "a number of")
	"מספר",
	// Percent
	"אחוז", "אחוזים",
];

const miscellaneous = [
	// Yes
	"כן",
	// No, not (incl. prefixed forms)
	"לא", "שלא",
	// All right
	"בסדר",
	// Thank you
	"תודה",
	// Please
	"בבקשה",
	// Hello
	"שלום",
	// Percent
	"אחוז",
	// Mr
	"מר",
	"אדוני",
	// Ms, Mrs
	"גברת",
	// Person
	"אדם",
];

export const all = transformWordsWithHyphens( [].concat( cardinalNumerals, ordinalNumerals, personalPronouns, demonstrativePronouns, interrogatives,
	quantifiers, reflexivePronouns, indefinitePronouns, prepositions, conjunctions, interviewVerbs,
	intensifiers, auxiliariesAndDelexicalizedVerbs, generalAdjectivesAdverbs, interjections, recipeWords,
	timeWords, vagueNouns, miscellaneous, transitionWords ) );

export default all;
