/**
 * Returns a list of verb stems that cannot be detected as passives by the Greek passive voice assessment.
 * This list includes deponent and semi-deponent verb stems.
 *
 * @returns {Array}                The list with deponent and semi-deponent verb stem.
 */
export default [
	// Deponent transitive verb stems.
	"διαπραγματεύ",
	"αισθάν",
	"ανέχ",
	"ανταγωνίζ",
	"αντιλαμβάν",
	"αντιστρατεύ",
	"απεχθάν",
	"αρν",
	"αφουγκράζ",
	"βαριέμαι",
	"γεύ",
	"δέχ",
	"διανο",
	"διηγ",
	"εγγυ",
	"καταριέμαι",
	"λιγουρεύ",
	"λυπάμαι",
	"μάχ",
	"μέμφ",
	"μεταχειρίζ",
	"μιμ",
	"νυμφεύ",
	"ονειρεύ",
	"οραματίζ",
	"οσμίζ",
	"περιποι",
	"προασπίζ",
	"προοιωνίζ",
	"προφασίζ",
	"ειρωνεύ",
	"εισηγ",
	"εκδικ",
	"εκμεταλλεύ",
	"εμπιστεύ",
	"επιβουλεύ",
	"επικαλ",
	"επισκέπτ",
	"επωμίζ",
	"ερωτεύ",
	"ευαγγελίζ",
	"εχθρεύ",
	"θυμάμαι",
	"καπηλεύ",
	"καρπών",
	"σέβ",
	"σιχαίν",
	"σκαρφίζ",
	"σκέφτ",
	"σπλαχνίζ",
	"συλλογίζ",
	"συμμερίζ",
	"υπαινίσσ",
	"υποκρίν",
	"υποπτεύ",
	"υπόσχ",
	"υποψιάζ",
	"φοβάμαι",
	"χειρίζ",
	"χρειάζ",
	"πραγματεύ",
	// Deponent intransitive verb stems.
	"μαθεύ",
	"ξαναγίν",
	"ξεκαρδίζ",
	"ξεκουμπίζ",
	"ξεχύν",
	"ξημεροβραδιάζ",
	"οδύρ",
	"παραιτ",
	"παραλογίζ",
	"παραστέκ",
	"παρεκτρέπ",
	"πειραματίζ",
	"περιπλαν",
	"πολιτεύ",
	"αγωνίζ",
	"αθλ",
	"ακροβολίζ",
	"αμιλλ",
	"αμύν",
	"αναδιπλών",
	"αναδύ",
	"αναρωτιέμαι",
	"αντιστέκ",
	"γεύ",
	"γκρεμοτσακίζ",
	"διαπληκτίζ",
	"εισέρχ",
	"εκρήγνυμαι",
	"εμφορ",
	"προπορεύ",
	"ρεύ",
	"σκυλοβαριέμαι",
	"σοβαρεύ",
	"συγκρού",
	"συμπαρατάσσ",
	"συμπεριφέρ",
	"συνδικαλίζ",
	"συνεννο",
	"συνεργάζ",
	"υπεισέρχ",
	"υπερηφανεύ",
	"φαγών",
	"φύ",
	"χαμοκυλιέμαι",
	"εναντιών",
	"ενίσταμαι",
	"επαίρ",
	"επιτίθεμαι",
	"ευθύν",
	"ηγ",
	"ηττ",
	"ίπταμαι",
	"καμών",
	"καταγίν",
	"κατάγ",
	"κλυδωνίζ",
	"κοκορεύ",
	"λογοδίν",
	"μαίν",
	// Semi-deponent ambitransitive verbs.
	"ανεβαιν",
	"ανεβηκα",
	"κατεβαιν",
	"κατέβηκα",
	// Semi-deponent intransitive verbs.
	"συγχαίρ",
	"συγχάρκα",
];
