import stem from "../../../../../../src/languageProcessing/languages/el/helpers/internal/stem";

import getMorphologyData from "../../../../../specHelpers/getMorphologyData";

const morphologyDataEL = getMorphologyData( "el" ).el;

const wordsToStem = [
	// Words that shouldn't be stemmed.
	[ "εντωμεταξυ", "εντωμεταξυ" ],
	[ "ως", "ως" ],
	// Stem words from step 1 exception.
	[ "κρεας", "κρε" ],
	[ "ημιφως", "ημιφω" ],
	[ "πανγκρεας", "πανγκρε" ],
	[ "κομπολογια", "κομπολογ" ],
	[ "πατερας", "πατερ" ],
	// Step 1.
	[ "γιαγιαδων", "γιαγι" ],
	[ "ομαδες", "ομαδ" ],
	[ "καφεδων", "καφ" ],
	[ "γηπεδων", "γηπεδ" ],
	[ "παππουδων", "παππ" ],
	[ "αρκουδες", "αρκουδ" ],
	[ "υποθεσεως", "υποθες" ],
	[ "υποθεσεων", "υποθες" ],
	[ "θεων", "θε" ],
	// Step 2.
	[ "γυναικειο", "γυναικ" ],
	[ "τελειου", "τελει" ],
	[ "τελειων", "τελει" ],
	[ "θεια", "θει" ],
	[ "παιδια", "παιδ" ],
	[ "παλιων", "παλαι" ],
	// Step 3.
	[ "ζηλιαρικο", "ζηλιαρ" ],
	[ "αγροικου", "αγροικ" ],
	// Step 4.
	[ "αγαμε", "αγαμ" ],
	[ "βάλετε", "βαλ" ],
	[ "αγαπαμε", "αγαπ" ],
	[ "αγαπησαμε", "αγαπ" ],
	[ "αναπαμε", "αναπαμ" ],
	[ "αγαπησανε", "αγαπ" ],
	[ "τραγανε", "τραγαν" ],
	[ "βραχμανε", "βραχμαν" ],
	[ "σαρακατσανε", "σαρακατσαν" ],
	[ "αγαπησετε", "αγαπ" ],
	[ "βενετε", "βενετ" ],
	[ "αγαπωντας", "αγαπ" ],
	[ "αρχοντας", "αρχοντ" ],
	[ "κρεωντας", "κρεωντ" ],
	[ "αγαπιομαστε", "αγαπ" ],
	[ "ονομαστε", "ονομαστ" ],
	[ "αγαπιεστε", "αγαπ" ],
	[ "πιεστε", "πιεστ" ],
	[ "εκτελεστε", "εκτελεστ" ],
	[ "χτιστηκε", "χτιστ" ],
	[ "διαθηκη", "διαθηκ" ],
	[ "διαθηκες", "διαθηκ" ],
	[ "κατακτηθηκε", "κατακτ" ],
	[ "πολεμηθηκε", "πολεμ" ],
	[ "χτυπω", "χτυπ" ],
	[ "χτυπουσες", "χτυπ" ],
	[ "μεδουσα", "μεδους" ],
	[ "μεδουσα", "μεδους" ],
	[ "κολλαγες", "κολλ" ],
	[ "αβασταγο", "αβασταγ" ],
	[ "αβασταγα", "αβασταγ" ],
	[ "αγαπω", "αγαπ" ],
	[ "αγαπησε", "αγαπ" ],
	[ "σβηστος", "σβηστ" ],
	[ "σβηστε", "σβηστ" ],
	[ "αγαπουνε", "αγαπ" ],
	[ "νουνος", "νουν" ],
	[ "νουνε", "νουν" ],
	[ "αγαπουμε", "αγαπ" ],
	[ "φουμος", "φουμ" ],
	[ "φουμε", "φουμ" ],
	// Step 5.
	[ "κυμα", "κυμ" ],
	[ "κυματα", "κυμ" ],
	[ "χωρατο", "χωρατ" ],
	[ "χωρατα", "χωρατ" ],
	[ "γενουα", "γενου" ],
	[ "γουα", "γου" ],
	[ "τουρνουα", "τουρνου" ],
	[ "νικαραγουα", "νικαραγου" ],
	[ "γραμματο", "γραμμα" ],
	[ "σταματά", "σταματ" ],
	// Step 6.
	[ "πλησιεστατος", "πλησι" ],
	[ "μεγαλυτερη", "μεγαλ" ],
	[ "κοντοτερο", "κοντ" ],
	[ "κατώτερος", "κατωτερ" ],
	[ "υπέρτατος", "υπερτατ" ],
	[ "δεύτερος", "δευτ" ],
	// Long stem list.
	[ "κολλαω", "κολλ" ],
	[ "διχτυ", "διχτ" ],
	[ "διχτυα", "διχτ" ],
	[ "μακρυ", "μακρ" ],
	[ "μακρυα", "μακρ" ],
	[ "δακρυ", "δακρ" ],
	[ "δακρυα", "δακρ" ],
];

const paradigms = [
	// Paradigm of a regular noun.
	{ stem: "βαθμ", forms: [
		"βαθμός",
		"βαθμού",
		"βαθμό",
		"βαθμοί",
		"βαθμών",
		"βαθμούς",
	] },
	// Paradigm of an irregular noun.
	{ stem: "μπαμπ", forms: [
		"μπαμπάς",
		"μπαμπά",
		"μπαμπάδες",
		"μπαμπάδων",
	] },
	// Paradigm of a verb.
	{ stem: "αγαπ", forms: [
		"αγαπώ",
		"αγαπάς",
		"αγαπά",
		"αγαπάμε",
		// "αγαπάτε",
		"αγαπάνε",
		"αγαπούν",
		"αγαπούσα",
		"αγαπούσες",
		"αγαπούσε",
		"αγαπούσαμε",
		"αγαπούσατε",
		"αγαπούσαν",
		"αγαπήσω",
		// "αγαπήσεις",
		"αγαπήσει",
		"αγαπήσουμε",
		"αγαπήσετε",
		"αγαπήσουν",
		"αγάπησα",
		"αγάπησες",
		"αγάπησε",
		"αγαπήσαμε",
		"αγαπήσατε",
		"αγάπησαν",
	] },
	// Paradigm of an adverb with comparative and superlative.
	{ stem: "γρηγορ", forms: [
		"γρήγορα",
		"γρηγορότερα",
	] },
	// Paradigm of an adjective with comparative and superlative.
	{ stem: "καλ", forms: [
		"καλός",
		"καλού",
		// "καλόν",
		"καλοί",
		"καλών",
		"καλούς",
		"καλύτερος",
		"καλύτερου",
		"καλύτερο",
		"καλύτεροι",
		"καλύτερων",
		"καλύτερους",
		"καλή",
		"καλής",
		"καλές",
		"καλό",
		"καλά",
		"καλύτερη",
		"καλύτερης",
		"καλύτερες",
		"καλύτερα",
	] },
];


describe( "Test for stemming Greek words", () => {
	it( "stems Greek words", () => {
		wordsToStem.forEach( wordToStem => expect( stem( wordToStem[ 0 ], morphologyDataEL ) ).toBe( wordToStem[ 1 ] ) );
	} );
} );

describe( "Test to make sure all forms of a paradigm get stemmed to the same stem", () => {
	for ( const paradigm of paradigms ) {
		for ( const form of paradigm.forms ) {
			it( "correctly stems the word: " + form + " to " + paradigm.stem, () => {
				expect( stem( form, morphologyDataEL ) ).toBe( paradigm.stem );
			} );
		}
	}
} );
