import Researcher from "../../../../src/languageProcessing/languages/_default/Researcher.js";
import Paper from "../../../../src/values/Paper.js";

describe( "a test for Default Researcher", function() {
	const researcher = new Researcher( new Paper( "" ) );

	it( "returns true if the Default Researcher has a specific research", function() {
		expect( researcher.hasResearch( "getParagraphLength" ) ).toBe( true );
	} );

	it( "returns false if the default research is deleted in the Default Researcher", function() {
		expect( researcher.getResearch( "getFleschReadingScore" ) ).toBe( false );
	} );

	it( "returns false if the Default Researcher doesn't have a certain helper", function() {
		expect( researcher.getHelper( "fleschReadingScore" ) ).toBe( false );
	} );

	it( "returns false if the Default Researcher doesn't have a certain config", function() {
		expect( researcher.getConfig( "sentenceLength" ) ).toBe( false );
	} );

	it( "doesn't stem word if the Default Researcher is used", function() {
		expect( researcher.getHelper( "getStemmer" )()( "cats" ) ).toBe( "cats" );
	} );
} );
