In our user interfaces, we distinguish five different button variants:

1. **Primary action**<br>
  Purple buttons are used to highlight the most important action or call to action on a page or screen. They should be used for the main action you want your users to take. The purple color is derived from our branding guidelines, which helps them stand out and catch the user's attention. These buttons should be used sparingly to avoid overwhelming users. Ideally, there should only be one primary action button on a page.

  > Example actions: *Save changes*, *Submit*, *Sign up* or *Confirm*.


2. **Secondary action**<br>
  White buttons are used to offer secondary or supplementary actions to users that are less important than the primary action. These buttons can complement the primary action or provide additional options to users. They have a clean and simple appearance that does not draw too much attention. In interfaces that offer a large number of actions, such as tables, it is recommended to use secondary action buttons or text links to keep the UI clean and uncluttered.

  > Example actions: *Cancel* or *Go back*.


3. **Tertiary action**<br>
  Transparent buttons are used for actions of lower priority than secondary actions. These buttons don't stand out much and are often optional, allowing users to take non-essential actions without getting distracted from the main tasks (primary and secondary actions). The transparent background prevents them from getting too much attention. Be careful when using these buttons because they're not very noticeable, and users might overlook them.

  > Example actions: *Close* or *Skip*.


4. **Danger action**<br>
  Red buttons are used to warn users of potentially hazardous or irreversible actions. They often alert users to high-risk actions that could have serious consequences if not handled carefully, such as deleting files, canceling subscriptions, or permanently removing data.

  > Example actions: *Deactivate Yoast SEO*, *Cancel subscription*, *Discard changes*, *Delete* or *Permanently remove all data*.


5. **Buy action**<br>
  Yellow buttons are used to indicate the start of a flow that eventually leads to a purchase or financial transaction related to our own products<!--related to **Yoast** products-->. Often, these buttons guide users toward a product page, their cart or the checkout process. Their bright color makes them stand out from our brand colors and other interface elements, attracting the user's attention.<!--These yellow upsell buttons are not typically used for upsells from partners (like Wincher or JetPack Boost). Partners typically provide their own upsell designs and use their own branded button colors or text links to encourage users to purchase their products.-->

  > Example actions: *Unlock with Premium*, *Get Yoast SEO Premium* or *Buy Yoast Local SEO*.

**Accessibility**<br>
All button variants have a clear hover and focus state, to help users with motor impairments understand which element they are interacting with.
