We distinguish four different alert variants:

1. **Info**<br>
  The info alert is used to:
     - inform users about a (changed) system state, an experience, or feature
     - give users an update on any ongoing process
     - provide users with information that does not require any immediate action<br>

  The info alert should be easily noticeable but not intrusive, and should not block any user actions.

  > Example copy: *Our app will be undergoing maintenance on Friday, March 31st from 8 PM to 10 PM EST.*


2. **Warning**<br>
  The warning alert is used to:
     - alert users about potential problems or issues that may arise if they proceed with a particular action
     - notify users of a potential security risk, or any other situation that requires attention and/or an action
     - notify users of a condition that might cause a problem in the future

  The warning alert, different from an error alert, appears **before** someone takes an action to indicate a significant change or potential loss of data.

  > Example copy: *Proceeding with this action will permanently delete all data associated with your account. Are you sure you want to continue?*


3. **Success**<br>
  The success alert is used to:
     - confirm that a particular action, task, or process has been completed successfully
     - provide users with positive feedback

  The success alert can be used to inform users that their action has been processed, a payment has been made, or any other successful completion of a process.

  > Example copy: *Your payment has been received. Thank you for your purchase!*


4. **Error**<br>
  The error alert is used to:
     - indicate that an error occurs or has occurred (often while performing a particular action)
     - provide users with information about why the error occurred, what went wrong and how to fix it (or at least move forward)
     - inform users about critical issues that negatively affect the functionality of the app

  An error alert, different from a warning alert, appears **after** someone has taken an action. The error alert can be used to alert users that their input is invalid, a process has failed, an action cannot be completed, or any other situation that requires immediate attention. Error messages should be concise and avoid irrelevant details.

  > Example copy: *There was an error processing your payment. Please check your payment information and try again.*
