# Contribution Guidelines
<img src="https://yoast-mercury.s3.amazonaws.com/uploads/2013/02/Yoast_Logo_Large_RGB.png" alt="Yoast logo" width="250px">

Before filing a bug report or a feature request, be sure to read the contribution guidelines.

## How to use GitHub
We use GitHub exclusively for well-documented bugs, feature requests and code contributions. Communication is always done in English.

To receive free support for WordPress SEO we have the following channels:
* [Yoast Knowledge base](https://yoa.st/1y0)
* [Support forums](https://wordpress.org/support/plugin/wordpress-seo) on WordPress.org

If you have purchased one of [our premium plugins](https://yoa.st/1y1), we will give you personal support via email, please see your purchase email for details.


Thanks for your understanding.

## Security issues
Please do not report security issues here. Instead, email them to security at yoast dot com so we can deal with them securely and quickly.

## I have found a bug
Before opening a new issue, please:
* update to the newest versions of WordPress and the Yoast SEO plugins.
* search for duplicate issues to prevent opening a duplicate issue. If there is already an open existing issue, please comment on that issue.
* check our [knowledge base](https://yoa.st/1y0) for your issue. There are a lot of common errors documented there with possible solutions.
* follow our _New issue_ template when creating a new issue.
* check for [plugin and theme conflicts](https://yoa.st/1y2). Please report your findings in the issue.
* check for [JavaScript errors with your browser's console](https://yoa.st/1y3). Please report your findings in the issue.
* add as much information as possible. For example: add screenshots, relevant links, step by step guides etc.

## I have a feature request
Before opening a new issue, please:
* search for duplicate issues to prevent opening a duplicate feature request. If there is already an open existing request, please leave a comment there.
* add as much information as possible. For example: give us a clear explanation of why you think the feature request is something we should consider for the Yoast SEO plugins.

## I want to create a patch
Community made patches, localizations, bug reports and contributions are very welcome and help Yoast SEO remain the #1 SEO plugin for WordPress.

When contributing please ensure you follow the guidelines below so that we can keep on top of things.

#### Submitting an issue you found
Make sure your problem does not exist as a ticket already by searching through [the existing issues](https://github.com/Yoast/wordpress-seo/issues). If you cannot find anything which resembles your problem, please [create a new issue](https://github.com/Yoast/wordpress-seo/issues/new).

#### Fixing an issue

* Fork the repository on GitHub (make sure to use the trunk branch, not main).
* Make the changes to your forked repository.
* Ensure you stick to the [WordPress Coding Standards](https://make.wordpress.org/core/handbook/best-practices/coding-standards/) and you properly document any new functions, actions and filters following the [documentation standards](https://make.wordpress.org/core/handbook/best-practices/inline-documentation-standards/php/).
* When committing, reference your issue and include a note about the fix.
* Push the changes to your fork and submit a pull request to the 'trunk' branch of the Yoast SEO repository.

We will review your pull request and merge when everything is in order. We will help you to make sure the code complies with the standards described above.

#### 'Patch welcome' issues
Some issues are labeled 'patch-welcome'. This means we see the value in the particular enhancement being suggested but have decided for now not to prioritize it. If you however decide to write a patch for it, we'll gladly include it after some code review.

#### Additional Resources
* [Yoast SEO API](https://yoa.st/1y4)
* [General GitHub Documentation](https://help.github.com/)
* [GitHub Pull Request documentation](https://help.github.com/send-pull-requests/)
